/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin.audio;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.sound.FlashbackAudioManager;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1140.class})
public class MixinSoundEngine {
    @Unique
    private boolean wasExportingAudio = false;

    @Inject(method={"destroy"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/audio/Library;cleanup()V")})
    public void destroy(CallbackInfo ci) {
        FlashbackAudioManager.invalidateLoadedBuffers();
    }

    @Inject(method={"shouldChangeDevice"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldChangeDevice(CallbackInfoReturnable<Boolean> cir) {
        boolean isExportingAudio;
        boolean bl = isExportingAudio = Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().recordAudio();
        if (this.wasExportingAudio != isExportingAudio) {
            this.wasExportingAudio = isExportingAudio;
            cir.setReturnValue((Object)true);
        } else if (isExportingAudio) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    public void play(class_1113 soundInstance, CallbackInfo ci) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null && Flashback.EXPORT_JOB == null && replayServer.replayPaused) {
            ci.cancel();
        }
    }
}

