/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.playback;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.SneakyThrow;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2672;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ReplayChunkCache {
    public static final int CHUNK_CACHE_SIZE = 10000;
    private final Int2ObjectMap<SoftReference<List<class_2672>>> levelChunkCachedPackets = new Int2ObjectOpenHashMap();
    private final IntSet missingChunkCacheFiles = new IntOpenHashSet();
    private final FileSystem playbackFileSystem;

    public ReplayChunkCache(FileSystem playbackFileSystem) {
        this.playbackFileSystem = playbackFileSystem;
    }

    public void clear() {
        this.levelChunkCachedPackets.clear();
    }

    @Nullable
    public class_2672 getOrLoad(int index, class_5455 registryAccess, class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec) {
        int indexInCache;
        List<class_2672> packets;
        int cacheIndex = index / 10000;
        SoftReference packetListReference = (SoftReference)this.levelChunkCachedPackets.get(cacheIndex);
        List<class_2672> list = packets = packetListReference == null ? null : (List<class_2672>)packetListReference.get();
        if (packets == null) {
            if (this.missingChunkCacheFiles.contains(cacheIndex)) {
                return null;
            }
            String pathString = "/level_chunk_caches/" + cacheIndex;
            Path levelChunkCachePath = this.playbackFileSystem.getPath(pathString, new String[0]);
            if (Files.exists(levelChunkCachePath, new LinkOption[0])) {
                try {
                    packets = ReplayChunkCache.loadLevelChunkCache(levelChunkCachePath, registryAccess, gamePacketCodec);
                    this.levelChunkCachedPackets.put(cacheIndex, new SoftReference<List<class_2672>>(packets));
                    Flashback.LOGGER.info("Loaded {} with {} entries", (Object)pathString, (Object)packets.size());
                }
                catch (IOException e) {
                    SneakyThrow.sneakyThrow(e);
                }
            } else {
                Flashback.LOGGER.error("Chunk index {} was requested, but cache file {} was missing", (Object)index, (Object)pathString);
                this.missingChunkCacheFiles.add(cacheIndex);
                return null;
            }
        }
        return (indexInCache = index - cacheIndex * 10000) < packets.size() ? (class_2672)packets.get(indexInCache) : null;
    }

    private static List<class_2672> loadLevelChunkCache(Path levelChunkCachePath, class_5455 registryAccess, class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec) throws IOException {
        ArrayList<class_2672> packets;
        block13: {
            packets = new ArrayList<class_2672>();
            InputStream is = Files.newInputStream(levelChunkCachePath, new OpenOption[0]);
            block7: while (true) {
                while (true) {
                    byte[] sizeBuffer;
                    if ((sizeBuffer = is.readNBytes(4)).length < 4) {
                        break block13;
                    }
                    int size = (sizeBuffer[0] & 0xFF) << 24 | (sizeBuffer[1] & 0xFF) << 16 | (sizeBuffer[2] & 0xFF) << 8 | sizeBuffer[3] & 0xFF;
                    byte[] chunk = is.readNBytes(size);
                    if (chunk.length < size) {
                        Flashback.LOGGER.error("Ran out of bytes while reading level_chunk_cache, needed {}, had {}", (Object)size, (Object)chunk.length);
                        break block13;
                    }
                    class_9129 registryFriendlyByteBuf = new class_9129(Unpooled.wrappedBuffer((byte[])chunk), registryAccess);
                    try {
                        class_2596 packet = (class_2596)gamePacketCodec.decode((Object)registryFriendlyByteBuf);
                        if (packet instanceof class_2672) {
                            class_2672 levelChunkWithLightPacket = (class_2672)packet;
                            packets.add(levelChunkWithLightPacket);
                            continue block7;
                        }
                        throw new IllegalStateException("Level chunk cache contains wrong packet: " + String.valueOf(packet));
                    }
                    catch (Exception e) {
                        Flashback.LOGGER.error("Encountered error while reading level_chunk_cache", (Throwable)e);
                        continue;
                    }
                    break;
                }
                break;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return packets;
    }
}

