/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.visuals;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.flashback.Utils;
import com.moulberry.flashback.combo_options.Sizing;
import com.moulberry.flashback.editor.ui.windows.TimelineWindow;
import com.moulberry.flashback.keyframe.Keyframe;
import com.moulberry.flashback.keyframe.change.KeyframeChange;
import com.moulberry.flashback.keyframe.change.KeyframeChangeCameraPosition;
import com.moulberry.flashback.keyframe.change.KeyframeChangeCameraPositionOrbit;
import com.moulberry.flashback.keyframe.change.KeyframeChangeFov;
import com.moulberry.flashback.keyframe.handler.KeyframeHandler;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.state.EditorScene;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.state.KeyframeTrack;
import com.moulberry.flashback.visuals.Shapes;
import java.util.Map;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1041;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_8555;
import net.minecraft.class_9801;
import net.minecraft.class_9958;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CameraPath {
    private static class_291 cameraPathVertexBuffer = null;
    private static CameraPathArgs lastCameraPathArgs = null;
    private static Vector3d basePosition = null;
    private static int lastEditorStateModCount = 0;
    private static int lastCursorTick = 0;
    private static final class_4587 cameraPoseStack = new class_4587();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderCameraPath(class_4587 poseStack, class_4184 camera, ReplayServer replayServer) {
        RenderSystem.assertOnRenderThread();
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        EditorState state = replayServer.getEditorState();
        int replayTick = TimelineWindow.getCursorTick();
        if (lastEditorStateModCount != state.modCount || lastCursorTick != replayTick) {
            CameraPathArgs cameraPathArgs;
            long stamp = state.acquireRead();
            try {
                cameraPathArgs = CameraPath.createCameraPathArgs(state.getCurrentScene(stamp), replayTick);
            }
            finally {
                state.release(stamp);
            }
            if (lastEditorStateModCount != state.modCount || !cameraPathArgs.equals(lastCameraPathArgs)) {
                class_9801 meshData;
                lastCameraPathArgs = cameraPathArgs;
                class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
                Vector3d basePosition = new Vector3d(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
                CameraPath.buildCameraPath(state, basePosition.mul(-1.0, new Vector3d()), cameraPathArgs, bufferBuilder);
                if (cameraPathVertexBuffer != null) {
                    cameraPathVertexBuffer.close();
                    cameraPathVertexBuffer = null;
                }
                if ((meshData = bufferBuilder.method_60794()) != null) {
                    CameraPath.basePosition = basePosition;
                    cameraPathVertexBuffer = new class_291(class_8555.field_54340);
                    cameraPathVertexBuffer.method_1353();
                    cameraPathVertexBuffer.method_1352(meshData);
                    class_291.method_1354();
                }
            }
            lastEditorStateModCount = state.modCount;
            lastCursorTick = replayTick;
        }
        if (cameraPathVertexBuffer == null) {
            return;
        }
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        class_5944 shaderInstance = RenderSystem.setShader((class_10156)class_10142.field_53864);
        class_9958 oldFog = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((class_9958)class_9958.field_53065);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22903();
        poseStack.method_22904(CameraPath.basePosition.x - camera.method_19326().field_1352, CameraPath.basePosition.y - camera.method_19326().field_1351 + (double)camera.field_18721, CameraPath.basePosition.z - camera.method_19326().field_1350);
        cameraPathVertexBuffer.method_1353();
        cameraPathVertexBuffer.method_34427(poseStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), shaderInstance);
        class_291.method_1354();
        if (replayServer.replayPaused) {
            CapturingKeyframeHandler handler = new CapturingKeyframeHandler();
            FovCapturingKeyframeHandler fovHandler = new FovCapturingKeyframeHandler();
            fovHandler.fov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
            state.applyKeyframes(handler, replayTick);
            state.applyKeyframes(fovHandler, replayTick);
            if (handler.position != null) {
                class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
                CameraPath.renderCamera(bufferBuilder, handler.position.sub((Vector3dc)basePosition, new Vector3d()), handler.angle, fovHandler.fov, CameraPath.getCameraColour(false, true), 1.0f);
                Matrix4f oldModelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
                RenderSystem.getModelViewMatrix().set((Matrix4fc)poseStack.method_23760().method_23761());
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                RenderSystem.getModelViewMatrix().set((Matrix4fc)oldModelViewMatrix);
            }
        }
        poseStack.method_22909();
        RenderSystem.setShaderFog((class_9958)oldFog);
        RenderSystem.enableCull();
    }

    private static CameraPathArgs createCameraPathArgs(EditorScene scene, int replayTick) {
        int lastCameraTick = -1;
        int nextCameraTick = -1;
        for (int trackIndex = 0; trackIndex < scene.keyframeTracks.size(); ++trackIndex) {
            KeyframeTrack keyframeTrack = scene.keyframeTracks.get(trackIndex);
            if (!keyframeTrack.enabled || !CameraPath.isChangeCameraKeyframeType(keyframeTrack.keyframeType.keyframeChangeType()) || keyframeTrack.keyframesByTick.isEmpty()) continue;
            Map.Entry<Integer, Keyframe> lastEntry = keyframeTrack.keyframesByTick.floorEntry(replayTick);
            Map.Entry<Integer, Keyframe> nextEntry = keyframeTrack.keyframesByTick.ceilingEntry(replayTick + 1);
            if (lastEntry != null && (lastCameraTick == -1 || lastEntry.getKey() > lastCameraTick)) {
                lastCameraTick = lastEntry.getKey();
            }
            if (nextEntry != null && (nextCameraTick == -1 || nextEntry.getKey() < nextCameraTick)) {
                nextCameraTick = nextEntry.getKey();
            }
            if (lastEntry != null && nextEntry != null) break;
        }
        int lastLastCameraTick = -1;
        int nextNextCameraTick = -1;
        for (int trackIndex = 0; trackIndex < scene.keyframeTracks.size(); ++trackIndex) {
            Map.Entry<Integer, Keyframe> nextNextEntry;
            KeyframeTrack keyframeTrack = scene.keyframeTracks.get(trackIndex);
            if (!keyframeTrack.enabled || !CameraPath.isChangeCameraKeyframeType(keyframeTrack.keyframeType.keyframeChangeType()) || keyframeTrack.keyframesByTick.isEmpty()) continue;
            Map.Entry<Integer, Keyframe> lastLastEntry = lastCameraTick == -1 ? null : keyframeTrack.keyframesByTick.floorEntry(lastCameraTick - 1);
            Map.Entry<Integer, Keyframe> entry = nextNextEntry = nextCameraTick == -1 ? null : keyframeTrack.keyframesByTick.ceilingEntry(nextCameraTick + 1);
            if (lastLastEntry != null && lastLastCameraTick == -1) {
                lastLastCameraTick = lastLastEntry.getKey();
            }
            if (nextNextEntry == null || nextNextCameraTick != -1) continue;
            nextNextCameraTick = nextNextEntry.getKey();
        }
        return new CameraPathArgs(lastLastCameraTick, lastCameraTick, nextCameraTick, nextNextCameraTick);
    }

    private static void buildCameraPath(EditorState state, Vector3d offset, CameraPathArgs args, class_287 bufferBuilder) {
        CapturingKeyframeHandler handler = new CapturingKeyframeHandler();
        FovCapturingKeyframeHandler fovHandler = new FovCapturingKeyframeHandler();
        float defaultFov = ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
        if (args.lastCameraTick != -1) {
            fovHandler.fov = defaultFov;
            state.applyKeyframes(handler, args.lastCameraTick);
            state.applyKeyframes(fovHandler, args.lastCameraTick);
            CameraPath.renderCamera(bufferBuilder, handler.position.add((Vector3dc)offset, new Vector3d()), handler.angle, fovHandler.fov, CameraPath.getCameraColour(false, false), 1.0f);
            if (args.lastLastCameraTick != -1) {
                fovHandler.fov = defaultFov;
                state.applyKeyframes(handler, args.lastLastCameraTick);
                state.applyKeyframes(fovHandler, args.lastLastCameraTick);
                CameraPath.renderCamera(bufferBuilder, handler.position.add((Vector3dc)offset, new Vector3d()), handler.angle, fovHandler.fov, CameraPath.getCameraColour(false, false), 0.6f);
                CameraPath.renderPath(bufferBuilder, args.lastLastCameraTick, args.lastCameraTick, state, offset, handler, 0.6f);
            }
        }
        if (args.nextCameraTick != -1) {
            fovHandler.fov = defaultFov;
            state.applyKeyframes(handler, args.nextCameraTick);
            state.applyKeyframes(fovHandler, args.nextCameraTick);
            CameraPath.renderCamera(bufferBuilder, handler.position.add((Vector3dc)offset, new Vector3d()), handler.angle, fovHandler.fov, CameraPath.getCameraColour(false, false), 1.0f);
            if (args.nextNextCameraTick != -1) {
                fovHandler.fov = defaultFov;
                state.applyKeyframes(handler, args.nextNextCameraTick);
                state.applyKeyframes(fovHandler, args.nextNextCameraTick);
                CameraPath.renderCamera(bufferBuilder, handler.position.add((Vector3dc)offset, new Vector3d()), handler.angle, fovHandler.fov, CameraPath.getCameraColour(false, false), 0.6f);
                CameraPath.renderPath(bufferBuilder, args.nextCameraTick, args.nextNextCameraTick, state, offset, handler, 0.6f);
            }
        }
        if (args.lastCameraTick != -1 && args.nextCameraTick != -1) {
            CameraPath.renderPath(bufferBuilder, args.lastCameraTick, args.nextCameraTick, state, offset, handler, 1.0f);
        }
    }

    private static int getCameraColour(boolean selected, boolean current) {
        if (current) {
            return 0x20FF20;
        }
        if (selected) {
            return 0xFF2020;
        }
        return 0xFFFF20;
    }

    private static void renderPath(class_287 bufferBuilder, int fromTick, int toTick, EditorState editorState, Vector3d offset, CapturingKeyframeHandler handler, float opacity) {
        Vector3d lastPosition = null;
        int step = (toTick - fromTick) / 2000 + 1;
        for (int tick = fromTick; tick <= toTick; tick += step) {
            editorState.applyKeyframes(handler, tick);
            Vector3d position = handler.position.add((Vector3dc)offset, new Vector3d());
            if (lastPosition != null) {
                double dx = position.x - lastPosition.x;
                double dy = position.y - lastPosition.y;
                double dz = position.z - lastPosition.z;
                float distanceInv = 1.0f / (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                bufferBuilder.method_22912((float)lastPosition.x, (float)lastPosition.y, (float)lastPosition.z).method_22915(1.0f, 1.0f, 0.1f, 0.0f).method_22914((float)(dx *= (double)distanceInv), (float)(dy *= (double)distanceInv), (float)(dz *= (double)distanceInv));
                bufferBuilder.method_22912((float)position.x, (float)position.y, (float)position.z).method_22915(1.0f, 1.0f, 0.1f, opacity).method_22914((float)dx, (float)dy, (float)dz);
            }
            lastPosition = position;
        }
    }

    private static void renderCamera(class_287 bufferBuilder, Vector3d position, Quaterniond angle, float fov, int rgb, float opacity) {
        float aspectRatio;
        cameraPoseStack.method_22903();
        cameraPoseStack.method_22904(position.x, position.y, position.z);
        cameraPoseStack.method_22907(new Quaternionf((Quaterniondc)angle));
        class_4587.class_4665 pose = cameraPoseStack.method_23760();
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && editorState.replayVisuals.sizing == Sizing.CHANGE_ASPECT_RATIO) {
            aspectRatio = editorState.replayVisuals.changeAspectRatio.aspectRatio();
        } else {
            class_1041 window = class_310.method_1551().method_22683();
            aspectRatio = (float)window.method_4489() / (float)window.method_4506();
        }
        float focalLength = Utils.fovToFocalLength(fov);
        float targetArea = (float)Math.sqrt(aspectRatio) * 0.3f;
        float d1 = (float)Math.sqrt(targetArea / aspectRatio * (focalLength * focalLength));
        float d2 = 0.5f;
        float d = (d1 + d2) / 2.0f;
        float h = d / focalLength;
        float w = h * aspectRatio;
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        Shapes.line(bufferBuilder, pose, class_243.field_1353, new class_243((double)w, (double)h, (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, new class_243((double)w, (double)h, (double)d), new class_243((double)(-w), (double)h, (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, class_243.field_1353, new class_243((double)(-w), (double)h, (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, new class_243((double)(-w), (double)h, (double)d), new class_243((double)(-w), (double)(-h), (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, class_243.field_1353, new class_243((double)(-w), (double)(-h), (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, new class_243((double)(-w), (double)(-h), (double)d), new class_243((double)w, (double)(-h), (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, class_243.field_1353, new class_243((double)w, (double)(-h), (double)d), red, green, blue, opacity);
        Shapes.line(bufferBuilder, pose, new class_243((double)w, (double)(-h), (double)d), new class_243((double)w, (double)h, (double)d), red, green, blue, opacity);
        cameraPoseStack.method_22909();
    }

    private static boolean isChangeCameraKeyframeType(Class<? extends KeyframeChange> clazz) {
        return clazz == KeyframeChangeCameraPosition.class || clazz == KeyframeChangeCameraPositionOrbit.class;
    }

    private record CameraPathArgs(int lastLastCameraTick, int lastCameraTick, int nextCameraTick, int nextNextCameraTick) {
    }

    private static class CapturingKeyframeHandler
    implements KeyframeHandler {
        private Vector3d position;
        private Quaterniond angle;

        private CapturingKeyframeHandler() {
        }

        @Override
        public boolean supportsKeyframeChange(Class<? extends KeyframeChange> clazz) {
            return CameraPath.isChangeCameraKeyframeType(clazz);
        }

        @Override
        public boolean alwaysApplyLastKeyframe() {
            return true;
        }

        @Override
        public void applyCameraPosition(Vector3d position, double yaw, double pitch, double roll) {
            this.position = position;
            this.angle = new Quaterniond().rotationYXZ((double)((float)(-Math.toRadians(yaw))), (double)((float)Math.toRadians(pitch)), (double)((float)(-Math.toRadians(roll))));
        }
    }

    private static class FovCapturingKeyframeHandler
    implements KeyframeHandler {
        private float fov;

        private FovCapturingKeyframeHandler() {
        }

        @Override
        public boolean supportsKeyframeChange(Class<? extends KeyframeChange> clazz) {
            return clazz == KeyframeChangeFov.class;
        }

        @Override
        public boolean alwaysApplyLastKeyframe() {
            return true;
        }

        @Override
        public void applyFov(float fov) {
            this.fov = fov;
        }
    }
}

