/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.keyframe.impl;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.moulberry.flashback.keyframe.Keyframe;
import com.moulberry.flashback.keyframe.KeyframeType;
import com.moulberry.flashback.keyframe.change.KeyframeChange;
import com.moulberry.flashback.keyframe.interpolation.InterpolationType;
import com.moulberry.flashback.keyframe.types.SpeedKeyframeType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2680;
import net.minecraft.class_2841;

public class BlockOverrideKeyframe
extends Keyframe {
    private static final long MIN_POSITION_LONG = class_2338.method_10064((int)-33554432, (int)-2048, (int)-33554432);
    public static final class_2680 EMPTY_STATE;
    public Long2ObjectMap<class_2841<class_2680>> blocks = new Long2ObjectOpenHashMap();
    private long lastPos = MIN_POSITION_LONG;
    private class_2841<class_2680> lastContainer = null;
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC;

    public BlockOverrideKeyframe() {
        this.interpolationType(InterpolationType.LINEAR);
    }

    @Override
    public KeyframeType<?> keyframeType() {
        return SpeedKeyframeType.INSTANCE;
    }

    public void setBlock(int x, int y, int z, class_2680 blockState) {
        long chunk = class_2338.method_10064((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        if (chunk != this.lastPos) {
            this.lastPos = chunk;
            this.lastContainer = (class_2841)this.blocks.computeIfAbsent(chunk, l -> new class_2841((class_2359)class_2248.field_10651, (Object)EMPTY_STATE, class_2841.class_6563.field_34569));
        }
        this.lastContainer.method_35321(x & 0xF, y & 0xF, z & 0xF, (Object)blockState);
    }

    @Override
    public Keyframe copy() {
        BlockOverrideKeyframe keyframe = new BlockOverrideKeyframe();
        for (Long2ObjectMap.Entry entry : this.blocks.long2ObjectEntrySet()) {
            keyframe.blocks.put(entry.getLongKey(), (Object)((class_2841)entry.getValue()).method_39957());
        }
        return keyframe;
    }

    @Override
    public KeyframeChange createChange() {
        return null;
    }

    @Override
    public KeyframeChange createSmoothInterpolatedChange(Keyframe p1, Keyframe p2, Keyframe p3, float t0, float t1, float t2, float t3, float amount) {
        return null;
    }

    @Override
    public KeyframeChange createHermiteInterpolatedChange(Map<Float, Keyframe> keyframes, float amount) {
        return null;
    }

    static {
        if (MIN_POSITION_LONG != -9223371899415820288L) {
            throw new RuntimeException("BlockPos representation changed!");
        }
        EMPTY_STATE = class_2246.field_10243.method_9564();
        BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)EMPTY_STATE);
    }

    public static class TypeAdapter
    implements JsonSerializer<BlockOverrideKeyframe>,
    JsonDeserializer<BlockOverrideKeyframe> {
        public BlockOverrideKeyframe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            BlockOverrideKeyframe blockOverrideKeyframe = new BlockOverrideKeyframe();
            JsonObject chunks = jsonObject.getAsJsonObject("chunks");
            for (String key : chunks.keySet()) {
                long pos = Long.parseLong(key);
                Optional result = BLOCK_STATE_CODEC.decode((DynamicOps)JsonOps.COMPRESSED, (Object)chunks.get(key)).result();
                if (!result.isPresent()) continue;
                class_2841 container = (class_2841)((Pair)result.get()).getFirst();
                blockOverrideKeyframe.blocks.put(pos, (Object)container);
            }
            return blockOverrideKeyframe;
        }

        public JsonElement serialize(BlockOverrideKeyframe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject chunks = new JsonObject();
            for (Long2ObjectMap.Entry entry : src.blocks.long2ObjectEntrySet()) {
                Optional result = BLOCK_STATE_CODEC.encodeStart((DynamicOps)JsonOps.COMPRESSED, (Object)((class_2841)entry.getValue())).result();
                if (!result.isPresent()) continue;
                chunks.add("" + entry.getLongKey(), (JsonElement)result.get());
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("chunks", (JsonElement)chunks);
            jsonObject.addProperty("type", "block_override");
            return jsonObject;
        }
    }
}

