/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.ReplayVisuals;
import com.moulberry.flashback.visuals.ShaderManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2394;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_703;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_846;
import net.minecraft.class_8679;
import net.minecraft.class_8921;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import net.minecraft.class_9909;
import net.minecraft.class_9922;
import net.minecraft.class_9958;
import net.minecraft.class_9960;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_761.class}, priority=1100)
public abstract class MixinLevelRenderer {
    @Shadow
    @Final
    public ObjectArrayList<class_846.class_851> field_45616;
    @Shadow
    @Nullable
    private class_846 field_45614;
    @Shadow
    @Final
    public class_8679 field_45615;
    @Shadow
    private int field_4073;
    @Shadow
    @Final
    private class_9960 field_53081;
    @Unique
    private class_276 roundAlphaBuffer = null;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            this.field_4073 = replayServer.getReplayTick();
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/TickRateManager;runsNormally()Z")})
    public boolean tick_runsNormally(class_8921 instance, Operation<Boolean> original) {
        if (Flashback.isInReplay()) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    public void renderLevel(class_9922 graphicsResourceAllocator, class_9779 deltaTracker, boolean bl, class_4184 camera, class_757 gameRenderer, Matrix4f matrix4f, Matrix4f projection, CallbackInfo ci) {
        ReplayUI.lastProjectionMatrix = projection;
        ReplayUI.lastViewQuaternion = camera.method_23767();
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        if (this.roundAlphaBuffer != null) {
            this.roundAlphaBuffer.method_1238();
        }
    }

    @Inject(method={"renderBlockDestroyAnimation"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void renderBlockDestroyAnimation(CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSectionLayer"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void renderSectionLayer(class_1921 renderType, double d, double e, double f, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            ci.cancel();
            return;
        }
        if (renderType == class_1921.method_23581() && Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
            class_276 main = class_310.method_1551().field_1689;
            if (this.roundAlphaBuffer == null) {
                this.roundAlphaBuffer = new class_6367(main.field_1482, main.field_1481, false);
            } else if (this.roundAlphaBuffer.field_1482 != main.field_1482 || this.roundAlphaBuffer.field_1481 != main.field_1481) {
                this.roundAlphaBuffer.method_1238();
                this.roundAlphaBuffer = new class_6367(main.field_1482, main.field_1481, false);
            }
            this.roundAlphaBuffer.method_1235(true);
            GlStateManager._disableDepthTest();
            GlStateManager._depthMask((boolean)false);
            GlStateManager._viewport((int)0, (int)0, (int)main.field_1480, (int)main.field_1477);
            GlStateManager._disableBlend();
            class_5944 shaderInstance = Objects.requireNonNull(RenderSystem.setShader((class_10156)ShaderManager.blitScreenRoundAlpha), "Blit shader not loaded");
            shaderInstance.method_62899("InSampler", main.field_1475);
            shaderInstance.method_34586();
            class_287 bufferBuilder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_29336);
            bufferBuilder.method_22912(0.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 1.0f, 0.0f);
            bufferBuilder.method_22912(0.0f, 1.0f, 0.0f);
            class_286.method_43437((class_9801)bufferBuilder.method_60800());
            shaderInstance.method_34585();
            main.method_1235(true);
            this.roundAlphaBuffer.method_1237(main.field_1482, main.field_1481);
            GlStateManager._enableBlend();
            GlStateManager._depthMask((boolean)true);
            GlStateManager._enableDepthTest();
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;Lorg/joml/Vector4f;FZF)Lnet/minecraft/client/renderer/FogParameters;")})
    public class_9958 setupFog(class_4184 camera, class_758.class_4596 fogMode, Vector4f colour, float distance, boolean foggy, float partialTick, Operation<class_9958> original) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null) {
            ReplayVisuals visuals = editorState.replayVisuals;
            if (visuals.overrideFogColour) {
                float[] fogColour = visuals.fogColour;
                if (fogMode == class_758.class_4596.field_20945) {
                    colour.set(fogColour[0], fogColour[1], fogColour[2], 1.0f);
                } else {
                    colour = new Vector4f(fogColour[0], fogColour[1], fogColour[2], 1.0f);
                }
            }
            if (fogMode == class_758.class_4596.field_20945 && !visuals.renderSky) {
                if (Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
                    Vector4f originalColour = colour;
                    colour = new Vector4f((Vector4fc)colour);
                    originalColour.set(0.0f, 0.0f, 0.0f, 0.0f);
                } else {
                    float[] skyColour = visuals.skyColour;
                    colour.set(skyColour[0], skyColour[1], skyColour[2], 1.0f);
                }
            }
        }
        return (class_9958)original.call(new Object[]{camera, fogMode, colour, Float.valueOf(distance), foggy, Float.valueOf(partialTick)});
    }

    @Inject(method={"renderBlockEntities"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBlockEntities(class_4587 poseStack, class_4597.class_4598 bufferSource, class_4597.class_4598 bufferSource2, class_4184 camera, float f, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            ci.cancel();
        }
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEntity(class_1297 entity, double d, double e, double f, float g, class_4587 poseStack, class_4597 multiBufferSource, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (entity instanceof class_1657) {
            if (editorState != null && !editorState.replayVisuals.renderPlayers) {
                ci.cancel();
            }
        } else if (editorState != null && !editorState.replayVisuals.renderEntities) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;getCloudsType()Lnet/minecraft/client/CloudStatus;")}, require=0)
    public class_4063 renderLevel_getCloudsType(class_315 instance, Operation<class_4063> original) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderSky) {
            return class_4063.field_18162;
        }
        return (class_4063)original.call(new Object[]{instance});
    }

    @Inject(method={"addParticlesPass"}, at={@At(value="HEAD")}, cancellable=true)
    public void addParticlesPass(class_9909 frameGraphBuilder, class_4184 camera, float f, class_9958 fogParameters, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderParticles) {
            ci.cancel();
        }
    }

    @Inject(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    public void addParticleInternal(class_2394 particleOptions, boolean bl, boolean bl2, double d, double e, double f, double g, double h, double i, CallbackInfoReturnable<class_703> cir) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderParticles) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"addSkyPass"}, at={@At(value="HEAD")}, cancellable=true)
    public void addSkyPass(class_9909 frameGraphBuilder, class_4184 camera, float f, class_9958 fogParameters, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderSky) {
            ci.cancel();
        }
    }
}

