/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.playback;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.PacketHelper;
import com.moulberry.flashback.TempFolderProvider;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.ext.ConnectionExt;
import com.moulberry.flashback.ext.LevelChunkExt;
import com.moulberry.flashback.ext.MinecraftExt;
import com.moulberry.flashback.ext.ServerGamePacketListenerImplExt;
import com.moulberry.flashback.ext.ServerTickRateManagerExt;
import com.moulberry.flashback.io.ReplayReader;
import com.moulberry.flashback.keyframe.Keyframe;
import com.moulberry.flashback.keyframe.handler.ReplayServerKeyframeHandler;
import com.moulberry.flashback.keyframe.impl.BlockOverrideKeyframe;
import com.moulberry.flashback.keyframe.types.BlockOverrideKeyframeType;
import com.moulberry.flashback.packet.FinishedServerTick;
import com.moulberry.flashback.packet.FlashbackAccurateEntityPosition;
import com.moulberry.flashback.packet.FlashbackClearEntities;
import com.moulberry.flashback.packet.FlashbackClearParticles;
import com.moulberry.flashback.packet.FlashbackForceClientTick;
import com.moulberry.flashback.packet.FlashbackInstantlyLerp;
import com.moulberry.flashback.packet.FlashbackRemoteExperience;
import com.moulberry.flashback.packet.FlashbackRemoteFoodData;
import com.moulberry.flashback.packet.FlashbackRemoteSelectHotbarSlot;
import com.moulberry.flashback.packet.FlashbackRemoteSetSlot;
import com.moulberry.flashback.packet.FlashbackSetBorderLerpStartTime;
import com.moulberry.flashback.playback.AllowPendingEntityPacketSet;
import com.moulberry.flashback.playback.FakePlayer;
import com.moulberry.flashback.playback.PlayableChunk;
import com.moulberry.flashback.playback.ReplayChunkCache;
import com.moulberry.flashback.playback.ReplayConfigurationPacketHandler;
import com.moulberry.flashback.playback.ReplayGamePacketHandler;
import com.moulberry.flashback.playback.ReplayPlayer;
import com.moulberry.flashback.record.FlashbackChunkMeta;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.state.EditorScene;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.state.KeyframeTrack;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10182;
import net.minecraft.class_10264;
import net.minecraft.class_1132;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2629;
import net.minecraft.class_2658;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_2684;
import net.minecraft.class_2720;
import net.minecraft.class_2772;
import net.minecraft.class_2818;
import net.minecraft.class_2841;
import net.minecraft.class_31;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3231;
import net.minecraft.class_3283;
import net.minecraft.class_3324;
import net.minecraft.class_3442;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_3950;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5889;
import net.minecraft.class_5896;
import net.minecraft.class_6904;
import net.minecraft.class_7497;
import net.minecraft.class_7699;
import net.minecraft.class_7712;
import net.minecraft.class_7924;
import net.minecraft.class_8605;
import net.minecraft.class_8710;
import net.minecraft.class_8732;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.class_8915;
import net.minecraft.class_9053;
import net.minecraft.class_9095;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ReplayServer
extends class_1132 {
    private static final Gson GSON = new Gson();
    public static int REPLAY_VIEWER_IDS_START = -981723987;
    public static String REPLAY_VIEWER_NAME = "Replay Viewer";
    public volatile int jumpToTick = -1;
    public volatile boolean replayPaused = true;
    public AtomicBoolean forceApplyKeyframes = new AtomicBoolean(false);
    public AtomicBoolean sendFinishedServerTick = new AtomicBoolean(false);
    private volatile float desiredTickRate = 20.0f;
    private volatile float desiredTickRateManual = 20.0f;
    private boolean desiredFrozen = false;
    private int desiredFrozenDelay = -1;
    private boolean isFrozen = false;
    private int frozenDelay = -1;
    public volatile boolean failedToLoadRegistryDataWarning = false;
    public volatile boolean failedToSpawnPlayerWarning = false;
    private boolean hasNonSpectatorReplayViewer = false;
    private int currentTick = 0;
    private volatile int targetTick = 0;
    private final int totalTicks;
    public class_5321<class_1937> spawnLevel = null;
    private final ReplayGamePacketHandler gamePacketHandler;
    private final ReplayConfigurationPacketHandler configurationPacketHandler;
    private class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec;
    private final class_9139<ByteBuf, class_2596<? super class_8732>> configurationPacketCodec;
    private final List<ReplayPlayer> replayViewers = new ArrayList<ReplayPlayer>();
    public boolean followLocalPlayerNextTickIfWrongDimension = false;
    public boolean isProcessingSnapshot = false;
    public List<class_2658> customPacketsInSnapshot = new ArrayList<class_2658>();
    private boolean processedSnapshot = false;
    public volatile boolean fastForwarding = false;
    public volatile boolean hasServerResourcePack = false;
    private List<BlockAtPosition> pendingBlockOverrides = new ArrayList<BlockAtPosition>();
    private int printFailedDecodePacketCount = 8;
    private final UUID playbackUUID;
    private final FlashbackMeta metadata;
    private final TreeMap<Integer, PlayableChunk> playableChunksByStart = new TreeMap();
    private ReplayChunkCache replayChunkCache = null;
    private final IntSet loadedChunkCacheFiles = new IntOpenHashSet();
    private ReplayReader currentReplayReader = null;
    private final Map<UUID, RemotePack> oldRemotePacks = new HashMap<UUID, RemotePack>();
    private final Map<UUID, RemotePack> remotePacks = new HashMap<UUID, RemotePack>();
    private final Map<UUID, class_1259> bossEvents = new HashMap<UUID, class_1259>();
    private class_2561 tabListHeader = class_2561.method_43473();
    private class_2561 tabListFooter = class_2561.method_43473();
    private final Map<class_5321<class_1937>, IntSet> needsPositionUpdate = new HashMap<class_5321<class_1937>, IntSet>();
    private class_2561 shutdownReason = null;
    private FileSystem playbackFileSystem = null;
    private boolean initializedWithSnapshot = false;
    public List<class_2378.class_10106<?>> overridePendingTags = null;
    private int lastReplayTick;
    private long lastTickTimeNanos;
    public static final class_3230<class_1923> ENTITY_LOAD_TICKET = class_3230.method_20628((String)"replay_entity_load", Comparator.comparingLong(class_1923::method_8324), (int)5);

    public ReplayServer(Thread thread, class_310 minecraft, class_32.class_5143 levelStorageAccess, class_3283 packRepository, class_6904 worldStem, class_7497 services, class_3950 chunkProgressListenerFactory, UUID playbackUUID, Path path) {
        super(thread, minecraft, levelStorageAccess, packRepository, worldStem, services, chunkProgressListenerFactory);
        this.playbackUUID = playbackUUID;
        this.gamePacketHandler = new ReplayGamePacketHandler(this);
        this.configurationPacketHandler = new ReplayConfigurationPacketHandler(this);
        this.gamePacketCodec = class_9095.field_48173.method_61107(class_9129.method_56350((class_5455)this.method_30611())).comp_2236();
        this.configurationPacketCodec = class_9157.field_48699.comp_2236();
        try {
            this.playbackFileSystem = FileSystems.newFileSystem(path);
            Path metadataPath = this.playbackFileSystem.getPath("/metadata.json", new String[0]);
            String metadataJson = Files.readString(metadataPath);
            this.metadata = FlashbackMeta.fromJson((JsonObject)GSON.fromJson(metadataJson, JsonObject.class));
            if (this.metadata == null) {
                throw new RuntimeException("Invalid metadata file");
            }
            int ticks = 0;
            for (Map.Entry<String, FlashbackChunkMeta> entry : this.metadata.chunks.entrySet()) {
                PlayableChunk chunkMetaWithPath = new PlayableChunk(entry.getValue(), this.playbackFileSystem.getPath("/" + entry.getKey(), new String[0]));
                this.playableChunksByStart.put(ticks, chunkMetaWithPath);
                ticks += entry.getValue().duration;
            }
            this.totalTicks = ticks;
            this.replayChunkCache = new ReplayChunkCache(this.playbackFileSystem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getEditorState().usedByPaths.add(path.toString());
    }

    public FlashbackMeta getMetadata() {
        return this.metadata;
    }

    public void updateRegistry(class_7699 featureFlagSet, List<class_2378.class_10106<?>> pendingTags, List<class_2596<? super class_8732>> initialPackets, List<class_8605> configurationTasks) {
        class_5219 class_52192 = this.field_24372;
        if (class_52192 instanceof class_31) {
            class_31 primaryLevelData = (class_31)class_52192;
            primaryLevelData.field_25030 = new class_1940(primaryLevelData.field_25030.method_27339(), primaryLevelData.field_25030.method_8574(), primaryLevelData.field_25030.method_8583(), primaryLevelData.field_25030.method_27340(), primaryLevelData.field_25030.method_8582(), Flashback.createReplayGameRules(featureFlagSet), new class_7712(this.field_24372.method_29589().comp_1010(), featureFlagSet));
        } else {
            this.field_24372.method_29590(new class_7712(this.field_24372.method_29589().comp_1010(), featureFlagSet));
        }
        this.overridePendingTags = pendingTags;
        this.method_29439(Set.of());
        this.gamePacketCodec = class_9095.field_48173.method_61107(class_9129.method_56350((class_5455)this.method_30611())).comp_2236();
        if (this.currentReplayReader != null) {
            this.currentReplayReader.changeRegistryAccess((class_5455)this.method_30611());
        }
        ArrayList players = new ArrayList(this.method_3760().method_14571());
        for (class_3222 player : players) {
            if (!(player instanceof ReplayPlayer)) continue;
            ((ServerGamePacketListenerImplExt)player.field_13987).flashback$switchToConfigWithTasks(initialPackets, configurationTasks);
        }
        this.replayViewers.clear();
    }

    public boolean method_3823() {
        class_1297.field_5978.set(1000000);
        final AtomicInteger newPlayerIds = new AtomicInteger(REPLAY_VIEWER_IDS_START);
        this.method_3846(new class_3324((MinecraftServer)this, this.method_46221(), this.field_24371, 1){

            public class_3222 method_14613(GameProfile gameProfile, class_8791 clientInformation) {
                class_3218 serverLevel;
                class_3218 level = ReplayServer.this.method_30002();
                if (ReplayServer.this.spawnLevel != null && (serverLevel = ReplayServer.this.method_3847(ReplayServer.this.spawnLevel)) != null) {
                    level = serverLevel;
                }
                ReplayPlayer player = new ReplayPlayer((MinecraftServer)ReplayServer.this, level, gameProfile, clientInformation);
                player.method_5838(newPlayerIds.getAndDecrement());
                player.followLocalPlayerNextTick = true;
                return player;
            }

            public void method_14570(class_2535 connection, class_3222 serverPlayer, class_8792 commonListenerCookie) {
                if (Flashback.getConfig().internal.filterUnnecessaryPackets) {
                    ((ConnectionExt)connection).flashback$setFilterUnnecessaryPackets();
                }
                super.method_14570(connection, serverPlayer, commonListenerCookie);
            }

            public boolean method_14609(GameProfile gameProfile) {
                return true;
            }

            public void method_43512(class_2561 component, Function<class_3222, class_2561> function, boolean bl) {
            }

            public void method_14576(class_3222 serverPlayer) {
                if (serverPlayer instanceof FakePlayer) {
                    return;
                }
                super.method_14576(serverPlayer);
            }

            public void method_14594(class_3222 serverPlayer) {
                if (serverPlayer instanceof FakePlayer) {
                    return;
                }
                super.method_14594(serverPlayer);
            }

            public void method_14581(class_2596<?> packet) {
                if (packet instanceof class_5896) {
                    long time = (long)ReplayServer.this.currentTick * 50L;
                    for (ReplayPlayer replayViewer : ReplayServer.this.replayViewers) {
                        ServerPlayNetworking.send((class_3222)replayViewer, (class_8710)new FlashbackSetBorderLerpStartTime(time));
                    }
                }
                super.method_14581(packet);
            }

            public void method_14605(@Nullable class_1657 player, double x, double y, double z, double distance, class_5321<class_1937> resourceKey, class_2596<?> packet) {
                UUID audioSourceEntity = null;
                EditorState editorState = ReplayServer.this.getEditorState();
                if (editorState != null) {
                    audioSourceEntity = editorState.audioSourceEntity;
                }
                for (ReplayPlayer replayViewer : ReplayServer.this.replayViewers) {
                    double dz;
                    double dy;
                    double dx;
                    class_1297 entity;
                    if (replayViewer == player || replayViewer.method_37908().method_27983() != resourceKey) continue;
                    class_243 source = replayViewer.method_19538();
                    if (audioSourceEntity != null && (entity = replayViewer.method_51469().method_14190(audioSourceEntity)) != null) {
                        source = entity.method_19538();
                    }
                    if (!((dx = x - source.field_1352) * dx + (dy = y - source.field_1351) * dy + (dz = z - source.field_1350) * dz < distance * distance)) continue;
                    replayViewer.field_13987.method_14364(packet);
                }
            }

            public void method_14606(class_3222 serverPlayer, class_3218 serverLevel) {
                if (serverPlayer instanceof FakePlayer) {
                    return;
                }
                super.method_14606(serverPlayer, serverLevel);
                serverPlayer.field_13987.method_14364((class_2596)new class_9053(Optional.empty()));
                EditorState editorState = ReplayServer.this.getEditorState();
                if (!editorState.replayVisuals.disableServerResourcePack) {
                    for (RemotePack remotePack : ReplayServer.this.remotePacks.values()) {
                        serverPlayer.field_13987.method_14364((class_2596)new class_2720(remotePack.id, remotePack.url, remotePack.hash, true, Optional.empty()));
                    }
                }
                serverPlayer.field_13987.method_14364((class_2596)new class_2772(ReplayServer.this.tabListHeader, ReplayServer.this.tabListFooter));
                serverPlayer.field_13987.method_14364((class_2596)new class_5889(serverLevel.method_8621()));
                ReplayServer.this.customPacketsInSnapshot.removeIf(packet -> {
                    try {
                        serverPlayer.field_13987.method_14364((class_2596)packet);
                        return false;
                    }
                    catch (Exception e) {
                        return true;
                    }
                });
            }

            protected void method_14577(class_3222 serverPlayer) {
            }

            public void method_14617() {
            }

            public void method_14597() {
                if (ReplayServer.this.shutdownReason == null) {
                    super.method_14597();
                } else {
                    List players = this.method_14571();
                    for (class_3222 player : players) {
                        player.field_13987.method_52396(ReplayServer.this.shutdownReason);
                    }
                }
            }

            public class_3442 method_14583(class_1657 player) {
                File statsDir = this.method_14561().method_27050(class_5218.field_24181).toFile();
                File statsFile = new File(statsDir, String.valueOf(player.method_5667()) + ".json");
                return new class_3442(this.method_14561(), statsFile);
            }
        });
        super.method_3823();
        return true;
    }

    public void pushRemotePack(UUID uuid, String url, String hash) {
        this.remotePacks.put(uuid, new RemotePack(uuid, url, hash));
    }

    public void popRemotePack(UUID uuid) {
        this.remotePacks.remove(uuid);
    }

    public void popAllRemotePacks() {
        this.remotePacks.clear();
    }

    public void setTabListCustomization(class_2561 header, class_2561 footer) {
        this.tabListHeader = header;
        this.tabListFooter = footer;
        this.method_3760().method_14581((class_2596)new class_2772(header, footer));
    }

    public void goToReplayTick(int tick) {
        this.jumpToTick = tick;
    }

    public float getDesiredTickRate(boolean manual) {
        if (manual) {
            return this.desiredTickRateManual;
        }
        return this.desiredTickRate;
    }

    public void setDesiredTickRate(float tickrate, boolean manual) {
        if (manual) {
            this.desiredTickRateManual = tickrate;
        } else {
            this.desiredTickRate = tickrate;
        }
    }

    public void setFrozen(boolean frozen, int delay) {
        this.desiredFrozen = frozen;
        this.desiredFrozenDelay = delay;
    }

    public int getReplayTick() {
        return this.targetTick;
    }

    public double getPartialReplayTick() {
        if (this.replayPaused || this.method_54809()) {
            return this.targetTick;
        }
        long currentNanos = class_156.method_648();
        long nanosPerTick = this.method_54833().method_54750();
        double partial = (double)(currentNanos - this.lastTickTimeNanos) / (double)nanosPerTick;
        partial = Math.max(0.0, Math.min(1.0, partial));
        return (double)this.lastReplayTick + partial;
    }

    public int getTotalReplayTicks() {
        return this.totalTicks;
    }

    public boolean doClientRendering() {
        return !this.isProcessingSnapshot && !this.processedSnapshot && !this.fastForwarding;
    }

    public void updateBossBar(class_2629 packet) {
        packet.method_34091(new class_2629.class_5881(){

            public void method_34103(UUID uuid, class_2561 component, float progress, class_1259.class_1260 bossBarColor, class_1259.class_1261 bossBarOverlay, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog) {
                class_1259 old = ReplayServer.this.bossEvents.remove(uuid);
                class_1259 newEvent = new class_1259(this, uuid, component, bossBarColor, bossBarOverlay){};
                newEvent.method_5408(progress);
                newEvent.method_5406(darkenScreen);
                newEvent.method_5410(playBossMusic);
                newEvent.method_5411(createWorldFog);
                if (old != null) {
                    if (old.method_5412() != progress) {
                        ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34094((class_1259)newEvent));
                    }
                    if (!old.method_5414().equals((Object)component)) {
                        ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34096((class_1259)newEvent));
                    }
                    if (!old.method_5420().equals((Object)bossBarColor) || !old.method_5415().equals((Object)bossBarOverlay)) {
                        ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34097((class_1259)newEvent));
                    }
                    if (old.method_5417() != darkenScreen || old.method_5418() != playBossMusic || old.method_5419() != createWorldFog) {
                        ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34098((class_1259)newEvent));
                    }
                } else {
                    ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34089((class_1259)newEvent));
                }
                ReplayServer.this.bossEvents.put(uuid, newEvent);
            }

            public void method_34099(UUID uuid) {
                if (ReplayServer.this.bossEvents.remove(uuid) != null) {
                    ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34090((UUID)uuid));
                }
            }

            public void method_34100(UUID uuid, float progress) {
                class_1259 current = ReplayServer.this.bossEvents.get(uuid);
                if (current != null) {
                    current.method_5408(progress);
                    ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34094((class_1259)current));
                }
            }

            public void method_34102(UUID uuid, class_2561 component) {
                class_1259 current = ReplayServer.this.bossEvents.get(uuid);
                if (current != null) {
                    current.method_5413(component);
                    ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34096((class_1259)current));
                }
            }

            public void method_34101(UUID uuid, class_1259.class_1260 bossBarColor, class_1259.class_1261 bossBarOverlay) {
                class_1259 current = ReplayServer.this.bossEvents.get(uuid);
                if (current != null) {
                    current.method_5416(bossBarColor);
                    current.method_5409(bossBarOverlay);
                    ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34097((class_1259)current));
                }
            }

            public void method_34104(UUID uuid, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog) {
                class_1259 current = ReplayServer.this.bossEvents.get(uuid);
                if (current != null) {
                    current.method_5406(darkenScreen);
                    current.method_5410(playBossMusic);
                    current.method_5411(createWorldFog);
                    ReplayServer.this.method_3760().method_14581((class_2596)class_2629.method_34098((class_1259)current));
                }
            }
        });
    }

    public Collection<ReplayPlayer> getReplayViewers() {
        return this.replayViewers;
    }

    public int getLocalPlayerId() {
        return this.gamePacketHandler.localPlayerId;
    }

    public void handleNextTick() {
        if (this.isProcessingSnapshot) {
            throw new IllegalStateException("Can't go to next tick while processing snapshot");
        }
        this.gamePacketHandler.flushPendingEntities();
        ++this.currentTick;
    }

    public void handleConfigurationPacket(class_9129 friendlyByteBuf) {
        class_2596 packet = (class_2596)this.configurationPacketCodec.decode((Object)friendlyByteBuf);
        this.gamePacketHandler.flushPendingEntities();
        packet.method_65081((class_2547)this.configurationPacketHandler);
    }

    public void handleGamePacket(class_9129 friendlyByteBuf) {
        class_2596 packet;
        this.configurationPacketHandler.flushPendingConfiguration();
        try {
            packet = (class_2596)this.gamePacketCodec.decode((Object)friendlyByteBuf);
        }
        catch (DecoderException decoderException) {
            if (this.printFailedDecodePacketCount > 0) {
                Flashback.LOGGER.error("Failed to decode packet from replay stream", (Throwable)decoderException);
                --this.printFailedDecodePacketCount;
            }
            this.gamePacketHandler.flushPendingEntities();
            friendlyByteBuf.method_52988(friendlyByteBuf.writerIndex());
            return;
        }
        if (!AllowPendingEntityPacketSet.allowPendingEntity(packet)) {
            this.gamePacketHandler.flushPendingEntities();
        }
        packet.method_65081((class_2547)this.gamePacketHandler);
    }

    public void handleCreateLocalPlayer(class_9129 friendlyByteBuf) {
        this.configurationPacketHandler.flushPendingConfiguration();
        this.gamePacketHandler.flushPendingEntities();
        this.gamePacketHandler.handleCreateLocalPlayer(friendlyByteBuf);
    }

    public void handleAccuratePlayerPosition(class_9129 friendlyByteBuf) {
        FlashbackConfigV1 config = Flashback.getConfig();
        if (config.advanced.disableIncreasedFirstPersonUpdates) {
            friendlyByteBuf.method_52988(friendlyByteBuf.writerIndex());
            return;
        }
        FlashbackAccurateEntityPosition packet = (FlashbackAccurateEntityPosition)FlashbackAccurateEntityPosition.STREAM_CODEC.decode((Object)friendlyByteBuf);
        for (ReplayPlayer replayViewer : this.replayViewers) {
            ServerPlayNetworking.send((class_3222)replayViewer, (class_8710)packet);
        }
    }

    public void handleMoveEntities(class_9129 friendlyByteBuf) {
        this.gamePacketHandler.flushPendingEntities();
        this.configurationPacketHandler.flushPendingConfiguration();
        int levelCount = friendlyByteBuf.method_10816();
        for (int i = 0; i < levelCount; ++i) {
            class_5321 dimension = friendlyByteBuf.method_44112(class_7924.field_41223);
            class_3218 level = (class_3218)this.field_4589.get(dimension);
            IntSet positionUpdateSet = null;
            if (level != null) {
                positionUpdateSet = this.needsPositionUpdate.computeIfAbsent((class_5321<class_1937>)dimension, k -> new IntOpenHashSet());
            }
            int count = friendlyByteBuf.method_10816();
            for (int j = 0; j < count; ++j) {
                int id = friendlyByteBuf.method_10816();
                double x = friendlyByteBuf.readDouble();
                double y = friendlyByteBuf.readDouble();
                double z = friendlyByteBuf.readDouble();
                float yaw = friendlyByteBuf.readFloat();
                float pitch = friendlyByteBuf.readFloat();
                float headYaw = friendlyByteBuf.readFloat();
                boolean onGround = friendlyByteBuf.readBoolean();
                if (level == null) continue;
                class_1297 entity = level.method_8469(id);
                if (entity != null) {
                    if (entity.method_5765()) {
                        entity.method_36456(yaw);
                        entity.method_36457(pitch);
                    } else {
                        entity.method_5808(x, y, z, yaw, pitch);
                        this.updatePositionOfPassengers(entity);
                    }
                    entity.method_5847(headYaw);
                    if (entity.method_24828() != onGround) {
                        entity.method_24830(onGround);
                    }
                    if (entity instanceof class_1542 || entity instanceof class_1303) continue;
                    positionUpdateSet.add(id);
                    continue;
                }
                if (this.isFrozen) continue;
                byte yRot = (byte)class_3532.method_15375((float)(yaw * 256.0f / 360.0f));
                byte xRot = (byte)class_3532.method_15375((float)(pitch * 256.0f / 360.0f));
                this.method_3760().method_14581(PacketHelper.createTeleportForUnknown(id, x, y, z, yRot, xRot, onGround));
            }
        }
    }

    private void updatePositionOfPassengers(class_1297 vehicle) {
        for (class_1297 passenger : vehicle.method_5685()) {
            vehicle.method_24201(passenger);
            this.updatePositionOfPassengers(passenger);
        }
    }

    public void handleLevelChunkCached(int index) {
        block5: {
            class_2672 packet = this.replayChunkCache.getOrLoad(index, (class_5455)this.method_30611(), this.gamePacketCodec);
            if (packet != null) {
                this.configurationPacketHandler.flushPendingConfiguration();
                this.gamePacketHandler.flushPendingEntities();
                try {
                    int x = packet.method_11523();
                    int z = packet.method_11524();
                    class_2818 chunk = this.gamePacketHandler.level().method_8497(x, z);
                    if (Flashback.EXPORT_JOB == null && ReplayServer.doesCachedChunkIdMatch(chunk, index) && !this.gamePacketHandler.forceSendChunksDueToMovingPistonShenanigans.contains(class_1923.method_8331((int)x, (int)z))) break block5;
                    packet.method_11528((class_2602)this.gamePacketHandler);
                    if (chunk instanceof LevelChunkExt) {
                        LevelChunkExt ext = (LevelChunkExt)chunk;
                        ext.flashback$setCachedChunkId(index);
                    }
                }
                catch (Exception exception) {}
            } else {
                Flashback.LOGGER.error("Missing cached level chunk: {}", (Object)index);
            }
        }
    }

    private static boolean doesCachedChunkIdMatch(class_2818 chunk, int chunkId) {
        if (chunk instanceof LevelChunkExt) {
            LevelChunkExt ext = (LevelChunkExt)chunk;
            return ext.flashback$getCachedChunkId() == chunkId;
        }
        return false;
    }

    public void method_3735() {
        super.method_3735();
        for (class_3218 level : this.field_4589.values()) {
            level.field_13957 = true;
        }
    }

    public void closeLevel(class_3218 serverLevel) {
        if (serverLevel == null) {
            return;
        }
        this.clearLevel(serverLevel);
        ((ServerWorldEvents.Unload)ServerWorldEvents.UNLOAD.invoker()).onWorldUnload((MinecraftServer)this, serverLevel);
        try {
            serverLevel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearLevel(class_3218 serverLevel) {
        if (serverLevel == null) {
            return;
        }
        for (class_3222 player : new ArrayList(serverLevel.method_18456())) {
            if (player instanceof ReplayPlayer) {
                ReplayPlayer replayPlayer = (ReplayPlayer)player;
                replayPlayer.lastFirstPersonDataUUID = null;
                continue;
            }
            player.method_31472();
        }
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (class_1297 entity : serverLevel.method_27909()) {
            if (entity instanceof class_3222) continue;
            entities.add(entity);
        }
        for (class_1297 entity : entities) {
            if (entity == null) continue;
            entity.method_31472();
        }
        serverLevel.method_29199(0L);
        for (class_3222 player : serverLevel.method_18456()) {
            if (!(player instanceof ReplayPlayer)) continue;
            ReplayPlayer replayPlayer = (ReplayPlayer)player;
            ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)FlashbackClearEntities.INSTANCE);
        }
    }

    public boolean method_3866() {
        return super.method_3866() && this.jumpToTick < 0;
    }

    public void method_20813() {
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    public EditorState getEditorState() {
        if (Flashback.isExporting()) {
            return Flashback.EXPORT_JOB.getSettings().editorState();
        }
        return EditorStateManager.get(this.metadata.replayIdentifier);
    }

    public boolean method_3820() {
        return super.method_3820() && this.initializedWithSnapshot;
    }

    public void method_3748(BooleanSupplier booleanSupplier) {
        if (!this.initializedWithSnapshot) {
            this.initializedWithSnapshot = true;
            ReplayReader replayReader = this.playableChunksByStart.get(0).getOrLoadReplayReader((class_5455)this.method_30611());
            replayReader.handleSnapshot(this);
            this.gamePacketHandler.flushPendingEntities();
        }
        EditorState editorState = this.getEditorState();
        this.lastReplayTick = this.targetTick;
        this.lastTickTimeNanos = this.field_47139 - this.method_54833().method_54750();
        this.replayViewers.clear();
        this.hasNonSpectatorReplayViewer = false;
        for (class_3222 player : this.method_3760().method_14571()) {
            if (!(player instanceof ReplayPlayer)) continue;
            ReplayPlayer replayPlayer = (ReplayPlayer)player;
            if (replayPlayer.method_5715()) {
                replayPlayer.spectatingUuid = null;
                replayPlayer.spectatingUuidTickCount = 0;
                replayPlayer.forceRespectateTickCount = 0;
            } else {
                class_1297 class_12972 = replayPlayer.method_14242();
                if (class_12972 != null && class_12972 != replayPlayer) {
                    replayPlayer.spectatingUuid = class_12972.method_5667();
                    replayPlayer.spectatingUuidTickCount = 20;
                } else if (replayPlayer.spectatingUuidTickCount > 0) {
                    --replayPlayer.spectatingUuidTickCount;
                } else {
                    replayPlayer.spectatingUuid = null;
                }
            }
            if (!replayPlayer.method_7325()) {
                this.hasNonSpectatorReplayViewer = true;
            }
            this.replayViewers.add(replayPlayer);
        }
        if (!this.replayPaused && this.method_54809()) {
            this.replayPaused = true;
        }
        boolean normalPlayback = false;
        if (this.jumpToTick >= 0) {
            this.targetTick = this.jumpToTick;
            this.jumpToTick = -1;
        } else if (!this.replayPaused && this.targetTick < this.totalTicks) {
            ++this.targetTick;
            normalPlayback = true;
        } else if (this.targetTick == this.totalTicks && this.currentTick == this.totalTicks) {
            this.replayPaused = true;
        }
        class_8915 tickRateManager = this.method_54833();
        ((ServerTickRateManagerExt)tickRateManager).flashback$setSuppressClientUpdates(true);
        if (Flashback.EXPORT_JOB != null || this.targetTick == this.currentTick || normalPlayback || this.isFrozen) {
            this.runUpdates(booleanSupplier);
        } else {
            int realTargetTick = this.targetTick;
            if (this.targetTick < this.currentTick) {
                int n = this.playableChunksByStart.floorKey(this.targetTick) + 1;
                this.targetTick = Math.max(n, realTargetTick - 20);
            } else {
                this.targetTick = Math.max(this.currentTick + 1, realTargetTick - 20);
            }
            if (this.targetTick >= realTargetTick) {
                this.targetTick = realTargetTick;
                this.runUpdates(booleanSupplier);
            } else {
                while (this.targetTick <= realTargetTick) {
                    this.fastForwarding = this.targetTick < realTargetTick;
                    this.runUpdates(booleanSupplier);
                    if (this.targetTick == realTargetTick) break;
                    ++this.targetTick;
                }
                this.fastForwarding = false;
            }
        }
        ((ServerTickRateManagerExt)tickRateManager).flashback$setSuppressClientUpdates(false);
        if (this.forceApplyKeyframes.compareAndSet(true, false)) {
            ((MinecraftExt)class_310.method_1551()).flashback$applyKeyframes();
        }
        this.tryFollowLocalPlayer();
        for (ReplayPlayer replayPlayer : this.replayViewers) {
            class_1297 camera;
            if (replayPlayer.spectatingUuid != null) {
                class_1297 targetEntity;
                camera = replayPlayer.method_14242();
                if ((replayPlayer.forceRespectateTickCount > 0 || camera == null || camera == replayPlayer || camera.method_31481()) && (targetEntity = replayPlayer.method_51469().method_14190(replayPlayer.spectatingUuid)) != null && !targetEntity.method_31481()) {
                    replayPlayer.method_14224(null);
                    replayPlayer.method_14224(targetEntity);
                    replayPlayer.spectatingUuid = targetEntity.method_5667();
                    if (replayPlayer.forceRespectateTickCount == 0) {
                        replayPlayer.forceRespectateTickCount = 5;
                    }
                }
            }
            if (replayPlayer.forceRespectateTickCount > 0) {
                --replayPlayer.forceRespectateTickCount;
            }
            if ((camera = replayPlayer.method_14242()) != replayPlayer && camera instanceof class_1657) {
                class_1799 hotbarItem;
                int i;
                class_1702 foodData;
                class_1657 playerCamera = (class_1657)camera;
                class_1661 inventory = playerCamera.method_31548();
                if (!Objects.equals(replayPlayer.lastFirstPersonDataUUID, playerCamera.method_5667())) {
                    replayPlayer.lastFirstPersonDataUUID = playerCamera.method_5667();
                    replayPlayer.lastFirstPersonExperienceProgress = playerCamera.field_7510;
                    replayPlayer.lastFirstPersonTotalExperience = playerCamera.field_7495;
                    replayPlayer.lastFirstPersonExperienceLevel = playerCamera.field_7520;
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteExperience(playerCamera.method_5628(), playerCamera.field_7510, playerCamera.field_7495, playerCamera.field_7520));
                    foodData = playerCamera.method_7344();
                    replayPlayer.lastFirstPersonFoodLevel = foodData.method_7586();
                    replayPlayer.lastFirstPersonSaturationLevel = foodData.method_7589();
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteFoodData(playerCamera.method_5628(), foodData.method_7586(), foodData.method_7589()));
                    replayPlayer.lastFirstPersonSelectedSlot = inventory.field_7545;
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteSelectHotbarSlot(playerCamera.method_5628(), inventory.field_7545));
                    for (i = 0; i < 9; ++i) {
                        hotbarItem = inventory.method_5438(i);
                        replayPlayer.lastFirstPersonHotbarItems[i] = hotbarItem.method_7972();
                        ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteSetSlot(playerCamera.method_5628(), i, hotbarItem.method_7972()));
                    }
                    continue;
                }
                if (replayPlayer.lastFirstPersonExperienceProgress != playerCamera.field_7510 || replayPlayer.lastFirstPersonTotalExperience != playerCamera.field_7495 || replayPlayer.lastFirstPersonExperienceLevel != playerCamera.field_7520) {
                    replayPlayer.lastFirstPersonExperienceProgress = playerCamera.field_7510;
                    replayPlayer.lastFirstPersonTotalExperience = playerCamera.field_7495;
                    replayPlayer.lastFirstPersonExperienceLevel = playerCamera.field_7520;
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteExperience(playerCamera.method_5628(), playerCamera.field_7510, playerCamera.field_7495, playerCamera.field_7520));
                }
                if (replayPlayer.lastFirstPersonFoodLevel != (foodData = playerCamera.method_7344()).method_7586() || replayPlayer.lastFirstPersonSaturationLevel != foodData.method_7589()) {
                    replayPlayer.lastFirstPersonFoodLevel = foodData.method_7586();
                    replayPlayer.lastFirstPersonSaturationLevel = foodData.method_7589();
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteFoodData(playerCamera.method_5628(), foodData.method_7586(), foodData.method_7589()));
                }
                if (replayPlayer.lastFirstPersonSelectedSlot != inventory.field_7545) {
                    replayPlayer.lastFirstPersonSelectedSlot = inventory.field_7545;
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteSelectHotbarSlot(playerCamera.method_5628(), inventory.field_7545));
                }
                for (i = 0; i < 9; ++i) {
                    hotbarItem = inventory.method_5438(i);
                    if (class_1799.method_7973((class_1799)replayPlayer.lastFirstPersonHotbarItems[i], (class_1799)hotbarItem)) continue;
                    replayPlayer.lastFirstPersonHotbarItems[i] = hotbarItem.method_7972();
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)new FlashbackRemoteSetSlot(playerCamera.method_5628(), i, hotbarItem.method_7972()));
                }
                continue;
            }
            replayPlayer.lastFirstPersonDataUUID = null;
        }
        if (this.remotePacks.isEmpty() || editorState.replayVisuals.disableServerResourcePack) {
            if (!this.oldRemotePacks.isEmpty()) {
                this.oldRemotePacks.clear();
                this.method_3760().method_14581((class_2596)new class_9053(Optional.empty()));
            }
        } else {
            for (Map.Entry entry : this.remotePacks.entrySet()) {
                RemotePack remotePack = (RemotePack)entry.getValue();
                RemotePack oldRemotePack = this.oldRemotePacks.get(entry.getKey());
                if (oldRemotePack == null) {
                    this.method_3760().method_14581((class_2596)new class_2720(remotePack.id, remotePack.url, remotePack.hash, true, Optional.empty()));
                } else if (!oldRemotePack.equals(remotePack)) {
                    this.method_3760().method_14581((class_2596)new class_9053(Optional.of(remotePack.id)));
                    this.method_3760().method_14581((class_2596)new class_2720(remotePack.id, remotePack.url, remotePack.hash, true, Optional.empty()));
                }
                this.oldRemotePacks.put((UUID)entry.getKey(), remotePack);
            }
            this.oldRemotePacks.keySet().removeIf(uuid -> {
                if (!this.remotePacks.containsKey(uuid)) {
                    this.method_3760().method_14581((class_2596)new class_9053(Optional.of(uuid)));
                    return true;
                }
                return false;
            });
        }
        boolean bl = this.hasServerResourcePack = !this.remotePacks.isEmpty();
        if (this.sendFinishedServerTick.compareAndExchange(true, false)) {
            for (ReplayPlayer replayPlayer : this.replayViewers) {
                ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)FinishedServerTick.INSTANCE);
            }
            if (this.replayViewers.isEmpty() && Flashback.EXPORT_JOB != null) {
                Flashback.EXPORT_JOB.onFinishedServerTick();
            }
        }
    }

    private void runUpdates(BooleanSupplier booleanSupplier) {
        boolean tickChanged;
        class_8915 tickRateManager;
        this.desiredTickRate = 20.0f;
        this.desiredFrozen = false;
        this.getEditorState().applyKeyframes(new ReplayServerKeyframeHandler(this), this.targetTick);
        if (this.desiredFrozen && this.frozenDelay < 0) {
            this.frozenDelay = this.desiredFrozenDelay <= 0 ? 1 : (this.desiredFrozenDelay <= 5 ? 2 : 3);
        }
        float tickRate = this.desiredTickRate;
        if (Flashback.EXPORT_JOB == null) {
            tickRate *= this.desiredTickRateManual / 20.0f;
        }
        if (this.desiredFrozen) {
            if (this.frozenDelay > 0) {
                --this.frozenDelay;
            }
            if (this.frozenDelay == 0) {
                this.isFrozen = true;
            }
        } else {
            this.frozenDelay = -1;
            this.isFrozen = false;
        }
        if ((tickRateManager = this.method_54833()).method_54748() != tickRate) {
            tickRateManager.method_54671(tickRate);
        }
        if (tickRateManager.method_54754() != this.isFrozen) {
            tickRateManager.method_54675(this.isFrozen);
        }
        boolean bl = tickChanged = this.targetTick != this.currentTick;
        if (this.isFrozen && this.targetTick >= this.currentTick) {
            tickChanged = false;
        } else {
            this.handleActions();
        }
        for (class_3218 class_32182 : this.method_3738()) {
            for (class_1297 entity : class_32182.method_27909()) {
                class_1923 chunkPos = new class_1923(entity.method_24515());
                class_32182.method_14178().method_17297(ENTITY_LOAD_TICKET, chunkPos, 3, (Object)chunkPos);
            }
        }
        super.method_3748(booleanSupplier);
        this.applyBlockOverridesToTimeline();
        if (!this.isFrozen && !this.needsPositionUpdate.isEmpty()) {
            for (Map.Entry entry : this.needsPositionUpdate.entrySet()) {
                class_5321 dimension = (class_5321)entry.getKey();
                IntSet entities = (IntSet)entry.getValue();
                class_3218 level = this.method_3847(dimension);
                if (level == null) continue;
                Int2ObjectMap entityMap = level.method_14178().field_17254.field_18242;
                IntIterator iterator = entities.intIterator();
                while (iterator.hasNext()) {
                    int entityId = iterator.nextInt();
                    class_3898.class_3208 trackedEntity = (class_3898.class_3208)entityMap.get(entityId);
                    if (trackedEntity == null) continue;
                    class_3231 serverEntity = trackedEntity.field_18246;
                    class_243 trackingPosition = serverEntity.field_14049.method_43390();
                    byte quantizedYRot = (byte)class_3532.method_15375((float)(serverEntity.field_14049.method_36454() * 256.0f / 360.0f));
                    byte quantizedXRot = (byte)class_3532.method_15375((float)(serverEntity.field_14049.method_36455() * 256.0f / 360.0f));
                    if (!serverEntity.field_14049.method_5765() && !serverEntity.field_39019.method_60933().equals((Object)trackingPosition)) {
                        trackedEntity.method_18730((class_2596)new class_10264(serverEntity.field_14049.method_5628(), class_10182.method_63638((class_1297)serverEntity.field_14049), serverEntity.field_14036));
                        serverEntity.field_39019.method_43494(trackingPosition);
                        serverEntity.field_14060 = quantizedYRot;
                        serverEntity.field_14047 = quantizedXRot;
                        continue;
                    }
                    if (quantizedYRot == serverEntity.field_14060 && quantizedXRot == serverEntity.field_14047) continue;
                    trackedEntity.method_18730((class_2596)new class_2684.class_2687(entityId, quantizedYRot, quantizedXRot, serverEntity.field_14036));
                    serverEntity.field_14060 = quantizedYRot;
                    serverEntity.field_14047 = quantizedXRot;
                }
            }
            this.needsPositionUpdate.clear();
        }
        if (Flashback.EXPORT_JOB == null) {
            if (this.processedSnapshot) {
                this.processedSnapshot = false;
                for (ReplayPlayer replayPlayer : this.replayViewers) {
                    replayPlayer.field_13987.field_45026.method_52386((class_3222)replayPlayer);
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)FlashbackInstantlyLerp.INSTANCE);
                    ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)FlashbackClearParticles.INSTANCE);
                }
                for (class_3218 class_32183 : this.method_3738()) {
                    for (class_3222 player : class_32183.method_18456()) {
                        if (!(player instanceof ReplayPlayer)) continue;
                        class_32183.method_14178().method_14096(player);
                        class_32183.method_14178().method_14096(player);
                    }
                }
            }
            if (this.replayPaused) {
                if (tickChanged) {
                    if (tickRateManager.method_54754()) {
                        tickRateManager.method_54675(false);
                    }
                    ((ServerTickRateManagerExt)tickRateManager).flashback$setSuppressClientUpdates(false);
                    for (ReplayPlayer replayPlayer : this.replayViewers) {
                        ServerPlayNetworking.send((class_3222)replayPlayer, (class_8710)FlashbackForceClientTick.INSTANCE);
                    }
                    tickRateManager.method_54675(true);
                    ((ServerTickRateManagerExt)tickRateManager).flashback$setSuppressClientUpdates(true);
                } else if (!tickRateManager.method_54754()) {
                    tickRateManager.method_54675(true);
                }
            } else if (tickRateManager.method_54754() != this.isFrozen) {
                tickRateManager.method_54675(this.isFrozen);
            }
        } else if (!tickRateManager.method_54754()) {
            tickRateManager.method_54675(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyBlockOverridesToTimeline() {
        if (this.pendingBlockOverrides.isEmpty()) {
            return;
        }
        List<BlockAtPosition> pendingBlockOverrides = this.pendingBlockOverrides;
        this.pendingBlockOverrides = new ArrayList<BlockAtPosition>();
        EditorState editorState = this.getEditorState();
        long stamp = editorState.acquireWrite();
        try {
            EditorScene scene = editorState.getCurrentScene(stamp);
            int currentTick = this.currentTick;
            boolean added = false;
            for (KeyframeTrack keyframeTrack : scene.keyframeTracks) {
                if (keyframeTrack.keyframeType != BlockOverrideKeyframeType.INSTANCE) continue;
                BlockOverrideKeyframe keyframe = (BlockOverrideKeyframe)keyframeTrack.keyframesByTick.get(currentTick);
                if (keyframe == null) {
                    keyframe = new BlockOverrideKeyframe();
                    keyframeTrack.keyframesByTick.put(currentTick, keyframe);
                }
                for (BlockAtPosition pendingBlockOverride : pendingBlockOverrides) {
                    long pos = pendingBlockOverride.pos;
                    int x = class_2338.method_10061((long)pos);
                    int y = class_2338.method_10071((long)pos);
                    int z = class_2338.method_10083((long)pos);
                    keyframe.setBlock(x, y, z, pendingBlockOverride.blockState);
                }
                added = true;
                break;
            }
            if (!added) {
                KeyframeTrack keyframeTrack = new KeyframeTrack(BlockOverrideKeyframeType.INSTANCE);
                BlockOverrideKeyframe keyframe = new BlockOverrideKeyframe();
                keyframeTrack.keyframesByTick.put(currentTick, keyframe);
                for (BlockAtPosition pendingBlockOverride : pendingBlockOverrides) {
                    long pos = pendingBlockOverride.pos;
                    int x = class_2338.method_10061((long)pos);
                    int y = class_2338.method_10071((long)pos);
                    int z = class_2338.method_10083((long)pos);
                    keyframe.setBlock(x, y, z, pendingBlockOverride.blockState);
                }
                scene.keyframeTracks.add(keyframeTrack);
            }
        }
        finally {
            editorState.release(stamp);
        }
    }

    public void method_49750(class_3218 level) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActions() {
        Map.Entry<Integer, PlayableChunk> entry;
        boolean shouldJump;
        this.targetTick = Math.max(0, Math.min(this.totalTicks, this.targetTick));
        if (this.targetTick == this.currentTick) {
            return;
        }
        Map.Entry<Integer, PlayableChunk> oldEntry = this.playableChunksByStart.floorEntry(this.currentTick);
        int duration = oldEntry != null ? oldEntry.getValue().chunkMeta.duration : 6000;
        duration = Math.max(1200, duration);
        boolean bl = shouldJump = this.targetTick < this.currentTick;
        if (this.targetTick > this.currentTick + duration) {
            if (oldEntry != null) {
                Map.Entry<Integer, PlayableChunk> targetEntry = this.playableChunksByStart.floorEntry(this.targetTick);
                shouldJump |= oldEntry.getValue() != targetEntry.getValue();
            } else {
                shouldJump = true;
            }
        }
        if (shouldJump) {
            this.processedSnapshot = true;
            this.clearDataForPlayingSnapshot();
            entry = this.playableChunksByStart.floorEntry(this.targetTick);
            ReplayReader replayReader = entry.getValue().getOrLoadReplayReader((class_5455)this.method_30611());
            replayReader.handleSnapshot(this);
            this.gamePacketHandler.flushPendingEntities();
            entry.getValue().getOrLoadReplayReader((class_5455)this.method_30611()).resetToStart();
            this.currentTick = entry.getKey();
        }
        if ((entry = this.playableChunksByStart.floorEntry(this.currentTick)) == null) {
            return;
        }
        this.currentReplayReader = entry.getValue().getOrLoadReplayReader((class_5455)this.method_30611());
        if (this.currentTick == entry.getKey()) {
            this.currentReplayReader.resetToStart();
            if (!this.processedSnapshot && entry.getValue().chunkMeta.forcePlaySnapshot) {
                this.processedSnapshot = true;
                this.clearDataForPlayingSnapshot();
                this.currentReplayReader.handleSnapshot(this);
                this.gamePacketHandler.flushPendingEntities();
            }
        }
        EditorState editorState = this.getEditorState();
        long stamp = editorState.acquireRead();
        try {
            EditorScene scene = editorState.getCurrentScene(stamp);
            TreeMap<Integer, Keyframe> blockOverrideKeyframes = null;
            for (KeyframeTrack keyframeTrack : scene.keyframeTracks) {
                if (!keyframeTrack.enabled || keyframeTrack.keyframeType != BlockOverrideKeyframeType.INSTANCE) continue;
                blockOverrideKeyframes = keyframeTrack.keyframesByTick;
                break;
            }
            if (blockOverrideKeyframes == null) {
                editorState.release(stamp);
                stamp = 0L;
            }
            int lastBlockOverrideTick = this.currentTick;
            while (this.currentTick < this.targetTick) {
                if (lastBlockOverrideTick != this.currentTick && blockOverrideKeyframes != null) {
                    this.applyBlockOverrideKeyframes(blockOverrideKeyframes, lastBlockOverrideTick);
                    lastBlockOverrideTick = this.currentTick;
                }
                if (!this.currentReplayReader.handleNextAction(this)) {
                    Map.Entry<Integer, PlayableChunk> newEntry = this.playableChunksByStart.floorEntry(this.currentTick);
                    if (newEntry.getValue() == entry.getValue()) {
                        this.targetTick = this.currentTick;
                        this.replayPaused = true;
                        return;
                    }
                    entry = newEntry;
                    if (newEntry.getKey() != this.currentTick) {
                        Flashback.LOGGER.error("Error processing replay: ran out of entries before expected end of PlayableChunk");
                        Flashback.LOGGER.error("Current tick: {}", (Object)this.currentTick);
                        Flashback.LOGGER.error("New entry start: {}", (Object)newEntry.getKey());
                        this.stopWithReason((class_2561)class_2561.method_43470((String)"Error processing replay: ran out of entries before expected end of PlayableChunk"));
                        return;
                    }
                    this.currentReplayReader = entry.getValue().getOrLoadReplayReader((class_5455)this.method_30611());
                    this.currentReplayReader.resetToStart();
                    if (entry.getValue().chunkMeta.forcePlaySnapshot) {
                        this.processedSnapshot = true;
                        this.clearDataForPlayingSnapshot();
                        this.currentReplayReader.handleSnapshot(this);
                        this.gamePacketHandler.flushPendingEntities();
                    }
                }
                if (entry.getKey() + entry.getValue().chunkMeta.duration >= this.currentTick) continue;
                Flashback.LOGGER.error("Error processing replay: actual duration of PlayableChunk inconsistent with recorded duration");
                Flashback.LOGGER.error("Current tick: {}", (Object)this.currentTick);
                Flashback.LOGGER.error("PlayableChunk tick base: {}", (Object)entry.getKey());
                Flashback.LOGGER.error("PlayableChunk duration: {}", (Object)entry.getValue().chunkMeta.duration);
                this.stopWithReason((class_2561)class_2561.method_43470((String)"Error processing replay: actual duration of PlayableChunk inconsistent with recorded duration"));
            }
            if (blockOverrideKeyframes != null) {
                if (lastBlockOverrideTick != this.currentTick) {
                    this.applyBlockOverrideKeyframes(blockOverrideKeyframes, lastBlockOverrideTick);
                }
                this.applyBlockOverrideKeyframes(blockOverrideKeyframes, this.currentTick);
            }
        }
        finally {
            if (stamp != 0L) {
                editorState.release(stamp);
            }
            this.currentReplayReader = null;
        }
    }

    private void applyBlockOverrideKeyframes(Map<Integer, Keyframe> blockOverrideKeyframes, int tick) {
        BlockOverrideKeyframe keyframe;
        class_3218 level = this.gamePacketHandler.level();
        if (level != null && (keyframe = (BlockOverrideKeyframe)blockOverrideKeyframes.get(tick)) != null) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_2680 emptyState = BlockOverrideKeyframe.EMPTY_STATE;
            for (Long2ObjectMap.Entry chunkEntry : keyframe.blocks.long2ObjectEntrySet()) {
                long chunkPos = chunkEntry.getLongKey();
                int chunkX = class_2338.method_10061((long)chunkPos);
                int chunkY = class_2338.method_10071((long)chunkPos);
                int chunkZ = class_2338.method_10083((long)chunkPos);
                if (chunkY < level.method_32891() || chunkY > level.method_31597()) continue;
                class_2841 container = (class_2841)chunkEntry.getValue();
                class_2818 levelChunk = level.method_8497(chunkX, chunkZ);
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                            if (blockState == emptyState) continue;
                            mutableBlockPos.method_10103((chunkX << 4) + x, (chunkY << 4) + y, (chunkZ << 4) + z);
                            class_2680 old = ((LevelChunkExt)levelChunk).flashback$setBlockStateWithoutUpdates((class_2338)mutableBlockPos, blockState);
                            if (old == null) continue;
                            level.method_8413((class_2338)mutableBlockPos, old, blockState, 3);
                        }
                    }
                }
            }
        }
    }

    private void clearDataForPlayingSnapshot() {
        for (ReplayPlayer replayViewer : this.replayViewers) {
            for (UUID uuid : this.bossEvents.keySet()) {
                replayViewer.field_13987.method_14364((class_2596)class_2629.method_34090((UUID)uuid));
            }
        }
        this.bossEvents.clear();
    }

    public void blockChangeOccurred(class_2338 blockPos, class_2680 result) {
        if (this.replayPaused && this.hasNonSpectatorReplayViewer) {
            this.pendingBlockOverrides.add(new BlockAtPosition(blockPos.method_10063(), result));
        }
    }

    private void tryFollowLocalPlayer() {
        if (this.spawnLevel == null) {
            return;
        }
        class_3218 currentLevel = this.method_3847(this.spawnLevel);
        if (currentLevel == null) {
            return;
        }
        class_1297 follow = currentLevel.method_8469(this.gamePacketHandler.localPlayerId);
        if (follow == null) {
            return;
        }
        for (ReplayPlayer replayViewer : this.getReplayViewers()) {
            boolean shouldFollow = replayViewer.followLocalPlayerNextTick;
            if (this.followLocalPlayerNextTickIfWrongDimension) {
                shouldFollow |= replayViewer.method_37908() != currentLevel;
            }
            if (!shouldFollow) continue;
            replayViewer.followLocalPlayerNextTick = false;
            replayViewer.method_48105(currentLevel, follow.method_23317(), follow.method_23318(), follow.method_23321(), Set.of(), follow.method_36454(), follow.method_36455(), false);
        }
        this.followLocalPlayerNextTickIfWrongDimension = false;
    }

    private void stopWithReason(class_2561 reason) {
        this.shutdownReason = reason;
        this.method_3747(false);
    }

    public boolean method_39218(boolean bl, boolean bl2, boolean bl3) {
        return false;
    }

    public boolean method_3723(boolean bl, boolean bl2, boolean bl3) {
        return false;
    }

    public void method_3782() {
        for (class_3218 level : this.field_4589.values()) {
            if (level == null) continue;
            try {
                level.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.field_4589.clear();
        super.method_3782();
        TempFolderProvider.deleteTemp(TempFolderProvider.TempFolderType.SERVER, this.playbackUUID);
        if (this.playbackFileSystem != null) {
            try {
                this.playbackFileSystem.close();
            }
            catch (IOException e) {
                Flashback.LOGGER.error("Failed to close playback zip", (Throwable)e);
            }
        }
        this.replayChunkCache.clear();
        this.playableChunksByStart.clear();
    }

    public void clearReplayTempFolder() {
        Path temp = TempFolderProvider.createTemp(TempFolderProvider.TempFolderType.SERVER, this.playbackUUID);
        try {
            Files.walkFileTree(temp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals("DistantHorizons.sqlite")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!Files.isDirectory(file, new LinkOption[0])) {
                        Files.deleteIfExists(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Flashback.LOGGER.error("Unable to delete replay temp folder", (Throwable)e);
        }
    }

    public boolean method_19466(GameProfile gameProfile) {
        return gameProfile.getName().equals(REPLAY_VIEWER_NAME) && gameProfile.getProperties().containsKey((Object)"IsReplayViewer");
    }

    private record RemotePack(UUID id, String url, String hash) {
    }

    private record BlockAtPosition(long pos, class_2680 blockState) {
    }
}

