/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.visuals;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.record.ReplayMarker;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.CameraPath;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class WorldRenderHook {
    public static void renderHook(class_4587 poseStack, float partialTick, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, Matrix4f projection) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer == null || Flashback.isExporting() || !ReplayUI.isActive()) {
            return;
        }
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && editorState.replayVisuals.cameraPath) {
            CameraPath.renderCameraPath(poseStack, camera, replayServer);
        }
        FlashbackMeta meta = replayServer.getMetadata();
        if (!meta.replayMarkers.isEmpty()) {
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            class_4597.class_4598 multiBufferSource = class_310.method_1551().method_22940().method_23000();
            String dimension = class_310.method_1551().field_1687.method_27983().toString();
            multiBufferSource.method_22993();
            for (ReplayMarker marker : meta.replayMarkers.values()) {
                ReplayMarker.MarkerPosition position;
                if (marker.position() == null || !(position = marker.position()).dimension().equals(dimension)) continue;
                poseStack.method_22903();
                poseStack.method_22904((double)position.position().x - camera.method_19326().field_1352, (double)position.position().y - camera.method_19326().field_1351, (double)position.position().z - camera.method_19326().field_1350);
                poseStack.method_22907(camera.method_23767());
                float width = 0.2f;
                bufferBuilder.method_56824(poseStack.method_23760(), -0.2f, -0.2f, 0.0f).method_22913(0.0f, 0.0f).method_39415(marker.colour() | 0xFF000000);
                bufferBuilder.method_56824(poseStack.method_23760(), 0.2f, -0.2f, 0.0f).method_22913(1.0f, 0.0f).method_39415(marker.colour() | 0xFF000000);
                bufferBuilder.method_56824(poseStack.method_23760(), 0.2f, 0.2f, 0.0f).method_22913(1.0f, 1.0f).method_39415(marker.colour() | 0xFF000000);
                bufferBuilder.method_56824(poseStack.method_23760(), -0.2f, 0.2f, 0.0f).method_22913(0.0f, 1.0f).method_39415(marker.colour() | 0xFF000000);
                if (marker.description() != null) {
                    class_327 font = class_310.method_1551().field_1772;
                    Matrix4f matrix4f = poseStack.method_23760().method_23761();
                    matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
                    matrix4f.scale(-0.025f, -0.025f, -0.025f);
                    int descriptionWidth = font.method_1727(marker.description());
                    font.method_27521(marker.description(), (float)(-descriptionWidth) / 2.0f, -20.0f, -1, true, matrix4f, (class_4597)multiBufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                }
                poseStack.method_22909();
            }
            class_9801 meshData = bufferBuilder.method_60794();
            if (meshData != null) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader((class_10156)class_10142.field_53880);
                RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"flashback:world_marker_circle.png"));
                class_286.method_43433((class_9801)meshData);
            }
            multiBufferSource.method_22993();
        }
    }
}

