/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui;

import com.moulberry.flashback.editor.ui.ReplayUI;
import imgui.ImGui;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.joml.Intersectionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract sealed class EditorMovementControls {
    public abstract boolean allowGameInputWhileCaptureKeyboard();

    public abstract boolean shouldStop(boolean var1);

    public abstract void update(double var1, double var3);

    public static EditorMovementControls none() {
        return None.INSTANCE;
    }

    public static EditorMovementControls rotate() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return None.INSTANCE;
        }
        return new Rotate(ReplayUI.getMouseForwardsVector(), new class_241(class_310.method_1551().field_1724.method_36455(), class_310.method_1551().field_1724.method_36454()));
    }

    protected static final class None
    extends EditorMovementControls {
        private static final None INSTANCE = new None();

        protected None() {
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return false;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return false;
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
        }
    }

    protected static final class Rotate
    extends EditorMovementControls {
        private final class_243 originalForwards;
        private final class_241 originalAngles;

        public Rotate(class_243 originalForwards, class_241 originalAngles) {
            this.originalForwards = originalForwards;
            this.originalAngles = originalAngles;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return true;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !ImGui.isMouseDown(0);
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            class_243 forwards = ReplayUI.getMouseForwardsVector();
            class_746 player = class_310.method_1551().field_1724;
            if (forwards == null || player == null) {
                return;
            }
            float pitch = this.originalAngles.field_1343;
            float yaw = this.originalAngles.field_1342;
            class_243 lastVector = this.originalForwards;
            for (int i = 1; i <= 10; ++i) {
                class_243 thisVector = this.originalForwards.method_35590(forwards, (double)((float)i / 10.0f));
                double differenceY = lastVector.field_1351 - thisVector.field_1351;
                double pitchDelta = Math.toDegrees(Math.asin(differenceY / 2.0)) * 2.0;
                pitch = class_3532.method_15393((float)(pitch - (float)pitchDelta));
                pitch = class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f);
                double yaw1 = Math.toDegrees(Math.atan2(lastVector.field_1352, lastVector.field_1350));
                double yaw2 = Math.toDegrees(Math.atan2(thisVector.field_1352, thisVector.field_1350));
                double yawDelta = class_3532.method_15338((double)(yaw1 - yaw2));
                Vector3f forwards3f = lastVector.method_35590(thisVector, 0.5).method_46409();
                forwards3f.rotateX((float)Math.toRadians(pitch));
                forwards3f.normalize();
                float radius = (float)Math.sqrt(1.0f - forwards3f.y() * forwards3f.y()) * 1.08f;
                if (radius < 0.2f) {
                    radius = 0.2f;
                }
                yaw = class_3532.method_15393((float)(yaw - (float)yawDelta / radius));
                lastVector = thisVector;
            }
            player.method_36457(pitch);
            player.method_36456(yaw);
        }
    }

    protected static final class Arcball
    extends EditorMovementControls {
        private final class_243 point;
        private float distance;
        private boolean snapLook;

        public Arcball(class_243 point, float distance, boolean snapLook) {
            this.point = point;
            this.distance = Math.max(1.0f, distance);
            this.snapLook = snapLook;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return false;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !isGrabbed;
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (this.snapLook) {
                this.snapLook = false;
                class_243 look = ReplayUI.getMouseLookVector();
                double horizontal = Math.sqrt(look.field_1352 * look.field_1352 + look.field_1350 * look.field_1350);
                float newXRot = class_3532.method_15393((float)((float)Math.toDegrees(-class_3532.method_15349((double)look.field_1351, (double)horizontal))));
                float newYRot = class_3532.method_15393((float)((float)Math.toDegrees(class_3532.method_15349((double)look.field_1350, (double)look.field_1352)) - 90.0f));
                player.method_36457(newXRot);
                player.method_36456(newYRot);
                return;
            }
            double baseSensitivity = (Double)class_310.method_1551().field_1690.method_42495().method_41753() * (double)0.6f + (double)0.2f;
            double sensitivity = baseSensitivity * baseSensitivity * baseSensitivity * 8.0;
            int invert = (Boolean)class_310.method_1551().field_1690.method_42438().method_41753() != false ? -1 : 1;
            player.method_5872(mouseDeltaX * sensitivity, mouseDeltaY * sensitivity * (double)invert);
            if (ReplayUI.getIO().getMouseWheel() != 0.0f) {
                float wheel = Math.signum(ReplayUI.getIO().getMouseWheel());
                float move = this.distance * 0.05f;
                if (move > 4.0f) {
                    move = 4.0f + (float)Math.sqrt(move - 4.0f);
                }
                move *= wheel;
                if (ReplayUI.isMoveQuickDown()) {
                    move *= 2.0f;
                }
                this.distance = Math.max(1.0f, this.distance - move);
            }
            class_243 position = this.point.method_1020(player.method_5720().method_1021((double)this.distance));
            class_310.method_1551().field_1724.method_33574(position.method_1023(0.0, (double)player.method_5751(), 0.0));
            class_310.method_1551().field_1724.method_22862();
        }
    }

    protected static final class Pan
    extends EditorMovementControls {
        private final class_243 originalPos;
        private final Vector3f planePoint;
        private final Vector3f planeNormal;

        public Pan(class_243 originalPos, Vector3f planePoint, Vector3f planeNormal) {
            this.originalPos = originalPos;
            this.planePoint = planePoint;
            this.planeNormal = planeNormal;
        }

        @Override
        public boolean allowGameInputWhileCaptureKeyboard() {
            return false;
        }

        @Override
        public boolean shouldStop(boolean isGrabbed) {
            return !ImGui.isMouseDown(1);
        }

        @Override
        public void update(double mouseDeltaX, double mouseDeltaY) {
            Vector3f view;
            class_243 forwards = ReplayUI.getMouseForwardsVector();
            class_746 player = class_310.method_1551().field_1724;
            if (forwards == null || player == null) {
                return;
            }
            Vector3f origin = this.originalPos.method_1031(0.0, (double)player.method_5751(), 0.0).method_46409();
            float distance = Intersectionf.intersectRayPlane((Vector3fc)origin, (Vector3fc)(view = ReplayUI.getMouseLookVectorFromForwards(forwards).method_46409()), (Vector3fc)this.planePoint, (Vector3fc)this.planeNormal, (float)1.0E-5f);
            if (distance < 0.0f) {
                return;
            }
            Vector3f targetPoint = origin.add((Vector3fc)new Vector3f((Vector3fc)view).mul(distance));
            Vector3f targetDelta = new Vector3f((Vector3fc)targetPoint).sub((Vector3fc)this.planePoint);
            class_243 finalPos = this.originalPos.method_1023((double)targetDelta.x, (double)targetDelta.y, (double)targetDelta.z);
            player.method_33574(finalPos);
            player.method_22862();
        }
    }
}

