/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui.windows;

import com.mojang.authlib.GameProfile;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import imgui.ImGui;
import imgui.ImGuiViewport;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;

public class PlayerListWindow {
    private static String lastSearch = null;
    private static long lastUpdate = 0L;
    private static boolean includeNpcs = false;
    private static boolean hasNpcs = false;
    private static final ImString search = ImGuiHelper.createResizableImString("");
    private static final List<class_640> searchedPlayers = new ArrayList<class_640>();

    private static void updatePlayerList() {
        searchedPlayers.clear();
        hasNpcs = false;
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        class_1297 camera = class_310.method_1551().method_1560();
        record SearchEntry(double distanceSq, class_640 info) {
        }
        ArrayList<SearchEntry> searchEntries = new ArrayList<SearchEntry>();
        ArrayList<SearchEntry> searchEntriesLowPriority = new ArrayList<SearchEntry>();
        String searchLower = lastSearch.toLowerCase(Locale.ROOT);
        boolean blankSearch = lastSearch.isBlank();
        for (class_640 playerInfo : connection.method_2880()) {
            class_1657 player;
            GameProfile profile = playerInfo.method_2966();
            if (profile.id().equals(class_310.method_1551().field_1724.method_5667())) continue;
            if (profile.id().version() != 4) {
                hasNpcs = true;
                if (!includeNpcs) continue;
            }
            double distanceSq = Double.MAX_VALUE;
            if (level != null && camera != null && (player = level.method_18470(profile.id())) != null) {
                distanceSq = player.method_5858(camera);
            }
            SearchEntry searchEntry = new SearchEntry(distanceSq, playerInfo);
            if (blankSearch) {
                searchEntries.add(searchEntry);
                continue;
            }
            String nameLower = profile.name().toLowerCase(Locale.ROOT);
            if (nameLower.startsWith(searchLower)) {
                searchEntries.add(searchEntry);
                continue;
            }
            if (!nameLower.contains(searchLower)) continue;
            searchEntriesLowPriority.add(searchEntry);
        }
        searchEntries.sort(Comparator.comparingDouble(SearchEntry::distanceSq));
        searchEntriesLowPriority.sort(Comparator.comparingDouble(SearchEntry::distanceSq));
        if (searchEntries.size() < 16) {
            searchEntries.addAll(searchEntriesLowPriority);
        }
        int count = Math.min(16, searchEntries.size());
        for (int i = 0; i < count; ++i) {
            searchedPlayers.add(((SearchEntry)searchEntries.get((int)i)).info);
        }
    }

    public static void render(ImBoolean open, boolean newlyOpened) {
        if (newlyOpened) {
            ImGuiViewport viewport = ImGui.getMainViewport();
            ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 8, 0.5f, 0.5f);
        }
        ImGui.setNextWindowSizeConstraints(250.0f, 50.0f, 5000.0f, 5000.0f);
        String title = class_1074.method_4662((String)"flashback.player_list", (Object[])new Object[0]);
        if (ImGui.begin(title + "###PlayerList", open, 4160)) {
            String searchStr = class_1074.method_4662((String)"flashback.search", (Object[])new Object[0]);
            ImGui.setNextItemWidth(ImGui.getContentRegionAvailX() - ImGuiHelper.calcTextWidth(searchStr) - 32.0f);
            if (ImGui.inputText(searchStr, search)) {
                lastSearch = null;
            }
            long currentTime = System.currentTimeMillis();
            if (lastSearch == null || currentTime > lastUpdate + 3000L || currentTime < lastUpdate) {
                lastSearch = ImGuiHelper.getString(search);
                lastUpdate = currentTime;
                PlayerListWindow.updatePlayerList();
            }
            if ((hasNpcs || includeNpcs) && ImGui.checkbox(class_1074.method_4662((String)"flashback.include_npcs", (Object[])new Object[0]), includeNpcs)) {
                includeNpcs = !includeNpcs;
                lastSearch = null;
            }
            EditorState editorState = EditorStateManager.getCurrent();
            ImGui.separator();
            for (int i = 0; i < searchedPlayers.size(); ++i) {
                ImGui.pushID(i);
                class_640 playerInfo = searchedPlayers.get(i);
                GameProfile profile = playerInfo.method_2966();
                ImGui.textUnformatted(profile.name());
                ImGui.sameLine();
                if (ImGui.smallButton(class_1074.method_4662((String)"flashback.tp", (Object[])new Object[0]))) {
                    class_310.method_1551().method_1562().method_45730("teleport " + String.valueOf(profile.id()));
                    lastUpdate = currentTime;
                }
                if (editorState != null) {
                    ImGui.sameLine();
                    if (editorState.hideDuringExport.contains(profile.id())) {
                        if (ImGui.smallButton(class_1074.method_4662((String)"flashback.show", (Object[])new Object[0]))) {
                            editorState.hideDuringExport.remove(profile.id());
                            lastUpdate = currentTime;
                        }
                    } else if (ImGui.smallButton(class_1074.method_4662((String)"flashback.hide", (Object[])new Object[0]))) {
                        editorState.hideDuringExport.add(profile.id());
                        lastUpdate = currentTime;
                    }
                }
                ImGui.sameLine();
                if (ImGui.smallButton(class_1074.method_4662((String)"flashback.spectate", (Object[])new Object[0]))) {
                    class_310.method_1551().method_1562().method_45730("spectate " + String.valueOf(profile.id()));
                    lastUpdate = currentTime;
                }
                ImGui.popID();
            }
            ImGui.separator();
            if (editorState != null) {
                if (ImGui.button(class_1074.method_4662((String)"flashback.hide_all", (Object[])new Object[0]))) {
                    PlayerListWindow.changeVisibilityOfAll(editorState, false);
                    lastUpdate = currentTime;
                }
                ImGui.sameLine();
                if (ImGui.button(class_1074.method_4662((String)"flashback.show_all", (Object[])new Object[0]))) {
                    PlayerListWindow.changeVisibilityOfAll(editorState, true);
                    lastUpdate = currentTime;
                }
            }
        }
        ImGui.end();
    }

    private static void changeVisibilityOfAll(EditorState editorState, boolean visible) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            return;
        }
        String searchLower = lastSearch.toLowerCase(Locale.ROOT);
        boolean blankSearch = lastSearch.isBlank();
        for (class_640 playerInfo : connection.method_2880()) {
            GameProfile profile = playerInfo.method_2966();
            if (profile.id().equals(class_310.method_1551().field_1724.method_5667()) || profile.id().version() != 4 && !includeNpcs) continue;
            if (blankSearch) {
                if (visible) {
                    editorState.hideDuringExport.remove(profile.id());
                    continue;
                }
                editorState.hideDuringExport.add(profile.id());
                continue;
            }
            String nameLower = profile.name().toLowerCase(Locale.ROOT);
            if (!nameLower.contains(searchLower)) continue;
            if (visible) {
                editorState.hideDuringExport.remove(profile.id());
                continue;
            }
            editorState.hideDuringExport.add(profile.id());
        }
    }
}

