/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.keyframe.types;

import com.moulberry.flashback.exporting.AsyncFileDialogs;
import com.moulberry.flashback.keyframe.Keyframe;
import com.moulberry.flashback.keyframe.KeyframeType;
import com.moulberry.flashback.keyframe.change.KeyframeChange;
import com.moulberry.flashback.keyframe.change.KeyframeChangePlayAudio;
import com.moulberry.flashback.keyframe.handler.KeyframeHandler;
import com.moulberry.flashback.keyframe.handler.MinecraftKeyframeHandler;
import com.moulberry.flashback.keyframe.impl.AudioKeyframe;
import imgui.ImGui;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import org.jetbrains.annotations.Nullable;

public class AudioKeyframeType
implements KeyframeType<AudioKeyframe> {
    public static AudioKeyframeType INSTANCE = new AudioKeyframeType();

    private AudioKeyframeType() {
    }

    @Override
    public boolean supportsHandler(KeyframeHandler handler) {
        return MinecraftKeyframeHandler.class.isAssignableFrom(handler.getClass());
    }

    @Override
    public Class<? extends KeyframeChange> keyframeChangeType() {
        return KeyframeChangePlayAudio.class;
    }

    @Override
    @Nullable
    public String icon() {
        return "\ue3a1";
    }

    @Override
    public String name() {
        return class_1074.method_4662((String)"flashback.keyframe.audio_track", (Object[])new Object[0]);
    }

    @Override
    public String id() {
        return "AUDIO";
    }

    @Override
    public boolean allowChangingInterpolationType() {
        return false;
    }

    @Override
    public boolean allowApplyingDuplicateKeyframeChanges() {
        return true;
    }

    @Override
    public boolean cullKeyframesInTimelineToTheLeft() {
        return false;
    }

    @Override
    public boolean hasCustomKeyframeChangeCalculation() {
        return true;
    }

    @Override
    public KeyframeChange customKeyframeChange(TreeMap<Integer, Keyframe> keyframes, float tick) {
        Map.Entry<Integer, Keyframe> entry = keyframes.floorEntry((int)tick);
        if (entry == null) {
            return null;
        }
        float delta = tick - (float)entry.getKey().intValue();
        AudioKeyframe audioKeyframe = (AudioKeyframe)entry.getValue();
        return audioKeyframe.createAudioChange(entry.getKey(), delta / 20.0f);
    }

    @Override
    @Nullable
    public AudioKeyframe createDirect() {
        return null;
    }

    @Override
    public KeyframeType.KeyframeCreatePopup<AudioKeyframe> createPopup() {
        CompletableFuture<String> pathFuture = AsyncFileDialogs.openFileDialog(FabricLoader.getInstance().getGameDir().toString(), "ogg", new String[0]);
        return () -> {
            if (!pathFuture.isDone()) {
                return null;
            }
            String pathStr = (String)pathFuture.join();
            if (pathStr == null) {
                ImGui.closeCurrentPopup();
                return null;
            }
            Path path = Path.of(pathStr, new String[0]);
            return new AudioKeyframe(path);
        };
    }
}

