/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.keyframe.types;

import com.moulberry.flashback.combo_options.TrackingBodyPart;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.keyframe.KeyframeType;
import com.moulberry.flashback.keyframe.change.KeyframeChange;
import com.moulberry.flashback.keyframe.change.KeyframeChangeTrackEntity;
import com.moulberry.flashback.keyframe.impl.TrackEntityKeyframe;
import imgui.ImGui;
import imgui.type.ImString;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class TrackEntityKeyframeType
implements KeyframeType<TrackEntityKeyframe> {
    public static TrackEntityKeyframeType INSTANCE = new TrackEntityKeyframeType();

    private TrackEntityKeyframeType() {
    }

    @Override
    public Class<? extends KeyframeChange> keyframeChangeType() {
        return KeyframeChangeTrackEntity.class;
    }

    @Override
    @Nullable
    public String icon() {
        return "\ue55f";
    }

    @Override
    public String name() {
        return class_1074.method_4662((String)"flashback.keyframe.track_entity", (Object[])new Object[0]);
    }

    @Override
    public String id() {
        return "TRACK_ENTITY";
    }

    @Override
    @Nullable
    public TrackEntityKeyframe createDirect() {
        return null;
    }

    @Override
    public KeyframeType.KeyframeCreatePopup<TrackEntityKeyframe> createPopup() {
        CameraTrackTargetData data = new CameraTrackTargetData();
        return () -> {
            if (ImGui.inputText(class_1074.method_4662((String)"flashback.entity_uuid", (Object[])new Object[0]), data.cameraTrackTarget)) {
                data.validEntityTarget = null;
                try {
                    class_1297 entity;
                    String uuidStr = ImGuiHelper.getString(data.cameraTrackTarget);
                    UUID uuid = UUID.fromString(uuidStr);
                    class_638 level = class_310.method_1551().field_1687;
                    if (level != null && (entity = (class_1297)level.method_31592().method_31808(uuid)) != null && entity != class_310.method_1551().field_1724) {
                        data.validEntityTarget = uuid;
                    }
                }
                catch (Exception uuidStr) {
                    // empty catch block
                }
            }
            data.trackingBodyPart = ImGuiHelper.enumCombo(class_1074.method_4662((String)"flashback.body_part", (Object[])new Object[0]), data.trackingBodyPart);
            ImGuiHelper.inputFloat(class_1074.method_4662((String)"flashback.yaw_offset", (Object[])new Object[0]), data.cameraTrackYaw);
            ImGuiHelper.inputFloat(class_1074.method_4662((String)"flashback.pitch_offset", (Object[])new Object[0]), data.cameraTrackPitch);
            ImGuiHelper.inputFloat(class_1074.method_4662((String)"flashback.position_offset", (Object[])new Object[0]), data.positionOffset);
            ImGuiHelper.inputFloat(class_1074.method_4662((String)"flashback.view_offset", (Object[])new Object[0]), data.viewOffset);
            ImGuiHelper.inputFloat(class_1074.method_4662((String)"flashback.roll", (Object[])new Object[0]), data.roll);
            if (data.validEntityTarget == null) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(class_1074.method_4662((String)"flashback.add", (Object[])new Object[0]))) {
                Vector3d positionOffset = new Vector3d((double)data.positionOffset[0], (double)data.positionOffset[1], (double)data.positionOffset[2]);
                Vector3d viewOffset = new Vector3d((double)data.viewOffset[0], (double)data.viewOffset[1], (double)data.viewOffset[2]);
                return new TrackEntityKeyframe(data.validEntityTarget, data.trackingBodyPart, data.cameraTrackYaw[0], data.cameraTrackPitch[0], positionOffset, viewOffset, data.roll[0]);
            }
            if (data.validEntityTarget == null) {
                ImGui.endDisabled();
            }
            ImGui.sameLine();
            if (ImGui.button(class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0]))) {
                ImGui.closeCurrentPopup();
            }
            return null;
        };
    }

    private static class CameraTrackTargetData {
        float[] positionOffset = new float[]{0.0f, 0.0f, 0.0f};
        float[] viewOffset = new float[]{0.0f, 0.0f, 3.0f};
        float[] cameraTrackYaw = new float[]{0.0f};
        float[] cameraTrackPitch = new float[]{0.0f};
        float[] roll = new float[]{0.0f};
        TrackingBodyPart trackingBodyPart = TrackingBodyPart.HEAD;
        ImString cameraTrackTarget = new ImString();
        UUID validEntityTarget = null;

        private CameraTrackTargetData() {
        }
    }
}

