/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ReplayUI;
import net.minecraft.class_1041;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1041.class})
public abstract class MixinWindow {
    @Shadow
    private int field_5181;
    @Shadow
    private int field_5196;
    @Shadow
    private int field_5182;
    @Shadow
    private int field_5197;
    @Shadow
    private int field_5179;
    @Shadow
    private int field_5180;
    @Shadow
    private int field_5194;
    @Shadow
    private int field_5174;
    @Shadow
    @Final
    private long field_5187;

    @Unique
    private float calculateWidthScaleFactor() {
        return Math.max(0.125f, Math.min(8.0f, (float)this.field_5181 / (float)this.field_5182));
    }

    @Unique
    private float calculateHeightScaleFactor() {
        return Math.max(0.125f, Math.min(8.0f, (float)this.field_5196 / (float)this.field_5197));
    }

    @Inject(method={"getWidth"}, at={@At(value="HEAD")}, cancellable=true)
    public void getWidth(CallbackInfoReturnable<Integer> cir) {
        if (Flashback.EXPORT_JOB != null && Flashback.EXPORT_JOB.shouldChangeFramebufferSize()) {
            cir.setReturnValue((Object)Flashback.EXPORT_JOB.getWidth());
        } else if (ReplayUI.shouldModifyViewport()) {
            cir.setReturnValue((Object)ReplayUI.getNewGameWidth(this.calculateWidthScaleFactor()));
        }
    }

    @Inject(method={"getHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void getHeight(CallbackInfoReturnable<Integer> cir) {
        if (Flashback.EXPORT_JOB != null && Flashback.EXPORT_JOB.shouldChangeFramebufferSize()) {
            cir.setReturnValue((Object)Flashback.EXPORT_JOB.getHeight());
        } else if (ReplayUI.shouldModifyViewport()) {
            cir.setReturnValue((Object)ReplayUI.getNewGameHeight(this.calculateHeightScaleFactor()));
        }
    }

    @Inject(method={"getScreenWidth"}, at={@At(value="HEAD")}, cancellable=true)
    public void getScreenWidth(CallbackInfoReturnable<Integer> cir) {
        if (ReplayUI.shouldModifyViewport()) {
            cir.setReturnValue((Object)ReplayUI.getNewGameWidth(1.0f));
        }
    }

    @Inject(method={"getScreenHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void getScreenHeight(CallbackInfoReturnable<Integer> cir) {
        if (ReplayUI.shouldModifyViewport()) {
            cir.setReturnValue((Object)ReplayUI.getNewGameHeight(1.0f));
        }
    }

    @Inject(method={"onResize"}, at={@At(value="HEAD")}, cancellable=true)
    public void onResize(long l, int i, int j, CallbackInfo ci) {
        if (l != this.field_5187) {
            ci.cancel();
        }
    }

    @Inject(method={"calculateScale"}, at={@At(value="HEAD")}, cancellable=true)
    public void calculateScale(int scale, boolean forceEven, CallbackInfoReturnable<Integer> cir) {
        if (Flashback.EXPORT_JOB != null && Flashback.EXPORT_JOB.shouldChangeFramebufferSize()) {
            int j;
            int fbw = Flashback.EXPORT_JOB.getWidth();
            int fbh = Flashback.EXPORT_JOB.getHeight();
            for (j = 1; j != scale && j < fbw && j < fbh && fbw / (j + 1) >= 320 && fbh / (j + 1) >= 240; ++j) {
            }
            if (forceEven && j % 2 != 0) {
                ++j;
            }
            cir.setReturnValue((Object)j);
        } else if (ReplayUI.shouldModifyViewport()) {
            int j;
            int fbw = ReplayUI.getNewGameWidth(this.calculateWidthScaleFactor());
            int fbh = ReplayUI.getNewGameHeight(this.calculateHeightScaleFactor());
            for (j = 1; j != scale && j < fbw && j < fbh && fbw / (j + 1) >= 320 && fbh / (j + 1) >= 240; ++j) {
            }
            if (forceEven && j % 2 != 0) {
                ++j;
            }
            cir.setReturnValue((Object)j);
        }
    }

    @Inject(method={"setGuiScale"}, at={@At(value="HEAD")}, cancellable=true)
    public void setGuiScale(int scale, CallbackInfo ci) {
        if (Flashback.EXPORT_JOB != null && Flashback.EXPORT_JOB.shouldChangeFramebufferSize()) {
            int fbw = Flashback.EXPORT_JOB.getWidth();
            int fbh = Flashback.EXPORT_JOB.getHeight();
            this.field_5179 = scale;
            int i = (int)((double)fbw / (double)scale);
            this.field_5180 = (double)fbw / (double)scale > (double)i ? i + 1 : i;
            int j = (int)((double)fbh / (double)scale);
            this.field_5194 = (double)fbh / (double)scale > (double)j ? j + 1 : j;
            ci.cancel();
        } else if (ReplayUI.shouldModifyViewport()) {
            int fbw = ReplayUI.getNewGameWidth(this.calculateWidthScaleFactor());
            int fbh = ReplayUI.getNewGameHeight(this.calculateHeightScaleFactor());
            this.field_5179 = scale;
            int i = (int)((double)fbw / (double)scale);
            this.field_5180 = (double)fbw / (double)scale > (double)i ? i + 1 : i;
            int j = (int)((double)fbh / (double)scale);
            this.field_5194 = (double)fbh / (double)scale > (double)j ? j + 1 : j;
            ci.cancel();
        }
    }
}

