/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.screen.select_replay;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.SneakyThrow;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.screen.ReplaySummary;
import com.moulberry.flashback.screen.select_replay.PendingSelectionEntry;
import com.moulberry.flashback.screen.select_replay.ReplaySelectionEntry;
import com.moulberry.flashback.screen.select_replay.ReplaySorting;
import com.moulberry.flashback.screen.select_replay.SelectReplayScreen;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ReplaySelectionList
extends class_4280<ReplaySelectionEntry> {
    private final SelectReplayScreen screen;
    private CompletableFuture<List<PendingSelectionEntry>> pendingReplays;
    @Nullable
    private List<PendingSelectionEntry> currentlyDisplayedReplays;
    private String filter;
    private ReplaySorting replaySorting;
    private boolean sortDescending;
    private final ReplaySelectionEntry.LoadingHeader loadingHeader;
    private final ReplaySelectionEntry.LoadFromDeviceHeader loadFromDeviceHeader;
    public final LinkedHashMap<String, LinkedHashSet<String>> currentNamespacesForRegistries;

    public ReplaySelectionList(SelectReplayScreen selectReplayScreen, class_310 minecraft, int i, int j, int k, int l, String filter, ReplaySorting replaySorting, boolean sortDescending, LinkedHashMap<String, LinkedHashSet<String>> currentNamespacesForRegistries, @Nullable ReplaySelectionList replaySelectionList) {
        super(minecraft, i, j, k, l);
        this.screen = selectReplayScreen;
        this.loadingHeader = new ReplaySelectionEntry.LoadingHeader(minecraft);
        this.loadFromDeviceHeader = new ReplaySelectionEntry.LoadFromDeviceHeader(minecraft);
        this.filter = filter;
        this.replaySorting = replaySorting;
        this.sortDescending = sortDescending;
        this.currentNamespacesForRegistries = currentNamespacesForRegistries;
        this.pendingReplays = replaySelectionList != null ? replaySelectionList.pendingReplays : this.loadReplays();
        this.fillLoadingReplays();
    }

    protected void method_25339() {
        this.method_25396().forEach(ReplaySelectionEntry::close);
        super.method_25339();
    }

    @Nullable
    private List<PendingSelectionEntry> pollReplaysIgnoreErrors() {
        try {
            return this.pendingReplays.getNow(null);
        }
        catch (CancellationException | CompletionException runtimeException) {
            return null;
        }
    }

    public void reloadReplayList() {
        this.pendingReplays = this.loadReplays();
    }

    public boolean method_25404(class_11908 keyEvent) {
        ReplaySelectionEntry.ReplayListEntry replayListEntry;
        if (keyEvent.method_74229() && (replayListEntry = this.getReplayListEntry()) != null && replayListEntry.canOpen()) {
            this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            replayListEntry.openReplay();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        List<PendingSelectionEntry> list = this.pollReplaysIgnoreErrors();
        if (this.currentlyDisplayedReplays != list) {
            if (list == null) {
                this.fillLoadingReplays();
            } else {
                list.sort(this.replaySorting.comparator(this.sortDescending));
                this.fillReplays(this.filter, list);
            }
            this.currentlyDisplayedReplays = list;
        }
        super.method_48579(guiGraphics, i, j, f);
    }

    public void updateFilter(String filter, ReplaySorting replaySorting, boolean sortDescending) {
        if (this.currentlyDisplayedReplays != null) {
            if (this.replaySorting != replaySorting || this.sortDescending != sortDescending) {
                this.currentlyDisplayedReplays.sort(replaySorting.comparator(sortDescending));
                this.fillReplays(filter, this.currentlyDisplayedReplays);
            } else if (!filter.equals(this.filter)) {
                this.fillReplays(filter, this.currentlyDisplayedReplays);
            }
        }
        this.filter = filter;
        this.replaySorting = replaySorting;
        this.sortDescending = sortDescending;
    }

    private CompletableFuture<List<PendingSelectionEntry>> loadReplays() {
        Path replayDir = this.screen.path;
        if (!Files.exists(replayDir, new LinkOption[0]) || !Files.isDirectory(replayDir, new LinkOption[0])) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        ArrayList<CompletableFuture<PendingSelectionEntry>> futures = new ArrayList<CompletableFuture<PendingSelectionEntry>>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(replayDir);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    futures.add(CompletableFuture.supplyAsync(() -> {
                        try {
                            BasicFileAttributeView attributeView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
                            BasicFileAttributes basicFileAttributes = attributeView.readAttributes();
                            long lastModified = Math.max(basicFileAttributes.creationTime().toMillis(), basicFileAttributes.lastModifiedTime().toMillis());
                            int replaysInFolder = 0;
                            try (DirectoryStream<Path> filesInFolder = Files.newDirectoryStream(path);){
                                for (Path fileInFolder : filesInFolder) {
                                    if (!fileInFolder.toString().endsWith(".zip")) continue;
                                    ++replaysInFolder;
                                }
                            }
                            return new PendingSelectionEntry.Folder(path, lastModified, replaysInFolder);
                        }
                        catch (IOException e) {
                            Flashback.LOGGER.error("Failed to load replay folder", (Throwable)e);
                            return null;
                        }
                    }, (Executor)class_156.method_18349()));
                    continue;
                }
                if (!path.toString().endsWith(".zip")) continue;
                futures.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        String fileName = path.getFileName().toString();
                        BasicFileAttributeView attributeView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
                        BasicFileAttributes basicFileAttributes = attributeView.readAttributes();
                        long lastModified = Math.max(basicFileAttributes.creationTime().toMillis(), basicFileAttributes.lastModifiedTime().toMillis());
                        long filesize = basicFileAttributes.size();
                        byte[] iconBytes = null;
                        String metadataString = null;
                        try (FileSystem fs = FileSystems.newFileSystem(path);){
                            Path metadataPath;
                            Path iconPath = fs.getPath("/icon.png", new String[0]);
                            if (Files.exists(iconPath, new LinkOption[0])) {
                                iconBytes = Files.readAllBytes(iconPath);
                            }
                            if (Files.exists(metadataPath = fs.getPath("/metadata.json", new String[0]), new LinkOption[0])) {
                                metadataString = Files.readString(metadataPath);
                            }
                        }
                        catch (IOException e) {
                            SneakyThrow.sneakyThrow(e);
                        }
                        if (metadataString == null) {
                            return null;
                        }
                        JsonObject metadataJson = (JsonObject)new Gson().fromJson(metadataString, JsonObject.class);
                        FlashbackMeta metadata = FlashbackMeta.fromJson(metadataJson);
                        if (metadata != null) {
                            ReplaySummary summary = new ReplaySummary(path, metadata, this.currentNamespacesForRegistries, fileName, lastModified, filesize, iconBytes);
                            return new PendingSelectionEntry.Replay(summary);
                        }
                    }
                    catch (IOException e) {
                        Flashback.LOGGER.error("Failed to load replay", (Throwable)e);
                    }
                    return null;
                }, (Executor)class_156.method_18349()));
            }
        }
        catch (IOException e) {
            SneakyThrow.sneakyThrow(e);
        }
        return class_156.method_43373(futures).thenApply(list -> {
            list.removeIf(Objects::isNull);
            return list;
        });
    }

    private void fillReplays(String filter, List<PendingSelectionEntry> list) {
        this.method_25339();
        this.method_25321((class_350.class_351)this.loadFromDeviceHeader);
        filter = filter.toLowerCase(Locale.ROOT);
        for (PendingSelectionEntry entry : list) {
            if (!entry.matchesFilter(filter)) continue;
            this.method_25321((class_350.class_351)entry.createEntry(this, this.field_22740));
        }
        this.notifyListUpdated();
    }

    private void fillLoadingReplays() {
        this.method_25339();
        this.method_25321((class_350.class_351)this.loadFromDeviceHeader);
        this.method_25321((class_350.class_351)this.loadingHeader);
        this.notifyListUpdated();
    }

    private void notifyListUpdated() {
        this.method_65506();
        this.screen.method_37064(true);
        this.screen.updateButtonStatus(null);
    }

    public int method_25322() {
        return 270;
    }

    public void setSelected(@Nullable ReplaySelectionEntry entry) {
        if (entry instanceof ReplaySelectionEntry.LoadFromDeviceHeader) {
            Flashback.openReplayFromFileBrowser();
            return;
        }
        super.method_25313((class_350.class_351)entry);
        if (entry instanceof ReplaySelectionEntry.ReplayListEntry) {
            ReplaySelectionEntry.ReplayListEntry replayListEntry = (ReplaySelectionEntry.ReplayListEntry)entry;
            this.screen.updateButtonStatus(replayListEntry.summary);
        } else {
            this.screen.updateButtonStatus(null);
        }
    }

    @Nullable
    public ReplaySelectionEntry.ReplayListEntry getReplayListEntry() {
        class_350.class_351 class_3512 = this.method_25334();
        if (class_3512 instanceof ReplaySelectionEntry.ReplayListEntry) {
            ReplaySelectionEntry.ReplayListEntry replayListEntry = (ReplaySelectionEntry.ReplayListEntry)class_3512;
            return replayListEntry;
        }
        return null;
    }

    public SelectReplayScreen getScreen() {
        return this.screen;
    }

    public void method_47399(class_6382 narrationElementOutput) {
        if (this.method_25396().contains(this.loadingHeader)) {
            this.loadingHeader.method_37020(narrationElementOutput);
            return;
        }
        super.method_47399(narrationElementOutput);
    }
}

