/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.visuals;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10799;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_9801;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FlashbackDrawBuffer
implements AutoCloseable {
    int usageFlags;
    GpuBuffer vertexBuffer;
    int indexCount;
    VertexFormat vertexFormat;
    VertexFormat.class_5596 vertexFormatMode;

    public FlashbackDrawBuffer(int usageFlags) {
        this.usageFlags = usageFlags;
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
    }

    public void upload(class_9801 meshData) {
        try (class_9801 class_98012 = meshData;){
            class_9801.class_4574 drawState = meshData.method_60822();
            this.uploadVertexBuffer(meshData.method_60818());
            this.vertexFormat = drawState.comp_749();
            this.vertexFormatMode = drawState.comp_752();
            this.indexCount = drawState.comp_751();
        }
    }

    private void uploadVertexBuffer(ByteBuffer byteBuffer) {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = RenderSystem.getDevice().createBuffer(null, this.usageFlags | 0x20, byteBuffer);
    }

    public void draw() {
        class_276 renderTarget = class_310.method_1551().method_1522();
        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)this.vertexFormatMode);
        GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(this.indexCount);
        VertexFormat.class_5595 indexType = autoStorageIndexBuffer.method_31924();
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        try (RenderPass renderPass = commandEncoder.createRenderPass(() -> "flashback draw", renderTarget.method_71639(), OptionalInt.empty(), renderTarget.field_1478 ? renderTarget.method_71640() : null, OptionalDouble.empty());){
            renderPass.setPipeline(class_10799.field_56833);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
            renderPass.setVertexBuffer(0, this.vertexBuffer);
            for (int i = 0; i < 12; ++i) {
                GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)i);
                if (gpuTexture == null) continue;
                renderPass.bindSampler("Sampler" + i, gpuTexture);
            }
            renderPass.setIndexBuffer(indexBuffer, indexType);
            renderPass.drawIndexed(0, 0, this.indexCount, 1);
        }
    }
}

