/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.blocks;

import java.util.ArrayList;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.witcher_rpg.item.WitcherGroup;

public class WitcherBlocks {
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Entry SILVER_ORE = WitcherBlocks.entry("silver_ore", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), (BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(3.0f, 3.0f)));
    public static final Entry DEEPSLATE_SILVER_ORE = WitcherBlocks.entry("deepslate_silver_ore", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), (BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(4.0f, 3.0f)));
    public static final Entry METEORITE_ORE = WitcherBlocks.entry("meteorite_ore", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), (BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.TERRACOTTA_BROWN).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(4.0f, 3.0f)));
    public static final Entry DEEPSLATE_DARK_IRON_ORE = WitcherBlocks.entry("deepslate_dark_iron_ore", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), (BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(4.0f, 3.0f)));
    public static final Entry DARK_IRON_ORE = WitcherBlocks.entry("dark_iron_ore", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), (BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(3.0f, 3.0f)));
    public static final Entry NETHER_DARK_IRON_ORE = WitcherBlocks.entry("nether_dark_iron_ore", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), (BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.NETHER).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(3.0f, 3.0f)));
    public static final Entry SILVER_BLOCK = WitcherBlocks.entry("silver_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.CLAY).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresTool().strength(5.0f, 6.0f).sounds(SoundType.METAL)));
    public static final Entry RAW_SILVER_BLOCK = WitcherBlocks.entry("raw_silver_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.COLOR_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresTool().strength(5.0f, 6.0f)));
    public static final Entry STEEL_BLOCK = WitcherBlocks.entry("steel_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresTool().strength(5.0f, 6.0f).sounds(SoundType.METAL)));
    public static final Entry METEORITE_BLOCK = WitcherBlocks.entry("meteorite_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.ICE).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresTool().strength(5.0f, 6.0f).sounds(SoundType.METAL)));
    public static final Entry DARK_IRON_BLOCK = WitcherBlocks.entry("dark_iron_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.PLANT).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresTool().strength(5.0f, 6.0f).sounds(SoundType.METAL)));
    public static final Entry METEORITE_SILVER_BLOCK = WitcherBlocks.entry("meteorite_silver_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.ICE).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresTool().strength(50.0f, 1200.0f).sounds(SoundType.NETHERITE_BLOCK)));
    public static final Entry DARK_STEEL_BLOCK = WitcherBlocks.entry("dark_steel_block", new Block((BlockBehaviour.Properties)FabricBlockSettings.create().mapColor(MapColor.GRASS).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresTool().strength(50.0f, 1200.0f).sounds(SoundType.NETHERITE_BLOCK)));

    private static Entry entry(String name, Block block) {
        Entry entry = new Entry(name, block);
        all.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : all) {
            Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)entry.name), (Object)entry.block);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)entry.name), (Object)entry.item());
        }
        ItemGroupEvents.modifyEntriesEvent(WitcherGroup.WITCHER_KEY).register(content -> {
            for (Entry entry : all) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public record Entry(String name, Block block, BlockItem item) {
        public Entry(String name, Block block) {
            this(name, block, new BlockItem(block, new Item.Properties()));
        }
    }
}

