/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.custom;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.AttributesConfig;
import net.witcher_rpg.entity.attribute.WitcherAttributes;

public class WitcherSpellSchools {
    public static final SpellSchool SIGN = new SpellSchool(SpellSchool.Archetype.MAGIC, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"sign"), 16776906, ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"signs")), WitcherAttributes.SIGN_INTENSITY);
    public static final SpellSchool AARD = new SpellSchool(SpellSchool.Archetype.MAGIC, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"aard"), 3927807, DamageTypes.MAGIC, WitcherAttributes.AARD_INTENSITY);
    public static final SpellSchool AXII = new SpellSchool(SpellSchool.Archetype.MAGIC, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"axii"), 32768, ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"axii")), WitcherAttributes.AXII_INTENSITY);
    public static final SpellSchool IGNI = new SpellSchool(SpellSchool.Archetype.MAGIC, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"igni"), 14503424, ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"igni")), WitcherAttributes.IGNI_INTENSITY);
    public static final SpellSchool QUEN = new SpellSchool(SpellSchool.Archetype.MAGIC, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"quen"), 16776906, ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen")), WitcherAttributes.QUEN_INTENSITY);
    public static final SpellSchool YRDEN = new SpellSchool(SpellSchool.Archetype.MAGIC, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"yrden"), 15144958, ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden")), WitcherAttributes.YRDEN_INTENSITY);
    public static final SpellSchool WITCHER_MELEE = new SpellSchool(SpellSchool.Archetype.MELEE, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"witcher_melee"), 0xB3B3B3, DamageTypes.PLAYER_ATTACK, Attributes.ATTACK_DAMAGE);

    public static void initialize() {
        int adrenaline_crit_damage_div = 3;
        int adrenaline_crit_chance_div = 10;
        ResourceLocation SPELL_POWER = ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"spell_power");
        SIGN.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().getAttributeValue(WitcherAttributes.SIGN_INTENSITY);
            Level world = query.entity().level();
            Optional spellpower = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(SPELL_POWER);
            if (spellpower.isPresent()) {
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)spellpower.get()), (ItemStack)query.entity().getMainHandItem());
                power *= 1.0 + 0.05 * (double)level;
            }
            return power;
        });
        SIGN.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        });
        SIGN.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_damage_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SIGN.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_chance_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)SIGN);
        SpellSchools.configureSpellHaste((SpellSchool)SIGN);
        SpellSchools.configureSpellCritChance((SpellSchool)SIGN);
        SpellSchools.register((SpellSchool)SIGN);
        AARD.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().getAttributeValue(WitcherSpellSchools.AARD.attributeEntry);
            double power2 = query.entity().getAttributeValue(SpellSchools.LIGHTNING.attributeEntry);
            power *= power2 + 1.0;
            Level world = query.entity().level();
            Optional spellpower = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(SPELL_POWER);
            if (spellpower.isPresent()) {
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)spellpower.get()), (ItemStack)query.entity().getMainHandItem());
                power *= 1.0 + 0.05 * (double)level;
            }
            return power;
        });
        AARD.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        });
        AARD.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_damage_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        AARD.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_chance_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)AARD);
        SpellSchools.configureSpellHaste((SpellSchool)AARD);
        SpellSchools.configureSpellCritChance((SpellSchool)AARD);
        SpellSchools.register((SpellSchool)AARD);
        AXII.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().getAttributeValue(WitcherSpellSchools.AXII.attributeEntry);
            double power2 = query.entity().getAttributeValue(SpellSchools.SOUL.attributeEntry);
            power *= power2 + 1.0;
            Level world = query.entity().level();
            Optional spellpower = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(SPELL_POWER);
            if (spellpower.isPresent()) {
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)spellpower.get()), (ItemStack)query.entity().getMainHandItem());
                power *= 1.0 + 0.05 * (double)level;
            }
            return power;
        });
        AXII.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        });
        AXII.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_damage_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        AXII.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_chance_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)AXII);
        SpellSchools.configureSpellHaste((SpellSchool)AXII);
        SpellSchools.configureSpellCritChance((SpellSchool)AXII);
        SpellSchools.register((SpellSchool)AXII);
        IGNI.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().getAttributeValue(WitcherSpellSchools.IGNI.attributeEntry);
            double power2 = query.entity().getAttributeValue(SpellSchools.FIRE.attributeEntry);
            power *= power2 + 1.0;
            Level world = query.entity().level();
            Optional spellpower = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(SPELL_POWER);
            if (spellpower.isPresent()) {
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)spellpower.get()), (ItemStack)query.entity().getMainHandItem());
                power *= 1.0 + 0.05 * (double)level;
            }
            return power;
        });
        IGNI.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        });
        IGNI.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_damage_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        IGNI.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_chance_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)IGNI);
        SpellSchools.configureSpellHaste((SpellSchool)IGNI);
        SpellSchools.configureSpellCritChance((SpellSchool)IGNI);
        SpellSchools.register((SpellSchool)IGNI);
        QUEN.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().getAttributeValue(WitcherSpellSchools.QUEN.attributeEntry);
            double power2 = query.entity().getAttributeValue(SpellSchools.LIGHTNING.attributeEntry);
            power *= power2 + 1.0;
            Level world = query.entity().level();
            Optional spellpower = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(SPELL_POWER);
            if (spellpower.isPresent()) {
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)spellpower.get()), (ItemStack)query.entity().getMainHandItem());
                power *= 1.0 + 0.05 * (double)level;
            }
            return power;
        });
        QUEN.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        });
        QUEN.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_damage_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        QUEN.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_chance_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)QUEN);
        SpellSchools.configureSpellHaste((SpellSchool)QUEN);
        SpellSchools.configureSpellCritChance((SpellSchool)QUEN);
        SpellSchools.register((SpellSchool)QUEN);
        YRDEN.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().getAttributeValue(WitcherSpellSchools.YRDEN.attributeEntry);
            double power2 = query.entity().getAttributeValue(SpellSchools.ARCANE.attributeEntry);
            power *= power2 + 1.0;
            Level world = query.entity().level();
            Optional spellpower = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(SPELL_POWER);
            if (spellpower.isPresent()) {
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)spellpower.get()), (ItemStack)query.entity().getMainHandItem());
                power *= 1.0 + 0.05 * (double)level;
            }
            return power;
        });
        YRDEN.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
            double value = query.entity().getAttributeValue(SpellPowerMechanics.HASTE.attributeEntry);
            double rate = value / 100.0;
            return rate - 1.0;
        });
        YRDEN.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_DAMAGE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_damage_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        YRDEN.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry);
            double value2 = (query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0) / (double)adrenaline_crit_chance_div;
            double rate = (value + value2) / 100.0;
            return rate - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)YRDEN);
        SpellSchools.configureSpellHaste((SpellSchool)YRDEN);
        SpellSchools.configureSpellCritChance((SpellSchool)YRDEN);
        SpellSchools.register((SpellSchool)YRDEN);
        WITCHER_MELEE.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(Attributes.ATTACK_DAMAGE));
        WITCHER_MELEE.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - (double)(100 / adrenaline_crit_damage_div);
            return value / 100.0 - 1.0;
        });
        WITCHER_MELEE.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - (double)(100 / adrenaline_crit_damage_div);
            return value / 100.0 - 1.0;
        });
        SpellSchools.configureSpellCritDamage((SpellSchool)WITCHER_MELEE);
        SpellSchools.configureSpellHaste((SpellSchool)WITCHER_MELEE);
        SpellSchools.configureSpellCritChance((SpellSchool)WITCHER_MELEE);
        SpellSchools.register((SpellSchool)WITCHER_MELEE);
    }
}

