/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.effect;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.more_rpg_classes.util.CustomMethods;
import net.spell_engine.api.effect.SpellEngineEffects;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.fx.ParticleHelper;
import net.witcher_rpg.effect.WitcherStatusEffects;

public class QuenActiveEffect
extends MobEffect {
    public static final ResourceLocation QUEN_BREAK_ID = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_sign_break");
    public static final SoundEvent QUEN_BREAK = SoundEvent.createVariableRangeEvent((ResourceLocation)QUEN_BREAK_ID);
    private final int healthPerStack;
    public static final ParticleBatch quen_break = new ParticleBatch("spell_engine:electric_arc_a", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 8.0f, 0.03f, 0.7f, 360.0f, 3.0f);

    public QuenActiveEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.healthPerStack = 6;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        float currentAbsorption;
        if (!entity.level().isClientSide && (currentAbsorption = entity.getAbsorptionAmount()) == 0.0f) {
            entity.removeEffect(WitcherStatusEffects.QUEN_ACTIVE.entry);
        }
        return entity.getAbsorptionAmount() > 0.0f || entity.level().isClientSide;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        CustomMethods.clearNegativeEffects((LivingEntity)entity, (boolean)false);
        entity.setAbsorptionAmount(Math.max(entity.getAbsorptionAmount(), (float)(this.healthPerStack * (1 + amplifier))));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public static void onRemove(LivingEntity entity) {
        float currentAbsorption = entity.getAbsorptionAmount();
        if (currentAbsorption == 0.0f) {
            entity.addEffect(new MobEffectInstance(SpellEngineEffects.STUN.entry, 5, 0, false, false, false));
        }
        if (!entity.level().isClientSide()) {
            entity.level().playSound(null, (Entity)entity, QUEN_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])new ParticleBatch[]{quen_break});
        }
    }
}

