/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.witcher_rpg.WitcherClassMod;
import net.witcher_rpg.config.TweaksConfig;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"attack(Lnet/minecraft/world/entity/Entity;)V"})
    public void witcherStackAdrenaline(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        AttributeInstance adrenaline = ((LivingEntity)this).getAttribute(WitcherAttributes.ADRENALINE_MODIFIER);
        int value1 = (int)adrenaline.getValue();
        if (player instanceof ServerPlayer && value1 != 100) {
            int adrenaline_duration_multiplier = (value1 -= 100) * 3;
            if (!player.hasEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry)) {
                player.addEffect(new MobEffectInstance(WitcherStatusEffects.ADRENALINE_GAIN.entry, 200 + adrenaline_duration_multiplier, 0, false, false, true));
            } else {
                int currentAmplifier = player.getEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry).getAmplifier();
                int currentDuration = player.getEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry).getDuration();
                int effectDuration = adrenaline_duration_multiplier + currentDuration;
                if (effectDuration > ((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_seconds_duration * 20) {
                    effectDuration = ((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_seconds_duration * 20;
                }
                if (currentAmplifier < ((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_amplifier - 1) {
                    player.addEffect(new MobEffectInstance(WitcherStatusEffects.ADRENALINE_GAIN.entry, effectDuration, currentAmplifier + 1, false, false, true));
                } else {
                    player.addEffect(new MobEffectInstance(WitcherStatusEffects.ADRENALINE_GAIN.entry, effectDuration, ((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_amplifier - 1, false, false, true));
                }
            }
        }
    }

    @ModifyArg(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=1)
    private float modifyWitcherDamageBattleTrance(float damage) {
        Player player = (Player)this;
        if (player.hasEffect(WitcherStatusEffects.BATTLE_TRANCE.entry) && player.hasEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry)) {
            int adrenaline_effect_amplifier = player.getEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry).getAmplifier() + 1;
            return damage + (float)(1 + adrenaline_effect_amplifier / 10);
        }
        return damage;
    }
}

