/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.util.tags.WitcherEntityTags;

public class AxiiPuppetEffect
extends MobEffect {
    protected AxiiPuppetEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            float range = 32.0f;
            AABB radius = new AABB(mobEntity.getX() + (double)range, mobEntity.getY() + (double)(range / 3.0f), mobEntity.getZ() + (double)range, mobEntity.getX() - (double)range, mobEntity.getY() - (double)(range / 3.0f), mobEntity.getZ() - (double)range);
            for (Entity entities : mobEntity.getCommandSenderWorld().getEntities((Entity)mobEntity, radius, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                if (entities == null || !(entities instanceof Monster)) continue;
                Monster otherMobEntity = (Monster)entities;
                mobEntity.setTarget((LivingEntity)otherMobEntity);
            }
        } else {
            entity.addEffect(new MobEffectInstance(WitcherStatusEffects.AXII.entry, 40, 0, false, false, true));
            entity.removeEffect(WitcherStatusEffects.AXII_PUPPET.entry);
        }
        super.applyEffectTick(entity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        EntityType type = livingEntity.getType();
        if (type.is(WitcherEntityTags.AXII_EFFECT_IMMUNE)) {
            livingEntity.removeEffect(WitcherStatusEffects.AXII_PUPPET.entry);
        }
    }
}

