/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.CustomStatusEffect;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.OnRemoval;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.event.CombatEvents;
import net.spell_power.api.SpellPowerMechanics;
import net.witcher_rpg.custom.WitcherSpellSchools;
import net.witcher_rpg.effect.AxiiEffect;
import net.witcher_rpg.effect.AxiiPuppetEffect;
import net.witcher_rpg.effect.QuenActiveEffect;
import net.witcher_rpg.effect.QuenShieldEffect;
import net.witcher_rpg.effect.RoseOfRemembranceEffect;
import net.witcher_rpg.effect.WitcherReflexesEffect;
import net.witcher_rpg.effect.YrdenCircleEffect;
import net.witcher_rpg.entity.attribute.WitcherAttributes;

public class WitcherStatusEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static float sign_intensity_boost = 0.1f;
    public static float specific_sign_intensity_boost = 1.0f;
    public static Effects.Entry AARD_INTENSITY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"aard_intensity"), "Aard Sign Intensity", "Increases the damage of the Aard Sign.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.AARD.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.getRegisteredName(), specific_sign_intensity_boost, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry AXII_INTENSITY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"axii_intensity"), "Axii Sign Intensity", "Increases the damage of the Axii Sign.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.AXII.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.getRegisteredName(), specific_sign_intensity_boost, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry IGNI_INTENSITY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"igni_intensity"), "Igni Sign Intensity", "Increases the damage of the Igni Sign.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.IGNI.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.getRegisteredName(), specific_sign_intensity_boost, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry QUEN_INTENSITY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_intensity"), "Quen Sign Intensity", "Increases the damage of the Quen Sign.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.QUEN.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.getRegisteredName(), specific_sign_intensity_boost, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry YRDEN_INTENSITY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden_intensity"), "Yrden Sign Intensity", "Increases the damage of the Yrden Sign.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.YRDEN.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.getRegisteredName(), specific_sign_intensity_boost, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry SIGN_INTENSITY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"sign_intensity"), "Sign Intensity", "Increases the damage of all Witcher Signs.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.SIGN.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), specific_sign_intensity_boost, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry ADRENALINE_BURST = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"adrenaline_burst"), "Adrenaline Burst", "Increases your Adrenaline Attribute.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.WITCHER_MELEE.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.getRegisteredName(), sign_intensity_boost, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry ADRENALINE_GAIN = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"adrenaline_gain"), "Adrenaline", "Increases attack damage and sign intensity per stack.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.WITCHER_MELEE.color), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.025f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), 0.025f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry AERONDIGHT_CHARGE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"aerondight_charge"), "Charged Sword", "Increases sign intensity, spell crit chance & spell crit damage per stack.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 12379646), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.01f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.02f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), 0.01f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry AXII = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"axii"), "Axii", "Stuns the target and makes it more vulnerable to damage.", (MobEffect)new AxiiEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.AXII.color), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry AXII_PUPPET = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"axii_puppet"), "Axii Puppeteer", "Makes a hostile monster your ally for a short time and buffs its attack damage.", (MobEffect)new AxiiPuppetEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.AXII.color), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry BATTLE_TRANCE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"battle_trance"), "Battle Trance", "Gain Movement Speed and deal 10% more melee damage for each Adrenaline Effect Amplifier.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.WITCHER_MELEE.color), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry BEAR_SCHOOL_MEDALLION = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"bear_school_medallion"), "Bear School Endurance", "Incoming damage is reduced.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.WITCHER_MELEE.color), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id, -0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry QUEN_ACTIVE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_active"), "Quen Active Shield", "Gives absorption and clears negative status effects, will be removed when no absorption hearts are active.", (MobEffect)new QuenActiveEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.QUEN.color), new EffectConfig(List.of(new AttributeModifier(Attributes.MAX_ABSORPTION.getRegisteredName(), 8.0f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry QUEN_SHIELD = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_shield"), "Quen Shield", "Gives absorption and clears negative status effects.", (MobEffect)new QuenShieldEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.QUEN.color), new EffectConfig(List.of(new AttributeModifier(Attributes.MAX_ABSORPTION.getRegisteredName(), 4.0f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry YRDEN_CIRCLE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden_circle"), "Magical Trap", "Reduces movement speed, damages and traps undead targets.", (MobEffect)new YrdenCircleEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.YRDEN.color), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.1f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry YRDEN_GLYPH = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden_glyph"), "Yrden Glyph", "Reduces movement speed.", (MobEffect)new YrdenCircleEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.YRDEN.color), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.1f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry WOLF_SCHOOL_MEDALLION = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"wolf_school_medallion"), "Wolf School Sign Blade", "Deals magical damage per melee hit.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.WITCHER_MELEE.color)));
    public static Effects.Entry AZURE_WRATH = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"azure_wrath"), "Azure Wrath", "Stops healing and regeneration.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.WITCHER_MELEE.color), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.HEALING_TAKEN.id, -1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry IRIS_CHARGE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"iris_charge"), "Charged Sword", "Increases attack damage and lifesteal per stack.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 12379646), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.025f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(MRPGCEntityAttributes.LIFESTEAL_MODIFIER.getRegisteredName(), 0.01f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry ROSE_OF_REMEMBRANCE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"rose_of_remembrance"), "Rose of Remembrance", "Heals 5% of your max health every 2 seconds.", (MobEffect)new RoseOfRemembranceEffect(MobEffectCategory.BENEFICIAL, 12379646), new EffectConfig(List.of())));
    public static Effects.Entry SUNSTONE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"sunstone"), "Sunstone", "Boosts Sign Intensity.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.SIGN.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry YRDEN_GRIFFIN_MASTER = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden_griffin_master"), "Yrden Griffin Boost", "Boosts Sign Intensity & Reduces incoming Damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.SIGN.color), new EffectConfig(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id, -0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry FELINE_INJURY_MASTER = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"feline_injury_master"), "Feline Injury Master", "Boosts Sign Intensity & Reduces incoming Damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.WITCHER_MELEE.color), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id, 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry AXII_LETHARGY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"axii_lethargy"), "Axii Lethargy", "Slows the Target.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, WitcherSpellSchools.AXII.color), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry QUEN_EXPLOSIVE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_explosive"), "Exploding Shield", "Deals damage and knocks surrounding entities back when quen breaks.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.QUEN.color), new EffectConfig(List.of())));
    public static Effects.Entry QUEN_DISCHARGE = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_discharge"), "Quen Discharge", "Deals damage to the attacker.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, WitcherSpellSchools.QUEN.color), new EffectConfig(List.of())));
    public static Effects.Entry MUSCLE_MEMORY = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"muscle_memory"), "Muscle Memory", "Increases attack speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry STRENGTH_TRAINING = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"strength_training"), "Strength Training", "Increases attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.025f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry WITCHER_REFLEXES = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"witcher_reflexes"), "Witcher Reflexes", "Blocks the next Arrow or Melee Impact", (MobEffect)new WitcherReflexesEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of())));
    public static Effects.Entry ARROW_DEFLECTION = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"arrow_deflection"), "Arrow Deflection", "While blocking Arrows with Witcher Reflexes, you send the Arrow back to the shooter.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of())));
    public static Effects.Entry COUNTERATTACK = WitcherStatusEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"counterattack"), "Counterattack", "After a successful block, your next melee attack deals increased damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        ActionImpairing.configure((MobEffect)WitcherStatusEffects.AXII.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        RemoveOnHit.configure((MobEffect)WitcherStatusEffects.AXII.effect, (RemoveOnHit.Trigger)RemoveOnHit.Trigger.ANY_HIT);
        OnRemoval.configure((MobEffect)WitcherStatusEffects.QUEN_SHIELD.effect, context -> {
            QuenShieldEffect.onRemove(context.entity());
            if (context.entity().hasEffect(WitcherStatusEffects.QUEN_EXPLOSIVE.entry)) {
                context.entity().removeEffect(WitcherStatusEffects.QUEN_EXPLOSIVE.entry);
            }
            if (context.entity().hasEffect(WitcherStatusEffects.QUEN_DISCHARGE.entry)) {
                context.entity().removeEffect(WitcherStatusEffects.QUEN_DISCHARGE.entry);
            }
        });
        OnRemoval.configure((MobEffect)WitcherStatusEffects.QUEN_ACTIVE.effect, context -> {
            QuenActiveEffect.onRemove(context.entity());
            if (context.entity().hasEffect(WitcherStatusEffects.QUEN_EXPLOSIVE.entry)) {
                context.entity().removeEffect(WitcherStatusEffects.QUEN_EXPLOSIVE.entry);
            }
            if (context.entity().hasEffect(WitcherStatusEffects.QUEN_DISCHARGE.entry)) {
                context.entity().removeEffect(WitcherStatusEffects.QUEN_DISCHARGE.entry);
            }
        });
        OnRemoval.configure((MobEffect)WitcherStatusEffects.WITCHER_REFLEXES.effect, context -> {
            Holder effect = WitcherStatusEffects.ARROW_DEFLECTION.entry;
            if (context.entity().hasEffect(effect)) {
                int amplifier = context.entity().getEffect(effect).getAmplifier();
                int duration = context.entity().getEffect(effect).getDuration();
                if (amplifier == 0) {
                    context.entity().removeEffect(effect);
                } else {
                    context.entity().removeEffect(effect);
                    context.entity().addEffect(new MobEffectInstance(effect, duration, amplifier - 1, false, false, true));
                }
            }
        });
        CombatEvents.PLAYER_MELEE_ATTACK.register(event -> {
            Holder effect = WitcherStatusEffects.COUNTERATTACK.entry;
            if (event.player().hasEffect(effect)) {
                event.player().removeEffect(effect);
            }
        });
        for (Effects.Entry entry : entries) {
            Synchronized.configure((MobEffect)entry.effect, (boolean)true);
        }
        Effects.register(entries, (Map)config.effects);
    }
}

