/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.entity;

import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.spell_engine.api.entity.SpellEntity;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.EntityRelation;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.witcher_rpg.custom.WitcherSpellSchools;
import net.witcher_rpg.entity.attribute.WitcherAttributes;

public class YrdenMagicTrapEntity
extends Entity
implements SpellEntity.Spawned {
    public static EntityType<YrdenMagicTrapEntity> ENTITY_TYPE;
    public static final ParticleBatch yrden_damage_circle;
    public static final ParticleBatch yrden_damage_spehre;
    private ResourceLocation spellId;
    private int timeToLive = 20;
    private int ownerId;
    public static final ResourceLocation yrdenSoundId;
    public static final SoundEvent yrdenSound;
    private static final EntityDataAccessor<String> SPELL_ID_TRACKER;
    private static final EntityDataAccessor<Integer> OWNER_ID_TRACKER;
    private static final EntityDataAccessor<Integer> TIME_TO_LIVE_TRACKER;
    private static final int checkInterval = 4;
    private static final int checkDamageInterval = 40;
    private LivingEntity cachedOwner = null;

    public YrdenMagicTrapEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public void onSpawnedBySpell(SpellEntity.Spawned.Args args) {
        LivingEntity owner = args.owner();
        ResourceLocation spellId = ((ResourceKey)args.spell().unwrapKey().get()).location();
        Spell.Impact.Action.Spawn spawn = args.spawnData();
        this.spellId = spellId;
        this.getEntityData().set(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.ownerId = owner.getId();
        this.getEntityData().set(OWNER_ID_TRACKER, (Object)this.ownerId);
        this.timeToLive = spawn.time_to_live_seconds * 20;
        this.getEntityData().set(TIME_TO_LIVE_TRACKER, (Object)this.timeToLive);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.level().playSound(null, (Entity)this, yrdenSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        return super.hurt(source, amount);
    }

    public EntityDimensions getDimensions(Pose pose) {
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            Spell spell = (Spell)spellEntry.value();
            float width = spell.range * 2.0f;
            float height = spell.range;
            return EntityDimensions.scalable((float)width, (float)height);
        }
        return super.getDimensions(pose);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPELL_ID_TRACKER, (Object)"");
        builder.define(OWNER_ID_TRACKER, (Object)0);
        builder.define(TIME_TO_LIVE_TRACKER, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        String rawSpellId = (String)this.getEntityData().get(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = ResourceLocation.parse((String)rawSpellId);
        }
        this.timeToLive = (Integer)this.getEntityData().get(TIME_TO_LIVE_TRACKER);
        this.refreshDimensions();
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.spellId = ResourceLocation.parse((String)nbt.getString(NBTKey.SPELL_ID.key));
        this.ownerId = nbt.getInt(NBTKey.OWNER_ID.key);
        this.timeToLive = nbt.getInt(NBTKey.TIME_TO_LIVE.key);
        this.getEntityData().set(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.getEntityData().set(OWNER_ID_TRACKER, (Object)this.ownerId);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.putInt(NBTKey.OWNER_ID.key, this.ownerId);
        nbt.putInt(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
    }

    public boolean isSilent() {
        return false;
    }

    public void tick() {
        float yrden_intensity = 0.0f;
        LivingEntity owner = this.cachedOwner;
        yrden_intensity = owner == null ? 1.0f : (float)owner.getAttributeValue(WitcherAttributes.YRDEN_INTENSITY);
        super.tick();
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return;
        }
        Level world = this.level();
        if (!world.isClientSide()) {
            if (this.tickCount > this.timeToLive) {
                this.kill();
            }
            if (this.tickCount % 4 == 0) {
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(3.5));
                for (Entity entity : entities) {
                    LivingEntity livingEntity;
                    AbstractArrow projectile;
                    if (entity instanceof AbstractArrow && !this.isProtected((projectile = (AbstractArrow)entity).getOwner())) {
                        entity.playSound(yrdenSound, 1.0f, 1.0f);
                        if (!entity.level().isClientSide()) {
                            ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])new ParticleBatch[]{yrden_damage_circle});
                            ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])new ParticleBatch[]{yrden_damage_spehre});
                        }
                        projectile.kill();
                    }
                    if (!(entity instanceof LivingEntity) || this.isProtected((Entity)(livingEntity = (LivingEntity)entity)) || this.tickCount % 40 != 0) continue;
                    Holder yrdenGlyphSpellImpact = (Holder)SpellRegistry.from((Level)owner.level()).getHolder(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden_glyph_impact")).get();
                    SpellHelper.performImpacts((Level)owner.level(), (LivingEntity)owner, (Entity)livingEntity, (Entity)livingEntity, (Holder)yrdenGlyphSpellImpact, (List)((Spell)yrdenGlyphSpellImpact.value()).impacts, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)WitcherSpellSchools.YRDEN, (LivingEntity)owner)).position(livingEntity.position()));
                    livingEntity.playSound(yrdenSound, 1.0f, 1.0f);
                    if (entity.level().isClientSide()) continue;
                    ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])new ParticleBatch[]{yrden_damage_circle});
                    ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])new ParticleBatch[]{yrden_damage_spehre});
                }
            }
        }
    }

    public boolean isProtected(Entity other) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        EntityRelation relation = EntityRelations.getRelation((LivingEntity)owner, (Entity)other);
        switch (relation) {
            case ALLY: 
            case FRIENDLY: {
                return true;
            }
            case NEUTRAL: 
            case MIXED: 
            case HOSTILE: {
                return false;
            }
        }
        return false;
    }

    @Nullable
    public Holder<Spell> getSpellEntry() {
        return SpellRegistry.from((Level)this.level()).getHolder(this.spellId).orElse(null);
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null) {
            return this.cachedOwner;
        }
        Entity owner = this.level().getEntity(this.ownerId);
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner;
            this.cachedOwner = livingOwner = (LivingEntity)owner;
            return livingOwner;
        }
        return null;
    }

    static {
        yrden_damage_circle = new ParticleBatch("witcher_rpg.json:yrden_cloud", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 15.0f, 0.001f, 0.02f, 0.0f);
        yrden_damage_spehre = new ParticleBatch("witcher_rpg.json:yrden_cloud", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 15.0f, 0.001f, 0.02f, 0.0f);
        yrdenSoundId = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"yrden_sign");
        yrdenSound = SoundEvent.createVariableRangeEvent((ResourceLocation)yrdenSoundId);
        SPELL_ID_TRACKER = SynchedEntityData.defineId(YrdenMagicTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        OWNER_ID_TRACKER = SynchedEntityData.defineId(YrdenMagicTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        TIME_TO_LIVE_TRACKER = SynchedEntityData.defineId(YrdenMagicTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    private static enum NBTKey {
        OWNER_ID("OwnerId"),
        SPELL_ID("SpellId"),
        TIME_TO_LIVE("TTL");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

