/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.item.weapon;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellPowerMechanics;
import net.witcher_rpg.WitcherClassMod;
import net.witcher_rpg.config.TweaksConfig;
import net.witcher_rpg.item.WitcherGroup;
import net.witcher_rpg.item.WitcherMaterials;
import net.witcher_rpg.item.weapon.WitcherSword;

public class WeaponsRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final ResourceLocation ATTACK_DAMAGE = ResourceLocation.withDefaultNamespace((String)"generic.attack_damage");
    private static final ResourceLocation ATTACK_SPEED = ResourceLocation.withDefaultNamespace((String)"generic.attack_speed");
    private static final ResourceLocation ADRENALINE = ResourceLocation.parse((String)"witcher_rpg:adrenaline_modifier");
    private static final ResourceLocation AARD_INTENSITY = ResourceLocation.parse((String)"witcher_rpg:aard_intensity");
    private static final ResourceLocation AXII_INTENSITY = ResourceLocation.parse((String)"witcher_rpg:axii_intensity");
    private static final ResourceLocation IGNI_INTENSITY = ResourceLocation.parse((String)"witcher_rpg:igni_intensity");
    private static final ResourceLocation QUEN_INTENSITY = ResourceLocation.parse((String)"witcher_rpg:quen_intensity");
    private static final ResourceLocation YRDEN_INTENSITY = ResourceLocation.parse((String)"witcher_rpg:yrden_intensity");
    private static final ResourceLocation SIGN_INTENSITY = ResourceLocation.parse((String)"witcher_rpg:sign_intensity");
    public static float witcher_sword_attackSpeed = -2.4f;
    public static ResourceLocation steel_sword = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"steel_sword_passive");
    public static ResourceLocation silver_sword = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"silver_sword_passive");
    public static ResourceLocation ultimatum_passive = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"ultimatum_passive");
    public static ResourceLocation winters_blade_passive = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"winters_blade_passive");
    public static ResourceLocation aerondight_passive = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"aerondight_passive");
    public static ResourceLocation azure_wrath_passive = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"azure_wrath_passive");
    public static ResourceLocation reach_of_the_damned_passive = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"reach_of_the_damned_passive");
    public static ResourceLocation iris_passive = ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"iris_passive");
    public static final Weapon.Entry iron_witcher_sword = WeaponsRegister.witcherswords("iron_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 4.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)0.5f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.02f)).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_witcher_sword = WeaponsRegister.witcherswords("golden_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 2.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)0.5f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.02f)).loot(Equipment.LootProperties.of((String)"golden"));
    public static final Weapon.Entry diamond_witcher_sword = WeaponsRegister.witcherswords("diamond_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 5.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)1.0f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.035f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_witcher_sword = WeaponsRegister.witcherswords("netherite_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 6.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)2.5f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.06f)).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry steel_witcher_sword = WeaponsRegister.witcherswords("steel_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.STEEL_INGOT.item()})), 4.5f).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.035f)).spell(steel_sword).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry dark_iron_witcher_sword = WeaponsRegister.witcherswords("dark_iron_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.DARK_IRON_INGOT.item()})), 5.0f).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.065f)).spell(steel_sword).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry dark_steel_witcher_sword = WeaponsRegister.witcherswords("dark_steel_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.DARK_STEEL_INGOT.item()})), 6.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)1.5f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.1f)).spell(steel_sword).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry witcher_silver_sword = WeaponsRegister.witcherswords("silver_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.SILVER_INGOT.item()})), 4.5f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)2.5f)).spell(silver_sword).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry witcher_meteorite_sword = WeaponsRegister.witcherswords("meteorite_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.METEORITE_INGOT.item()})), 4.5f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)3.0f)).spell(silver_sword).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry witcher_meteorite_silver_sword = WeaponsRegister.witcherswords("meteorite_silver_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.METEORITE_SILVER_INGOT.item()})), 5.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)4.0f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.05f)).spell(silver_sword).loot(Equipment.LootProperties.of((int)3));
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final String AETHER = "aether";
    private static final String ARSENAL = "arsenal";

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType weaponType) {
        Weapon.Entry entry = new Weapon.Entry("witcher_rpg", name, material, factory, defaults, weaponType);
        entry.castSpell();
        entries.add(entry);
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry witcherswords(String name, Weapon.CustomMaterial material, float damage) {
        return WeaponsRegister.entry(name, material, WitcherSword::new, new WeaponConfig(damage, witcher_sword_attackSpeed), Equipment.WeaponType.SWORD);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Supplier<Ingredient> repair;
        if (FabricLoader.getInstance().isModLoaded(BETTER_NETHER) || ((TweaksConfig)WitcherClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.witcherswords("ruby_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 7.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)4.0f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.1f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(BETTER_END) || ((TweaksConfig)WitcherClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.witcherswords("aeternium_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 7.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)4.0f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.1f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(AETHER) || ((TweaksConfig)WitcherClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.witcherswords("aether_witcher_sword", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 7.0f).attribute(AttributeModifier.bonus((ResourceLocation)SIGN_INTENSITY, (float)4.0f)).attribute(AttributeModifier.multiply((ResourceLocation)ADRENALINE, (float)0.1f)).loot(Equipment.LootProperties.of((String)AETHER));
        }
        if (FabricLoader.getInstance().isModLoaded(ARSENAL) || ((TweaksConfig)WitcherClassMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.witcherswords((String)"winters_blade_sword", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$12(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)6.5f).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.AARD_INTENSITY, (float)3.0f)).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)WeaponsRegister.ADRENALINE, (float)0.05f)).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.15f)).spell((ResourceLocation)WeaponsRegister.winters_blade_passive).rarity = Rarity.RARE;
            WeaponsRegister.witcherswords((String)"ultimatum_sword", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$13(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)6.5f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.1f)).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)WeaponsRegister.ADRENALINE, (float)0.075f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.IGNI_INTENSITY, (float)3.0f)).spell((ResourceLocation)WeaponsRegister.ultimatum_passive).rarity = Rarity.RARE;
            WeaponsRegister.witcherswords((String)"azure_wrath_sword", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$14(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)6.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)WeaponsRegister.ADRENALINE, (float)0.05f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.SIGN_INTENSITY, (float)4.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.YRDEN_INTENSITY, (float)3.0f)).spell((ResourceLocation)WeaponsRegister.azure_wrath_passive).rarity = Rarity.RARE;
            WeaponsRegister.witcherswords((String)"reach_of_the_damned_sword", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$15(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)6.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)WeaponsRegister.ADRENALINE, (float)0.05f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.SIGN_INTENSITY, (float)4.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.AXII_INTENSITY, (float)3.0f)).spell((ResourceLocation)WeaponsRegister.reach_of_the_damned_passive).rarity = Rarity.RARE;
            WeaponsRegister.witcherswords((String)"aerondight_sword", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$16(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)6.5f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)WeaponsRegister.ADRENALINE, (float)0.1f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)WeaponsRegister.SIGN_INTENSITY, (float)5.0f)).spell((ResourceLocation)WeaponsRegister.aerondight_passive).rarity = Rarity.EPIC;
            WeaponsRegister.witcherswords((String)"iris_sword", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$17(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)7.0f).attribute((AttributeModifier)AttributeModifier.multiply((ResourceLocation)WeaponsRegister.ADRENALINE, (float)0.15f)).spell((ResourceLocation)WeaponsRegister.iris_passive).rarity = Rarity.EPIC;
        }
        Weapon.register(configs, entries, WitcherGroup.WITCHER_KEY);
    }

    private static /* synthetic */ Ingredient lambda$register$17() {
        return Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.DARK_STEEL_INGOT.item()});
    }

    private static /* synthetic */ Ingredient lambda$register$16() {
        return Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.METEORITE_SILVER_INGOT.item()});
    }

    private static /* synthetic */ Ingredient lambda$register$15() {
        return Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.SILVER_INGOT.item()});
    }

    private static /* synthetic */ Ingredient lambda$register$14() {
        return Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.SILVER_INGOT.item()});
    }

    private static /* synthetic */ Ingredient lambda$register$13() {
        return Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.STEEL_INGOT.item()});
    }

    private static /* synthetic */ Ingredient lambda$register$12() {
        return Ingredient.of((ItemLike[])new ItemLike[]{WitcherMaterials.STEEL_INGOT.item()});
    }
}

