/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.mixin;

import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.witcher_rpg.effect.WitcherStatusEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class PersistentProjectileEntityMixin {
    @Shadow
    protected boolean inGround;

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setRemainingFireTicks(I)V")}, cancellable=true)
    private void entityHitArrowDeflect(EntityHitResult entityHitResult, CallbackInfo ci) {
        AbstractArrow arrow;
        Entity entity;
        Entity arrowEntity;
        Player playerEntity;
        Entity hitEntity = entityHitResult.getEntity();
        if (hitEntity instanceof Player && (playerEntity = (Player)hitEntity).hasEffect(WitcherStatusEffects.ARROW_DEFLECTION.entry) && playerEntity.isBlocking() && !playerEntity.level().isClientSide() && (arrowEntity = (Entity)this) instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)arrowEntity).getOwner()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            ci.cancel();
            Vec3 toShooter = shooter.position().add(0.0, (double)shooter.getEyeHeight() / 2.0, 0.0).subtract(playerEntity.position().add(0.0, (double)playerEntity.getEyeHeight() / 2.0, 0.0)).normalize().scale(arrow.getDeltaMovement().length());
            arrow.setDeltaMovement(toShooter);
            arrow.setOwner((Entity)playerEntity);
            arrow.tickCount = 0;
            arrow.setYRot((float)(Mth.atan2((double)toShooter.x, (double)toShooter.z) * 57.29577951308232));
            arrow.setXRot((float)(Mth.atan2((double)toShooter.y, (double)toShooter.horizontalDistance()) * 57.29577951308232));
            arrow.yRotO = arrow.getYRot();
            arrow.xRotO = arrow.getXRot();
        }
    }

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void witcher$quenAbsorb(EntityHitResult entityHitResult, CallbackInfo ci) {
        PersistentProjectileEntityMixin persistentProjectileEntityMixin;
        Player player;
        Entity hit = entityHitResult.getEntity();
        if (hit instanceof Player && (player = (Player)hit).hasEffect(WitcherStatusEffects.QUEN_ACTIVE.entry) && (persistentProjectileEntityMixin = this) instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)persistentProjectileEntityMixin;
            ci.cancel();
            DamageSource source = arrow.damageSources().arrow(arrow, arrow.getOwner());
            hit.hurt(source, (float)arrow.getBaseDamage());
            arrow.discard();
            this.inGround = false;
            arrow.hasImpulse = true;
        }
    }
}

