/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.util.loot;

import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.witcher_rpg.item.WitcherMaterials;

public class WitcherLootTableChestModifiers {
    private static final ResourceLocation WEAPON_SMITH_CHEST = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_weaponsmith");
    private static final float silver_ingot_chance = 0.65f;
    private static final float steel_ingot_chance = 0.65f;
    private static final float dark_iron_ingot_chance = 0.15f;
    private static final float meteorite_ingot_chance = 0.15f;

    public static void modifyChestLootTables() {
        LootTableEvents.MODIFY.register((Object)new LootTableEvents.Modify(){

            public void modifyLootTable(ResourceKey<LootTable> key, LootTable.Builder tableBuilder, LootTableSource source, HolderLookup.Provider registries) {
                if (source.isBuiltin() && WEAPON_SMITH_CHEST.equals(key)) {
                    LootPool.Builder poolBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.65f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)WitcherMaterials.SILVER_INGOT.item())).apply(SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).build());
                    LootPool.Builder poolBuilder2 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.15f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)WitcherMaterials.DARK_IRON_INGOT.item())).apply(SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).build());
                    LootPool.Builder poolBuilder3 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.65f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)WitcherMaterials.STEEL_INGOT.item())).apply(SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).build());
                    LootPool.Builder poolBuilder4 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.15f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)WitcherMaterials.METEORITE.item())).apply(SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).build());
                    tableBuilder.pool(poolBuilder.build());
                    tableBuilder.pool(poolBuilder2.build());
                    tableBuilder.pool(poolBuilder3.build());
                    tableBuilder.pool(poolBuilder4.build());
                }
            }
        });
    }
}

