/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.witcher_rpg.datagen.WitcherModelProvider;
import net.witcher_rpg.datagen.WitcherRecipeProvider;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import net.witcher_rpg.item.WitcherArmorDiagrams;
import net.witcher_rpg.item.WitcherMaterials;
import net.witcher_rpg.item.WitcherTrinkets;
import net.witcher_rpg.item.armor.Armors;
import net.witcher_rpg.item.weapon.WeaponsRegister;
import net.witcher_rpg.spell.SetBonuses;
import net.witcher_rpg.spell.WitcherSpells;
import net.witcher_rpg.util.tags.WitcherItemTags;

public class WitcherClassModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(EnchantmentGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(WitcherModelProvider::new);
        pack.addProvider(WitcherRecipeProvider::new);
        pack.addProvider(EquipmentSetGenerator::new);
    }

    public static class EquipmentSetGenerator
    extends FabricDynamicRegistryProvider {
        public EquipmentSetGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(HolderLookup.Provider registries, FabricDynamicRegistryProvider.Entries entries) {
            HolderGetter itemLookup = registries.asGetterLookup().lookupOrThrow(Registries.ITEM);
            for (SetBonuses.Entry set : SetBonuses.all) {
                HolderSet.Direct items = HolderSet.direct(set.itemSupplier().get().stream().map(id -> itemLookup.getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id))).toList());
                entries.add(ResourceKey.create((ResourceKey)EquipmentSetRegistry.KEY, (ResourceLocation)set.id()), (Object)new EquipmentSet.Definition(set.id().getPath(), (HolderSet)items, set.bonuses()));
            }
        }

        public String getName() {
            return "Equipment Set Generator";
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(HolderLookup.Provider wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            WitcherTrinkets.entries.forEach(entry -> translationBuilder.add(entry.item().get().getDescriptionId(), entry.translatedName()));
            WitcherSpells.entries.forEach(entry -> {
                ResourceLocation id = entry.id();
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".name", entry.title());
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".description", entry.description());
            });
            WitcherStatusEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.getDescriptionId(), entry.title);
                translationBuilder.add(entry.effect.getDescriptionId() + ".description", entry.description);
            });
            SetBonuses.all.forEach(entry -> translationBuilder.add(EquipmentSet.translationKey((ResourceLocation)entry.id()), entry.title()));
            translationBuilder.add("filled_map.witcher_rpg.feline_hideouts", "Scavenger Hunt: Cat School Gear");
            translationBuilder.add("filled_map.witcher_rpg.griffin_hideouts", "Scavenger Hunt: Griffin School Gear");
            translationBuilder.add("filled_map.witcher_rpg.ursine_hideouts", "Scavenger Hunt: Bear School Gear");
            translationBuilder.add("filled_map.witcher_rpg.wolven_hideouts", "Scavenger Hunt: Wolf School Gear");
        }
    }

    private static class EnchantmentGenerator
    extends FabricDynamicRegistryProvider {
        public EnchantmentGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(HolderLookup.Provider registries, FabricDynamicRegistryProvider.Entries entries) {
            HolderGetter itemLookup = registries.asGetterLookup().lookupOrThrow(Registries.ITEM);
            float bonus = 0.03f;
            ResourceKey signIntensityId = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"sign_intensity"));
            Enchantment.Builder signIntensity = Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(WitcherItemTags.SIGN_INTENSITY_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"sign_intensity"), WitcherAttributes.SIGN_INTENSITY, (LevelBasedValue)LevelBasedValue.perLevel((float)bonus), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            entries.add(signIntensityId, (Object)signIntensity.build(signIntensityId.location()));
        }

        public String getName() {
            return "enchantments";
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        List<String> relicSwords1Keywords = List.of("azure_wrath", "reach_of_the_damned", "ultimatum", "winters");
        List<String> relicSwords2Keywords = List.of("aerondight", "iris");
        List<String> silverSwordsKeywords = List.of("silver", "meteorite", "aerondight", "azure_wrath", "reach_of_the_damned");
        List<String> steelSwordsKeywords = List.of("steel", "dark_iron", "iris", "ultimatum", "winters");
        List<String> meleeArmorKeywords = List.of("ursine", "feline");
        List<String> magicArmorKeywords = List.of("witcher", "wolven", "griffin");
        TagKey relicsKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"all"));
        List<String> trinkets0Keywords = List.of("crystal_skull", "rose_of_remembrance", "pure_silver");
        List<String> trinkets1Keywords = List.of("sunstone");

        public ItemTagGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateWitcherWeaponTags(List<Weapon.Entry> weapons, TagKey tagKey) {
            for (Weapon.Entry weapon : weapons) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                tag.addOptional(weapon.id());
            }
        }

        public void generateWitcherArmorTag(List<Armor.Entry> armors, TagKey tagKey) {
            for (Armor.Entry armor : armors) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                for (Object id : armor.armorSet().pieceIds()) {
                    tag.addOptional((ResourceLocation)id);
                }
            }
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            this.generateWeaponTags(WeaponsRegister.entries);
            this.generateWitcherWeaponTags(WeaponsRegister.entries, WitcherItemTags.WITCHER_SWORDS);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.silverSwordsKeywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.SILVER_SWORDS);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.steelSwordsKeywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.STEEL_SWORDS);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.relicSwords1Keywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.RELIC_SWORDS_1);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.relicSwords2Keywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.RELIC_SWORDS_2);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> this.magicArmorKeywords.stream().anyMatch(entry.name()::contains)).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> this.meleeArmorKeywords.stream().anyMatch(entry.name()::contains)).toList(), RPGSeriesItemTags.ArmorMetaType.MELEE);
            this.generateWitcherArmorTag(Armors.entries, WitcherItemTags.WITCHER_ARMOR);
            FabricTagProvider.FabricTagBuilder relicsAll = this.getOrCreateTagBuilder(this.relicsKey);
            WitcherTrinkets.entries.stream().filter(entry -> !entry.name().toLowerCase().contains("medallion")).forEach(entry -> relicsAll.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder glyphs0 = this.getOrCreateTagBuilder(WitcherItemTags.GLYPHS_0);
            WitcherTrinkets.entries.stream().filter(entry -> entry.name().toLowerCase().contains("lesser")).forEach(entry -> glyphs0.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder glyphs1 = this.getOrCreateTagBuilder(WitcherItemTags.GLYPHS_1);
            WitcherTrinkets.entries.stream().filter(entry -> entry.name().toLowerCase().contains("glyph")).filter(entry -> !entry.name().toLowerCase().contains("greater")).filter(entry -> !entry.name().toLowerCase().contains("lesser")).forEach(entry -> glyphs1.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder glyphs2 = this.getOrCreateTagBuilder(WitcherItemTags.GLYPHS_2);
            WitcherTrinkets.entries.stream().filter(entry -> entry.name().toLowerCase().contains("greater")).forEach(entry -> glyphs2.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder trinkets0 = this.getOrCreateTagBuilder(WitcherItemTags.TRINKETS_0);
            WitcherTrinkets.entries.stream().filter(entry -> this.trinkets0Keywords.stream().anyMatch(entry.name()::contains)).toList().forEach(entry -> trinkets0.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder trinkets1 = this.getOrCreateTagBuilder(WitcherItemTags.TRINKETS_1);
            WitcherTrinkets.entries.stream().filter(entry -> this.trinkets1Keywords.stream().anyMatch(entry.name()::contains)).toList().forEach(entry -> trinkets1.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder tier5ArmorTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)5, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
            FabricTagProvider.FabricTagBuilder enhanced = this.getOrCreateTagBuilder(WitcherItemTags.ENHANCED_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("enhanced")).forEach(entry -> enhanced.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder superior = this.getOrCreateTagBuilder(WitcherItemTags.SUPERIOR_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("superior")).forEach(entry -> superior.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder mastercrafted = this.getOrCreateTagBuilder(WitcherItemTags.MASTERCRAFTED_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("mastercrafted")).forEach(entry -> mastercrafted.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder grandmaster = this.getOrCreateTagBuilder(WitcherItemTags.GRANDMASTER_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("grandmaster")).forEach(entry -> grandmaster.addOptional(entry.id()));
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("grandmaster")).forEach(entry -> tier5ArmorTag.addOptional(entry.id()));
            WitcherMaterials.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("dimeritium_ingot")).forEach(entry -> tier5ArmorTag.addOptional(entry.id()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (WitcherSpells.Entry entry : WitcherSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

