/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.witcher_rpg.item.WitcherArmorDiagrams;
import net.witcher_rpg.item.WitcherTrinkets;
import net.witcher_rpg.item.armor.Armors;

public class WitcherModelProvider
extends FabricModelProvider {
    public WitcherModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
    }

    public void generateItemModels(ItemModelGenerators itemModelGenerator) {
        WitcherArmorDiagrams.ENTRIES.forEach(entry -> {
            Item item = entry.item();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
            JsonObject json = new JsonObject();
            json.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "witcher_rpg:item/misc/witcher_armor_diagram");
            json.add("textures", (JsonElement)textures);
            itemModelGenerator.output.accept(modelId, () -> json);
        });
        WitcherTrinkets.entries.forEach(entry -> {
            Item item = entry.item().get();
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
            JsonObject json = new JsonObject();
            json.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "witcher_rpg:item/trinkets/" + entry.name());
            json.add("textures", (JsonElement)textures);
            itemModelGenerator.output.accept(modelId, () -> json);
        });
        Armors.entries.forEach(entry -> {
            ArmorItem item = entry.armorSet().head;
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
            JsonObject json = new JsonObject();
            json.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "witcher_rpg:item/armor/" + entry.name() + "_head");
            json.add("textures", (JsonElement)textures);
            itemModelGenerator.output.accept(modelId, () -> json);
        });
        Armors.entries.forEach(entry -> {
            ArmorItem item = entry.armorSet().chest;
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
            JsonObject json = new JsonObject();
            json.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "witcher_rpg:item/armor/" + entry.name() + "_chest");
            json.add("textures", (JsonElement)textures);
            itemModelGenerator.output.accept(modelId, () -> json);
        });
        Armors.entries.forEach(entry -> {
            ArmorItem item = entry.armorSet().feet;
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
            JsonObject json = new JsonObject();
            json.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "witcher_rpg:item/armor/" + entry.name() + "_feet");
            json.add("textures", (JsonElement)textures);
            itemModelGenerator.output.accept(modelId, () -> json);
        });
        Armors.entries.forEach(entry -> {
            ArmorItem item = entry.armorSet().legs;
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
            ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
            JsonObject json = new JsonObject();
            json.addProperty("parent", "item/generated");
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", "witcher_rpg:item/armor/" + entry.name() + "_legs");
            json.add("textures", (JsonElement)textures);
            itemModelGenerator.output.accept(modelId, () -> json);
        });
    }
}

