/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.ItemLike;
import net.witcher_rpg.item.WitcherGroup;

public class WitcherArmorDiagrams {
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static final List<ResourceLocation> BASE_ITEMS = List.of(ResourceLocation.parse((String)"item/empty_slot_sword"), ResourceLocation.parse((String)"item/empty_armor_slot_helmet"), ResourceLocation.parse((String)"item/empty_armor_slot_chestplate"), ResourceLocation.parse((String)"item/empty_armor_slot_leggings"), ResourceLocation.parse((String)"item/empty_armor_slot_boots"));
    public static final List<ResourceLocation> INGREDIENT_ITEMS_WITCHER_ARMOR = List.of(ResourceLocation.parse((String)"item/empty_slot_ingot"));
    private static final String[] KEYS;

    private static Entry add(Entry entry) {
        ENTRIES.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : ENTRIES) {
            Item item;
            entry.container.item = item = entry.factory().apply(entry.settings());
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(WitcherGroup.WITCHER_KEY).register(content -> {
            for (Entry entry : ENTRIES) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    static {
        for (String key : KEYS = new String[]{"enhanced", "superior", "mastercrafted", "grandmaster"}) {
            WitcherArmorDiagrams.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)(key + "_diagram")), settings -> new SmithingTemplateItem((Component)Component.translatable((String)("smithing_template.witcher_rpg." + key + ".applies_to")).withStyle(ChatFormatting.DARK_GREEN), (Component)Component.translatable((String)("smithing_template.witcher_rpg." + key + ".ingredients")).withStyle(ChatFormatting.DARK_GREEN), (Component)Component.translatable((String)("smithing_template.witcher_rpg." + key + ".title")).withStyle(ChatFormatting.GREEN), (Component)Component.translatable((String)("smithing_template.witcher_rpg." + key + ".base_slot_description")), (Component)Component.translatable((String)("smithing_template.witcher_rpg." + key + ".additions_slot_description")), BASE_ITEMS, INGREDIENT_ITEMS_WITCHER_ARMOR, new FeatureFlag[0]), new Item.Properties()));
        }
    }

    public record Entry(ResourceLocation id, Function<Item.Properties, Item> factory, Item.Properties settings, Container container) {
        public Entry(ResourceLocation id, Function<Item.Properties, Item> factory, Item.Properties settings) {
            this(id, factory, settings, new Container());
        }

        public Item item() {
            return this.container.item;
        }
    }

    public static class Container {
        Item item;
    }
}

