/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1322;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9701;
import net.minecraft.class_9704;
import net.minecraft.class_9720;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.witcher_rpg.datagen.WitcherModelProvider;
import net.witcher_rpg.datagen.WitcherRecipeProvider;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import net.witcher_rpg.item.WitcherArmorDiagrams;
import net.witcher_rpg.item.WitcherMaterials;
import net.witcher_rpg.item.WitcherTrinkets;
import net.witcher_rpg.item.armor.Armors;
import net.witcher_rpg.item.weapon.WeaponsRegister;
import net.witcher_rpg.spell.SetBonuses;
import net.witcher_rpg.spell.WitcherSpells;
import net.witcher_rpg.util.tags.WitcherItemTags;

public class WitcherClassModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(EnchantmentGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(WitcherModelProvider::new);
        pack.addProvider(WitcherRecipeProvider::new);
        pack.addProvider(EquipmentSetGenerator::new);
    }

    public static class EquipmentSetGenerator
    extends FabricDynamicRegistryProvider {
        public EquipmentSetGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            class_7871 itemLookup = registries.method_46758().method_46751(class_7924.field_41197);
            for (SetBonuses.Entry set : SetBonuses.all) {
                class_6885.class_6886 items = class_6885.method_40242(set.itemSupplier().get().stream().map(id -> itemLookup.method_46747(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id))).toList());
                entries.add(class_5321.method_29179((class_5321)EquipmentSetRegistry.KEY, (class_2960)set.id()), (Object)new EquipmentSet.Definition(set.id().method_12832(), (class_6885)items, set.bonuses()));
            }
        }

        public String method_10321() {
            return "Equipment Set Generator";
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            WitcherTrinkets.entries.forEach(entry -> translationBuilder.add(entry.item().get().method_7876(), entry.translatedName()));
            WitcherSpells.entries.forEach(entry -> {
                class_2960 id = entry.id();
                translationBuilder.add("spell." + id.method_12836() + "." + id.method_12832() + ".name", entry.title());
                translationBuilder.add("spell." + id.method_12836() + "." + id.method_12832() + ".description", entry.description());
            });
            WitcherStatusEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.method_5567(), entry.title);
                translationBuilder.add(entry.effect.method_5567() + ".description", entry.description);
            });
            SetBonuses.all.forEach(entry -> translationBuilder.add(EquipmentSet.translationKey((class_2960)entry.id()), entry.title()));
            translationBuilder.add("filled_map.witcher_rpg.feline_hideouts", "Scavenger Hunt: Cat School Gear");
            translationBuilder.add("filled_map.witcher_rpg.griffin_hideouts", "Scavenger Hunt: Griffin School Gear");
            translationBuilder.add("filled_map.witcher_rpg.ursine_hideouts", "Scavenger Hunt: Bear School Gear");
            translationBuilder.add("filled_map.witcher_rpg.wolven_hideouts", "Scavenger Hunt: Wolf School Gear");
        }
    }

    private static class EnchantmentGenerator
    extends FabricDynamicRegistryProvider {
        public EnchantmentGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            class_7871 itemLookup = registries.method_46758().method_46751(class_7924.field_41197);
            float bonus = 0.03f;
            class_5321 signIntensityId = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"witcher_rpg", (String)"sign_intensity"));
            class_1887.class_9700 signIntensity = class_1887.method_60030((class_1887.class_9427)class_1887.method_58442((class_6885)itemLookup.method_46735(WitcherItemTags.SIGN_INTENSITY_ENCHANTABLE), (int)2, (int)5, (class_1887.class_9426)class_1887.method_58441((int)1, (int)11), (class_1887.class_9426)class_1887.method_58441((int)12, (int)11), (int)1, (class_9274[])new class_9274[]{class_9274.field_49224})).method_60065(class_9701.field_51668, new class_9720(class_2960.method_60655((String)"witcher_rpg", (String)"sign_intensity"), WitcherAttributes.SIGN_INTENSITY, (class_9704)class_9704.method_60194((float)bonus), class_1322.class_1323.field_6330));
            entries.add(signIntensityId, (Object)signIntensity.method_60060(signIntensityId.method_29177()));
        }

        public String method_10321() {
            return "enchantments";
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        List<String> relicSwords1Keywords = List.of("azure_wrath", "reach_of_the_damned", "ultimatum", "winters");
        List<String> relicSwords2Keywords = List.of("aerondight", "iris");
        List<String> silverSwordsKeywords = List.of("silver", "meteorite", "aerondight", "azure_wrath", "reach_of_the_damned");
        List<String> steelSwordsKeywords = List.of("steel", "dark_iron", "iris", "ultimatum", "winters");
        List<String> meleeArmorKeywords = List.of("ursine", "feline");
        List<String> magicArmorKeywords = List.of("witcher", "wolven", "griffin");
        class_6862 relicsKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"relics_rpgs", (String)"all"));
        List<String> trinkets0Keywords = List.of("crystal_skull", "rose_of_remembrance", "pure_silver");
        List<String> trinkets1Keywords = List.of("sunstone");

        public ItemTagGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateWitcherWeaponTags(List<Weapon.Entry> weapons, class_6862 tagKey) {
            for (Weapon.Entry weapon : weapons) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                tag.addOptional(weapon.id());
            }
        }

        public void generateWitcherArmorTag(List<Armor.Entry> armors, class_6862 tagKey) {
            for (Armor.Entry armor : armors) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                for (Object id : armor.armorSet().pieceIds()) {
                    tag.addOptional((class_2960)id);
                }
            }
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateWeaponTags(WeaponsRegister.entries);
            this.generateWitcherWeaponTags(WeaponsRegister.entries, WitcherItemTags.WITCHER_SWORDS);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.silverSwordsKeywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.SILVER_SWORDS);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.steelSwordsKeywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.STEEL_SWORDS);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.relicSwords1Keywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.RELIC_SWORDS_1);
            this.generateWitcherWeaponTags(WeaponsRegister.entries.stream().filter(entry -> this.relicSwords2Keywords.stream().anyMatch(entry.name()::contains)).toList(), WitcherItemTags.RELIC_SWORDS_2);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> this.magicArmorKeywords.stream().anyMatch(entry.name()::contains)).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> this.meleeArmorKeywords.stream().anyMatch(entry.name()::contains)).toList(), RPGSeriesItemTags.ArmorMetaType.MELEE);
            this.generateWitcherArmorTag(Armors.entries, WitcherItemTags.WITCHER_ARMOR);
            FabricTagProvider.FabricTagBuilder relicsAll = this.getOrCreateTagBuilder(this.relicsKey);
            WitcherTrinkets.entries.stream().filter(entry -> !entry.name().toLowerCase().contains("medallion")).forEach(entry -> relicsAll.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder glyphs0 = this.getOrCreateTagBuilder(WitcherItemTags.GLYPHS_0);
            WitcherTrinkets.entries.stream().filter(entry -> entry.name().toLowerCase().contains("lesser")).forEach(entry -> glyphs0.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder glyphs1 = this.getOrCreateTagBuilder(WitcherItemTags.GLYPHS_1);
            WitcherTrinkets.entries.stream().filter(entry -> entry.name().toLowerCase().contains("glyph")).filter(entry -> !entry.name().toLowerCase().contains("greater")).filter(entry -> !entry.name().toLowerCase().contains("lesser")).forEach(entry -> glyphs1.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder glyphs2 = this.getOrCreateTagBuilder(WitcherItemTags.GLYPHS_2);
            WitcherTrinkets.entries.stream().filter(entry -> entry.name().toLowerCase().contains("greater")).forEach(entry -> glyphs2.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder trinkets0 = this.getOrCreateTagBuilder(WitcherItemTags.TRINKETS_0);
            WitcherTrinkets.entries.stream().filter(entry -> this.trinkets0Keywords.stream().anyMatch(entry.name()::contains)).toList().forEach(entry -> trinkets0.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder trinkets1 = this.getOrCreateTagBuilder(WitcherItemTags.TRINKETS_1);
            WitcherTrinkets.entries.stream().filter(entry -> this.trinkets1Keywords.stream().anyMatch(entry.name()::contains)).toList().forEach(entry -> trinkets1.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder tier5ArmorTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)5, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
            FabricTagProvider.FabricTagBuilder enhanced = this.getOrCreateTagBuilder(WitcherItemTags.ENHANCED_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("enhanced")).forEach(entry -> enhanced.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder superior = this.getOrCreateTagBuilder(WitcherItemTags.SUPERIOR_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("superior")).forEach(entry -> superior.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder mastercrafted = this.getOrCreateTagBuilder(WitcherItemTags.MASTERCRAFTED_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("mastercrafted")).forEach(entry -> mastercrafted.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder grandmaster = this.getOrCreateTagBuilder(WitcherItemTags.GRANDMASTER_DIAGRAMS);
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("grandmaster")).forEach(entry -> grandmaster.addOptional(entry.id()));
            WitcherArmorDiagrams.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("grandmaster")).forEach(entry -> tier5ArmorTag.addOptional(entry.id()));
            WitcherMaterials.ENTRIES.stream().filter(entry -> entry.id().toString().toLowerCase().contains("dimeritium_ingot")).forEach(entry -> tier5ArmorTag.addOptional(entry.id()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (WitcherSpells.Entry entry : WitcherSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

