/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_power.api.SpellPowerMechanics;
import net.witcher_rpg.config.TrinketConfig;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import net.witcher_rpg.item.WitcherGroup;
import net.witcher_rpg.spell.SetBonuses;
import org.jetbrains.annotations.Nullable;

public class WitcherTrinkets {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Function<ItemArgs, class_1792> factory = args -> {
        class_1792.class_1793 settings = args.settings;
        if (args.attributes != null) {
            settings.method_57348(args.attributes);
        }
        return new class_1792(settings);
    };
    public static float medallion_sign_intensity = 0.1f;
    public static float medallion_attack_damage = 0.12f;
    public static float medallion_haste = 0.05f;
    public static float medallion_adrenaline = 0.1f;
    public static float medallion_health = 4.0f;
    public static float lesser_glyph_power = 1.0f;
    public static float glyph_power = 1.5f;
    public static float greater_glyph_power = 2.0f;
    public static final Entry BEAR_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "bear_school_medallion", "Bear School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23716.method_55840(), medallion_health, class_1322.class_1323.field_6328), new AttributeModifier(class_5134.field_23721.method_55840(), medallion_attack_damage, class_1322.class_1323.field_6330), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.method_55840(), medallion_adrenaline, class_1322.class_1323.field_6330)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_ursine.id());
    public static final Entry CAT_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "cat_school_medallion", "Cat School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23723.method_55840(), medallion_haste, class_1322.class_1323.field_6330), new AttributeModifier(class_5134.field_23721.method_55840(), medallion_attack_damage, class_1322.class_1323.field_6330), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.method_55840(), medallion_adrenaline, class_1322.class_1323.field_6330)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_feline.id());
    public static final Entry GRIFFIN_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "griffin_school_medallion", "Griffin School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.method_55840(), medallion_sign_intensity, class_1322.class_1323.field_6330), new AttributeModifier(SpellPowerMechanics.HASTE.id, medallion_haste, class_1322.class_1323.field_6330), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.method_55840(), medallion_adrenaline, class_1322.class_1323.field_6330)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_griffin.id());
    public static final Entry WOLF_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "wolf_school_medallion", "Wolf School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.method_55840(), medallion_sign_intensity, class_1322.class_1323.field_6330), new AttributeModifier(class_5134.field_23721.method_55840(), medallion_attack_damage, class_1322.class_1323.field_6330), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.method_55840(), medallion_adrenaline, class_1322.class_1323.field_6330)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_wolven.id());
    public static final Entry LESSER_AARD_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_aard_glyph", "Lesser Aard Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.method_55840(), lesser_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry LESSER_AXII_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_axii_glyph", "Lesser Axii Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.method_55840(), lesser_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry LESSER_IGNI_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_igni_glyph", "Lesser Igni Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.method_55840(), lesser_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry LESSER_QUEN_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_quen_glyph", "Lesser Quen Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.method_55840(), lesser_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry LESSER_YRDEN_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_yrden_glyph", "Lesser Yrden Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.method_55840(), lesser_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry AARD_GLYPH = WitcherTrinkets.add(new Entry(10, "aard_glyph", "Aard Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.method_55840(), glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry AXII_GLYPH = WitcherTrinkets.add(new Entry(10, "axii_glyph", "Axii Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.method_55840(), glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry IGNI_GLYPH = WitcherTrinkets.add(new Entry(10, "igni_glyph", "Igni Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.method_55840(), glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry QUEN_GLYPH = WitcherTrinkets.add(new Entry(10, "quen_glyph", "Quen Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.method_55840(), glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry YRDEN_GLYPH = WitcherTrinkets.add(new Entry(10, "yrden_glyph", "Yrden Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.method_55840(), glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry GREATER_AARD_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_aard_glyph", "Greater Aard Glyph")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:greater_aard_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.method_55840(), greater_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry GREATER_AXII_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_axii_glyph", "Greater Axii Glyph")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:greater_axii_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.method_55840(), greater_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry GREATER_IGNI_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_igni_glyph", "Greater Igni Glyph")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:greater_igni_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.method_55840(), greater_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry GREATER_QUEN_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_quen_glyph", "Greater Quen Glyph")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:greater_quen_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.method_55840(), greater_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry GREATER_YRDEN_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_yrden_glyph", "Greater Yrden Glyph")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:greater_yrden_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.method_55840(), greater_glyph_power, class_1322.class_1323.field_6328))));
    public static final Entry PURE_SILVER = WitcherTrinkets.add(new Entry(10, "pure_silver", "Pure Silver")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:pure_silver"))).config(new TrinketConfig.Entry());
    public static final Entry ROSE_OF_REMEMBRANCE = WitcherTrinkets.add(new Entry(10, "rose_of_remembrance", "Rose of Remembrance")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:rose_of_remembrance"))).config(new TrinketConfig.Entry());
    public static final Entry CRYSTAL_SKULL = WitcherTrinkets.add(new Entry(10, "crystal_skull", "Crystal Skull")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:crystal_skull"))).config(new TrinketConfig.Entry());
    public static final Entry SUNSTONE = WitcherTrinkets.add(new Entry(10, "sunstone", "Sunstone")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"witcher_rpg:sunstone"))).config(new TrinketConfig.Entry());

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Function<ItemArgs, class_1792> getFactory() {
        return factory;
    }

    public static void register(Map<String, TrinketConfig.Entry> config) {
        for (Entry entry : entries) {
            String key = entry.id().toString();
            TrinketConfig.Entry configEntry = config.get(key);
            if (configEntry != null) {
                entry.config(configEntry);
                continue;
            }
            config.put(key, entry.config());
        }
        for (Entry entry : entries) {
            if (!entry.isEnabled()) continue;
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(WitcherGroup.WITCHER_KEY).register(content -> {
            for (Entry entry : entries) {
                if (!entry.isEnabled()) continue;
                content.method_45421((class_1935)entry.item().get());
            }
        });
    }

    public static final class Entry {
        private final int tier;
        public String lootTheme;
        private final String name;
        private final String translatedName;
        private TrinketConfig.Entry config;
        public TrinketConfig.Entry defaults;
        private final Supplier<class_1792> item;
        private SpellContainer spellContainer;
        private final List<UnaryOperator<class_1792.class_1793>> settingsMutators = new ArrayList<UnaryOperator<class_1792.class_1793>>();

        public Entry(int tier, String name, String translatedName) {
            this(tier, name, translatedName, TrinketConfig.Entry.EMPTY);
        }

        public Entry(int tier, String name, String translatedName, TrinketConfig.Entry config) {
            this.tier = tier;
            this.name = name;
            this.translatedName = translatedName;
            this.config = config;
            this.defaults = config;
            this.item = Suppliers.memoize(() -> {
                class_1792.class_1793 settings = new class_1792.class_1793().method_7889(1);
                class_9285 attributes = this.config().attributes != null && !this.config().attributes.isEmpty() ? ConfigUtil.attributesComponent((class_2960)class_2960.method_60655((String)"witcher_rpg", (String)name), this.config().attributes).method_57486() : null;
                SpellContainer spellContainer = this.spellContainer();
                if (spellContainer != null) {
                    settings = settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)spellContainer);
                }
                if (this.config().durability > 0) {
                    settings = settings.method_7895(this.config().durability);
                }
                if (name.contains("medallion")) {
                    settings = settings.method_7894(class_1814.field_8904);
                }
                if (name.contains("lesser")) {
                    settings = settings.method_7894(class_1814.field_8906);
                }
                if (!name.contains("lesser") && !name.contains("greater") && name.contains("glyph")) {
                    settings = settings.method_7894(class_1814.field_8907);
                }
                if (name.contains("greater")) {
                    settings = settings.method_7894(class_1814.field_8903);
                }
                if (name.contains("pure_silver") && name.contains("rose_of_remembrance") && name.contains("crystal_skull")) {
                    settings = settings.method_7894(class_1814.field_8903);
                }
                if (name.contains("sunstone")) {
                    settings = settings.method_7894(class_1814.field_8904);
                }
                for (UnaryOperator<class_1792.class_1793> mutator : this.settingsMutators) {
                    settings = (class_1792.class_1793)mutator.apply(settings);
                }
                return WitcherTrinkets.getFactory().apply(new ItemArgs(settings, attributes));
            });
        }

        public int tier() {
            return this.tier;
        }

        public class_2960 id() {
            return class_2960.method_60655((String)"witcher_rpg", (String)this.name);
        }

        public String name() {
            return this.name;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public TrinketConfig.Entry config() {
            return this.config;
        }

        public Supplier<class_1792> item() {
            return this.item;
        }

        @Nullable
        public SpellContainer spellContainer() {
            return this.spellContainer;
        }

        public Entry config(TrinketConfig.Entry config) {
            this.config = config;
            return this;
        }

        public Entry spell(SpellContainer spellContainer) {
            this.spellContainer = spellContainer;
            return this;
        }

        public Entry lootTheme(String lootTheme) {
            this.lootTheme = lootTheme;
            return this;
        }

        public <T> Entry component(class_9331<T> type, T value) {
            this.settingsMutators.add(settings -> settings.method_57349(type, value));
            return this;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public record ItemArgs(class_1792.class_1793 settings, @Nullable class_9285 attributes) {
    }
}

