/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.spell;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.SpellEngineEffects;
import net.spell_engine.api.entity.SpellEntityPredicates;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.util.TriState;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.witcher_rpg.custom.WitcherSpellSchools;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import net.witcher_rpg.sounds.Sounds;
import org.jetbrains.annotations.Nullable;

public class WitcherSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static float sign_vulnerability = 0.3f;
    private static final SpellEntityPredicates.Entry HAS_YRDEN = SpellEntityPredicates.hasEffectOptimized((class_2960)class_2960.method_60655((String)"witcher_rpg", (String)"yrden"));
    public static final Entry AARD = WitcherSpells.add(WitcherSpells.aard());
    public static final Entry yrden = WitcherSpells.add(WitcherSpells.yrden());
    public static final Entry yrden_glyph_impact = WitcherSpells.add(WitcherSpells.yrden_glyph_impact());
    public static Entry quen_active_helper = WitcherSpells.add(WitcherSpells.quen_active_helper());
    public static final Entry defensive_witcher_mechanics = WitcherSpells.add(WitcherSpells.defensive_witcher_mechanics());
    public static final Entry GREATER_AARD_GLYPH = WitcherSpells.add(WitcherSpells.greater_aard_glyph());
    public static final Entry GREATER_AXII_GLYPH = WitcherSpells.add(WitcherSpells.greater_axii_glyph());
    public static final Entry GREATER_IGNI_GLYPH = WitcherSpells.add(WitcherSpells.greater_igni_glyph());
    public static final Entry GREATER_QUEN_GLYPH = WitcherSpells.add(WitcherSpells.greater_quen_glyph());
    public static final Entry GREATER_YRDEN_GLYPH = WitcherSpells.add(WitcherSpells.greater_yrden_glyph());
    public static Entry improved_whirl = WitcherSpells.add(WitcherSpells.improved_whirl());
    public static Entry improved_yrden = WitcherSpells.add(WitcherSpells.improved_yrden());
    public static Entry improved_aard = WitcherSpells.add(WitcherSpells.improved_aard());
    public static Entry improved_rend = WitcherSpells.add(WitcherSpells.improved_rend());
    public static final Entry aard_far_reach = WitcherSpells.add(WitcherSpells.aard_far_reach());
    public static Entry aard_shockwave = WitcherSpells.add(WitcherSpells.aard_shockwave());
    public static Entry aard_frostbite = WitcherSpells.add(WitcherSpells.aard_frostbite());
    public static final Entry axii_lethargy = WitcherSpells.add(WitcherSpells.axii_lethargy());
    public static Entry axii_link = WitcherSpells.add(WitcherSpells.axii_link());
    public static Entry axii_domination = WitcherSpells.add(WitcherSpells.axii_domination());
    public static Entry igni_melt_armor = WitcherSpells.add(WitcherSpells.igni_melt_armor());
    public static Entry igni_combustion = WitcherSpells.add(WitcherSpells.igni_combustion());
    public static final Entry igni_pyromaniac = WitcherSpells.add(WitcherSpells.igni_pyromaniac());
    public static final Entry quen_exploding_shield = WitcherSpells.add(WitcherSpells.quen_exploding_shield());
    public static final Entry quen_warding_shield = WitcherSpells.add(WitcherSpells.quen_warding_shield());
    public static final Entry quen_discharge = WitcherSpells.add(WitcherSpells.quen_discharge());
    public static final Entry yrden_sustained_glyphs = WitcherSpells.add(WitcherSpells.yrden_sustained_glyphs());
    public static final Entry yrden_binding_glyphs = WitcherSpells.add(WitcherSpells.yrden_binding_glyphs());
    public static final Entry yrden_supercharged_glyphs = WitcherSpells.add(WitcherSpells.yrden_supercharged_glyphs());
    public static final Entry muscle_memory = WitcherSpells.add(WitcherSpells.muscle_memory());
    public static Entry whirl_boost_a = WitcherSpells.add(WitcherSpells.whirl_boost_a());
    public static final Entry strength_training = WitcherSpells.add(WitcherSpells.strength_training());
    public static Entry rend_boost_a = WitcherSpells.add(WitcherSpells.rend_boost_a());
    public static Entry witcher_reflexes_boost_a = WitcherSpells.add(WitcherSpells.witcher_reflexes_boost_a());
    public static Entry arrow_deflection = WitcherSpells.add(WitcherSpells.arrow_deflection());
    public static Entry counterattack = WitcherSpells.add(WitcherSpells.counterattack());
    public static final Entry griffin_school_technique = WitcherSpells.add(WitcherSpells.griffin_school_technique());
    public static final Entry cat_school_technique = WitcherSpells.add(WitcherSpells.cat_school_technique());
    public static final Entry bear_school_technique = WitcherSpells.add(WitcherSpells.bear_school_technique());
    public static final Entry wolf_school_technique = WitcherSpells.add(WitcherSpells.wolf_school_technique());
    public static final Entry ROSE_OF_REMEMBRANCE = WitcherSpells.add(WitcherSpells.rose_of_remembrance());
    public static Entry sunstone = WitcherSpells.add(WitcherSpells.sunstone());
    public static Entry crystal_skull = WitcherSpells.add(WitcherSpells.crystal_skull());
    public static Entry pure_silver = WitcherSpells.add(WitcherSpells.pure_silver());
    public static final Entry grandmaster_feline = WitcherSpells.add(WitcherSpells.grandmaster_feline());
    public static final Entry grandmaster_griffin = WitcherSpells.add(WitcherSpells.grandmaster_griffin());
    public static final Entry grandmaster_wolven = WitcherSpells.add(WitcherSpells.grandmaster_wolven());
    public static final Entry grandmaster_ursine = WitcherSpells.add(WitcherSpells.grandmaster_ursine());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.learn = new Spell.Learn();
        return spell;
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell modifierSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 1;
        spell.type = Spell.Type.MODIFIER;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, true);
        spell.tooltip.description.color = class_124.field_1080.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.tooltip.name.show_in_compact = false;
        spell.tooltip.name.show_in_details = false;
        spell.tooltip.show_header = false;
        return spell;
    }

    private static Spell createModifierAlikePassiveSpell() {
        Spell spell = SpellBuilder.createSpellPassive();
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_activation = false;
        return spell;
    }

    private static Spell.Impact createEffectImpact(class_2960 effectId, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectId.toString();
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static Spell.Impact createHeal(float coefficient) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.HEAL;
        buff.action.heal = new Spell.Impact.Action.Heal();
        buff.action.heal.spell_power_coefficient = coefficient;
        return buff;
    }

    private static Spell.Impact createDamage(float coefficient, float knockback) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.DAMAGE;
        buff.action.damage = new Spell.Impact.Action.Damage();
        buff.action.damage.spell_power_coefficient = coefficient;
        buff.action.damage.knockback = knockback;
        return buff;
    }

    private static Spell.Impact.TargetModifier createImpactModifier(String entityType) {
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_type = entityType;
        Spell.Impact.TargetModifier modifier = new Spell.Impact.TargetModifier();
        modifier.conditions = List.of(condition);
        return modifier;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static Spell.Impact.TargetModifier extraDamageAard() {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#witcher_rpg:aard_vulnerable");
        Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
        powerModifier.power_multiplier = sign_vulnerability;
        modifier.modifier = powerModifier;
        return modifier;
    }

    private static Spell.Impact.TargetModifier extraDamageIgni() {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#witcher_rpg:igni_vulnerable");
        Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
        powerModifier.power_multiplier = sign_vulnerability;
        modifier.modifier = powerModifier;
        return modifier;
    }

    private static void axiiDeny(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#witcher_rpg:axii_effect_immune");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static void undeadDeny(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#minecraft:undead");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static void silverVulnerabilityAllow(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#witcher_rpg:silver_vulnerable");
        modifier.execute = TriState.ALLOW;
        impact.target_modifiers = List.of(modifier);
    }

    private static void freezeImmunityDeny(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#minecraft:freeze_immune_entity_types");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static void yrdenAllow(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = WitcherSpells.createImpactModifier("#witcher_rpg:yrden_vulnerable");
        modifier.execute = TriState.ALLOW;
        impact.target_modifiers = List.of(modifier);
    }

    private static Entry aard() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"aard");
        String title = "Aard";
        String description = "Telekinetic thrust that knocks targets back and deals {damage} sign-damage around the caster.";
        Spell spell = WitcherSpells.activeSpellBase();
        spell.school = WitcherSpellSchools.AARD;
        spell.range = 7.5f;
        spell.tier = 1;
        spell.release.animation = "witcher_rpg:sign_cast_short";
        spell.release.sound = new Sound(Sounds.AARD_SIGN_ID);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("witcher_rpg:aard_sign_cast", ParticleBatch.Shape.PIPE, ParticleBatch.Origin.CENTER, 4.0f, 0.01f, 0.1f), new ParticleBatch("more_rpg_classes:wind_vacuum", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.LAUNCH_POINT, 1.0f, 0.1f, 1.0f), new ParticleBatch("small_gust", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 30.0f, 0.25f, 0.25f)};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.angle_degrees = 90.0f;
        Spell.Impact custom = new Spell.Impact();
        custom.action = new Spell.Impact.Action();
        custom.action.custom = new Spell.Impact.Action.Custom();
        custom.action.type = Spell.Impact.Action.Type.CUSTOM;
        custom.action.custom.intent = SpellTarget.Intent.HARMFUL;
        custom.action.custom.handler = "more_rpg_classes:stop_arrows";
        Spell.Impact damage = new Spell.Impact();
        damage.target_modifiers = List.of(WitcherSpells.extraDamageAard());
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 0.75f;
        damage.action.damage.knockback = 5.0f;
        damage.particles = new ParticleBatch[]{new ParticleBatch("more_rpg_classes:wind_vacuum", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.LAUNCH_POINT, 1.0f, 0.1f, 1.0f), new ParticleBatch("gust", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 10.0f, 0.2f, 0.5f)};
        spell.impacts = List.of(damage, custom);
        WitcherSpells.configureCooldown(spell, 16.0f);
        spell.cost.exhaust = 0.4f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry yrden() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"yrden");
        String title = "Yrden";
        String description = "Slows enemies for {cloud_duration} seconds, dealing {damage} to undead entities.";
        Spell spell = WitcherSpells.activeSpellBase();
        spell.school = WitcherSpellSchools.YRDEN;
        spell.range = 0.0f;
        spell.tier = 2;
        spell.release.animation = "witcher_rpg:sign_cast_ground";
        spell.release.sound = new Sound("witcher_rpg:yrden_sign");
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("witcher_rpg:yrden_sign_cast", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 1.0f, 0.001f, 0.006f), new ParticleBatch("witcher_rpg:yrden_sign_cast", ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.CENTER, 1.0f, 0.001f, 0.006f)};
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 3.0f;
        cloud.volume.area.vertical_range_multiplier = 1.5f;
        cloud.impact_tick_interval = 10;
        cloud.time_to_live_seconds = 10.0f;
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 14;
        cloud.client_data.model = new Spell.ProjectileModel();
        cloud.client_data.model.model_id = "witcher_rpg:effect/yrden_circle";
        cloud.client_data.model.scale = 3.0f;
        cloud.client_data.model.rotate_degrees_per_tick = 0.0f;
        cloud.client_data.model.light_emission = LightEmission.RADIATE;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.ground_glow.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).scale(3.25f).color(Color.ARCANE.alpha(0.25f).toRGBA())};
        cloud.placement.force_onto_ground = true;
        cloud.placement.location_offset_y = 0.0f;
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact debuff = SpellBuilder.Impacts.effectSet((String)WitcherStatusEffects.YRDEN_CIRCLE.id.toString(), (float)1.0f, (int)0);
        debuff.particles = new ParticleBatch[]{new ParticleBatch("witcher_rpg:yrden_cloud", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 2.0f, 0.05f, 0.2f)};
        debuff.action.status_effect.amplifier_power_multiplier = 0.3f;
        debuff.sound = Sound.withRandomness((class_2960)class_2960.method_60654((String)"witcher_rpg:yrden_sign"), (float)0.2f);
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.1f, (float)0.0f);
        WitcherSpells.yrdenAllow(damage);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.1f, 0.3f).extent(0.5f).color(Color.ARCANE.toRGBA())};
        spell.impacts = List.of(debuff, damage);
        WitcherSpells.configureCooldown(spell, 18.0f);
        spell.cost.exhaust = 0.4f;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry yrden_glyph_impact() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"yrden_glyph_impact");
        Spell spell = WitcherSpells.activeSpellBase();
        String title = "Yrden Glyph Impact";
        String description = "The yrden glyph deals {damage} damage and slows nearby targets by {effect_duration} sec.";
        spell.school = WitcherSpellSchools.YRDEN;
        spell.range = 100.0f;
        spell.tier = 1;
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        Spell.Impact debuff = SpellBuilder.Impacts.effectSet((String)WitcherStatusEffects.YRDEN_GLYPH.id.toString(), (float)6.0f, (int)0);
        debuff.action.status_effect.amplifier_power_multiplier = 0.1f;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.75f, (float)0.1f);
        spell.impacts = List.of(damage, debuff);
        WitcherSpells.configureCooldown(spell, 1.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry quen_active_helper() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"quen_active_helper");
        String description = "Quen Active Helper Impact";
        Effects.Entry effect = WitcherStatusEffects.QUEN_ACTIVE;
        String title = "Quen Active Helper Impact";
        Spell spell = SpellBuilder.createSpellActive();
        spell.tier = 0;
        spell.school = WitcherSpellSchools.QUEN;
        Spell.Impact buff = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)20.0f, (int)0);
        buff.action.status_effect.amplifier_power_multiplier = 0.2f;
        spell.impacts = List.of(buff);
        WitcherSpells.configureCooldown(spell, 0.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry defensive_witcher_mechanics() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"defensive_witcher_mechanics");
        Effects.Entry effect = WitcherStatusEffects.WITCHER_REFLEXES;
        String description = "Sharpens your reflexes for {effect_duration} sec, blocking {effect_amplifier} arrow or melee impacts.";
        Spell spell = SpellBuilder.createSpellActive();
        spell.tier = 1;
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        String title = effect.title;
        spell.target.type = Spell.Target.Type.CASTER;
        Spell.Impact buff = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)10.0f, (int)0);
        buff.action.status_effect.amplifier_cap = 2;
        buff.action.status_effect.amplifier_power_multiplier = 0.15f;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        WitcherSpells.configureCooldown(spell, 15.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_aard_glyph() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"greater_aard_glyph");
        String title = "Greater Aard Glyph";
        String description = "Increases critical chance of Aard Signs by {critical_chance_bonus}";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.AARD;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.critical_chance_bonus = 0.05f;
        Spell.Modifier.ImpactFilter impactfilter = new Spell.Modifier.ImpactFilter();
        impactfilter.type = Spell.Impact.Action.Type.DAMAGE;
        impactfilter.school = WitcherSpellSchools.AARD;
        modifier.impact_filters = List.of(impactfilter);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_axii_glyph() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"greater_axii_glyph");
        String title = "Greater Axii Glyph";
        String description = "Increases duration of Axii Sign Effects by {effect_duration_add} sec";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.AXII;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.effect_duration_add = 2.0f;
        Spell.Modifier.ImpactFilter impactfilter = new Spell.Modifier.ImpactFilter();
        impactfilter.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impactfilter.school = WitcherSpellSchools.AXII;
        modifier.impact_filters = List.of(impactfilter);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_igni_glyph() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"greater_igni_glyph");
        String title = "Greater Igni Glyph";
        String description = "Increases critical damage of Igni Signs by {critical_damage_bonus}";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.IGNI;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.critical_damage_bonus = 0.1f;
        Spell.Modifier.ImpactFilter impactfilter = new Spell.Modifier.ImpactFilter();
        impactfilter.type = Spell.Impact.Action.Type.DAMAGE;
        impactfilter.school = WitcherSpellSchools.IGNI;
        modifier.impact_filters = List.of(impactfilter);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_quen_glyph() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"greater_quen_glyph");
        String title = "Greater Quen Glyph";
        String description = "Quen Signs get {power_multiplier} more power bonus.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.QUEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.power_multiplier = 0.15f;
        Spell.Modifier.ImpactFilter impactfilter = new Spell.Modifier.ImpactFilter();
        impactfilter.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impactfilter.school = WitcherSpellSchools.QUEN;
        modifier.impact_filters = List.of(impactfilter);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_yrden_glyph() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"greater_yrden_glyph");
        String title = "Greater Yrden Glyph";
        String description = "Increases the duration Yrden Signs by {spawn_duration_add} sec.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.YRDEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spawn_duration_add = 2.0f;
        Spell.Modifier.ImpactFilter impactfilter_spawn = new Spell.Modifier.ImpactFilter();
        impactfilter_spawn.school = WitcherSpellSchools.YRDEN;
        modifier.impact_filters = List.of(impactfilter_spawn);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry improved_whirl() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"improved_whirl");
        String title = "Improved Whirl";
        String description = "Reduces cooldown of Whirl by {cooldown_duration_deduct} sec";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:whirl";
        modifier.cooldown_duration_deduct = 3.0f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry improved_yrden() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"improved_yrden");
        String title = "Improved Yrden";
        String description = "Reduces cooldown of the Yrden Sign by {cooldown_duration_deduct} sec";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.YRDEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:yrden";
        modifier.cooldown_duration_deduct = 2.0f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry improved_aard() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"improved_aard");
        String title = "Improved Aard";
        String description = "Reduces cooldown of the Aard Sign by {cooldown_duration_deduct} sec";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.AARD;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:aard";
        modifier.cooldown_duration_deduct = 2.0f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry improved_rend() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"improved_rend");
        String title = "Improved Rend";
        String description = "Increases critical chance of Rend by {critical_chance_bonus}";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:rend";
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.critical_chance_bonus = 0.05f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry aard_far_reach() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"aard_far_reach");
        String title = "Far-Reaching Aard";
        String description = "Increases the range of Aard Signs by {range_add_1}.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.AARD;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:aard";
        modifier.range_add = 2.0f;
        Spell.Modifier modifier2 = new Spell.Modifier();
        modifier2.spell_pattern = "witcher_rpg:aard_sweep";
        modifier2.range_add = 2.0f;
        spell.modifiers = List.of(modifier, modifier2);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry aard_shockwave() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"aard_shockwave");
        String title = "Shockwave";
        String description = "Aard impacts now have a {trigger_chance} chance to stun the target.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.AARD;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellHit((float)0.15f, (String)WitcherSpellSchools.AARD.id.toString());
        spell.passive.triggers = List.of(trigger);
        Spell.Impact stun = SpellBuilder.Impacts.effectSet((String)SpellEngineEffects.STUN.id.toString(), (float)3.0f, (int)0);
        spell.impacts = List.of(stun);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)0.5f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry aard_frostbite() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"aard_frostbite");
        String title = "Frostbite";
        String description = "Aard impacts now deals additional frost {damage} damage and has {impact_chance} chance to freeze the target.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = SpellSchools.FROST;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellHit((float)1.0f, (String)WitcherSpellSchools.AARD.id.toString());
        spell.passive.triggers = List.of(trigger);
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.5f, (float)0.0f);
        damage.attribute = WitcherAttributes.AARD_INTENSITY.method_55840();
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, 30.0f, 0.4f, 0.4f), new ParticleBatch(SpellEngineParticles.frost_shard.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.4f, 0.6f)};
        Spell.Impact freeze = SpellBuilder.Impacts.effectSet((String)MRPGCEffects.FROSTED.id.toString(), (float)3.0f, (int)0);
        freeze.chance = 0.2f;
        spell.impacts = List.of(freeze);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)0.5f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry axii_lethargy() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"axii_lethargy");
        String title = "Lethargy";
        String description = "Axii signs inflict Lethargy slowing the target by {bonus}.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.AXII;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.STATUS_EFFECT.toString();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.school = WitcherSpellSchools.AXII.id.toString();
        spell.passive.triggers = List.of(trigger);
        Spell.Impact debuff = SpellBuilder.Impacts.effectSet((String)WitcherStatusEffects.AXII_LETHARGY.id.toString(), (float)10.0f, (int)0);
        debuff.action.status_effect.amplifier_cap = 5;
        debuff.action.status_effect.amplifier_power_multiplier = 0.15f;
        spell.impacts = List.of(debuff);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)0.5f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry axii_link() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"axii_link");
        String title = "Link";
        String description = "{trigger_chance} chance that the Axii sign spreads around the target.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.AXII;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.STATUS_EFFECT.toString();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.chance = 0.25f;
        trigger.spell.id = "witcher_rpg:axii";
        spell.passive.triggers = List.of(trigger);
        Spell.Impact impact = SpellBuilder.Impacts.effectSet((String)WitcherStatusEffects.AXII.id.toString(), (float)3.0f, (int)0);
        impact.action.status_effect.amplifier_power_multiplier = 0.15f;
        impact.action.allow_on_center_target = false;
        spell.impacts = List.of(impact);
        Spell.AreaImpact area_impact = new Spell.AreaImpact();
        area_impact.radius = 2.0f;
        area_impact.extra_radius = new Spell.AreaImpact.ExtraRadius();
        area_impact.extra_radius.power_coefficient = 0.1f;
        area_impact.area = new Spell.Target.Area();
        area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.area_impact = area_impact;
        SpellBuilder.Cost.cooldown((Spell)spell, (float)5.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry axii_domination() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"axii_domination");
        String title = "Domination";
        String description = "";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.AXII;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.STATUS_EFFECT.toString();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.id = "witcher_rpg:axii";
        spell.passive.triggers = List.of(trigger);
        Spell.Impact impact = SpellBuilder.Impacts.effectSet((String)WitcherStatusEffects.AXII.id.toString(), (float)3.0f, (int)0);
        impact.action.status_effect.amplifier_power_multiplier = 0.15f;
        impact.action.allow_on_center_target = false;
        spell.impacts = List.of(impact);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)5.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry igni_melt_armor() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"igni_melt_armor");
        String title = "Molten Armor";
        String description = "Igni impacts now have a {trigger_chance} chance to stun the target.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.IGNI;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellHit((float)1.0f, (String)WitcherSpellSchools.IGNI.id.toString());
        spell.passive.triggers = List.of(trigger);
        Spell.Impact debuff = SpellBuilder.Impacts.effectAdd((String)MRPGCEffects.MOLTEN_ARMOR.id.toString(), (float)4.0f, (int)1, (int)5);
        debuff.action.status_effect.amplifier_cap_power_multiplier = 0.15f;
        spell.impacts = List.of(debuff);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)0.5f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry igni_combustion() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"igni_combustion");
        String title = "Combustion";
        String description = "Igni impacts on burning targets spread fire around them.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.IGNI;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellHit((float)1.0f, (String)WitcherSpellSchools.IGNI.id.toString());
        trigger.target_conditions = List.of(SpellBuilder.TargetConditions.ofPredicate((SpellEntityPredicates.Entry)SpellEntityPredicates.IS_ON_FIRE));
        spell.passive.triggers = List.of(trigger);
        Spell.Impact impact = SpellBuilder.Impacts.fire((float)3.0f);
        impact.action.allow_on_center_target = false;
        spell.impacts = List.of(impact);
        Spell.AreaImpact area_impact = new Spell.AreaImpact();
        area_impact.radius = 3.0f;
        area_impact.area = new Spell.Target.Area();
        area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 30.0f, 0.5f, 0.5f)};
        area_impact.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IGNITE.id().toString());
        spell.area_impact = area_impact;
        SpellBuilder.Cost.cooldown((Spell)spell, (float)5.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry igni_pyromaniac() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"igni_pyromaniac");
        String title = "Pyromaniac";
        String description = "Increases the critical damage of Igni Signs by {critical_damage_bonus_1}.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.IGNI;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:igni";
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.critical_damage_bonus = 0.2f;
        Spell.Modifier modifier2 = new Spell.Modifier();
        modifier2.spell_pattern = "witcher_rpg:igni_firestream";
        modifier2.power_modifier = new Spell.Impact.Modifier();
        modifier2.power_modifier.critical_damage_bonus = 0.2f;
        spell.modifiers = List.of(modifier, modifier2);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry quen_exploding_shield() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"quen_exploding_shield");
        Effects.Entry effect = WitcherStatusEffects.QUEN_EXPLOSIVE;
        String title = effect.title;
        String description = "Quen shields now knock back attackers.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.QUEN;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellCast((SpellSchool)WitcherSpellSchools.QUEN);
        spell.passive.triggers = List.of(trigger);
        Spell.Trigger stashTrigger = SpellBuilder.Triggers.damageTaken();
        SpellBuilder.Deliver.stash((Spell)spell, (String)effect.id.toString(), (float)20.0f, (Spell.Trigger)stashTrigger);
        spell.deliver.stash_effect.consume = 0;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.0f, (float)1.5f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.electric_arc_A.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.15f, 0.2f)};
        damage.sound = new Sound("");
        spell.impacts = List.of(damage);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)1.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry quen_warding_shield() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"quen_warding_shield");
        String title = "Warding Shield";
        String description = "The Quen Signs stays up longer for {effect_duration_add} sec.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.QUEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:quen";
        modifier.effect_duration_add = 4.0f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry quen_discharge() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"quen_discharge");
        Effects.Entry effect = WitcherStatusEffects.QUEN_DISCHARGE;
        String title = effect.title;
        String description = "Quen shields now reflect {damage} to the attacker.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        spell.school = WitcherSpellSchools.QUEN;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellCast((SpellSchool)WitcherSpellSchools.QUEN);
        spell.passive.triggers = List.of(trigger);
        Spell.Trigger stashTrigger = SpellBuilder.Triggers.damageTaken();
        SpellBuilder.Deliver.stash((Spell)spell, (String)effect.id.toString(), (float)20.0f, (Spell.Trigger)stashTrigger);
        spell.deliver.stash_effect.consume = 0;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.25f, (float)0.1f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.electric_arc_A.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.15f, 0.2f)};
        damage.sound = new Sound("");
        spell.impacts = List.of(damage);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)1.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry yrden_sustained_glyphs() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"yrden_sustained_glyphs");
        String title = "Sustained Glyphs";
        String description = "Increases Yrden Signs duration by {spawn_duration_add} sec.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.YRDEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spawn_duration_add = 2.0f;
        Spell.Modifier.ImpactFilter impactfilter_spawn = new Spell.Modifier.ImpactFilter();
        impactfilter_spawn.school = WitcherSpellSchools.YRDEN;
        modifier.impact_filters = List.of(impactfilter_spawn);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry yrden_binding_glyphs() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"yrden_binding_glyphs");
        String title = "Binding Glyphs";
        String description = "The power of yrden signs is increased by {power_multiplier}.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.YRDEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.power_multiplier = 0.15f;
        Spell.Modifier.ImpactFilter impactfilter_spawn = new Spell.Modifier.ImpactFilter();
        impactfilter_spawn.school = WitcherSpellSchools.YRDEN;
        modifier.impact_filters = List.of(impactfilter_spawn);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry yrden_supercharged_glyphs() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"yrden_supercharged_glyphs");
        String title = "Super Charged Glyphs";
        String description = "The Yrden circle now deals {damage} damage to all entities.";
        Spell spell = SpellBuilder.createSpellModifier();
        spell.school = WitcherSpellSchools.YRDEN;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:yrden";
        Spell.Impact impact = SpellBuilder.Impacts.damage((float)0.2f, (float)0.0f);
        modifier.mutate_impacts = Spell.Modifier.ImpactListModifier.PREPEND;
        modifier.impacts = List.of(impact);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry muscle_memory() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"muscle_memory");
        Effects.Entry effect = WitcherStatusEffects.MUSCLE_MEMORY;
        String description = "Increasing melee attack speed by {bonus}, stacking up to {effect_amplifier_cap} times, lasting for {effect_duration} seconds.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell.Trigger passiveMeleeTrigger = new Spell.Trigger();
        passiveMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.passive.triggers = List.of(passiveMeleeTrigger);
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashMeleeTrigger = new Spell.Trigger();
        stashMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        stashMeleeTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.deliver.stash_effect.triggers = List.of(stashMeleeTrigger);
        Spell.Impact buff = SpellBuilder.Impacts.effectAdd((String)effect.id.toString(), (float)10.0f, (int)1, (int)5);
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        WitcherSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry whirl_boost_a() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"whirl_boost_a");
        String title = "Slicing Whirl";
        String description = "Increases the power of Whirl by {power_multiplier}";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:whirl";
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.power_multiplier = 0.25f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry strength_training() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"strength_training");
        Effects.Entry effect = WitcherStatusEffects.STRENGTH_TRAINING;
        String description = "Increasing melee attack damage by {bonus}, stacking up to {effect_amplifier_cap} times, lasting for {effect_duration} seconds.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell.Trigger passiveMeleeTrigger = new Spell.Trigger();
        passiveMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.passive.triggers = List.of(passiveMeleeTrigger);
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashMeleeTrigger = new Spell.Trigger();
        stashMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        stashMeleeTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.deliver.stash_effect.triggers = List.of(stashMeleeTrigger);
        Spell.Impact buff = SpellBuilder.Impacts.effectAdd((String)effect.id.toString(), (float)10.0f, (int)1, (int)5);
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        WitcherSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry rend_boost_a() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"rend_boost_a");
        String title = "Slashing Rend";
        String description = "Increases the power of Rend by {power_multiplier}";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:rend";
        modifier.power_modifier = new Spell.Impact.Modifier();
        modifier.power_modifier.power_multiplier = 0.3f;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry witcher_reflexes_boost_a() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"witcher_reflexes_boost_a");
        String title = "Superhuman Reflexes";
        String description = "Increases the amount of Blocks by {effect_amplifier_add} for Witcher Reflexes.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:defensive_witcher_mechanics";
        modifier.effect_amplifier_add = 2;
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry arrow_deflection() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"arrow_deflection");
        Effects.Entry effect = WitcherStatusEffects.ARROW_DEFLECTION;
        String title = "Arrow Deflection";
        String description = "While blocking Arrows with Witcher Reflexes, you send the Arrow back to the shooter.";
        Spell spell = WitcherSpells.modifierSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:defensive_witcher_mechanics";
        Spell.Impact impact = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)20.0f, (int)0);
        impact.action.status_effect.amplifier_power_multiplier = 0.15f;
        modifier.mutate_impacts = Spell.Modifier.ImpactListModifier.APPEND;
        modifier.impacts = List.of(impact);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry counterattack() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"counterattack");
        Effects.Entry effect = WitcherStatusEffects.COUNTERATTACK;
        String title = effect.title;
        String description = "After blocking, with your next melee attack you have {bonus} attack damage.";
        Spell spell = WitcherSpells.createModifierAlikePassiveSpell();
        SpellTooltip.DescriptionMutator mutator = args -> {
            String bonus = SpellTooltip.percent((float)effect.config().firstModifier().value);
            return args.description().replace("{bonus}", bonus);
        };
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.shieldBlock();
        spell.passive.triggers = List.of(trigger);
        Spell.Impact impact = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)15.0f, (int)0);
        impact.action.status_effect.amplifier_power_multiplier = 0.15f;
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry griffin_school_technique() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"griffin_school_technique");
        String title = "Griffin School Technique";
        String description = "Casting Signs halves the active cooldowns of all signs.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.SIGN;
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellCast();
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact aard = new Spell.Impact();
        aard.action = new Spell.Impact.Action();
        aard.action.type = Spell.Impact.Action.Type.COOLDOWN;
        aard.action.cooldown = new Spell.Impact.Action.Cooldown();
        aard.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        aard.action.cooldown.actives.school = WitcherSpellSchools.AARD.id.toString();
        aard.action.cooldown.actives.duration_multiplier = 0.5f;
        Spell.Impact axii = new Spell.Impact();
        axii.action = new Spell.Impact.Action();
        axii.action.type = Spell.Impact.Action.Type.COOLDOWN;
        axii.action.cooldown = new Spell.Impact.Action.Cooldown();
        axii.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        axii.action.cooldown.actives.school = WitcherSpellSchools.AXII.id.toString();
        axii.action.cooldown.actives.duration_multiplier = 0.5f;
        Spell.Impact igni = new Spell.Impact();
        igni.action = new Spell.Impact.Action();
        igni.action.type = Spell.Impact.Action.Type.COOLDOWN;
        igni.action.cooldown = new Spell.Impact.Action.Cooldown();
        igni.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        igni.action.cooldown.actives.school = WitcherSpellSchools.IGNI.id.toString();
        igni.action.cooldown.actives.duration_multiplier = 0.5f;
        Spell.Impact quen = new Spell.Impact();
        quen.action = new Spell.Impact.Action();
        quen.action.type = Spell.Impact.Action.Type.COOLDOWN;
        quen.action.cooldown = new Spell.Impact.Action.Cooldown();
        quen.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        quen.action.cooldown.actives.school = WitcherSpellSchools.QUEN.id.toString();
        quen.action.cooldown.actives.duration_multiplier = 0.5f;
        Spell.Impact yrden = new Spell.Impact();
        yrden.action = new Spell.Impact.Action();
        yrden.action.type = Spell.Impact.Action.Type.COOLDOWN;
        yrden.action.cooldown = new Spell.Impact.Action.Cooldown();
        yrden.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        yrden.action.cooldown.actives.school = WitcherSpellSchools.YRDEN.id.toString();
        yrden.action.cooldown.actives.duration_multiplier = 0.5f;
        Spell.Impact sign = new Spell.Impact();
        sign.action = new Spell.Impact.Action();
        sign.action.type = Spell.Impact.Action.Type.COOLDOWN;
        sign.action.cooldown = new Spell.Impact.Action.Cooldown();
        sign.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        sign.action.cooldown.actives.school = WitcherSpellSchools.SIGN.id.toString();
        sign.action.cooldown.actives.duration_multiplier = 0.5f;
        spell.impacts = List.of(aard, axii, igni);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)45.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry cat_school_technique() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"cat_school_technique");
        String title = "Cat School Technique";
        String description = "Hitting targets with bad effects inflicts extra damage, dealing more damage the less health the target has.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        spell.range = 0.0f;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        Spell.Trigger trigger = SpellBuilder.Triggers.meleeAttack((boolean)false);
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_predicate_id = SpellEntityPredicates.HAS_BAD_EFFECT.id().toString();
        trigger.target_conditions = List.of(condition);
        spell.passive.triggers = List.of(trigger);
        Spell.Impact custom = new Spell.Impact();
        custom.action = new Spell.Impact.Action();
        custom.action.custom = new Spell.Impact.Action.Custom();
        custom.action.type = Spell.Impact.Action.Type.CUSTOM;
        custom.action.custom.intent = SpellTarget.Intent.HARMFUL;
        custom.action.custom.handler = "more_rpg_classes:damage_according_to_missing_health";
        custom.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.dripping_blood.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 35.0f, 0.4f, 1.0f), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.2f, 0.5f).color(Color.RED.toRGBA())};
        spell.impacts = List.of(custom);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)45.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry bear_school_technique() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"bear_school_technique");
        String title = "Bear School Technique";
        Effects.Entry effect = WitcherStatusEffects.BEAR_SCHOOL_MEDALLION;
        String description = "Taking Damage reduces incoming damage by {bonus} for {effect_duration} secs.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = (AttributeModifier)effect.config().attributes().get(0);
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact buff = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)5.0f, (int)0);
        spell.impacts = List.of(buff);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry wolf_school_technique() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"wolf_school_technique");
        String title = "Wolf School Technique";
        Effects.Entry effect = WitcherStatusEffects.WOLF_SCHOOL_MEDALLION;
        String description = "After casting a sign, you deal {damage} magical damage per melee attack for {stash_duration} sec.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.SIGN;
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellCast();
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Trigger trigger_stash_damage_taken = new Spell.Trigger();
        trigger_stash_damage_taken.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.duration = 8.0f;
        spell.deliver.stash_effect.amplifier = 0;
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        spell.deliver.stash_effect.triggers = List.of(trigger_stash_damage_taken);
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.15f, (float)0.0f);
        damage.attribute = "minecraft:generic.attack_damage";
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.1f, 0.2f).color(Color.ELECTRIC.toRGBA())};
        spell.impacts = List.of(damage);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)45.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry rose_of_remembrance() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"rose_of_remembrance");
        Effects.Entry effect = WitcherStatusEffects.ROSE_OF_REMEMBRANCE;
        String title = "Rose of Remembrance";
        String description = "On taking damage: {trigger_chance} chance, to heal yourself for 5%% of your max health for {effect_duration} seconds..";
        Spell spell = WitcherSpells.passiveSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Trigger trigger_damage_taken = new Spell.Trigger();
        trigger_damage_taken.chance = 0.15f;
        trigger_damage_taken.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger_damage_taken.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger_damage_taken);
        Spell.Impact debuff = WitcherSpells.createEffectImpact(class_2960.method_60654((String)effect.id.toString()), 10.0f);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        debuff.action.status_effect.amplifier = 1;
        debuff.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_3.id());
        debuff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(debuff);
        WitcherSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry sunstone() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"sunstone");
        String description = "Use: Increases sign intensity by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = WitcherStatusEffects.SUNSTONE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.school = WitcherSpellSchools.SIGN;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.6f).color(Color.WHITE.toRGBA())};
        spell.impacts = List.of(WitcherSpells.createEffectImpact(class_2960.method_60654((String)effect.id.toString()), 15.0f));
        WitcherSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry crystal_skull() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"crystal_skull");
        String description = "On melee hit: {trigger_chance} to shoot crystal shards, dealing {damage} to enemies.";
        String title = "Crystal Skull";
        Spell spell = WitcherSpells.passiveSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        spell.range = 16.0f;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.melee = new Spell.Trigger.MeleeCondition();
        trigger.chance = 0.2f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.inherit_shooter_pitch = false;
        spell.deliver.projectile.launch_properties.velocity = 1.25f;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 0.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "witcher_rpg:projectile/crystal_skull";
        projectile.perks.pierce = 999;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 0.2f;
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.1f, 0.3f, 0.0f, 0.0f).color(Color.GREEN.toRGBA())};
        spell.impacts = List.of(damage);
        WitcherSpells.configureCooldown(spell, 5.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry pure_silver() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"pure_silver");
        String description = "On melee hit: Sets silver vulnerable targets on fire.";
        String title = "Pure Silver";
        Spell spell = WitcherSpells.passiveSpellBase();
        spell.school = WitcherSpellSchools.WITCHER_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.melee = new Spell.Trigger.MeleeCondition();
        trigger.chance = 1.0f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact fire = SpellBuilder.Impacts.fire((float)3.0f);
        WitcherSpells.silverVulnerabilityAllow(fire);
        fire.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.1f, 0.3f, 0.0f, 0.0f).color(Color.WHITE.toRGBA())};
        spell.impacts = List.of(fire);
        WitcherSpells.configureCooldown(spell, 1.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry grandmaster_feline() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"grandmaster_feline");
        Effects.Entry effect = WitcherStatusEffects.FELINE_INJURY_MASTER;
        String title = "Grandmaster Feline Technique";
        String description = "Fencing Spells and melee hits inflict injuries if the target has a bad effect, increasing incoming damage and reducing movement speed by {bonus} {effect_duration} sec.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = (AttributeModifier)effect.config().attributes().get(0);
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.AARD;
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.id = "#witcher_rpg:fencing";
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_predicate_id = SpellEntityPredicates.HAS_BAD_EFFECT.id().toString();
        trigger.target_conditions = List.of(condition);
        Spell.Trigger trigger2 = SpellBuilder.Triggers.meleeAttack((boolean)false);
        Spell.TargetCondition condition2 = new Spell.TargetCondition();
        condition2.entity_predicate_id = SpellEntityPredicates.HAS_BAD_EFFECT.id().toString();
        trigger2.target_conditions = List.of(condition2);
        spell.passive.triggers = List.of(trigger, trigger2);
        Spell.Impact debuff = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)5.0f, (int)0);
        spell.impacts = List.of(debuff);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)20.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry grandmaster_griffin() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"grandmaster_griffin");
        String title = "Grandmaster Griffin Technique";
        Effects.Entry effect = WitcherStatusEffects.YRDEN_GRIFFIN_MASTER;
        String description = "The Yrden circle increases the sign intensity of the caster by {bonus2} & reduces incoming damage by {bonus}.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = (AttributeModifier)effect.config().attributes().get(1);
            AttributeModifier modifier2 = (AttributeModifier)effect.config().attributes().get(0);
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            String bonus2 = SpellTooltip.bonus((float)modifier2.value, (class_1322.class_1323)modifier2.operation);
            return args.description().replace("{bonus}", bonus).replace("{bonus2}", bonus2);
        };
        Spell spell = SpellBuilder.createSpellModifier();
        spell.school = WitcherSpellSchools.YRDEN;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        Spell.Modifier modifier = new Spell.Modifier();
        modifier.spell_pattern = "witcher_rpg:yrden";
        Spell.Impact impact = SpellBuilder.Impacts.effectSet((String)effect.id.toString(), (float)2.0f, (int)0);
        impact.action.apply_to_caster = true;
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.GROUND, 20.0f, 0.2f, 0.2f).extent(1.0f).color(Color.ARCANE.toRGBA())};
        modifier.mutate_impacts = Spell.Modifier.ImpactListModifier.APPEND;
        modifier.impacts = List.of(impact);
        spell.modifiers = List.of(modifier);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry grandmaster_wolven() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"grandmaster_wolven");
        String title = "Grandmaster Wolven Technique";
        String description = "Targets in the yrden circle, receive extra {damage} damage with aard signs.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.AARD;
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellHit((float)1.0f, (String)"aard");
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_predicate_id = HAS_YRDEN.id().toString();
        trigger.target_conditions = List.of(condition);
        spell.passive.triggers = List.of(trigger);
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)1.0f, (float)0.0f);
        spell.impacts = List.of(damage);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)1.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry grandmaster_ursine() {
        class_2960 id = class_2960.method_60655((String)"witcher_rpg", (String)"grandmaster_ursine");
        String title = "Grandmaster Ursine Technique";
        String description = "Taking Damage has {trigger_chance} chance to apply a quen shield.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.school = WitcherSpellSchools.QUEN;
        spell.range = 0.0f;
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger.chance = 0.2f;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact effect = SpellBuilder.Impacts.effectSet((String)WitcherStatusEffects.QUEN_SHIELD.id.toString(), (float)10.0f, (int)0);
        effect.action.status_effect.amplifier_power_multiplier = 0.3f;
        spell.impacts = List.of(effect);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)60.0f);
        return new Entry(id, spell, title, description, null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

