/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.SpellBooks;
import net.witcher_rpg.WitcherClassMod;
import net.witcher_rpg.item.WitcherArmorDiagrams;
import net.witcher_rpg.item.WitcherGroup;
import net.witcher_rpg.item.misc.MasterSpellBook;
import net.witcher_rpg.item.misc.UpgradeItem;

public class WitcherMaterials {
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static final Entry SILVER_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"silver_ingot"), Item::new, new Item.Properties()));
    public static final Entry SILVER_NUGGET = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"silver_nugget"), Item::new, new Item.Properties()));
    public static final Entry METEORITE_SILVER_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"meteorite_silver_ingot"), Item::new, new Item.Properties()));
    public static final Entry DARK_STEEL_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"dark_steel_ingot"), Item::new, new Item.Properties()));
    public static final Entry STEEL_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"steel_ingot"), Item::new, new Item.Properties()));
    public static final Entry STEEL_NUGGET = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"steel_nugget"), Item::new, new Item.Properties()));
    public static final Entry RAW_SILVER = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"raw_silver"), Item::new, new Item.Properties()));
    public static final Entry METEORITE = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"meteorite"), Item::new, new Item.Properties()));
    public static final Entry METEORITE_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"meteorite_ingot"), Item::new, new Item.Properties()));
    public static final Entry DARK_IRON_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"dark_iron_ingot"), Item::new, new Item.Properties()));
    public static final Entry RAW_DARK_IRON = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"raw_dark_iron"), Item::new, new Item.Properties()));
    public static final Entry DIMERITIUM_INGOT = WitcherMaterials.add(new Entry(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"dimeritium_ingot"), settings -> new UpgradeItem((Item.Properties)settings, "item.witcher_rpg.dimeritium_ingot.applies_to"), new Item.Properties()));
    public static final MasterSpellBook MASTER_BOOK = new MasterSpellBook(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"master_spell_book"), new Item.Properties().stacksTo(1));

    public static Entry add(Entry entry) {
        ENTRIES.add(entry);
        return entry;
    }

    public static void registerModItems() {
        for (Entry e : ENTRIES) {
            Item item;
            e.container.item = item = e.factory().apply(e.settings());
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)e.id(), (Object)item);
        }
        List<String> books = List.of("base_signs", "fencing");
        for (String name : books) {
            SpellBooks.createAndRegister((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)name), WitcherGroup.WITCHER_KEY);
        }
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"master_spell_book"), (Object)((Object)MASTER_BOOK));
        ItemGroupEvents.modifyEntriesEvent(WitcherGroup.WITCHER_KEY).register(content -> {
            for (Entry e : ENTRIES) {
                content.accept((ItemLike)e.item());
            }
            content.accept((ItemLike)MASTER_BOOK);
        });
        WitcherArmorDiagrams.register();
        WitcherClassMod.LOGGER.info("Registered Witcher Items");
    }

    public record Entry(ResourceLocation id, Function<Item.Properties, Item> factory, Item.Properties settings, Container container) {
        public Entry(ResourceLocation id, Function<Item.Properties, Item> factory, Item.Properties settings) {
            this(id, factory, settings, new Container());
        }

        public Item item() {
            return this.container.item;
        }
    }

    public static class Container {
        Item item;
    }
}

