/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_power.api.SpellPowerMechanics;
import net.witcher_rpg.config.TrinketConfig;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import net.witcher_rpg.item.WitcherGroup;
import net.witcher_rpg.spell.SetBonuses;
import org.jetbrains.annotations.Nullable;

public class WitcherTrinkets {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Function<ItemArgs, Item> factory = args -> {
        Item.Properties settings = args.settings;
        if (args.attributes != null) {
            settings.attributes(args.attributes);
        }
        return new Item(settings);
    };
    public static float medallion_sign_intensity = 0.1f;
    public static float medallion_attack_damage = 0.12f;
    public static float medallion_haste = 0.05f;
    public static float medallion_adrenaline = 0.1f;
    public static float medallion_health = 4.0f;
    public static float lesser_glyph_power = 1.0f;
    public static float glyph_power = 1.5f;
    public static float greater_glyph_power = 2.0f;
    public static final Entry BEAR_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "bear_school_medallion", "Bear School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.MAX_HEALTH.getRegisteredName(), medallion_health, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), medallion_attack_damage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.getRegisteredName(), medallion_adrenaline, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_ursine.id());
    public static final Entry CAT_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "cat_school_medallion", "Cat School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), medallion_haste, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), medallion_attack_damage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.getRegisteredName(), medallion_adrenaline, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_feline.id());
    public static final Entry GRIFFIN_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "griffin_school_medallion", "Griffin School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), medallion_sign_intensity, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellPowerMechanics.HASTE.id, medallion_haste, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.getRegisteredName(), medallion_adrenaline, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_griffin.id());
    public static final Entry WOLF_SCHOOL_MEDALLION = WitcherTrinkets.add(new Entry(10, "wolf_school_medallion", "Wolf School Medallion")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.SIGN_INTENSITY.getRegisteredName(), medallion_sign_intensity, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), medallion_attack_damage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(WitcherAttributes.ADRENALINE_MODIFIER.getRegisteredName(), medallion_adrenaline, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).component(SpellDataComponents.EQUIPMENT_SET, SetBonuses.grandmaster_wolven.id());
    public static final Entry LESSER_AARD_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_aard_glyph", "Lesser Aard Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.getRegisteredName(), lesser_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry LESSER_AXII_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_axii_glyph", "Lesser Axii Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.getRegisteredName(), lesser_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry LESSER_IGNI_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_igni_glyph", "Lesser Igni Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.getRegisteredName(), lesser_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry LESSER_QUEN_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_quen_glyph", "Lesser Quen Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.getRegisteredName(), lesser_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry LESSER_YRDEN_GLYPH = WitcherTrinkets.add(new Entry(10, "lesser_yrden_glyph", "Lesser Yrden Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.getRegisteredName(), lesser_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry AARD_GLYPH = WitcherTrinkets.add(new Entry(10, "aard_glyph", "Aard Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.getRegisteredName(), glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry AXII_GLYPH = WitcherTrinkets.add(new Entry(10, "axii_glyph", "Axii Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.getRegisteredName(), glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry IGNI_GLYPH = WitcherTrinkets.add(new Entry(10, "igni_glyph", "Igni Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.getRegisteredName(), glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry QUEN_GLYPH = WitcherTrinkets.add(new Entry(10, "quen_glyph", "Quen Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.getRegisteredName(), glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry YRDEN_GLYPH = WitcherTrinkets.add(new Entry(10, "yrden_glyph", "Yrden Glyph")).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.getRegisteredName(), glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry GREATER_AARD_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_aard_glyph", "Greater Aard Glyph")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:greater_aard_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AARD_INTENSITY.getRegisteredName(), greater_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry GREATER_AXII_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_axii_glyph", "Greater Axii Glyph")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:greater_axii_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.AXII_INTENSITY.getRegisteredName(), greater_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry GREATER_IGNI_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_igni_glyph", "Greater Igni Glyph")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:greater_igni_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.IGNI_INTENSITY.getRegisteredName(), greater_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry GREATER_QUEN_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_quen_glyph", "Greater Quen Glyph")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:greater_quen_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.QUEN_INTENSITY.getRegisteredName(), greater_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry GREATER_YRDEN_GLYPH = WitcherTrinkets.add(new Entry(10, "greater_yrden_glyph", "Greater Yrden Glyph")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:greater_yrden_glyph"))).config(new TrinketConfig.Entry().withAttributes(List.of(new AttributeModifier(WitcherAttributes.YRDEN_INTENSITY.getRegisteredName(), greater_glyph_power, AttributeModifier.Operation.ADD_VALUE))));
    public static final Entry PURE_SILVER = WitcherTrinkets.add(new Entry(10, "pure_silver", "Pure Silver")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:pure_silver"))).config(new TrinketConfig.Entry());
    public static final Entry ROSE_OF_REMEMBRANCE = WitcherTrinkets.add(new Entry(10, "rose_of_remembrance", "Rose of Remembrance")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:rose_of_remembrance"))).config(new TrinketConfig.Entry());
    public static final Entry CRYSTAL_SKULL = WitcherTrinkets.add(new Entry(10, "crystal_skull", "Crystal Skull")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:crystal_skull"))).config(new TrinketConfig.Entry());
    public static final Entry SUNSTONE = WitcherTrinkets.add(new Entry(10, "sunstone", "Sunstone")).spell(SpellContainerHelper.createForRelic((ResourceLocation)ResourceLocation.parse((String)"witcher_rpg:sunstone"))).config(new TrinketConfig.Entry());

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Function<ItemArgs, Item> getFactory() {
        return factory;
    }

    public static void register(Map<String, TrinketConfig.Entry> config) {
        for (Entry entry : entries) {
            String key = entry.id().toString();
            TrinketConfig.Entry configEntry = config.get(key);
            if (configEntry != null) {
                entry.config(configEntry);
                continue;
            }
            config.put(key, entry.config());
        }
        for (Entry entry : entries) {
            if (!entry.isEnabled()) continue;
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(WitcherGroup.WITCHER_KEY).register(content -> {
            for (Entry entry : entries) {
                if (!entry.isEnabled()) continue;
                content.accept((ItemLike)entry.item().get());
            }
        });
    }

    public static final class Entry {
        private final int tier;
        public String lootTheme;
        private final String name;
        private final String translatedName;
        private TrinketConfig.Entry config;
        public TrinketConfig.Entry defaults;
        private final Supplier<Item> item;
        private SpellContainer spellContainer;
        private final List<UnaryOperator<Item.Properties>> settingsMutators = new ArrayList<UnaryOperator<Item.Properties>>();

        public Entry(int tier, String name, String translatedName) {
            this(tier, name, translatedName, TrinketConfig.Entry.EMPTY);
        }

        public Entry(int tier, String name, String translatedName, TrinketConfig.Entry config) {
            this.tier = tier;
            this.name = name;
            this.translatedName = translatedName;
            this.config = config;
            this.defaults = config;
            this.item = Suppliers.memoize(() -> {
                Item.Properties settings = new Item.Properties().stacksTo(1);
                ItemAttributeModifiers attributes = this.config().attributes != null && !this.config().attributes.isEmpty() ? ConfigUtil.attributesComponent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)name), this.config().attributes).build() : null;
                SpellContainer spellContainer = this.spellContainer();
                if (spellContainer != null) {
                    settings = settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)spellContainer);
                }
                if (this.config().durability > 0) {
                    settings = settings.durability(this.config().durability);
                }
                if (name.contains("medallion")) {
                    settings = settings.rarity(Rarity.EPIC);
                }
                if (name.contains("lesser")) {
                    settings = settings.rarity(Rarity.COMMON);
                }
                if (!name.contains("lesser") && !name.contains("greater") && name.contains("glyph")) {
                    settings = settings.rarity(Rarity.UNCOMMON);
                }
                if (name.contains("greater")) {
                    settings = settings.rarity(Rarity.RARE);
                }
                if (name.contains("pure_silver") && name.contains("rose_of_remembrance") && name.contains("crystal_skull")) {
                    settings = settings.rarity(Rarity.RARE);
                }
                if (name.contains("sunstone")) {
                    settings = settings.rarity(Rarity.EPIC);
                }
                for (UnaryOperator<Item.Properties> mutator : this.settingsMutators) {
                    settings = (Item.Properties)mutator.apply(settings);
                }
                return WitcherTrinkets.getFactory().apply(new ItemArgs(settings, attributes));
            });
        }

        public int tier() {
            return this.tier;
        }

        public ResourceLocation id() {
            return ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)this.name);
        }

        public String name() {
            return this.name;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public TrinketConfig.Entry config() {
            return this.config;
        }

        public Supplier<Item> item() {
            return this.item;
        }

        @Nullable
        public SpellContainer spellContainer() {
            return this.spellContainer;
        }

        public Entry config(TrinketConfig.Entry config) {
            this.config = config;
            return this;
        }

        public Entry spell(SpellContainer spellContainer) {
            this.spellContainer = spellContainer;
            return this;
        }

        public Entry lootTheme(String lootTheme) {
            this.lootTheme = lootTheme;
            return this;
        }

        public <T> Entry component(DataComponentType<T> type, T value) {
            this.settingsMutators.add(settings -> settings.component(type, value));
            return this;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public record ItemArgs(Item.Properties settings, @Nullable ItemAttributeModifiers attributes) {
    }
}

