/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.mixin;

import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.AnimationHelper;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static void witcher$createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).add(WitcherAttributes.AARD_INTENSITY).add(WitcherAttributes.ADRENALINE_MODIFIER).add(WitcherAttributes.AXII_INTENSITY).add(WitcherAttributes.IGNI_INTENSITY).add(WitcherAttributes.QUEN_INTENSITY).add(WitcherAttributes.YRDEN_INTENSITY).add(WitcherAttributes.SIGN_INTENSITY);
    }

    @Inject(at={@At(value="HEAD")}, method={"isBlocking()Z"}, cancellable=true)
    private void witcherBlockingMechanics(CallbackInfoReturnable<Boolean> info) {
        ServerPlayer player;
        LivingEntity player2 = (LivingEntity)this;
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2) instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)player;
            Holder.Reference spellEntryWhirl = SpellRegistry.from((Level)player.level()).getHolder(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"whirl")).orElse(null);
            Spell spellWhirl = (Spell)spellEntryWhirl.value();
            Holder effect = WitcherStatusEffects.WITCHER_REFLEXES.entry;
            Spell spell = caster.getCurrentSpell();
            ItemStack stack = player.getItemBySlot(EquipmentSlot.MAINHAND);
            if (stack.is(ItemTags.SWORDS) && player2.hasEffect(WitcherStatusEffects.WITCHER_REFLEXES.entry) && !caster.isCastingSpell() && !player.isUsingItem() && !player.isSleeping()) {
                info.setReturnValue((Object)true);
            }
            if (spell != null && Objects.equals(caster.getCurrentSpell(), spellWhirl)) {
                info.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void animationWitcherReflexes(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        SpellCasterEntity caster;
        ServerPlayer player;
        LivingEntity damagedTarget = (LivingEntity)this;
        Holder effect = WitcherStatusEffects.WITCHER_REFLEXES.entry;
        ItemStack stack = damagedTarget.getItemBySlot(EquipmentSlot.MAINHAND);
        if (stack.is(ItemTags.SWORDS) && damagedTarget instanceof ServerPlayer && (player = (ServerPlayer)damagedTarget) instanceof SpellCasterEntity && !(caster = (SpellCasterEntity)player).isCastingSpell() && !player.isUsingItem() && !player.isSleeping() && damagedTarget.hasEffect(effect) && !source.is(DamageTypeTags.BYPASSES_SHIELD)) {
            Collection tracker = PlayerLookup.tracking((Entity)damagedTarget);
            AnimationHelper.sendAnimation((Player)player, (Collection)tracker, (SpellCast.Animation)SpellCast.Animation.MISC, (String)"witcher_rpg:witcher_reflexes", (float)1.0f);
            int amplifier = player.getEffect(effect).getAmplifier();
            int duration = player.getEffect(effect).getDuration();
            if (amplifier == 0) {
                player.removeEffect(effect);
            } else {
                player.removeEffect(effect);
                player.addEffect(new MobEffectInstance(effect, duration, amplifier - 1, false, false, true));
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void applyQuenHealBeforeDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity damagedTarget = (LivingEntity)this;
        if (damagedTarget.isAlwaysTicking() && damagedTarget.hasEffect(WitcherStatusEffects.QUEN_ACTIVE.entry) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            damagedTarget.heal(amount / 2.0f);
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void decreaseAdrenalineAmplifierOnDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity damagedTarget = (LivingEntity)this;
        if (damagedTarget.isAlwaysTicking() && damagedTarget.hasEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry)) {
            int adrenaline_effect_amplifier = damagedTarget.getEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry).getAmplifier();
            int adrenaline_effect_duration = damagedTarget.getEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry).getDuration();
            float adrenaline_attribute_player = (float)(damagedTarget.getAttributeValue(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0);
            float random = new Random().nextFloat(100.0f);
            if (adrenaline_effect_amplifier != 0) {
                if (random > adrenaline_attribute_player) {
                    damagedTarget.removeEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry);
                    damagedTarget.addEffect(new MobEffectInstance(WitcherStatusEffects.ADRENALINE_GAIN.entry, adrenaline_effect_duration, adrenaline_effect_amplifier - 1, false, false, true));
                }
            } else {
                damagedTarget.removeEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry);
            }
        }
    }
}

