/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.mixin;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.more_rpg_classes.util.CustomMethods;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_power.api.SpellSchool;
import net.witcher_rpg.WitcherClassMod;
import net.witcher_rpg.config.TweaksConfig;
import net.witcher_rpg.custom.WitcherSpellSchools;
import net.witcher_rpg.effect.WitcherStatusEffects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpellHelper.class})
public abstract class SpellHelperMixin {
    @Inject(at={@At(value="HEAD")}, method={"performSpell(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/Holder;Lnet/spell_engine/internals/target/SpellTarget$SearchResult;Lnet/spell_engine/internals/casting/SpellCast$Action;F)V"}, cancellable=true)
    private static void witcherQuenActiveShield(Level world, Player player, Holder<Spell> spellEntry, SpellTarget.SearchResult targetResult, SpellCast.Action action, float progress, CallbackInfo callbackInfo) {
        if (!player.isSpectator() && player instanceof SpellCasterEntity) {
            SpellCasterEntity spellCasterEntity = (SpellCasterEntity)player;
            Spell spell = spellCasterEntity.getCurrentSpell();
            Holder.Reference spellEntryQuen = SpellRegistry.from((Level)player.level()).getHolder(ResourceLocation.fromNamespaceAndPath((String)"witcher_rpg", (String)"quen_active_shield")).orElse(null);
            if (spell != null && action == SpellCast.Action.RELEASE && Objects.equals(spell, spellEntryQuen.value())) {
                player.removeEffect(WitcherStatusEffects.QUEN_ACTIVE.entry);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"performSpell(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/Holder;Lnet/spell_engine/internals/target/SpellTarget$SearchResult;Lnet/spell_engine/internals/casting/SpellCast$Action;F)V"}, cancellable=true)
    private static void damagingSignAdrenalineGain(Level world, Player player, Holder<Spell> spellEntry, SpellTarget.SearchResult targetResult, SpellCast.Action action, float progress, CallbackInfo callbackInfo) {
        if (!player.isSpectator()) {
            Spell spell = (Spell)spellEntry.value();
            SpellSchool school = spell.school;
            List entities = targetResult.entities();
            if (spell != null && action == SpellCast.Action.RELEASE && entities != null && school == WitcherSpellSchools.IGNI || school == WitcherSpellSchools.AARD) {
                int actualDuration;
                AttributeInstance adrenaline = player.getAttribute(WitcherAttributes.ADRENALINE_MODIFIER);
                int value1 = (int)adrenaline.getValue() - 100;
                int adrenaline_duration_multiplier = value1 * 3;
                int durationSeconds = 20 + adrenaline_duration_multiplier;
                if (player.hasEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry) && (durationSeconds += (actualDuration = player.getEffect(WitcherStatusEffects.ADRENALINE_GAIN.entry).getDuration() * 20)) > ((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_seconds_duration * 20) {
                    durationSeconds = ((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_seconds_duration * 20;
                }
                CustomMethods.applyStatusEffect((LivingEntity)player, (int)0, (int)durationSeconds, (Holder)WitcherStatusEffects.ADRENALINE_GAIN.entry, (int)(((TweaksConfig)WitcherClassMod.tweaksConfig.value).adrenaline_max_amplifier - 1), (boolean)true, (boolean)true, (boolean)false, (int)0);
            }
        }
    }
}

