/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SummonCommand.class})
public abstract class SummonCommandMix {
    @Shadow
    @Final
    private static SimpleCommandExceptionType INVALID_POSITION;
    @Shadow
    @Final
    private static SimpleCommandExceptionType ERROR_DUPLICATE_UUID;
    @Shadow
    @Final
    private static SimpleCommandExceptionType ERROR_FAILED;

    @Shadow
    public static Entity createEntity(CommandSourceStack p_270582_, Holder.Reference<EntityType<?>> p_270277_, Vec3 p_270366_, CompoundTag p_270197_, boolean p_270947_) {
        return null;
    }

    @Inject(method={"createEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, Vec3 pos, CompoundTag tag, boolean randomizeProperties, CallbackInfoReturnable<Entity> cir) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.containing((Position)pos);
        if (!Level.isInSpawnableBounds((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundtag = tag.copy();
        compoundtag.putString("id", type.key().location().toString());
        ServerLevel serverlevel = source.getLevel();
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)serverlevel, loadEntity -> {
            if (loadEntity instanceof Mob) {
                Mob mob = (Mob)loadEntity;
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(MobSpawnType.COMMAND.toString()));
            }
            loadEntity.moveTo(pos.x, pos.y, pos.z, loadEntity.getYRot(), loadEntity.getXRot());
            return loadEntity;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!entity.isAlive()) {
                cir.setReturnValue(null);
                return;
            }
            if (randomizeProperties) {
                mob.finalizeSpawn((ServerLevelAccessor)source.getLevel(), source.getLevel().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.COMMAND, null);
            }
        }
        if (!serverlevel.tryAddFreshEntityWithPassengers(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        cir.setReturnValue((Object)entity);
    }

    @Inject(method={"spawnEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private static void spawnEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, Vec3 pos, CompoundTag tag, boolean randomizeProperties, CallbackInfoReturnable<Integer> cir) {
        Entity entity = SummonCommandMix.createEntity(source, type, pos, tag, randomizeProperties);
        if (entity != null) {
            source.sendSuccess(() -> Component.translatable((String)"commands.summon.success", (Object[])new Object[]{entity.getDisplayName()}), true);
            cir.setReturnValue((Object)1);
        } else {
            source.sendFailure((Component)Component.translatable((String)"commands.summon.failed"));
            cir.setReturnValue((Object)0);
        }
    }
}

