/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.data.Range;
import com.crackerjackbox.mobcontrol.data.Weighted;
import com.crackerjackbox.mobcontrol.data.WeightedItem;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.iface.IServerLevel;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExCodec;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1420;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7924;

public class Util {
    public static final HashMap<String, Long> nextTicks = new HashMap();
    public static boolean isGenerating = false;
    public static Random random = new Random();
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(MobEx.class, (Object)new MobExCodec()).create();

    public static MobEx getMobEx(class_1308 mob, class_2960 key) {
        String nameFilter = "";
        if (mob != null) {
            class_7417 class_74172 = mob.method_5477().method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 translatableContents = (class_2588)class_74172;
                nameFilter = translatableContents.method_11022().toLowerCase();
            } else {
                nameFilter = mob.method_5477().getString().toLowerCase();
            }
        }
        MobEx exactMobWithNameFilter = Config.mobs.getOrDefault(key.method_12836() + ":" + key.method_12832() + ":" + nameFilter, null);
        MobEx exactMob = Config.mobs.getOrDefault(key.method_12836() + ":" + key.method_12832(), null);
        MobEx exactMod = Config.mobs.getOrDefault(key.method_12836() + ":*", null);
        MobEx allWildOrNull = Config.mobs.getOrDefault("*:*", Config.mobs.getOrDefault("*", null));
        return exactMobWithNameFilter != null ? exactMobWithNameFilter : (exactMob != null ? exactMob : (exactMod != null ? exactMod : allWildOrNull));
    }

    public static void setRandomItem(class_1308 mob, class_1304 equipmentSlot, Weighted<WeightedItem> items) {
        if (items != null) {
            WeightedItem weightedItem = items.getWeighted();
            class_1799 itemStack = Util.getRandomItemStack(mob.method_37908(), weightedItem);
            if (itemStack != null) {
                mob.method_5673(equipmentSlot, itemStack);
                if (weightedItem.drop() > 0) {
                    ((IMob)mob).mobControl$addDeathLoot(weightedItem);
                }
            }
        }
    }

    public static class_1799 getRandomItemStack(class_1937 level, WeightedItem weightedItem) {
        if (weightedItem != null) {
            String itemName = weightedItem.key();
            class_7157 context = class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)class_7701.field_40182);
            class_2287 itemArgument = new class_2287(context);
            try {
                class_2290 itemInput = itemArgument.method_9778(new StringReader(itemName));
                return itemInput.method_9781(1, false);
            }
            catch (CommandSyntaxException ex) {
                Constants.LOG.error("Error getting item stack", (Throwable)ex);
            }
        }
        return null;
    }

    public static <T> T getRandomElement(ArrayList<T> array) {
        return array.get(random.nextInt(0, array.size()));
    }

    public static ArrayList<class_2960> getStructures(class_3218 serverLevel, class_2338 pos) {
        ArrayList<class_2960> resourceLocations = new ArrayList<class_2960>();
        class_2378 structureRegistry = serverLevel.method_30349().method_30530(class_7924.field_41246);
        serverLevel.method_27056().method_41037(pos).forEach((structure, set) -> {
            class_2960 resourceLocation = structureRegistry.method_10221(structure);
            if (resourceLocation != null) {
                resourceLocations.add(resourceLocation);
            }
        });
        return resourceLocations;
    }

    public static ArrayList<class_2960> getBiomeTags(class_3218 serverLevel, class_2338 pos) {
        ArrayList<class_2960> resourceLocations = new ArrayList<class_2960>();
        serverLevel.method_23753(pos).method_40228().forEach(tagKeyBiome -> resourceLocations.add(tagKeyBiome.comp_327()));
        return resourceLocations;
    }

    public static String getReasonSpawnType(String spawnReason) {
        if (spawnReason.equals(class_3730.field_16469.toString())) {
            return "spawner";
        }
        if (spawnReason.equals(Constants.ReasonControl)) {
            return "control";
        }
        if (spawnReason.equals(class_3730.field_16461.toString())) {
            return "trigger";
        }
        return "natural";
    }

    public static long getNearByOrServerDays(IServerLevel iServerLevel, class_2338 pos) {
        class_1657 nearestPlayer;
        if (pos != null && (nearestPlayer = ((class_3218)iServerLevel).method_18461(class_4051.method_36625().method_18418(80.0), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) instanceof IPlayer) {
            IPlayer serverPlayer = (IPlayer)nearestPlayer;
            return serverPlayer.mobControl$ticks() / 24000L;
        }
        return iServerLevel.mobControl$savedData() == null ? 0L : iServerLevel.mobControl$savedData().getTicks() / 24000L;
    }

    public static boolean isValidMob(class_3218 serverLevel, class_1308 mob, String spawnReason) {
        return Util.setMob(serverLevel, mob, null, null, spawnReason, true);
    }

    public static boolean isValidMob(class_3218 serverLevel, class_2960 mobResourceLocation, class_2338 pos, String spawnReason) {
        return Util.setMob(serverLevel, null, mobResourceLocation, pos, spawnReason, true);
    }

    public static boolean setMob(class_3218 serverLevel, class_1308 mob, double x, double y, double z) {
        MobExRule mobExRule = ((IMob)mob).mobControl$getRule();
        if (mobExRule == null) {
            if (((IMob)mob).mobControl$getMobSpawn() == null || ((IMob)mob).mobControl$getMobSpawn().reason == null) {
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(class_3730.field_16459.toString()));
            }
            String spawnReason = ((IMob)mob).mobControl$getMobSpawn().reason;
            Constants.LOG.debug("setMob: Checking rules for {}, reason {}, id {}", new Object[]{mob.method_5477().getString(), spawnReason, mob.method_5667()});
            if (spawnReason.equals(class_3730.field_16468.toString()) || spawnReason.equals(Constants.ReasonOverride)) {
                return true;
            }
            if (Util.setMob(serverLevel, mob, null, null, spawnReason, false)) {
                Constants.LOG.debug("setMob: {} has been allowed, reason {}, id {}, loc {} {} {}", new Object[]{mob.method_5477().getString(), spawnReason, mob.method_5667(), (int)x, (int)y, (int)z});
                return true;
            }
            if (!Constants.ReasonControl.equals(spawnReason)) {
                Constants.LOG.debug("setMob: {} has been canceled, reason {}, id {}", new Object[]{mob.method_5477().getString(), spawnReason, mob.method_5667()});
                if (class_3730.field_16459.toString().equals(spawnReason) && mob.method_5864() == class_1299.field_6116 && serverLevel.method_29198() != null) {
                    Constants.LOG.debug("Canceled ender dragon boss fight due to no rule allowing ender dragon");
                    ((IMob)mob).mobControl$setCancelBossFight(true);
                    serverLevel.method_29198().method_12528((class_1510)mob);
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean setMob(class_3218 serverLevel, class_1308 mob, class_2960 mobResourceLocation, class_2338 pos, String spawnReason, boolean checkOnly) {
        try {
            if (Util.isGenerating) {
                Constants.LOG.debug("setMob: Ignoring due to isGenerating");
                return false;
            }
            if (mob != null) {
                pos = mob.method_24515();
                if (mobResourceLocation == null) {
                    mobResourceLocation = class_1299.method_5890((class_1299)mob.method_5864());
                }
            }
            if (mobResourceLocation == null) {
                Constants.LOG.debug("setMob: resourceLocation == null");
                return false;
            }
            mobEx = Util.getMobEx(mob, mobResourceLocation);
            if (mobEx == null) {
                Constants.LOG.debug("setMob: mobEx == null");
                return false;
            }
            iServerLevel = (IServerLevel)serverLevel;
            currentTick = iServerLevel.mobControl$savedData().getTicks();
            mobName = mobResourceLocation.method_12836() + ":" + mobResourceLocation.method_12832();
            simpleSpawnReason = Util.getReasonSpawnType(spawnReason);
            willRandomizePosition = List.of(Constants.ReasonControl, class_3730.field_16469.toString()).contains(spawnReason);
            currentWeather = serverLevel.method_8419() != false ? "rain" : (serverLevel.method_8546() != false ? "thunderstorm" : "clear");
            Constants.LOG.debug("setMob: Checking rule {}, mobExName {}, reason {}, have mob {}, check {} @ {} {} {}", new Object[]{mobEx.name(), mobName, spawnReason, mob != null, checkOnly, pos.method_10263(), pos.method_10264(), pos.method_10260()});
            for (MobExRule mobExRule : mobEx.rules) {
                block47: {
                    if (mobExRule.coolDownFrom != null && mobExRule.coolDownTo != null && mobExRule.coolDownNextSpawnTick != null && mobExRule.coolDownNextSpawnTick > currentTick) {
                        Constants.LOG.debug("setMob: Skipping rule due to cool down of {} > server ticks {}, rule {}, name {}, reason {}", new Object[]{mobExRule.coolDownNextSpawnTick, currentTick, mobEx.name(), mobName, spawnReason});
                        continue;
                    }
                    repeat = mobExRule.repeatFrom == null || mobExRule.repeatTo == null ? (spawnReason.equals(class_3730.field_16469.toString()) && (mobExRule.type.contains("all") || mobExRule.type.contains("spawner")) ? Range.of(200, 800) : Range.of(0, 0)) : Range.of(mobExRule.repeatFrom, mobExRule.repeatTo);
                    if (willRandomizePosition && repeat.getMaximum() == 0) {
                        Constants.LOG.debug("setMob: Skipping rule due to repeat of 0 & being a control/spawner, rule {}, name {}, reason {}, repeat: {} to {}", new Object[]{mobEx.name(), mobName, spawnReason, repeat.getMinimum(), repeat.getMaximum()});
                        continue;
                    }
                    if (!(mobExRule.type.contains("all") || mobExRule.type.contains("block") || List.of(class_3730.field_16462.toString(), class_3730.field_16468.toString(), class_3730.field_16465.toString()).contains(spawnReason) || mobExRule.type.contains(simpleSpawnReason))) {
                        if (spawnReason.equals(Constants.ReasonControl)) continue;
                        Constants.LOG.debug("setMob: Skipping rule due to wrong type of {}, rule {}, name {}, reason {}", new Object[]{mobExRule.type, mobEx.name(), mobName, spawnReason});
                        continue;
                    }
                    if (spawnReason.equals(class_3730.field_16468.toString())) break block47;
                    if (mobExRule.type.contains("block")) {
                        Constants.LOG.debug("setMob: Match a block rule {}, rule {}, name {}, reason {}", new Object[]{mobExRule.type, mobEx.name(), mobName, spawnReason});
                        return false;
                    }
                    v0 = mobExRule.spawn.countFrom == null || mobExRule.spawn.countTo == null ? MobEx.randomFromRange(1, spawnReason.equals(class_3730.field_16469.toString()) != false ? 4 : 1) : (spawnCount = MobEx.randomFromRange(mobExRule.spawn.countFrom, mobExRule.spawn.countTo));
                    if (spawnCount <= 0) {
                        Constants.LOG.debug("canCreateMob: Skipping due to spawn count {} is less than 1 from [{},{}]", new Object[]{spawnCount, mobExRule.spawn.countFrom, mobExRule.spawn.countTo});
                        continue;
                    }
                    currentDimension = serverLevel.method_27983().method_29177();
                    if (!(mobExRule.dimension == null || mobExRule.dimension.contains(currentDimension.method_12836() + ":" + currentDimension.method_12832()) || mobExRule.dimension.contains(currentDimension.method_12836() + ":*") || mobExRule.dimension.contains("*:*") || mobExRule.dimension.contains("*"))) {
                        Constants.LOG.debug("canCreateMob: Skipping due to dimension {}:{} not in {}", new Object[]{currentDimension.method_12836(), currentDimension.method_12832(), String.join((CharSequence)", ", mobExRule.dimension)});
                        continue;
                    }
                    if (serverLevel.method_22385().method_22393(pos).method_40230().isPresent()) {
                        currentBiome = ((class_5321)serverLevel.method_22385().method_22393(pos).method_40230().get()).method_29177();
                        if (!(mobExRule.biome == null || mobExRule.biome.contains(currentBiome.method_12836() + ":" + currentBiome.method_12832()) || mobExRule.biome.contains(currentBiome.method_12836() + ":*") || mobExRule.biome.contains("*:*") || mobExRule.biome.contains("*"))) {
                            Constants.LOG.debug("canCreateMob: Skipping due to biome {}:{} not in {}", new Object[]{currentBiome.method_12836(), currentBiome.method_12832(), String.join((CharSequence)", ", mobExRule.biome)});
                            continue;
                        }
                    }
                    if (mobExRule.biomeTag != null) {
                        foundBiomeTags = Util.getBiomeTags(serverLevel, pos);
                        passedBiomeTagCheck = false;
                        for (class_2960 structureToCheck : foundBiomeTags) {
                            if (!mobExRule.biomeTag.contains(structureToCheck.method_12836() + ":" + structureToCheck.method_12832()) && !mobExRule.biomeTag.contains(structureToCheck.method_12836() + ":*") && !mobExRule.biomeTag.contains("*:*") && !mobExRule.biomeTag.contains("*")) continue;
                            passedBiomeTagCheck = true;
                            break;
                        }
                        if (!passedBiomeTagCheck) {
                            Constants.LOG.debug("canCreateMob: Skipping due to biome tags are not in {}", (Object)String.join((CharSequence)", ", mobExRule.biomeTag));
                            continue;
                        }
                    }
                    if (mobExRule.structure != null) {
                        foundStructures = Util.getStructures(serverLevel, pos);
                        if (mobExRule.structure.contains("none") && !foundStructures.isEmpty()) {
                            Constants.LOG.debug("canCreateMob: Skipping due to finding structures with {}", (Object)String.join((CharSequence)", ", mobExRule.structure));
                            continue;
                        }
                        passedStructureCheck = false;
                        for (class_2960 structureToCheck : foundStructures) {
                            if (!mobExRule.structure.contains(structureToCheck.method_12836() + ":" + structureToCheck.method_12832()) && !mobExRule.structure.contains(structureToCheck.method_12836() + ":*") && !mobExRule.structure.contains("*:*") && !mobExRule.structure.contains("*")) continue;
                            passedStructureCheck = true;
                            break;
                        }
                        if (!passedStructureCheck) {
                            Constants.LOG.debug("canCreateMob: Skipping due to not find any of the following structures {}", (Object)String.join((CharSequence)", ", mobExRule.structure));
                            continue;
                        }
                    }
                    if (mobExRule.weather != null && !mobExRule.weather.contains(currentWeather)) {
                        Constants.LOG.debug("canCreateMob: Skipping due to weather {} not in {}", (Object)currentWeather, (Object)String.join((CharSequence)", ", mobExRule.weather));
                        continue;
                    }
                    if (!(mob instanceof IMob)) ** GOTO lbl-1000
                    iMob = (IMob)mob;
                    if (iMob.mobControl$getMobSpawn().dayCheck != null) {
                        v1 = iMob.mobControl$getMobSpawn().dayCheck;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = currentDays = Long.valueOf(Util.getNearByOrServerDays(iServerLevel, pos));
                    }
                    if (mobExRule.dayFrom != null && mobExRule.dayTo != null && (currentDays < (long)mobExRule.dayFrom.intValue() || currentDays > (long)mobExRule.dayTo.intValue())) {
                        Constants.LOG.debug("setMob: Skipping due to day {} not between {}-{}", new Object[]{currentDays, mobExRule.dayFrom, mobExRule.dayTo});
                        continue;
                    }
                    currentTimeOfDay = serverLevel.method_8401().method_217() % 24000L;
                    if (mobExRule.timeOfDayFrom != null && mobExRule.timeOfDayTo != null && (currentTimeOfDay < (long)mobExRule.timeOfDayFrom.intValue() || currentTimeOfDay > (long)mobExRule.timeOfDayTo.intValue())) {
                        Constants.LOG.debug("setMob: Skipping due to time of day {} not between {}-{}", new Object[]{currentTimeOfDay, mobExRule.timeOfDayFrom, mobExRule.timeOfDayTo});
                        continue;
                    }
                    if (!willRandomizePosition && !Util.positionalRuleChecks(serverLevel, mobExRule, pos, spawnReason)) continue;
                    currentPerMob = Constants.MOB_STATS.getOrDefault(mobResourceLocation.toString(), 0L);
                    if (mobExRule.maxPerMob != null && (currentPerMob += (long)spawnCount) > (long)mobExRule.maxPerMob.intValue()) {
                        Constants.LOG.debug("setMob: Skipping due to max per mob {} is greater than {}", (Object)currentPerMob, (Object)mobExRule.maxPerMob);
                        continue;
                    }
                    playerCount = serverLevel.method_18456().size();
                    if (mobExRule.maxPerPlayer != null && currentPerMob > (long)mobExRule.maxPerPlayer.intValue() * (long)playerCount) {
                        Constants.LOG.debug("setMob: Skipping due to max per player {} is greater than {}", (Object)currentPerMob, (Object)(mobExRule.maxPerPlayer * playerCount));
                        continue;
                    }
                    if (mob != null && mobExRule.isBaby != null && mobExRule.isBaby.booleanValue() != mob.method_6109()) {
                        Constants.LOG.debug("setMob: Skipping due to is baby {} is not equal to {}", (Object)mob.method_6109(), (Object)mobExRule.isBaby);
                        continue;
                    }
                    if (willRandomizePosition && repeat.getMaximum() > 0) {
                        tickName = spawnReason + ":" + mobExRule.name + ":" + repeat.getMinimum() + ":" + repeat.getMaximum() + ":" + mobName + (String)(spawnReason.equals(class_3730.field_16469.toString()) != false ? ":" + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() : "");
                        nextTickValue = Util.nextTicks.get(tickName);
                        if (nextTickValue == null || nextTickValue == 0L) {
                            Util.nextTicks.put(tickName, currentTick + (long)MobEx.randomFromRange(repeat.getMinimum(), repeat.getMaximum()));
                            Constants.LOG.debug("setMob: Rule ignored due to seeding, type \"{}\", rule {}, tick name {}, reason {}", new Object[]{String.join((CharSequence)",", mobExRule.type), mobEx.name(), tickName, spawnReason});
                            continue;
                        }
                        if (currentTick < nextTickValue) {
                            Constants.LOG.debug("setMob: Rule ignored due to delaying, type \"{}\", rule {}, tick name {}, reason {}, c {}, l {}, r {}", new Object[]{String.join((CharSequence)",", mobExRule.type), mobEx.name(), tickName, spawnReason, currentTick, nextTickValue, 0});
                            continue;
                        }
                        Util.nextTicks.put(tickName, currentTick + (long)MobEx.randomFromRange(repeat.getMinimum(), repeat.getMaximum()));
                        Constants.LOG.debug("setMob: Ticking {}, rule {}, reason {}, current {}, repeat {}, next {}, tick name {}, id {}", new Object[]{mobName, mobEx.name(), spawnReason, currentTick, 0, nextTickValue, tickName, mob != null ? mob.method_5667() : "n/a"});
                    }
                    if (!MobEx.can(mobExRule.run)) {
                        Constants.LOG.debug("setMob: Would have passed, but blocked by run probability {}, rule {}, reason {}, type \"{}\"", new Object[]{mobName, mobEx.name(), spawnReason, String.join((CharSequence)",", mobExRule.type)});
                        continue;
                    }
                    Constants.LOG.debug("setMob: Passed {}, rule {}, reason {}, type \"{}\"", new Object[]{mobName, mobEx.name(), spawnReason, String.join((CharSequence)",", mobExRule.type)});
                    if (!checkOnly && mob != null) {
                        Constants.LOG.debug("setMob: Count 1 of {}, reason {}, id {}, rule name {}, health {}", new Object[]{spawnCount, spawnReason, mob.method_5667(), mobExRule.name, mobExRule.set.healthTo});
                        Util.mobSet(mob, mobExRule);
                        mobAtY = mob.method_24515().method_10264();
                        if (willRandomizePosition) {
                            distanceXFrom = mobExRule.spawn.distanceXFrom;
                            distanceXTo = mobExRule.spawn.distanceXTo;
                            distanceZFrom = mobExRule.spawn.distanceZFrom;
                            distanceZTo = mobExRule.spawn.distanceZTo;
                            atYFrom = mobExRule.spawn.atYFrom;
                            atYTo = mobExRule.spawn.atYTo;
                            if (spawnReason.equals(class_3730.field_16469.toString())) {
                                if (mobExRule.spawn.distanceFrom == null && mobExRule.spawn.distanceTo == null && distanceXFrom == null && distanceXTo == null && distanceZFrom == null && distanceZTo == null) {
                                    distanceXFrom = distanceZFrom = Integer.valueOf(0);
                                    distanceXTo = distanceZTo = Integer.valueOf(4);
                                }
                                if (mobExRule.spawn.atYFrom == -256 && mobExRule.spawn.atYTo == 256) {
                                    atYFrom = mobAtY - (mobExRule.spawn.distanceY + 1);
                                    atYTo = mobAtY + mobExRule.spawn.distanceY + 1;
                                }
                            }
                            if (distanceXFrom == null || distanceXTo == null || distanceZFrom == null || distanceZTo == null) {
                                blockPos = Util.getRandomPosition(mob.method_24515(), mobExRule.spawn.distanceFrom == null ? 24.0 : (double)mobExRule.spawn.distanceFrom.intValue(), mobExRule.spawn.distanceTo == null ? 128.0 : (double)mobExRule.spawn.distanceTo.intValue());
                                mobX = blockPos.method_10263();
                                mobZ = blockPos.method_10260();
                            } else {
                                mobX = mob.method_23317() + (double)(MobEx.randomFromRange(distanceXFrom, distanceXTo) * (Util.random.nextBoolean() != false ? 1 : -1));
                                mobZ = mob.method_23321() + (double)(MobEx.randomFromRange(distanceZFrom, distanceZTo) * (Util.random.nextBoolean() != false ? 1 : -1));
                            }
                            if (!Util.setMobLocation(serverLevel, mob, mobExRule, spawnReason, mobX, mobAtY, mobZ, atYFrom.intValue(), atYTo.intValue())) {
                                continue;
                            }
                        } else if (mobAtY < mobExRule.spawn.atYFrom || mobAtY > mobExRule.spawn.atYTo) {
                            Constants.LOG.debug("setMob: Failed due to y-axis of {} is not between {} to {}", new Object[]{mobAtY, mobExRule.spawn.atYFrom, mobExRule.spawn.atYTo});
                            continue;
                        }
                        for (mobIndex = 0; mobIndex < spawnCount - 1; ++mobIndex) {
                            Constants.LOG.debug("setMob: New {} of {}, reason {}", new Object[]{mobIndex + 2, spawnCount, spawnReason});
                            entity = mob.method_5864().method_5883((class_1937)serverLevel);
                            if (!(entity instanceof class_1308)) continue;
                            newMob = (class_1308)entity;
                            ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonOverride));
                            Constants.LOG.debug("setMob: Count {} of {}, reason {}, id {}", new Object[]{mobIndex + 2, spawnCount, spawnReason, newMob.method_5667()});
                            Util.mobSet(newMob, mobExRule);
                            ((IMob)mob).mobControl$addMob(newMob);
                        }
                        if (mobExRule.coolDownFrom != null && mobExRule.coolDownTo != null) {
                            mobExRule.coolDownNextSpawnTick = currentTick + (long)MobEx.randomFromRange(mobExRule.coolDownFrom, mobExRule.coolDownTo);
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception ex) {
            Constants.LOG.error("setMob: Exception", (Throwable)ex);
        }
        return false;
    }

    public static class_2338 getRandomPosition(class_2338 blockPos, double minDistance, double maxDistance) {
        double distance = minDistance + random.nextDouble() * (maxDistance - minDistance);
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int offsetX = (int)Math.round(Math.cos(angle) * distance);
        int offsetZ = (int)Math.round(Math.sin(angle) * distance);
        return new class_2338(blockPos.method_10263() + offsetX, blockPos.method_10264(), blockPos.method_10260() + offsetZ);
    }

    private static boolean positionalRuleChecks(class_3218 serverLevel, MobExRule mobExRule, class_2338 pos, String spawnReason) {
        boolean canSeeSky = serverLevel.method_8311(pos);
        if (mobExRule.canSeeSky != null && mobExRule.canSeeSky != canSeeSky) {
            Constants.LOG.debug("setMob: Skipping due to can see sky {} not {}", (Object)canSeeSky, (Object)mobExRule.canSeeSky);
            return false;
        }
        int currentLightSky = serverLevel.method_8314(class_1944.field_9284, pos);
        if (mobExRule.lightSkyFrom != null && (currentLightSky < mobExRule.lightSkyFrom || currentLightSky > mobExRule.lightSkyTo)) {
            Constants.LOG.debug("setMob: Skipping due to light sky {} not between {}-{}", new Object[]{currentLightSky, mobExRule.lightSkyFrom, mobExRule.lightSkyTo});
            return false;
        }
        int currentLightBlock = serverLevel.method_8314(class_1944.field_9282, pos);
        Integer lightBlockFrom = mobExRule.lightBlockFrom;
        Integer lightBlockTo = mobExRule.lightBlockTo;
        if ((lightBlockFrom == null || lightBlockTo == null) && (mobExRule.type.contains("all") || mobExRule.type.contains("spawner")) && spawnReason.equals(class_3730.field_16469.toString())) {
            lightBlockFrom = 0;
            lightBlockTo = 5;
        }
        if (lightBlockFrom != null && lightBlockTo != null && (currentLightBlock < lightBlockFrom || currentLightBlock > lightBlockTo)) {
            Constants.LOG.debug("setMob: Skipping due to light block {} not between {}-{}", new Object[]{currentLightBlock, lightBlockFrom, lightBlockTo});
            return false;
        }
        return true;
    }

    public static boolean isInWall(class_3218 serverLevel, class_1308 mob) {
        return Util.isInWall(serverLevel, mob, mob.method_33571());
    }

    public static boolean isInWall(class_3218 serverLevel, class_1308 mob, class_243 position) {
        float width = mob.method_17681() * 0.8f;
        class_238 box = class_238.method_30048((class_243)position, (double)width, (double)1.0E-6f, (double)width);
        return class_2338.method_29715((class_238)box).anyMatch(blockPos -> {
            class_2680 blockState = serverLevel.method_8320(blockPos);
            return !blockState.method_26215() && blockState.method_26228((class_1922)serverLevel, blockPos) && class_259.method_1074((class_265)blockState.method_26220((class_1922)serverLevel, blockPos).method_1096((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), (class_265)class_259.method_1078((class_238)box), (class_247)class_247.field_16896);
        });
    }

    public static boolean validSpawnPlacement(class_3218 serverLevel, class_1317.class_1319 spawnPlacementType, class_1308 mob, MobExRule mobExRule, String spawnReason) {
        if (mobExRule.spawn.additionalChecks != null && mobExRule.spawn.additionalChecks.booleanValue() && !mob.method_5957((class_4538)serverLevel)) {
            return false;
        }
        if (!Util.positionalRuleChecks(serverLevel, mobExRule, mob.method_24515(), spawnReason)) {
            return false;
        }
        class_3610 fluidState = serverLevel.method_8316(mob.method_24515().method_10074());
        if (spawnPlacementType == class_1317.class_1319.field_6318 || spawnPlacementType == class_1317.class_1319.field_23221) {
            Constants.LOG.debug("validSpawnPlacement: WATER or LAVA");
            return fluidState.method_15767(spawnPlacementType == class_1317.class_1319.field_6318 ? class_3486.field_15517 : class_3486.field_15518);
        }
        if (spawnPlacementType == class_1317.class_1319.field_6317) {
            Constants.LOG.debug("validSpawnPlacement: GROUND");
            if (!fluidState.method_15769() && (fluidState.method_15767(class_3486.field_15517) || fluidState.method_15767(class_3486.field_15518)) || Util.isInWall(serverLevel, mob)) {
                return false;
            }
            return serverLevel.method_8320(mob.method_24515()).method_26215() && serverLevel.method_8320(mob.method_24515().method_10084()).method_26215() && (spawnReason.equals(class_3730.field_16469.toString()) || !serverLevel.method_8320(mob.method_24515().method_10074()).method_26215() && !serverLevel.method_8320(mob.method_24515().method_10074()).method_26164(class_3481.field_15503));
        }
        Constants.LOG.debug("validSpawnPlacement: OTHER");
        return !Util.isInWall(serverLevel, mob);
    }

    public static boolean setMobLocation(class_3218 serverLevel, class_1308 mob, MobExRule mobExRule, String spawnReason, double x, double sourceY, double z, double atYFrom, double atYTo) {
        class_1317.class_1319 spawnPlacementType = class_1317.method_6159((class_1299)mob.method_5864());
        if (mob instanceof class_1420) {
            spawnPlacementType = class_1317.class_1319.field_19350;
        }
        boolean foundPlacement = false;
        Constants.LOG.debug("mobFixLocation: Placement up @ {} {} {}", new Object[]{x, sourceY, z});
        double yCheck = sourceY + (double)mobExRule.spawn.distanceY.intValue();
        if (yCheck < atYFrom) {
            yCheck = atYFrom;
        }
        while (!foundPlacement && yCheck <= atYTo && !serverLevel.method_8320(mob.method_24515()).method_27852(class_2246.field_9987)) {
            mob.method_23327(x, yCheck, z);
            if (Util.validSpawnPlacement(serverLevel, spawnPlacementType, mob, mobExRule, spawnReason)) {
                foundPlacement = true;
                continue;
            }
            yCheck += 1.0;
        }
        if (!foundPlacement) {
            Constants.LOG.debug("mobFixLocation: Placement down");
            yCheck = sourceY - 1.0 - (double)mobExRule.spawn.distanceY.intValue();
            if (yCheck > atYTo) {
                yCheck = atYTo;
            }
            mob.method_23327(x, yCheck, z);
            while (!foundPlacement && yCheck >= atYFrom && !serverLevel.method_8320(mob.method_24515()).method_27852(class_2246.field_9987)) {
                mob.method_23327(x, yCheck, z);
                if (Util.validSpawnPlacement(serverLevel, spawnPlacementType, mob, mobExRule, spawnReason)) {
                    foundPlacement = true;
                    continue;
                }
                yCheck -= 1.0;
            }
        }
        if (foundPlacement) {
            Constants.LOG.debug("mobFixLocation: mob.moveTo {} {} {}", new Object[]{x, yCheck, z});
            mob.method_23327(x, yCheck, z);
            mob.method_36456(random.nextFloat() * 360.0f);
            mob.method_36457(190.0f);
            mob.method_22862();
            mob.method_5814(mob.method_19538().field_1352, mob.method_19538().field_1351, mob.method_19538().field_1350);
            return true;
        }
        Constants.LOG.debug("mobFixLocation: no safe placement {} {} {}, distance y {}, at {} to {}", new Object[]{x, sourceY, z, mobExRule.spawn.distanceY, atYFrom, atYTo});
        return false;
    }

    private static void mobSet(class_1308 mob, MobExRule mobExRule) {
        ((IMob)mob).mobControl$setRule(mobExRule);
    }
}

