/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.WriterContext;
import com.crackerjackbox.toml.iface.IValueReader;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.util.concurrent.atomic.AtomicInteger;

public class BooleanValueReaderWriter
implements IValueReader,
IValueWriter {
    static final BooleanValueReaderWriter BOOLEAN_VALUE_READER_WRITER = new BooleanValueReaderWriter();

    @Override
    public boolean canRead(String string) {
        return string.startsWith("true") || string.startsWith("false");
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        Boolean isBoolean = string.substring(atomicInteger.get()).startsWith("true") ? Boolean.TRUE : Boolean.FALSE;
        atomicInteger.addAndGet((isBoolean == Boolean.TRUE ? 4 : 5) - 1);
        return isBoolean;
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public void write(Object value, WriterContext context) {
        context.write(value.toString());
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    public String toString() {
        return "boolean";
    }
}

