/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.ai;

import com.crackerjackbox.mobcontrol.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BreakBlocksGoal<T extends Monster>
extends Goal {
    final T monster;
    final Level level;
    final int[] patternY = new int[]{0, 1, 2};
    final int patternYSize = this.patternY.length;
    final int[] patternXZ = new int[]{0, -1, 1};
    final int patternXZSize = this.patternXZ.length;
    BlockPos targetBlock;
    double progress = 0.0;
    double destroyTime = Double.MAX_VALUE;

    public BreakBlocksGoal(T monster) {
        this.monster = monster;
        this.level = monster.level();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.progress = 0.0;
        this.destroyTime = this.level.getBlockState(this.targetBlock).getBlock().defaultDestroyTime();
    }

    public void stop() {
        if (this.targetBlock != null) {
            this.level.destroyBlockProgress(this.monster.getId(), this.targetBlock, -1);
            this.targetBlock = null;
        }
        this.monster.getNavigation().recomputePath();
    }

    public void tick() {
        if (this.targetBlock != null && this.monster.getTarget() != null) {
            double distance = this.monster.distanceToSqr((Entity)this.monster.getTarget());
            if (distance > (double)0.3f && distance < 50.0) {
                this.monster.swing(InteractionHand.MAIN_HAND);
                this.progress += 0.1;
                if (this.progress >= this.destroyTime) {
                    this.level.destroyBlock(this.targetBlock, true, this.monster);
                    this.level.destroyBlockProgress(this.monster.getId(), this.targetBlock, -1);
                    this.monster.getNavigation().recomputePath();
                } else {
                    this.monster.stopInPlace();
                    this.monster.getLookControl().setLookAt((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ());
                    this.level.destroyBlockProgress(this.monster.getId(), this.targetBlock, (int)(this.progress / this.destroyTime * 10.0));
                    return;
                }
            }
            this.targetBlock = null;
        }
    }

    public boolean canContinueToUse() {
        return this.canReach(this.targetBlock);
    }

    private boolean canReach(BlockPos blockPos) {
        return blockPos != null && this.monster.distanceToSqr(blockPos.getCenter()) <= 9.0;
    }

    public boolean canUse() {
        if (this.targetBlock != null) {
            return true;
        }
        if (this.monster.getTarget() != null && this.monster.isAlive() && !this.monster.isNoAi() && (this.monster.getNavigation().isDone() || this.monster.getNavigation().isStuck())) {
            Vec3 center = this.monster.getTarget().blockPosition().getCenter().subtract(this.monster.blockPosition().getCenter());
            BlockPos blockPos = this.monster.blockPosition().offset(Double.compare(center.x, 0.0), Double.compare(center.y, 0.0), Double.compare(center.z, 0.0));
            for (int x = 0; x < this.patternXZSize; ++x) {
                for (int z = 0; z < this.patternXZSize; ++z) {
                    for (int y = 0; y < this.patternYSize; ++y) {
                        if (!this.isBreakable(blockPos.offset(this.patternXZ[x], this.patternY[y], this.patternXZ[z]))) continue;
                        return Util.random.nextDouble() > 0.25;
                    }
                }
            }
        }
        return false;
    }

    boolean isBreakable(BlockPos blockPos) {
        float destroyTime;
        BlockState state = this.level.getBlockState(blockPos);
        if (state != Blocks.AIR.defaultBlockState() && state != Blocks.BARRIER.defaultBlockState() && state != Blocks.BEDROCK.defaultBlockState() && (destroyTime = state.getBlock().defaultDestroyTime()) >= 0.0f && destroyTime <= 50.0f && this.canReach(blockPos)) {
            this.targetBlock = blockPos;
            return true;
        }
        return false;
    }
}

