/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.ai;

import com.crackerjackbox.mobcontrol.iface.IBat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class GenericAttackGoal
extends Goal {
    private final Mob mob;

    public GenericAttackGoal(Mob mob) {
        this.mob = mob;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUse() {
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity == null) return false;
        if (!livingEntity.isAlive()) return false;
        if (!(livingEntity instanceof Player)) return true;
        Player player = (Player)livingEntity;
        if (livingEntity.isSpectator()) return false;
        if (player.isCreative()) return false;
        return true;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
    }

    public void stop() {
        this.mob.setTarget(null);
    }

    public void tick() {
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity != null) {
            Mob mob = this.mob;
            if (mob instanceof IBat) {
                IBat bat = (IBat)mob;
                bat.mobControl$setTagetPosition(livingEntity.blockPosition());
            }
            if (this.mob.getBoundingBox().inflate((double)0.3f).intersects(livingEntity.getBoundingBox())) {
                this.mob.doHurtTarget((Entity)livingEntity);
            }
        }
    }
}

