/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.data.Range;
import com.crackerjackbox.mobcontrol.data.Weighted;
import com.crackerjackbox.mobcontrol.data.WeightedItem;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IServerLevel;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExCodec;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Util {
    public static final HashMap<String, Long> lastTicks = new HashMap();
    public static boolean isGenerating = false;
    public static Random random = new Random();
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(MobEx.class, (Object)new MobExCodec()).create();

    public static MobEx getMobEx(ResourceLocation key) {
        MobEx exactMob = Config.mobs.getOrDefault(key.getNamespace() + ":" + key.getPath(), null);
        MobEx exactMod = Config.mobs.getOrDefault(key.getNamespace() + ":*", null);
        MobEx allWildOrNull = Config.mobs.getOrDefault("*:*", Config.mobs.getOrDefault("*", null));
        return exactMob != null ? exactMob : (exactMod != null ? exactMod : allWildOrNull);
    }

    public static void setRandomItem(Mob mob, EquipmentSlot equipmentSlot, Weighted items) {
        if (items != null) {
            WeightedItem weightedItem = items.getWeightedItem();
            ItemStack itemStack = Util.getRandomItemStack((ServerLevel)mob.level(), weightedItem);
            if (itemStack != null) {
                mob.setItemSlot(equipmentSlot, itemStack);
                if (weightedItem.drop() > 0) {
                    ((IMob)mob).mobControl$addDeathLoot(weightedItem);
                }
            }
        }
    }

    public static ItemStack getRandomItemStack(ServerLevel level, WeightedItem weightedItem) {
        if (weightedItem != null) {
            String itemName = weightedItem.key();
            CommandBuildContext context = CommandBuildContext.simple((HolderLookup.Provider)level.registryAccess(), (FeatureFlagSet)FeatureFlags.VANILLA_SET);
            ItemArgument itemArgument = new ItemArgument(context);
            try {
                ItemInput itemInput = itemArgument.parse(new StringReader(itemName));
                return itemInput.createItemStack(1, false);
            }
            catch (CommandSyntaxException ex) {
                Constants.LOG.error("Error getting item stack", (Throwable)ex);
            }
        }
        return null;
    }

    public static <T> T getRandomElement(ArrayList<T> array) {
        return array.get(random.nextInt(0, array.size()));
    }

    public static ArrayList<ResourceLocation> getStructures(ServerLevel serverLevel, BlockPos pos) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        Registry structureRegistry = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE);
        serverLevel.structureManager().getAllStructuresAt(pos).forEach((structure, set) -> {
            ResourceLocation resourceLocation = structureRegistry.getKey(structure);
            if (resourceLocation != null) {
                resourceLocations.add(resourceLocation);
            }
        });
        return resourceLocations;
    }

    public static ArrayList<ResourceLocation> getBiomeTags(ServerLevel serverLevel, BlockPos pos) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        serverLevel.getBiome(pos).tags().forEach(tagKeyBiome -> resourceLocations.add(tagKeyBiome.location()));
        return resourceLocations;
    }

    public static String getReasonSpawnType(String spawnReason) {
        if (spawnReason.equals(MobSpawnType.SPAWNER.toString()) || spawnReason.equals(MobSpawnType.TRIAL_SPAWNER.toString())) {
            return "spawner";
        }
        if (spawnReason.equals(Constants.ReasonControl)) {
            return "control";
        }
        return "natural";
    }

    public static boolean isValidMob(ServerLevel serverLevel, Mob mob, String spawnReason) {
        return Util.setMob(serverLevel, mob, null, null, spawnReason, true);
    }

    public static boolean isValidMob(ServerLevel serverLevel, ResourceLocation mobResourceLocation, BlockPos pos, String spawnReason) {
        return Util.setMob(serverLevel, null, mobResourceLocation, pos, spawnReason, true);
    }

    public static boolean setMob(ServerLevel serverLevel, Mob mob, double x, double y, double z) {
        MobExRule mobExRule = ((IMob)mob).mobControl$getRule();
        if (mobExRule == null) {
            if (((IMob)mob).mobControl$getMobSpawn() == null || ((IMob)mob).mobControl$getMobSpawn().reason == null) {
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(MobSpawnType.NATURAL.toString()));
            }
            String spawnReason = ((IMob)mob).mobControl$getMobSpawn().reason;
            Constants.LOG.debug("setMob: Checking rules for {}, reason {}, id {}", new Object[]{mob.getName().getString(), spawnReason, mob.getUUID()});
            if (spawnReason.equals(MobSpawnType.CONVERSION.toString()) || spawnReason.equals(Constants.ReasonOverride)) {
                return true;
            }
            if (Util.setMob(serverLevel, mob, null, null, spawnReason, false)) {
                Constants.LOG.debug("setMob: {} has been allowed, reason {}, id {}, loc {} {} {}", new Object[]{mob.getName().getString(), spawnReason, mob.getUUID(), (int)x, (int)y, (int)z});
                return true;
            }
            if (!Constants.ReasonControl.equals(spawnReason)) {
                Constants.LOG.debug("setMob: {} has been canceled, reason {}, id {}", new Object[]{mob.getName().getString(), spawnReason, mob.getUUID()});
                if (MobSpawnType.NATURAL.toString().equals(spawnReason) && mob.getType() == EntityType.ENDER_DRAGON && serverLevel.getDragonFight() != null) {
                    Constants.LOG.debug("Canceled ender dragon boss fight due to no rule allowing ender dragon");
                    ((IMob)mob).mobControl$setCancelBossFight(true);
                    serverLevel.getDragonFight().setDragonKilled((EnderDragon)mob);
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean setMob(ServerLevel serverLevel, Mob mob, ResourceLocation mobResourceLocation, BlockPos pos, String spawnReason, boolean checkOnly) {
        try {
            if (Util.isGenerating) {
                Constants.LOG.debug("setMob: Ignoring due to isGenerating");
                return false;
            }
            if (mob != null) {
                pos = mob.blockPosition();
                if (mobResourceLocation == null) {
                    mobResourceLocation = EntityType.getKey((EntityType)mob.getType());
                }
            }
            if (mobResourceLocation == null) {
                Constants.LOG.debug("setMob: resourceLocation == null");
                return false;
            }
            mobEx = Util.getMobEx(mobResourceLocation);
            if (mobEx == null) {
                Constants.LOG.debug("setMob: mobEx == null");
                return false;
            }
            currentTick = serverLevel.getGameTime();
            mobName = mobResourceLocation.getNamespace() + ":" + mobResourceLocation.getPath();
            simpleSpawnReason = Util.getReasonSpawnType(spawnReason);
            iServerLevel = (IServerLevel)serverLevel;
            willRandomizePosition = List.of(Constants.ReasonControl, MobSpawnType.SPAWNER.toString()).contains(spawnReason);
            currentWeather = serverLevel.isRaining() != false ? "rain" : (serverLevel.isThundering() != false ? "thunderstorm" : "clear");
            Constants.LOG.debug("setMob: Checking rule {}, mobExName {}, reason {}, have mob {}, check {} @ {} {} {}", new Object[]{mobEx.name(), mobName, spawnReason, mob != null, checkOnly, pos.getX(), pos.getY(), pos.getZ()});
            for (MobExRule mobExRule : mobEx.rules) {
                block42: {
                    repeat = mobExRule.repeatFrom == null || mobExRule.repeatTo == null ? ((mobExRule.type.contains("all") || mobExRule.type.contains("spawner")) && spawnReason.equals(MobSpawnType.SPAWNER.toString()) ? Range.of(200, 800) : Range.of(0, 0)) : Range.of(mobExRule.repeatFrom, mobExRule.repeatTo);
                    if (willRandomizePosition && repeat.getMaximum() == 0) {
                        Constants.LOG.debug("setMob: Skipping rule due to repeat of 0 & being a control/spawner, rule {}, name {}, reason {}", new Object[]{mobEx.name(), mobName, spawnReason});
                        continue;
                    }
                    if (!(mobExRule.type.contains("all") || mobExRule.type.contains("block") || List.of(MobSpawnType.COMMAND.toString(), MobSpawnType.CONVERSION.toString(), MobSpawnType.SPAWN_EGG.toString()).contains(spawnReason) || mobExRule.type.contains(simpleSpawnReason))) {
                        if (spawnReason.equals(Constants.ReasonControl)) continue;
                        Constants.LOG.debug("setMob: Skipping rule due to wrong type of {}, rule {}, name {}, reason {}", new Object[]{mobExRule.type, mobEx.name(), mobName, spawnReason});
                        continue;
                    }
                    if (spawnReason.equals(MobSpawnType.CONVERSION.toString())) break block42;
                    if (mobExRule.type.contains("block")) {
                        Constants.LOG.debug("setMob: Match a block rule {}, rule {}, name {}, reason {}", new Object[]{mobExRule.type, mobEx.name(), mobName, spawnReason});
                        return false;
                    }
                    v0 = mobExRule.spawn.countFrom == null || mobExRule.spawn.countTo == null ? MobEx.randomFromRange(1, spawnReason.equals(MobSpawnType.SPAWNER.toString()) != false ? 4 : 1) : (spawnCount = MobEx.randomFromRange(mobExRule.spawn.countFrom, mobExRule.spawn.countTo));
                    if (spawnCount <= 0) {
                        Constants.LOG.debug("canCreateMob: Skipping due to spawn count {} is less than 1 from [{},{}]", new Object[]{spawnCount, mobExRule.spawn.countFrom, mobExRule.spawn.countTo});
                        continue;
                    }
                    currentDimension = serverLevel.dimension().location();
                    if (!(mobExRule.dimension == null || mobExRule.dimension.contains(currentDimension.getNamespace() + ":" + currentDimension.getPath()) || mobExRule.dimension.contains(currentDimension.getNamespace() + ":*") || mobExRule.dimension.contains("*:*") || mobExRule.dimension.contains("*"))) {
                        Constants.LOG.debug("canCreateMob: Skipping due to dimension {}:{} not in {}", new Object[]{currentDimension.getNamespace(), currentDimension.getPath(), String.join((CharSequence)", ", mobExRule.dimension)});
                        continue;
                    }
                    if (serverLevel.getBiomeManager().getBiome(pos).unwrapKey().isPresent()) {
                        currentBiome = ((ResourceKey)serverLevel.getBiomeManager().getBiome(pos).unwrapKey().get()).location();
                        if (!(mobExRule.biome == null || mobExRule.biome.contains(currentBiome.getNamespace() + ":" + currentBiome.getPath()) || mobExRule.biome.contains(currentBiome.getNamespace() + ":*") || mobExRule.biome.contains("*:*") || mobExRule.biome.contains("*"))) {
                            Constants.LOG.debug("canCreateMob: Skipping due to biome {}:{} not in {}", new Object[]{currentBiome.getNamespace(), currentBiome.getPath(), String.join((CharSequence)", ", mobExRule.biome)});
                            continue;
                        }
                    }
                    if (mobExRule.biomeTag != null) {
                        foundBiomeTags = Util.getBiomeTags(serverLevel, pos);
                        passedBiomeTagCheck = false;
                        for (ResourceLocation structureToCheck : foundBiomeTags) {
                            if (!mobExRule.biomeTag.contains(structureToCheck.getNamespace() + ":" + structureToCheck.getPath()) && !mobExRule.biomeTag.contains(structureToCheck.getNamespace() + ":*") && !mobExRule.biomeTag.contains("*:*") && !mobExRule.biomeTag.contains("*")) continue;
                            passedBiomeTagCheck = true;
                            break;
                        }
                        if (!passedBiomeTagCheck) {
                            Constants.LOG.debug("canCreateMob: Skipping due to biome tags are not in {}", (Object)String.join((CharSequence)", ", mobExRule.biomeTag));
                            continue;
                        }
                    }
                    if (mobExRule.structure != null) {
                        foundStructures = Util.getStructures(serverLevel, pos);
                        if (mobExRule.structure.contains("none") && !foundStructures.isEmpty()) {
                            Constants.LOG.debug("canCreateMob: Skipping due to finding structures with {}", (Object)String.join((CharSequence)", ", mobExRule.structure));
                            continue;
                        }
                        passedStructureCheck = false;
                        for (ResourceLocation structureToCheck : foundStructures) {
                            if (!mobExRule.structure.contains(structureToCheck.getNamespace() + ":" + structureToCheck.getPath()) && !mobExRule.structure.contains(structureToCheck.getNamespace() + ":*") && !mobExRule.structure.contains("*:*") && !mobExRule.structure.contains("*")) continue;
                            passedStructureCheck = true;
                            break;
                        }
                        if (!passedStructureCheck) {
                            Constants.LOG.debug("canCreateMob: Skipping due to not find any of the following structures {}", (Object)String.join((CharSequence)", ", mobExRule.structure));
                            continue;
                        }
                    }
                    if (mobExRule.weather != null && !mobExRule.weather.contains(currentWeather)) {
                        Constants.LOG.debug("canCreateMob: Skipping due to weather {} not in {}", (Object)currentWeather, (Object)String.join((CharSequence)", ", mobExRule.weather));
                        continue;
                    }
                    if (!(mob instanceof IMob)) ** GOTO lbl-1000
                    iMob = (IMob)mob;
                    if (iMob.mobControl$getMobSpawn().dayCheck != null) {
                        v1 = iMob.mobControl$getMobSpawn().dayCheck;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = currentDays = Long.valueOf(iServerLevel.mobControl$savedData() == null ? 0L : iServerLevel.mobControl$savedData().getTicks() / 24000L);
                    }
                    if (mobExRule.dayFrom != null && mobExRule.dayTo != null && (currentDays < (long)mobExRule.dayFrom.intValue() || currentDays > (long)mobExRule.dayTo.intValue())) {
                        Constants.LOG.debug("setMob: Skipping due to day {} not between {}-{}", new Object[]{currentDays, mobExRule.dayFrom, mobExRule.dayTo});
                        continue;
                    }
                    currentTimeOfDay = serverLevel.getLevelData().getDayTime() % 24000L;
                    if (mobExRule.timeOfDayFrom != null && mobExRule.timeOfDayTo != null && (currentTimeOfDay < (long)mobExRule.timeOfDayFrom.intValue() || currentTimeOfDay > (long)mobExRule.timeOfDayTo.intValue())) {
                        Constants.LOG.debug("setMob: Skipping due to time of day {} not between {}-{}", new Object[]{currentTimeOfDay, mobExRule.timeOfDayFrom, mobExRule.timeOfDayTo});
                        continue;
                    }
                    if (!willRandomizePosition && !Util.positionalRuleChecks(serverLevel, mobExRule, pos)) continue;
                    currentPerMob = Constants.MOB_STATS.getOrDefault(mobResourceLocation.toString(), 0L);
                    if (mobExRule.maxPerMob != null && (currentPerMob += (long)spawnCount) > (long)mobExRule.maxPerMob.intValue()) {
                        Constants.LOG.debug("setMob: Skipping due to max per mob {} is greater than {}", (Object)currentPerMob, (Object)mobExRule.maxPerMob);
                        continue;
                    }
                    playerCount = serverLevel.players().size();
                    if (mobExRule.maxPerPlayer != null && currentPerMob > (long)mobExRule.maxPerPlayer.intValue() * (long)playerCount) {
                        Constants.LOG.debug("setMob: Skipping due to max per player {} is greater than {}", (Object)currentPerMob, (Object)(mobExRule.maxPerPlayer * playerCount));
                        continue;
                    }
                    if (!spawnReason.equals(MobSpawnType.TRIAL_SPAWNER.toString()) && willRandomizePosition && repeat.getMaximum() > 0) {
                        tickName = spawnReason + ":" + mobExRule.name + ":" + repeat.getMinimum() + ":" + repeat.getMaximum() + ":" + mobName;
                        lastTickValue = Util.getLastTick(tickName);
                        if (lastTickValue == null || lastTickValue == 0L) {
                            Util.setLastTick(tickName, currentTick);
                            Constants.LOG.debug("setMob: Rule ignored due to seeding, type \"{}\", rule {}, tick name {}, reason {}", new Object[]{String.join((CharSequence)",", mobExRule.type), mobEx.name(), tickName, spawnReason});
                            continue;
                        }
                        repeatTicks = MobEx.randomFromRange(repeat.getMinimum(), repeat.getMaximum());
                        if (currentTick < lastTickValue + (long)repeatTicks) {
                            Constants.LOG.debug("setMob: Rule ignored due to delaying, type \"{}\", rule {}, tick name {}, reason {}, c {}, l {}, r {}", new Object[]{String.join((CharSequence)",", mobExRule.type), mobEx.name(), tickName, spawnReason, currentTick, lastTickValue, repeatTicks});
                            continue;
                        }
                        Util.setLastTick(tickName, currentTick);
                        Constants.LOG.debug("setMob: Ticking {}, rule {}, reason {}, current {}, repeat {}, last {}, tick name {}, id {}", new Object[]{mobName, mobEx.name(), spawnReason, currentTick, repeatTicks, Util.getLastTick(tickName), tickName, mob != null ? mob.getUUID() : "n/a"});
                    }
                    if (!MobEx.can(mobExRule.run)) {
                        Constants.LOG.debug("setMob: Would have passed, but blocked by run probability {}, rule {}, reason {}, type \"{}\"", new Object[]{mobName, mobEx.name(), spawnReason, String.join((CharSequence)",", mobExRule.type)});
                        continue;
                    }
                    Constants.LOG.debug("setMob: Passed {}, rule {}, reason {}, type \"{}\"", new Object[]{mobName, mobEx.name(), spawnReason, String.join((CharSequence)",", mobExRule.type)});
                    if (!checkOnly && mob != null) {
                        Constants.LOG.debug("setMob: Count 1 of {}, reason {}, id {}, rule name {}, health {}", new Object[]{spawnCount, spawnReason, mob.getUUID(), mobExRule.name, mobExRule.set.healthTo});
                        Util.mobSet(mob, mobExRule);
                        mobAtY = mob.blockPosition().getY();
                        if (willRandomizePosition) {
                            distanceXFrom = distanceZFrom = mobExRule.spawn.distanceXFrom.intValue();
                            distanceXTo = distanceZTo = mobExRule.spawn.distanceXTo.intValue();
                            atYFrom = mobExRule.spawn.atYFrom;
                            atYTo = mobExRule.spawn.atYTo;
                            if (spawnReason.equals(MobSpawnType.SPAWNER.toString())) {
                                if (mobExRule.spawn.distanceXFrom == 50 && mobExRule.spawn.distanceXTo == 256 && mobExRule.spawn.distanceZFrom == 50 && mobExRule.spawn.distanceZTo == 256) {
                                    distanceZFrom = 0;
                                    distanceXFrom = 0;
                                    distanceZTo = 4;
                                    distanceXTo = 4;
                                }
                                if (mobExRule.spawn.atYFrom == -256 && mobExRule.spawn.atYTo == 256) {
                                    atYFrom = mobAtY - (mobExRule.spawn.distanceY + 1);
                                    atYTo = mobAtY + mobExRule.spawn.distanceY + 1;
                                }
                            }
                            if (!Util.setMobLocation(serverLevel, mob, mobExRule, spawnReason, mob.getX() + (double)(MobEx.randomFromRange(distanceXFrom, distanceXTo) * (Util.random.nextBoolean() != false ? 1 : -1)), mobAtY, mob.getZ() + (double)(MobEx.randomFromRange(distanceZFrom, distanceZTo) * (Util.random.nextBoolean() != false ? 1 : -1)), atYFrom, atYTo)) {
                                continue;
                            }
                        } else if (mobAtY < mobExRule.spawn.atYFrom || mobAtY > mobExRule.spawn.atYTo) {
                            Constants.LOG.debug("setMob: Failed due to y-axis of {} is not between {} to {}", new Object[]{mobAtY, mobExRule.spawn.atYFrom, mobExRule.spawn.atYTo});
                            continue;
                        }
                        for (mobIndex = 0; mobIndex < spawnCount - 1; ++mobIndex) {
                            Constants.LOG.debug("setMob: New {} of {}, reason {}", new Object[]{mobIndex + 2, spawnCount, spawnReason});
                            entity = mob.getType().create((Level)serverLevel);
                            if (!(entity instanceof Mob)) continue;
                            newMob = (Mob)entity;
                            ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonOverride));
                            Constants.LOG.debug("setMob: Count {} of {}, reason {}, id {}", new Object[]{mobIndex + 2, spawnCount, spawnReason, newMob.getUUID()});
                            Util.mobSet(newMob, mobExRule);
                            ((IMob)mob).mobControl$addMob(newMob);
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception ex) {
            Constants.LOG.error("setMob: Exception", (Throwable)ex);
        }
        return false;
    }

    private static boolean positionalRuleChecks(ServerLevel serverLevel, MobExRule mobExRule, BlockPos pos) {
        int currentLightSky = serverLevel.getBrightness(LightLayer.SKY, pos);
        if (mobExRule.lightSkyFrom != null && (currentLightSky < mobExRule.lightSkyFrom || currentLightSky > mobExRule.lightSkyTo)) {
            Constants.LOG.debug("setMob: Skipping due to light sky {} not between {}-{}", new Object[]{currentLightSky, mobExRule.lightSkyFrom, mobExRule.lightSkyTo});
            return false;
        }
        int currentLightBlock = serverLevel.getBrightness(LightLayer.BLOCK, pos);
        if (mobExRule.lightBlockFrom != null && (currentLightBlock < mobExRule.lightBlockFrom || currentLightBlock > mobExRule.lightBlockTo)) {
            Constants.LOG.debug("setMob: Skipping due to light block {} not between {}-{}", new Object[]{currentLightBlock, mobExRule.lightBlockFrom, mobExRule.lightBlockTo});
            return false;
        }
        return true;
    }

    private static Long getLastTick(String name) {
        return lastTicks.get(name);
    }

    private static void setLastTick(String name, Long value) {
        lastTicks.put(name, value);
    }

    public static boolean isInWall(ServerLevel serverLevel, Mob mob) {
        return Util.isInWall(serverLevel, mob, mob.getEyePosition());
    }

    public static boolean isInWall(ServerLevel serverLevel, Mob mob, Vec3 position) {
        float width = mob.getBbWidth() * 0.8f;
        AABB box = AABB.ofSize((Vec3)position, (double)width, (double)1.0E-6f, (double)width);
        return BlockPos.betweenClosedStream((AABB)box).anyMatch(blockPos -> {
            BlockState blockState = serverLevel.getBlockState(blockPos);
            return !blockState.isAir() && blockState.isSuffocating((BlockGetter)serverLevel, blockPos) && Shapes.joinIsNotEmpty((VoxelShape)blockState.getCollisionShape((BlockGetter)serverLevel, blockPos).move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (VoxelShape)Shapes.create((AABB)box), (BooleanOp)BooleanOp.AND);
        });
    }

    public static boolean validSpawnPlacement(ServerLevel serverLevel, SpawnPlacementType spawnPlacementType, Mob mob, MobExRule mobExRule, String spawnReason) {
        if (mobExRule.spawn.additionalChecks != null && mobExRule.spawn.additionalChecks.booleanValue() && !mob.checkSpawnObstruction((LevelReader)serverLevel)) {
            return false;
        }
        if (!Util.positionalRuleChecks(serverLevel, mobExRule, mob.blockPosition())) {
            return false;
        }
        FluidState fluidState = serverLevel.getFluidState(mob.blockPosition().below());
        if (spawnPlacementType == SpawnPlacementTypes.IN_WATER || spawnPlacementType == SpawnPlacementTypes.IN_LAVA) {
            Constants.LOG.debug("validSpawnPlacement: WATER or LAVA");
            return fluidState.is(spawnPlacementType == SpawnPlacementTypes.IN_WATER ? FluidTags.WATER : FluidTags.LAVA);
        }
        if (spawnPlacementType == SpawnPlacementTypes.ON_GROUND) {
            Constants.LOG.debug("validSpawnPlacement: GROUND");
            if (!fluidState.isEmpty() && (fluidState.is(FluidTags.WATER) || fluidState.is(FluidTags.LAVA)) || Util.isInWall(serverLevel, mob)) {
                return false;
            }
            return serverLevel.getBlockState(mob.blockPosition()).isAir() && serverLevel.getBlockState(mob.blockPosition().above()).isAir() && (spawnReason.equals(MobSpawnType.SPAWNER.toString()) || !serverLevel.getBlockState(mob.blockPosition().below()).isAir() && !serverLevel.getBlockState(mob.blockPosition().below()).is(BlockTags.LEAVES));
        }
        Constants.LOG.debug("validSpawnPlacement: OTHER");
        return !Util.isInWall(serverLevel, mob);
    }

    public static boolean setMobLocation(ServerLevel serverLevel, Mob mob, MobExRule mobExRule, String spawnReason, double x, double sourceY, double z, double atYFrom, double atYTo) {
        SpawnPlacementType spawnPlacementType = SpawnPlacements.getPlacementType((EntityType)mob.getType());
        if (mob instanceof Bat) {
            spawnPlacementType = SpawnPlacementTypes.NO_RESTRICTIONS;
        }
        boolean foundPlacement = false;
        Constants.LOG.debug("mobFixLocation: Placement up @ {} {} {}", new Object[]{x, sourceY, z});
        double yCheck = sourceY + (double)mobExRule.spawn.distanceY.intValue();
        if (yCheck < atYFrom) {
            yCheck = atYFrom;
        }
        while (!foundPlacement && yCheck <= atYTo && !serverLevel.getBlockState(mob.blockPosition()).is(Blocks.BEDROCK)) {
            mob.setPosRaw(x, yCheck, z);
            if (Util.validSpawnPlacement(serverLevel, spawnPlacementType, mob, mobExRule, spawnReason)) {
                foundPlacement = true;
                continue;
            }
            yCheck += 1.0;
        }
        if (!foundPlacement) {
            Constants.LOG.debug("mobFixLocation: Placement down");
            yCheck = sourceY - 1.0 - (double)mobExRule.spawn.distanceY.intValue();
            if (yCheck > atYTo) {
                yCheck = atYTo;
            }
            mob.setPosRaw(x, yCheck, z);
            while (!foundPlacement && yCheck >= atYFrom && !serverLevel.getBlockState(mob.blockPosition()).is(Blocks.BEDROCK)) {
                mob.setPosRaw(x, yCheck, z);
                if (Util.validSpawnPlacement(serverLevel, spawnPlacementType, mob, mobExRule, spawnReason)) {
                    foundPlacement = true;
                    continue;
                }
                yCheck -= 1.0;
            }
        }
        if (foundPlacement) {
            Constants.LOG.debug("mobFixLocation: mob.moveTo {} {} {}", new Object[]{x, yCheck, z});
            mob.setPosRaw(x, yCheck, z);
            mob.setYRot(random.nextFloat() * 360.0f);
            mob.setXRot(190.0f);
            mob.setOldPosAndRot();
            mob.setPos(mob.position().x, mob.position().y, mob.position().z);
            return true;
        }
        Constants.LOG.debug("mobFixLocation: no safe placement {} {} {}, distance y {}, at {} to {}", new Object[]{x, sourceY, z, mobExRule.spawn.distanceY, atYFrom, atYTo});
        return false;
    }

    private static void mobSet(Mob mob, MobExRule mobExRule) {
        AttributeInstance attribute;
        ((IMob)mob).mobControl$setRule(mobExRule);
        if (mobExRule.set.sizeFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.SCALE)) != null) {
            attribute.setBaseValue(0.01 * (double)MobEx.randomFromRange(mobExRule.set.sizeFrom, mobExRule.set.sizeTo));
            mob.refreshDimensions();
        }
    }
}

