/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.ai.BreakBlocksGoal;
import com.crackerjackbox.mobcontrol.ai.GenericAttackGoal;
import com.crackerjackbox.mobcontrol.ai.GenericHurtByTargetGoal;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.data.Weighted;
import com.crackerjackbox.mobcontrol.data.WeightedItem;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.crackerjackbox.mobcontrol.rule.MobExSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMix
implements IMob {
    @Unique
    private MobSpawn mobControl$mobSpawn = null;
    @Unique
    private MobExRule mobControl$mobExRule = null;
    @Unique
    private long mobControl$lastPlacedTick = 0L;
    @Unique
    private boolean mobControl$cancelBossFight = false;
    @Shadow
    protected int xpReward;
    @Shadow
    @Final
    protected GoalSelector targetSelector;
    @Shadow
    @Final
    protected GoalSelector goalSelector;
    @Shadow
    protected PathNavigation navigation;
    @Unique
    private final ArrayList<Mob> mobControl$secondaryMobs = new ArrayList();
    @Unique
    private final ArrayList<WeightedItem> mobControl$deathLoot = new ArrayList();

    @Shadow
    public abstract LivingEntity getTarget();

    @Shadow
    public abstract void removeAllGoals(Predicate<Goal> var1);

    @Shadow
    public abstract void setTarget(@Nullable LivingEntity var1);

    @Shadow
    protected abstract void populateDefaultEquipmentSlots(RandomSource var1, DifficultyInstance var2);

    @Override
    @Unique
    public MobSpawn mobControl$getMobSpawn() {
        return this.mobControl$mobSpawn;
    }

    @Override
    @Unique
    public void mobControl$setMobSpawn(MobSpawn value) {
        this.mobControl$mobSpawn = value;
    }

    @Override
    @Unique
    public MobExRule mobControl$getRule() {
        return this.mobControl$mobExRule;
    }

    @Override
    @Unique
    public void mobControl$setRule(MobExRule value) {
        this.mobControl$mobExRule = (MobExRule)Util.gson.fromJson(Util.gson.toJson((Object)value), MobExRule.class);
    }

    @Override
    public void mobControl$addMob(Mob newMob) {
        this.mobControl$secondaryMobs.add(newMob);
    }

    @Override
    public void mobControl$addDeathLoot(WeightedItem weightedItem) {
        this.mobControl$deathLoot.add(weightedItem);
    }

    @Override
    @Unique
    public void mobControl$setCancelBossFight(boolean value) {
        this.mobControl$cancelBossFight = value;
    }

    @Override
    @Unique
    public boolean mobControl$getCancelBossFight() {
        return this.mobControl$cancelBossFight;
    }

    @Inject(method={"convertTo"}, at={@At(value="RETURN")})
    private <T extends Mob> void convertTo(EntityType<T> entityType, boolean transferInventory, CallbackInfoReturnable<T> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof Mob) {
            Mob convertedMob = (Mob)object;
            if (this.mobControl$mobExRule != null) {
                ((IMob)convertedMob).mobControl$setRule(this.mobControl$mobExRule);
                ((IMob)convertedMob).mobControl$getRule().converting = true;
            }
        }
    }

    @Inject(method={"dropCustomDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean recentlyHit, CallbackInfo ci) {
        MobExRule mobExRule;
        Mob mob = (Mob)this;
        if (mob.blockPosition() != null && (mobExRule = this.mobControl$getRule()) != null) {
            if (mobExRule.loot != null && mobExRule.loot.any()) {
                Constants.LOG.debug("Dropping loot for {}", (Object)mobExRule.mobExName);
                mobExRule.loot.getWeightedGroupItems().forEach(loot -> this.mobControl$dropItem(serverLevel, mob.blockPosition(), (WeightedItem)loot));
                ci.cancel();
            }
            if (!this.mobControl$deathLoot.isEmpty()) {
                this.mobControl$deathLoot.forEach(loot -> {
                    if (MobEx.can(loot.drop())) {
                        this.mobControl$dropItem(serverLevel, mob.blockPosition(), (WeightedItem)loot);
                        ci.cancel();
                    }
                });
            }
        }
        if (this.mobControl$cancelBossFight && serverLevel.getDragonFight() != null) {
            serverLevel.getDragonFight().setDragonKilled(null);
        }
    }

    @Unique
    private void mobControl$dropItem(ServerLevel level, BlockPos position, WeightedItem loot) {
        ItemStack itemStack;
        if (loot.quantityTo() != 0 && (itemStack = Util.getRandomItemStack(level, loot)) != null) {
            itemStack.setCount(MobEx.randomFromRange(loot.quantityFrom(), loot.quantityTo()));
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)position.getX(), (double)position.getY(), (double)position.getZ(), itemStack);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    @Inject(method={"createMobAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createMobAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        cir.setReturnValue((Object)((AttributeSupplier.Builder)cir.getReturnValue()).add(Attributes.ATTACK_DAMAGE));
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void setTarget(LivingEntity target, CallbackInfo ci) {
        Mob mob;
        if (this.mobControl$mobExRule != null && this.mobControl$mobExRule.set.attack != null && !this.mobControl$mobExRule.set.attack.contains("player") && !((mob = (Mob)this).getLastHurtByMob() instanceof Player) && target instanceof Player) {
            ci.cancel();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void baseTick(CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (this.mobControl$mobExRule != null) {
            this.mobControl$mobExRule.currentHealth = mob.getHealth();
            if (!this.mobControl$mobExRule.hasLoaded) {
                MobMix mobMix;
                AttributeInstance attribute;
                Entity entity;
                Object newMobType;
                this.mobControl$mobExRule.hasLoaded = true;
                Constants.LOG.debug("setMob: Finalizing {}, rule {}", (Object)mob.getName().getString(), (Object)this.mobControl$mobExRule.name);
                if (this.mobControl$mobExRule.spawn.convert != null && ((Optional)(newMobType = EntityType.byString((String)Util.getRandomElement(this.mobControl$mobExRule.spawn.convert)))).isPresent() && mob.getType() != ((Optional)newMobType).get() && (entity = ((EntityType)((Optional)newMobType).get()).create(mob.level())) instanceof IMob) {
                    IMob iMob = (IMob)entity;
                    iMob.mobControl$setRule(this.mobControl$mobExRule);
                    iMob.mobControl$setMobSpawn(new MobSpawn(MobSpawnType.CONVERSION.toString()));
                    ((Mob)iMob).setPos(mob.position());
                    if (mob.getType().equals(EntityType.ENDER_DRAGON)) {
                        iMob.mobControl$setCancelBossFight(true);
                    }
                    mob.level().addFreshEntity(entity);
                    mob.discard();
                    mob.setHealth(0.0f);
                }
                mob.resetFallDistance();
                if (!this.mobControl$secondaryMobs.isEmpty()) {
                    for (Mob mob2 : this.mobControl$secondaryMobs) {
                        if (mob.isDeadOrDying()) {
                            mob2.discard();
                            mob2.setHealth(0.0f);
                            continue;
                        }
                        mob2.setPos(mob.position());
                        mob.level().addFreshEntity((Entity)mob2);
                    }
                    this.mobControl$secondaryMobs.clear();
                }
                if (mob instanceof Animal) {
                    Util.setRandomItem(mob, EquipmentSlot.BODY, this.mobControl$mobExRule.chest);
                }
                this.populateDefaultEquipmentSlots(mob.level().random, mob.level().getCurrentDifficultyAt(mob.blockPosition()));
                Util.setRandomItem(mob, EquipmentSlot.HEAD, this.mobControl$mobExRule.head);
                Util.setRandomItem(mob, EquipmentSlot.CHEST, this.mobControl$mobExRule.chest);
                Util.setRandomItem(mob, EquipmentSlot.LEGS, this.mobControl$mobExRule.legs);
                Util.setRandomItem(mob, EquipmentSlot.FEET, this.mobControl$mobExRule.feet);
                Util.setRandomItem(mob, EquipmentSlot.MAINHAND, this.mobControl$mobExRule.mainhand);
                Util.setRandomItem(mob, EquipmentSlot.OFFHAND, this.mobControl$mobExRule.offhand);
                if (this.mobControl$mobExRule.set.baby != null) {
                    mob.setBaby(MobEx.can(this.mobControl$mobExRule.set.baby));
                }
                if (this.mobControl$mobExRule.set.xpFrom != null) {
                    this.xpReward = MobEx.randomFromRange(this.mobControl$mobExRule.set.xpFrom, this.mobControl$mobExRule.set.xpTo);
                }
                if (this.mobControl$mobExRule.set.healthFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.MAX_HEALTH)) != null) {
                    if (this.mobControl$mobExRule.maxHealth == 0.0f) {
                        Constants.LOG.debug("Setting MAX_HEALTH mobControl$mobExRule.maxHealth == {}", (Object)Float.valueOf(this.mobControl$mobExRule.maxHealth));
                        this.mobControl$mobExRule.currentHealth = this.mobControl$mobExRule.maxHealth = (float)MobEx.randomFromRange(this.mobControl$mobExRule.set.healthFrom, this.mobControl$mobExRule.set.healthTo);
                    }
                    Constants.LOG.debug("Setting MAX_HEALTH XX cur {}, max b4 {}, ruleTo {}", new Object[]{Float.valueOf(this.mobControl$mobExRule.currentHealth), attribute.getValue(), this.mobControl$mobExRule.set.healthTo});
                    attribute.setBaseValue((double)this.mobControl$mobExRule.maxHealth);
                    mob.setHealth(this.mobControl$mobExRule.currentHealth);
                    Constants.LOG.debug("Setting MAX_HEALTH to {} with current of {} for {}", new Object[]{mob.getAttributes().getValue(Attributes.MAX_HEALTH), Float.valueOf(mob.getHealth()), this.mobControl$mobExRule.mobExName});
                }
                if (this.mobControl$mobExRule.set.damageFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.ATTACK_DAMAGE)) != null) {
                    attribute.setBaseValue((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.damageFrom, this.mobControl$mobExRule.set.damageTo));
                    Constants.LOG.debug("Setting ATTACK_DAMAGE to {} for {}", (Object)mob.getAttributes().getValue(Attributes.ATTACK_DAMAGE), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.knockbackFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.ATTACK_KNOCKBACK)) != null) {
                    attribute.setBaseValue((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.knockbackFrom, this.mobControl$mobExRule.set.knockbackTo));
                    Constants.LOG.debug("Setting ATTACK_KNOCKBACK to {} for {}", (Object)mob.getAttributes().getValue(Attributes.ATTACK_KNOCKBACK), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.movementSpeedFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.MOVEMENT_SPEED)) != null) {
                    attribute.setBaseValue(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.movementSpeedFrom, this.mobControl$mobExRule.set.movementSpeedTo));
                    Constants.LOG.debug("Setting MOVEMENT_SPEED to {} for {}", (Object)mob.getAttributes().getValue(Attributes.MOVEMENT_SPEED), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.flyingSpeedFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.FLYING_SPEED)) != null) {
                    attribute.setBaseValue(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.flyingSpeedFrom, this.mobControl$mobExRule.set.flyingSpeedTo));
                    Constants.LOG.debug("Setting FLYING_SPEED to {} for {}", (Object)mob.getAttributes().getValue(Attributes.FLYING_SPEED), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.sizeFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.SCALE)) != null) {
                    attribute.setBaseValue(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.sizeFrom, this.mobControl$mobExRule.set.sizeTo));
                    mob.refreshDimensions();
                    Constants.LOG.debug("Setting.SCALE to {} for {}", (Object)mob.getAttributes().getValue(Attributes.SCALE), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.followRangeFrom != null && (attribute = mob.getAttributes().getInstance(Attributes.FOLLOW_RANGE)) != null) {
                    attribute.setBaseValue(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.followRangeFrom, this.mobControl$mobExRule.set.followRangeTo));
                    Constants.LOG.debug("Setting.FOLLOW_RANGE to {} for {}", (Object)mob.getAttributes().getValue(Attributes.FOLLOW_RANGE), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.name != null && !this.mobControl$mobExRule.set.name.isEmpty()) {
                    mob.setCustomName((Component)Component.literal((String)this.mobControl$mobExRule.set.name));
                }
                mob.setCustomNameVisible(this.mobControl$mobExRule.set.nameAlwaysShown);
                boolean hasAttackGoals = false;
                for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                    Goal goal2 = wrappedGoal.getGoal();
                    if (!goal2.getClass().toString().toLowerCase().contains("attackgoal")) continue;
                    hasAttackGoals = true;
                    break;
                }
                if (!(this.mobControl$mobExRule.set.onHurt == null && this.mobControl$mobExRule.set.attack == null || hasAttackGoals)) {
                    if (mob instanceof PathfinderMob) {
                        PathfinderMob pathfinderMob = (PathfinderMob)mob;
                        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(pathfinderMob, 1.2, true));
                    } else {
                        this.goalSelector.addGoal(1, (Goal)new GenericAttackGoal(mob));
                    }
                }
                if (this.mobControl$mobExRule.set.onHurt != null && !this.mobControl$mobExRule.set.onHurt.isEmpty()) {
                    this.removeAllGoals(goal -> goal instanceof HurtByTargetGoal);
                    if (mob instanceof PathfinderMob) {
                        PathfinderMob pathfinderMob = (PathfinderMob)mob;
                        this.targetSelector.addGoal(1, (Goal)(this.mobControl$mobExRule.set.onHurt.equals("all") ? new HurtByTargetGoal(pathfinderMob, new Class[0]).setAlertOthers(new Class[0]) : new HurtByTargetGoal(pathfinderMob, new Class[0])));
                    } else {
                        this.targetSelector.addGoal(1, (Goal)(this.mobControl$mobExRule.set.onHurt.equals("all") ? new GenericHurtByTargetGoal(mob).setAlertOthers() : new GenericHurtByTargetGoal(mob)));
                    }
                }
                if (this.mobControl$mobExRule.set.attack != null) {
                    this.removeAllGoals(goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof NearestAttackableWitchTargetGoal || goal instanceof NonTameRandomTargetGoal);
                    this.setTarget(null);
                    for (String mobToAttack : this.mobControl$mobExRule.set.attack) {
                        if (mobToAttack.equals("player")) {
                            if (mob instanceof Witch) {
                                Witch witch = (Witch)mob;
                                this.targetSelector.addGoal(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, Player.class, 10, true, false, livingEntity -> livingEntity instanceof Player));
                                continue;
                            }
                            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal(mob, Player.class, true, livingEntity -> livingEntity instanceof Player));
                            continue;
                        }
                        Optional optional = EntityType.byString((String)mobToAttack);
                        if (!optional.isPresent()) continue;
                        EntityType entityType = (EntityType)optional.get();
                        if (mob.getType().equals(entityType)) continue;
                        if (mob instanceof Witch) {
                            Witch witch = (Witch)mob;
                            this.targetSelector.addGoal(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, Mob.class, 10, true, false, livingEntity -> livingEntity.getType() == entityType));
                            continue;
                        }
                        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal(mob, Mob.class, true, livingEntity -> livingEntity.getType() == entityType));
                    }
                }
                if (MobEx.can(this.mobControl$mobExRule.set.breakBlock) && (mobMix = this) instanceof Monster) {
                    Monster monster = (Monster)mobMix;
                    this.goalSelector.addGoal(1, new BreakBlocksGoal<Monster>(monster));
                }
            }
            if (this.mobControl$mobExRule.set.climbFallTicks != null) {
                MobExSet mobExSet = this.mobControl$mobExRule.set;
                mobExSet.climbFallTicks = mobExSet.climbFallTicks - 1;
                if (mobExSet.climbFallTicks > 0) {
                    mob.resetFallDistance();
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (this.mobControl$mobExRule != null) {
            String json = Util.gson.toJson((Object)this.mobControl$mobExRule);
            compound.putString("mobcontrol:rule", json);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (this.mobControl$mobExRule == null) {
            String json = compound.getString("mobcontrol:rule");
            if (!json.isEmpty()) {
                this.mobControl$setRule((MobExRule)Util.gson.fromJson(json, MobExRule.class));
                this.mobControl$mobExRule.hasLoaded = false;
            }
        } else {
            this.mobControl$mobExRule.hasLoaded = false;
        }
    }

    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSunBurnTick(CallbackInfoReturnable<Boolean> cir) {
        if (this.mobControl$mobExRule != null && this.mobControl$mobExRule.set.sunburn != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean mobControl$blockPosContains(BlockPos pos, BlockPos pos1, BlockPos pos2) {
        return pos.getX() >= Math.min(pos1.getX(), pos2.getX()) && pos.getX() <= Math.max(pos1.getX(), pos2.getX()) && pos.getZ() >= Math.min(pos1.getZ(), pos2.getZ()) && pos.getZ() <= Math.max(pos1.getZ(), pos2.getZ());
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")})
    private void customServerAiStep(CallbackInfo ci) {
        List list;
        Block footBlock;
        ServerLevel serverLevel;
        Mob mob;
        block30: {
            block29: {
                mob = (Mob)this;
                Level level = mob.level();
                if (!(level instanceof ServerLevel)) break block29;
                serverLevel = (ServerLevel)level;
                if (mob != null) break block30;
            }
            return;
        }
        MobExRule mobExRule = this.mobControl$getRule();
        if (mobExRule == null) {
            if (!Util.setMob(serverLevel, mob, mob.getX(), mob.getY(), mob.getZ())) {
                Constants.LOG.debug("*WARN* AI: mobExRule == null, type {}, id {} @ {} {} {}", new Object[]{mob.getType(), mob.getUUID(), mob.blockPosition().getX(), mob.blockPosition().getY(), mob.blockPosition().getZ()});
                mob.discard();
                mob.setHealth(0.0f);
            }
            return;
        }
        if (mobExRule.converting) {
            Constants.LOG.debug("AI: mobExRule.converting");
            mobExRule.converting = false;
            if (!Util.isValidMob(serverLevel, mob, MobSpawnType.CONVERSION.toString())) {
                mob.kill();
            }
            return;
        }
        Vec3 mobVector = new Vec3(mob.getX(), mob.getY(), mob.getZ());
        LivingEntity target = this.getTarget();
        BlockPos aboveMob = BlockPos.containing((double)mob.getX(), (double)mob.getEyeY(), (double)mob.getZ()).above();
        BlockPos mobFootPos = BlockPos.containing((double)mob.getX(), (double)mob.getY(), (double)mob.getZ());
        int lightLevel = serverLevel.getMaxLocalRawBrightness(aboveMob);
        if (serverLevel.isDay() && MobEx.can(mobExRule.set.sunburn) && lightLevel > 7 && !mob.isInWaterOrRain() && !mob.isInPowderSnow && !mob.wasInPowderSnow && serverLevel.canSeeSky(aboveMob)) {
            ItemStack itemstack = mob.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemstack.isEmpty()) {
                if (itemstack.isDamageableItem()) {
                    Item item = itemstack.getItem();
                    itemstack.setDamageValue(itemstack.getDamageValue() + Util.random.nextInt(2));
                    if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                        mob.onEquippedItemBroken(item, EquipmentSlot.HEAD);
                        mob.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
            } else {
                mob.igniteForSeconds(7.0f);
            }
        }
        if (MobEx.can(mobExRule.set.eatPlants)) {
            mob.swing(InteractionHand.MAIN_HAND, true);
            footBlock = serverLevel.getBlockState(mobFootPos).getBlock();
            if (MobMix.mobControl$isBush(footBlock) || MobMix.mobControl$isCrop(footBlock)) {
                serverLevel.destroyBlock(mobFootPos, false);
                if (MobEx.can(mobExRule.set.eatPlantsHeals)) {
                    mob.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 75, 0));
                }
            }
        }
        if (MobEx.can(mobExRule.set.plantFlowers) && Feature.isDirt((BlockState)serverLevel.getBlockState(mobFootPos.below())) && mobFootPos.getY() > 0 && mobFootPos.getY() < 256 && !MobMix.mobControl$isBlockBadSoil(serverLevel, mobFootPos, true) && !(list = ((Biome)serverLevel.getBiome(mobFootPos).value()).getGenerationSettings().getFlowerFeatures()).isEmpty()) {
            Holder holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.getFirst()).config()).feature();
            ((PlacedFeature)holder.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), serverLevel.random, mobFootPos);
        }
        if (MobEx.can(mobExRule.set.plantTrees) && serverLevel.getBiomeManager().getBiome(mobFootPos).unwrapKey().isPresent() && Feature.isDirt((BlockState)serverLevel.getBlockState(mobFootPos.below())) && mobFootPos.getY() > 0 && mobFootPos.getY() < 256 && MobMix.mobControl$isAreaGoodSoil(serverLevel, mobFootPos)) {
            ResourceLocation currentBiome = ((ResourceKey)serverLevel.getBiomeManager().getBiome(mobFootPos).unwrapKey().get()).location();
            serverLevel.setBlock(mobFootPos, MobMix.mobControl$getSaplingFromBiome(currentBiome), 11);
        }
        if (MobEx.can(mobExRule.set.cutGrass)) {
            mob.swing(InteractionHand.MAIN_HAND, true);
            footBlock = serverLevel.getBlockState(mobFootPos).getBlock();
            if (MobMix.mobControl$isGrass(footBlock)) {
                serverLevel.destroyBlock(mobFootPos, false);
            }
        }
        if (target != null && (this.navigation.isDone() || this.navigation.isStuck()) && MobEx.can(mobExRule.set.placeBlock) && this.mobControl$blockPosContains(mob.blockPosition(), new BlockPos(target.blockPosition().getX() - 5, 0, target.blockPosition().getZ() - 5), new BlockPos(target.blockPosition().getX() + 5, 0, target.blockPosition().getZ() + 5))) {
            BlockPos placePos = new BlockPos((Vec3i)mobFootPos);
            if (target.getY() > (double)mob.blockPosition().getY() && !Util.isInWall(serverLevel, mob, placePos.getCenter())) {
                if (this.mobControl$lastPlacedTick + 100L < serverLevel.getGameTime()) {
                    this.mobControl$lastPlacedTick = serverLevel.getGameTime();
                    serverLevel.setBlock(placePos, Blocks.MOSS_BLOCK.defaultBlockState(), 11);
                    mob.getNavigation().moveTo((double)placePos.getX(), (double)placePos.getY(), (double)placePos.getZ(), (double)mob.getSpeed());
                }
            } else {
                BlockPos towardsTarget = BlockPos.containing((double)(mob.getX() + (double)Double.compare(target.getX(), mob.getX())), (double)(mob.getY() + (double)Double.compare(target.getY(), mob.getY())), (double)(mob.getZ() + (double)Double.compare(target.getZ(), mob.getZ())));
                boolean way = Util.random.nextDouble() > 0.5;
                placePos = new BlockPos(way ? towardsTarget.getX() : mob.blockPosition().getX(), mob.blockPosition().getY(), way ? mob.blockPosition().getZ() : towardsTarget.getZ());
                if (!Util.isInWall(serverLevel, mob, placePos.getCenter()) && this.mobControl$lastPlacedTick + 100L < serverLevel.getGameTime()) {
                    this.mobControl$lastPlacedTick = serverLevel.getGameTime();
                    serverLevel.setBlock(placePos, Blocks.MOSS_BLOCK.defaultBlockState(), 11);
                    mob.getNavigation().moveTo((double)placePos.getX(), (double)placePos.getY(), (double)placePos.getZ(), (double)mob.getSpeed());
                }
            }
        }
        List<Entity> nearEntities = serverLevel.getEntitiesOfClass(Entity.class, new AABB(mobVector, mobVector).inflate(0.225), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.distanceToSqr(mobVector))).toList();
        for (Entity nearEntity : nearEntities) {
            if (mob.getId() == nearEntity.getId() || !(nearEntity instanceof Mob)) continue;
            Mob nearMob = (Mob)nearEntity;
            if (MobEx.can(mobExRule.set.climb) && mob.getTarget() != null && mob.getTarget().getY() > mob.getY()) {
                double rndX = Util.random.nextDouble(0.0, 0.1f) * (double)(mob.getTarget().getX() > mob.getX() ? 1 : -1);
                double rndY = Util.random.nextDouble(0.0, 0.55f) + (mob.isBaby() ? 0.25 : 0.0);
                double rndZ = Util.random.nextDouble(0.0, 0.1f) * (double)(mob.getTarget().getZ() > mob.getZ() ? 1 : -1);
                mob.setDeltaMovement(new Vec3(rndX + mob.getDeltaMovement().x(), rndY, rndZ + mob.getDeltaMovement().z()));
                mob.swing(InteractionHand.MAIN_HAND, true);
                mob.resetFallDistance();
                mobExRule.set.climbFallTicks = 20;
                if (!mob.hasEffect(MobEffects.SLOW_FALLING)) {
                    mob.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 3, 0, false, false));
                }
            }
            if (!MobEx.can(mobExRule.set.spreadFire) || !mob.isOnFire()) continue;
            if (!mob.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, mob.getRemainingFireTicks(), 2, false, false));
            }
            if (nearMob == null || nearMob.isOnFire()) continue;
            int remainingFireTicks = mob.getRemainingFireTicks();
            nearMob.igniteForTicks(remainingFireTicks < 75 ? remainingFireTicks + Util.random.nextInt(0, 10) : remainingFireTicks);
        }
    }

    @Unique
    private static boolean mobControl$isGrass(Block block) {
        return block instanceof DoublePlantBlock || block instanceof TallGrassBlock;
    }

    @Unique
    private static boolean mobControl$isBush(Block block) {
        return block instanceof BushBlock;
    }

    @Unique
    private static boolean mobControl$isCrop(Block block) {
        return block instanceof CropBlock;
    }

    @Unique
    private static boolean mobControl$isBlockBadSoil(ServerLevel serverLevel, BlockPos blockPos, boolean groundCheck) {
        boolean goodGround = !groundCheck || Feature.isDirt((BlockState)serverLevel.getBlockState(blockPos.below()));
        boolean canSeedPlant = MobMix.mobControl$isGrass(serverLevel.getBlockState(blockPos).getBlock()) || serverLevel.getBlockState(blockPos).isAir();
        return !goodGround || !canSeedPlant;
    }

    @Unique
    private static boolean mobControl$isAreaGoodSoil(ServerLevel serverLevel, BlockPos blockPos) {
        for (int checkY = 0; checkY < 5; ++checkY) {
            BlockPos checkBlockPos = new BlockPos(blockPos.getX(), blockPos.getY() + checkY, blockPos.getZ());
            if (serverLevel.getBlockState(checkBlockPos).isAir() || MobMix.mobControl$isGrass(serverLevel.getBlockState(checkBlockPos).getBlock())) continue;
            return false;
        }
        for (int checkX = -2; checkX < 3; ++checkX) {
            for (int checkZ = -2; checkZ < 3; ++checkZ) {
                BlockPos checkBlockPos = new BlockPos(blockPos.getX() + checkX, blockPos.getY(), blockPos.getZ() + checkZ);
                if (!MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos, true) && !MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos.above(), false) && !MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos.above().above(), false)) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    @NotNull
    private static BlockState mobControl$getSaplingFromBiome(ResourceLocation currentBiome) {
        Weighted weighted = new Weighted();
        weighted.add(new WeightedItem("oak", "", 2, 1, 1, 0));
        weighted.add(new WeightedItem("birch", "", 1, 1, 1, 0));
        weighted.add(new WeightedItem("default", "", 97, 1, 1, 0));
        if (weighted.getWeightedItem().key().equals("oak")) {
            return Blocks.OAK_SAPLING.defaultBlockState();
        }
        if (weighted.getWeightedItem().key().equals("birch")) {
            return Blocks.BIRCH_SAPLING.defaultBlockState();
        }
        if (weighted.getWeightedItem().key().equals("default")) {
            if (currentBiome.getPath().contains("taiga")) {
                return Blocks.SPRUCE_SAPLING.defaultBlockState();
            }
            if (currentBiome.getPath().contains("jungle")) {
                return Blocks.JUNGLE_SAPLING.defaultBlockState();
            }
            if (currentBiome.getPath().contains("savanna")) {
                return Blocks.ACACIA_SAPLING.defaultBlockState();
            }
            if (currentBiome.getPath().contains("dark_forest")) {
                return Blocks.DARK_OAK_SAPLING.defaultBlockState();
            }
            if (currentBiome.getPath().contains("cherry_grove")) {
                return Blocks.CHERRY_SAPLING.defaultBlockState();
            }
        }
        return Util.random.nextDouble() > 0.75 ? Blocks.BIRCH_SAPLING.defaultBlockState() : Blocks.OAK_SAPLING.defaultBlockState();
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        Mob mob;
        MobMix mobMix = this;
        if (mobMix instanceof Mob && (mob = (Mob)mobMix).isDeadOrDying()) {
            cir.setReturnValue((Object)new AgeableMob.AgeableMobGroupData(false));
        }
    }
}

