/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.command;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.iface.IServerLevel;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class GenericCommand {
    public static final SuggestionProvider<class_2168> SUGGEST_RULES = (ctx, builder) -> {
        for (MobEx mobEx : Config.mobs.values()) {
            for (MobExRule mobExRule : mobEx.rules) {
                if (mobExRule.name == null || mobExRule.name.isEmpty() || mobExRule.name.startsWith("___INTERNAL___")) continue;
                builder.suggest(mobExRule.name);
            }
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> commandDispatcher, class_7157 context) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mobcontrol").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(4))).executes(source -> {
            GenericCommand.reload((CommandContext<class_2168>)source);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(source -> source.method_9259(4))).executes(source -> {
            Config.logDebug = !Config.logDebug;
            Config.setLoggerLevel();
            ((class_2168)source.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aDebug toggled to: " + (Config.logDebug ? "true" : "false"))), !((class_2168)source.getSource()).method_43737());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear-mobs").requires(source -> source.method_9259(4))).executes(source -> {
            class_3222 patt0$temp;
            class_3218 serverLevel = ((class_2168)source.getSource()).method_9225();
            ArrayList<class_1297> entities = new ArrayList<class_1297>();
            serverLevel.method_27909().forEach(entity -> {
                if (entity instanceof class_1308) {
                    entities.add((class_1297)entity);
                }
            });
            entities.forEach(class_1297::method_31472);
            Util.nextTicks.clear();
            if (((class_2168)source.getSource()).method_43737() && (patt0$temp = ((class_2168)source.getSource()).method_44023()) instanceof class_3222) {
                class_3222 sourcePlayer = patt0$temp;
                serverLevel.method_8396(null, sourcePlayer.method_24515(), class_3417.field_14803, class_3419.field_15248, 1.0f, 1.0f);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(source -> source.method_9259(4))).executes(source -> {
            Object patt0$temp;
            if (((class_2168)source.getSource()).method_43737() && (patt0$temp = ((class_2168)source.getSource()).method_44023()) instanceof class_3222) {
                class_3222 sourcePlayer = patt0$temp;
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7aNext Ticks"));
                for (Map.Entry entry : Util.nextTicks.entrySet()) {
                    ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7b" + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()))));
                }
                class_3218 serverLevel = ((class_2168)source.getSource()).method_9225();
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7aMobs"));
                for (Map.Entry<String, Long> entry : Constants.MOB_STATS.entrySet()) {
                    ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7b" + entry.getKey() + ": " + String.valueOf(entry.getValue()))));
                }
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7aServer Info"));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bDimension: " + serverLevel.method_27983().method_29177().method_12836() + ":" + serverLevel.method_27983().method_29177().method_12832())));
                if (serverLevel.method_22385().method_22393(sourcePlayer.method_24515()).method_40230().isPresent()) {
                    class_2960 class_29602 = ((class_5321)serverLevel.method_22385().method_22393(sourcePlayer.method_24515()).method_40230().get()).method_29177();
                    ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bBiome: " + class_29602.method_12836() + ":" + class_29602.method_12832())));
                }
                ArrayList<class_2960> arrayList = Util.getBiomeTags(serverLevel, sourcePlayer.method_24515());
                ArrayList arrayList2 = new ArrayList();
                arrayList.forEach(resourceLocation -> biomeTags.add(resourceLocation.method_12836() + ":" + resourceLocation.method_12832()));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bBiome Tags: " + (arrayList2.isEmpty() ? "(none)" : String.join((CharSequence)",", arrayList2)))));
                long serverTicks = ((IServerLevel)serverLevel).mobControl$savedData().getTicks();
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bDays: " + serverTicks + " (" + serverTicks / 24000L + " days)")));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bTime of Day: " + serverLevel.method_8401().method_217() % 24000L)));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bSky Light: " + serverLevel.method_8314(class_1944.field_9284, sourcePlayer.method_24515()) + " @ " + sourcePlayer.method_24515().method_10263() + " " + sourcePlayer.method_24515().method_10264() + " " + sourcePlayer.method_24515().method_10260())));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bBlock Light: " + serverLevel.method_8314(class_1944.field_9282, sourcePlayer.method_24515()) + " @ " + sourcePlayer.method_24515().method_10263() + " " + sourcePlayer.method_24515().method_10264() + " " + sourcePlayer.method_24515().method_10260())));
                ArrayList<class_2960> arrayList3 = Util.getStructures(serverLevel, sourcePlayer.method_24515());
                ArrayList structures = new ArrayList();
                arrayList3.forEach(resourceLocation -> structures.add(resourceLocation.method_12836() + ":" + resourceLocation.method_12832()));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7bStructures: " + (structures.isEmpty() ? "(none)" : String.join((CharSequence)",", structures)))));
                ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7aPlayer Days"));
                for (class_3222 serverPlayer : serverLevel.method_8503().method_3760().method_14571()) {
                    long playerTicks = ((IPlayer)serverPlayer).mobControl$ticks();
                    ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7b" + serverPlayer.method_5476().getString() + ": " + playerTicks + " (" + playerTicks / 24000L + " days)")));
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"force-summon").requires(source -> source.method_9259(4))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)context, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(source -> {
            class_2487 entityCompoundTag = new class_2487();
            entityCompoundTag.method_10582("id", class_7733.method_45610((CommandContext)source, (String)"entity").method_40237().method_29177().toString());
            GenericCommand.forceSummon((CommandContext<class_2168>)source, entityCompoundTag, "");
            return 1;
        })).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RULES).executes(source -> {
            class_2487 entityCompoundTag = new class_2487();
            entityCompoundTag.method_10582("id", class_7733.method_45610((CommandContext)source, (String)"entity").method_40237().method_29177().toString());
            GenericCommand.forceSummon((CommandContext<class_2168>)source, entityCompoundTag, StringArgumentType.getString((CommandContext)source, (String)"rule"));
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"days").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"days", (ArgumentType)IntegerArgumentType.integer()).executes(source -> {
            class_3222 targetPlayer = class_2186.method_9315((CommandContext)source, (String)"target");
            ((IPlayer)targetPlayer).mobControl$setDays(IntegerArgumentType.getInteger((CommandContext)source, (String)"days"));
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"show-config").requires(source -> source.method_9259(4))).executes(source -> {
            Path configPath = FileSystems.getDefault().getPath("config", "mobcontrol.toml");
            ((class_2168)source.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a72Click to copy path to clipboard: \u00a76" + String.valueOf(configPath.toAbsolutePath()))).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, configPath.toAbsolutePath().toString()))), !((class_2168)source.getSource()).method_43737());
            return 1;
        })))).requires(source -> source.method_9259(0))).then(class_2170.method_9247((String)"ver").executes(source -> {
            ((class_2168)source.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a72Mob Control, version 1.5.13 by \u00a79Ohayden"), !((class_2168)source.getSource()).method_43737());
            return 1;
        })));
    }

    private static void forceSummon(CommandContext<class_2168> source, class_2487 entityCompoundTag, String ruleName) {
        class_1299.method_17842((class_2487)entityCompoundTag, (class_1937)((class_2168)source.getSource()).method_9225(), entity -> {
            if (entity instanceof class_1308) {
                MobExRule mobExRule;
                class_1308 mob = (class_1308)entity;
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonOverride));
                if (!ruleName.isEmpty() && (mobExRule = Config.findRuleByName(ruleName)) != null) {
                    ((IMob)mob).mobControl$setRule(mobExRule);
                }
            }
            entity.method_29495(((class_2168)source.getSource()).method_9222());
            ((class_2168)source.getSource()).method_9225().method_30736(entity);
            return entity;
        });
        ((class_2168)source.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7bOk"));
    }

    private static void reload(CommandContext<class_2168> source) {
        if (Config.load()) {
            ((class_2168)source.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aReload finished"), !((class_2168)source.getSource()).method_43737());
        } else {
            ((class_2168)source.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a74Error reloading, check logs and validate config"), !((class_2168)source.getSource()).method_43737());
        }
    }
}

