/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BaseSpawner.class})
public abstract class BaseSpawnerMix {
    @Shadow
    private int f_45452_;
    @Unique
    private MobEx mobControl$mobEx;
    @Unique
    private UUID mobControl$lastReloadedId;

    @Shadow
    protected abstract boolean m_151343_(Level var1, BlockPos var2);

    @Shadow
    protected abstract SpawnData m_253144_(Level var1, RandomSource var2, BlockPos var3);

    @Inject(method={"serverTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void serverTick(ServerLevel serverLevel, BlockPos pos, CallbackInfo ci) {
        Mob mob;
        Entity entity;
        if (!this.m_151343_((Level)serverLevel, pos)) {
            return;
        }
        long playerDays = -1L;
        for (Player player : serverLevel.m_6907_()) {
            if (!EntitySelector.f_20408_.test(player) || !EntitySelector.f_20403_.test(player)) continue;
            double distanceToSqr = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            if (!((float)this.f_45452_ < 0.0f) && !(distanceToSqr < (double)(this.f_45452_ * this.f_45452_))) continue;
            playerDays = Math.max(((IPlayer)player).mobControl$ticks() / 24000L, playerDays);
        }
        if (playerDays == -1L) {
            return;
        }
        SpawnData spawndata = this.m_253144_((Level)serverLevel, serverLevel.m_213780_(), pos);
        CompoundTag compoundtag = spawndata.m_186567_();
        Optional optional = EntityType.m_20637_((CompoundTag)compoundtag);
        if (optional.isPresent() && Config.lastReloadedId != null && this.mobControl$lastReloadedId != Config.lastReloadedId) {
            this.mobControl$lastReloadedId = Config.lastReloadedId;
            entity = ((EntityType)optional.get()).m_20615_((Level)serverLevel);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                this.mobControl$mobEx = Util.getMobEx(mob, EntityType.m_20613_((EntityType)((EntityType)optional.get())));
            }
        }
        if (this.mobControl$mobEx != null && optional.isPresent() && (entity = ((EntityType)optional.get()).m_20615_((Level)serverLevel)) instanceof Mob) {
            mob = (Mob)entity;
            ((IMob)entity).mobControl$setMobSpawn(new MobSpawn(MobSpawnType.SPAWNER.toString()));
            ((IMob)mob).mobControl$getMobSpawn().dayCheck = playerDays;
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, Util.random.nextFloat() * 360.0f, 0.0f);
            if (!mob.m_21224_()) {
                serverLevel.m_7967_((Entity)mob);
            }
            ci.cancel();
        }
    }
}

