/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.data;

import com.crackerjackbox.mobcontrol.iface.IWeightedGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class Weighted<T extends IWeightedGroup>
implements Serializable {
    HashMap<String, Integer> groupMax = new HashMap();
    HashMap<String, ArrayList<T>> groupRecords = new HashMap();

    public boolean any() {
        return !this.groupRecords.isEmpty();
    }

    public void clear() {
        this.groupRecords.clear();
    }

    public boolean add(T record) {
        this.groupMax.put(record.group(), this.groupMax.getOrDefault(record.group(), 0) + record.weight());
        this.groupRecords.computeIfAbsent(record.group(), k -> new ArrayList());
        return this.groupRecords.get(record.group()).add(record);
    }

    public T getWeighted(String group) {
        int index;
        ArrayList weightedRecords = this.groupRecords.getOrDefault(group, new ArrayList());
        if (weightedRecords.isEmpty()) {
            return null;
        }
        double random = Math.random() * (double)this.groupMax.get(group).intValue();
        for (index = 0; index < weightedRecords.size() - 1 && !((random -= (double)((IWeightedGroup)weightedRecords.get(index)).weight()) <= 0.0); ++index) {
        }
        return (T)((IWeightedGroup)weightedRecords.get(index));
    }

    public T getWeighted() {
        if (this.groupMax.isEmpty()) {
            return null;
        }
        return this.getWeighted((String)this.groupMax.keySet().stream().findFirst().get());
    }

    public ArrayList<T> getWeightedGroupRecords() {
        ArrayList<T> records = new ArrayList<T>();
        for (String group : this.groupMax.keySet()) {
            records.add(this.getWeighted(group));
        }
        return records;
    }
}

