/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.StringValueReaderWriter;
import com.crackerjackbox.toml.iface.IValueReader;
import java.util.concurrent.atomic.AtomicInteger;

public class MultilineStringValueReader
implements IValueReader {
    static final MultilineStringValueReader MULTILINE_STRING_VALUE_READER = new MultilineStringValueReader();

    @Override
    public boolean canRead(String string) {
        return string.startsWith("\"\"\"");
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int originalStartIndex = atomicInteger.get();
        int startIndex = atomicInteger.addAndGet(3);
        int endIndex = -1;
        if (string.charAt(startIndex) == '\n') {
            startIndex = atomicInteger.incrementAndGet();
            line.incrementAndGet();
        }
        int index = startIndex;
        while (index < string.length()) {
            char character = string.charAt(index);
            if (character == '\n') {
                line.incrementAndGet();
            } else if (character == '\"' && string.length() > index + 2 && string.charAt(index + 1) == '\"' && string.charAt(index + 2) == '\"') {
                endIndex = index;
                atomicInteger.addAndGet(2);
                break;
            }
            index = atomicInteger.incrementAndGet();
        }
        if (endIndex == -1) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), string.substring(originalStartIndex), startLine);
            return errors;
        }
        string = string.substring(startIndex, endIndex);
        string = string.replaceAll("\\\\\\s+", "");
        string = StringValueReaderWriter.STRING_VALUE_READER_WRITER.replaceUnicodeCharacters(string);
        string = StringValueReaderWriter.STRING_VALUE_READER_WRITER.replaceSpecialCharacters(string);
        return string;
    }
}

