/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.ai;

import com.crackerjackbox.mobcontrol.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BreakBlocksGoal<T extends Monster>
extends Goal {
    final T monster;
    final Level level;
    final int[] patternY = new int[]{0, 1, 2};
    final int patternYSize = this.patternY.length;
    final int[] patternXZ = new int[]{0, -1, 1};
    final int patternXZSize = this.patternXZ.length;
    BlockPos targetBlock;
    double progress = 0.0;
    double destroyTime = Double.MAX_VALUE;

    public BreakBlocksGoal(T monster) {
        this.monster = monster;
        this.level = monster.m_9236_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.progress = 0.0;
        this.destroyTime = this.level.m_8055_(this.targetBlock).m_60734_().m_155943_();
    }

    public void m_8041_() {
        if (this.targetBlock != null) {
            this.level.m_6801_(this.monster.m_19879_(), this.targetBlock, -1);
            this.targetBlock = null;
        }
        this.monster.m_21573_().m_26569_();
    }

    public void m_8037_() {
        if (this.targetBlock != null && this.monster.m_5448_() != null) {
            double distance = this.monster.m_20280_((Entity)this.monster.m_5448_());
            if (distance > (double)0.3f && distance < 50.0) {
                this.monster.m_6674_(InteractionHand.MAIN_HAND);
                this.progress += 0.1;
                if (this.progress >= this.destroyTime) {
                    this.level.m_46953_(this.targetBlock, true, this.monster);
                    this.level.m_6801_(this.monster.m_19879_(), this.targetBlock, -1);
                    this.monster.m_21573_().m_26569_();
                } else {
                    this.monster.m_21573_().m_26573_();
                    this.monster.m_21570_(0.0f);
                    this.monster.m_21567_(0.0f);
                    this.monster.m_7910_(0.0f);
                    this.monster.m_21563_().m_24946_((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_());
                    this.level.m_6801_(this.monster.m_19879_(), this.targetBlock, (int)(this.progress / this.destroyTime * 10.0));
                    return;
                }
            }
            this.targetBlock = null;
        }
    }

    public boolean m_8045_() {
        return this.canReach(this.targetBlock);
    }

    private boolean canReach(BlockPos blockPos) {
        return blockPos != null && this.monster.m_20238_(blockPos.m_252807_()) <= 9.0;
    }

    public boolean m_8036_() {
        if (this.targetBlock != null) {
            return true;
        }
        if (this.monster.m_5448_() != null && this.monster.m_6084_() && !this.monster.m_21525_() && (this.monster.m_21573_().m_26571_() || this.monster.m_21573_().m_26577_())) {
            Vec3 center = this.monster.m_5448_().m_20183_().m_252807_().m_82546_(this.monster.m_20183_().m_252807_());
            BlockPos blockPos = this.monster.m_20183_().m_7918_(Double.compare(center.f_82479_, 0.0), Double.compare(center.f_82480_, 0.0), Double.compare(center.f_82481_, 0.0));
            for (int x = 0; x < this.patternXZSize; ++x) {
                for (int z = 0; z < this.patternXZSize; ++z) {
                    for (int y = 0; y < this.patternYSize; ++y) {
                        if (!this.isBreakable(blockPos.m_7918_(this.patternXZ[x], this.patternY[y], this.patternXZ[z]))) continue;
                        return Util.random.nextDouble() > 0.25;
                    }
                }
            }
        }
        return false;
    }

    boolean isBreakable(BlockPos blockPos) {
        float destroyTime;
        BlockState state = this.level.m_8055_(blockPos);
        if (state != Blocks.f_50016_.m_49966_() && state != Blocks.f_50375_.m_49966_() && state != Blocks.f_50752_.m_49966_() && (destroyTime = state.m_60734_().m_155943_()) >= 0.0f && destroyTime <= 50.0f && this.canReach(blockPos)) {
            this.targetBlock = blockPos;
            return true;
        }
        return false;
    }
}

