/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.command;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.iface.IServerLevel;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class GenericCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_RULES = (ctx, builder) -> {
        for (MobEx mobEx : Config.mobs.values()) {
            for (MobExRule mobExRule : mobEx.rules) {
                if (mobExRule.name == null || mobExRule.name.isEmpty() || mobExRule.name.startsWith("___INTERNAL___")) continue;
                builder.suggest(mobExRule.name);
            }
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext context) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mobcontrol").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(source -> source.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(source -> source.m_6761_(4))).executes(source -> {
            GenericCommand.reload((CommandContext<CommandSourceStack>)source);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").requires(source -> source.m_6761_(4))).executes(source -> {
            Config.logDebug = !Config.logDebug;
            Config.setLoggerLevel();
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aDebug toggled to: " + (Config.logDebug ? "true" : "false"))), !((CommandSourceStack)source.getSource()).m_230897_());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear-mobs").requires(source -> source.m_6761_(4))).executes(source -> {
            ServerPlayer patt3600$temp;
            ServerLevel serverLevel = ((CommandSourceStack)source.getSource()).m_81372_();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            serverLevel.m_8583_().forEach(entity -> {
                if (entity instanceof Mob) {
                    entities.add((Entity)entity);
                }
            });
            entities.forEach(Entity::m_146870_);
            Util.nextTicks.clear();
            if (((CommandSourceStack)source.getSource()).m_230897_() && (patt3600$temp = ((CommandSourceStack)source.getSource()).m_230896_()) instanceof ServerPlayer) {
                ServerPlayer sourcePlayer = patt3600$temp;
                serverLevel.m_5594_(null, sourcePlayer.m_20183_(), SoundEvents.f_11892_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stats").requires(source -> source.m_6761_(4))).executes(source -> {
            Object patt4361$temp;
            if (((CommandSourceStack)source.getSource()).m_230897_() && (patt4361$temp = ((CommandSourceStack)source.getSource()).m_230896_()) instanceof ServerPlayer) {
                ServerPlayer sourcePlayer = patt4361$temp;
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)"\u00a7aNext Ticks"));
                for (Map.Entry entry : Util.nextTicks.entrySet()) {
                    ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7b" + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()))));
                }
                ServerLevel serverLevel = ((CommandSourceStack)source.getSource()).m_81372_();
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)"\u00a7aMobs"));
                for (Map.Entry<String, Long> entry : Constants.MOB_STATS.entrySet()) {
                    ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7b" + entry.getKey() + ": " + String.valueOf(entry.getValue()))));
                }
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)"\u00a7aServer Info"));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bDimension: " + serverLevel.m_46472_().m_135782_().m_135827_() + ":" + serverLevel.m_46472_().m_135782_().m_135815_())));
                if (serverLevel.m_7062_().m_204214_(sourcePlayer.m_20183_()).m_203543_().isPresent()) {
                    ResourceLocation resourceLocation2 = ((ResourceKey)serverLevel.m_7062_().m_204214_(sourcePlayer.m_20183_()).m_203543_().get()).m_135782_();
                    ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bBiome: " + resourceLocation2.m_135827_() + ":" + resourceLocation2.m_135815_())));
                }
                ArrayList<ResourceLocation> arrayList = Util.getBiomeTags(serverLevel, sourcePlayer.m_20183_());
                ArrayList arrayList2 = new ArrayList();
                arrayList.forEach(resourceLocation -> biomeTags.add(resourceLocation.m_135827_() + ":" + resourceLocation.m_135815_()));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bBiome Tags: " + (arrayList2.isEmpty() ? "(none)" : String.join((CharSequence)",", arrayList2)))));
                long serverTicks = ((IServerLevel)serverLevel).mobControl$savedData().getTicks();
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bDays: " + serverTicks + " (" + serverTicks / 24000L + " days)")));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bTime of Day: " + serverLevel.m_6106_().m_6792_() % 24000L)));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bSky Light: " + serverLevel.m_45517_(LightLayer.SKY, sourcePlayer.m_20183_()) + " @ " + sourcePlayer.m_20183_().m_123341_() + " " + sourcePlayer.m_20183_().m_123342_() + " " + sourcePlayer.m_20183_().m_123343_())));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bBlock Light: " + serverLevel.m_45517_(LightLayer.BLOCK, sourcePlayer.m_20183_()) + " @ " + sourcePlayer.m_20183_().m_123341_() + " " + sourcePlayer.m_20183_().m_123342_() + " " + sourcePlayer.m_20183_().m_123343_())));
                ArrayList<ResourceLocation> arrayList3 = Util.getStructures(serverLevel, sourcePlayer.m_20183_());
                ArrayList structures = new ArrayList();
                arrayList3.forEach(resourceLocation -> structures.add(resourceLocation.m_135827_() + ":" + resourceLocation.m_135815_()));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7bStructures: " + (structures.isEmpty() ? "(none)" : String.join((CharSequence)",", structures)))));
                ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)"\u00a7aPlayer Days"));
                for (ServerPlayer serverPlayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                    long playerTicks = ((IPlayer)serverPlayer).mobControl$ticks();
                    ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7b" + serverPlayer.m_5446_().getString() + ": " + playerTicks + " (" + playerTicks / 24000L + " days)")));
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"force-summon").requires(source -> source.m_6761_(4))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(source -> {
            CompoundTag entityCompoundTag = new CompoundTag();
            entityCompoundTag.m_128359_("id", ResourceArgument.m_247713_((CommandContext)source, (String)"entity").m_205785_().m_135782_().toString());
            GenericCommand.forceSummon((CommandContext<CommandSourceStack>)source, entityCompoundTag, "");
            return 1;
        })).then(Commands.m_82129_((String)"rule", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RULES).executes(source -> {
            CompoundTag entityCompoundTag = new CompoundTag();
            entityCompoundTag.m_128359_("id", ResourceArgument.m_247713_((CommandContext)source, (String)"entity").m_205785_().m_135782_().toString());
            GenericCommand.forceSummon((CommandContext<CommandSourceStack>)source, entityCompoundTag, StringArgumentType.getString((CommandContext)source, (String)"rule"));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"days").requires(source -> source.m_6761_(4))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"days", (ArgumentType)IntegerArgumentType.integer()).executes(source -> {
            ServerPlayer targetPlayer = EntityArgument.m_91474_((CommandContext)source, (String)"target");
            ((IPlayer)targetPlayer).mobControl$setDays(IntegerArgumentType.getInteger((CommandContext)source, (String)"days"));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"show-config").requires(source -> source.m_6761_(4))).executes(source -> {
            Path configPath = FileSystems.getDefault().getPath("config", "mobcontrol.toml");
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a72Click to copy path to clipboard: \u00a76" + String.valueOf(configPath.toAbsolutePath()))).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, configPath.toAbsolutePath().toString()))), !((CommandSourceStack)source.getSource()).m_230897_());
            return 1;
        })))).requires(source -> source.m_6761_(0))).then(Commands.m_82127_((String)"ver").executes(source -> {
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a72Mob Control, version 1.5.13 by \u00a79Ohayden"), !((CommandSourceStack)source.getSource()).m_230897_());
            return 1;
        })));
    }

    private static void forceSummon(CommandContext<CommandSourceStack> source, CompoundTag entityCompoundTag, String ruleName) {
        EntityType.m_20645_((CompoundTag)entityCompoundTag, (Level)((CommandSourceStack)source.getSource()).m_81372_(), entity -> {
            if (entity instanceof Mob) {
                MobExRule mobExRule;
                Mob mob = (Mob)entity;
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonOverride));
                if (!ruleName.isEmpty() && (mobExRule = Config.findRuleByName(ruleName)) != null) {
                    ((IMob)mob).mobControl$setRule(mobExRule);
                }
            }
            entity.m_20219_(((CommandSourceStack)source.getSource()).m_81371_());
            ((CommandSourceStack)source.getSource()).m_81372_().m_8860_(entity);
            return entity;
        });
        ((CommandSourceStack)source.getSource()).m_243053_((Component)Component.m_237113_((String)"\u00a7bOk"));
    }

    private static void reload(CommandContext<CommandSourceStack> source) {
        if (Config.load()) {
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aReload finished"), !((CommandSourceStack)source.getSource()).m_230897_());
        } else {
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a74Error reloading, check logs and validate config"), !((CommandSourceStack)source.getSource()).m_230897_());
        }
    }
}

