/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.ai.BreakBlocksGoal;
import com.crackerjackbox.mobcontrol.ai.GenericAttackGoal;
import com.crackerjackbox.mobcontrol.ai.GenericHurtByTargetGoal;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.data.Weighted;
import com.crackerjackbox.mobcontrol.data.WeightedItem;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.crackerjackbox.mobcontrol.rule.MobExSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMix
implements IMob {
    @Unique
    private MobSpawn mobControl$mobSpawn = null;
    @Unique
    private MobExRule mobControl$mobExRule = null;
    @Unique
    private long mobControl$lastPlacedTick = 0L;
    @Unique
    private boolean mobControl$cancelBossFight = false;
    @Shadow
    protected int f_21364_;
    @Shadow
    @Final
    protected GoalSelector f_21346_;
    @Shadow
    @Final
    protected GoalSelector f_21345_;
    @Shadow
    protected PathNavigation f_21344_;
    @Unique
    private final ArrayList<Mob> mobControl$secondaryMobs = new ArrayList();
    @Unique
    private final ArrayList<WeightedItem> mobControl$deathLoot = new ArrayList();

    @Shadow
    public abstract LivingEntity m_5448_();

    @Shadow
    public abstract void m_262441_(Predicate<Goal> var1);

    @Shadow
    public abstract void m_6710_(LivingEntity var1);

    @Shadow
    public abstract void m_21463_(Entity var1, boolean var2);

    @Shadow
    public abstract boolean m_21523_();

    @Shadow
    protected abstract void m_213945_(RandomSource var1, DifficultyInstance var2);

    @Override
    @Unique
    public MobSpawn mobControl$getMobSpawn() {
        return this.mobControl$mobSpawn;
    }

    @Override
    @Unique
    public void mobControl$setMobSpawn(MobSpawn value) {
        this.mobControl$mobSpawn = value;
    }

    @Override
    @Unique
    public MobExRule mobControl$getRule() {
        return this.mobControl$mobExRule;
    }

    @Override
    @Unique
    public void mobControl$setRule(MobExRule value) {
        this.mobControl$mobExRule = (MobExRule)Util.gson.fromJson(Util.gson.toJson((Object)value), MobExRule.class);
    }

    @Override
    public void mobControl$addMob(Mob newMob) {
        this.mobControl$secondaryMobs.add(newMob);
    }

    @Override
    public void mobControl$addDeathLoot(WeightedItem weightedItem) {
        this.mobControl$deathLoot.add(weightedItem);
    }

    @Override
    @Unique
    public void mobControl$setCancelBossFight(boolean value) {
        this.mobControl$cancelBossFight = value;
    }

    @Override
    @Unique
    public boolean mobControl$getCancelBossFight() {
        return this.mobControl$cancelBossFight;
    }

    @Inject(method={"convertTo"}, at={@At(value="RETURN")})
    private <T extends Mob> void convertTo(EntityType<T> entityType, boolean transferInventory, CallbackInfoReturnable<T> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof Mob) {
            Mob convertedMob = (Mob)object;
            if (this.mobControl$mobExRule != null) {
                ((IMob)convertedMob).mobControl$setRule(this.mobControl$mobExRule);
                ((IMob)convertedMob).mobControl$getRule().converting = true;
            }
        }
    }

    @Inject(method={"dropCustomDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    protected void dropCustomDeathLoot(DamageSource source, int looting, boolean recentlyHit, CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (mob.m_20183_() != null) {
            Level level;
            MobExRule mobExRule = this.mobControl$getRule();
            if (mobExRule != null) {
                if (mobExRule.loot != null && mobExRule.loot.any()) {
                    Constants.LOG.debug("Dropping loot for {}", (Object)mobExRule.mobExName);
                    mobExRule.loot.getWeightedGroupRecords().forEach(loot -> this.mobControl$dropItem(mob.m_9236_(), mob.m_20183_(), (WeightedItem)loot));
                    ci.cancel();
                }
                if (!this.mobControl$deathLoot.isEmpty()) {
                    this.mobControl$deathLoot.forEach(loot -> {
                        if (MobEx.can(loot.drop())) {
                            this.mobControl$dropItem(mob.m_9236_(), mob.m_20183_(), (WeightedItem)loot);
                            ci.cancel();
                        }
                    });
                }
            }
            if ((level = mob.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.mobControl$cancelBossFight && serverLevel.m_8586_() != null) {
                    serverLevel.m_8586_().m_64085_(null);
                }
            }
        }
    }

    @Unique
    private void mobControl$dropItem(Level level, BlockPos position, WeightedItem loot) {
        ItemStack itemStack;
        if (loot.quantityTo() != 0 && (itemStack = Util.getRandomItemStack(level, loot)) != null) {
            itemStack.m_41764_(MobEx.randomFromRange(loot.quantityFrom(), loot.quantityTo()));
            ItemEntity itemEntity = new ItemEntity(level, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), itemStack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }

    @Inject(method={"createMobAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createMobAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        cir.setReturnValue((Object)((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(Attributes.f_22281_));
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void setTarget(LivingEntity target, CallbackInfo ci) {
        Mob mob;
        if (this.mobControl$mobExRule != null && this.mobControl$mobExRule.set.attack != null && !this.mobControl$mobExRule.set.attack.contains("player") && !((mob = (Mob)this).m_21188_() instanceof Player) && target instanceof Player) {
            ci.cancel();
        }
    }

    @Inject(method={"checkAndHandleImportantInteractions"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkAndHandleImportantInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42655_)) {
            if (this.mobControl$mobExRule != null && !this.m_21523_() && MobEx.can(this.mobControl$mobExRule.set.canLead)) {
                this.m_21463_((Entity)player, true);
                itemstack.m_41774_(1);
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)true));
                return;
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)true));
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void baseTick(CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (this.mobControl$mobExRule != null) {
            this.mobControl$mobExRule.currentHealth = mob.m_21223_();
            if (!this.mobControl$mobExRule.hasLoaded) {
                MobMix mobMix;
                Object pathfinderMob;
                AttributeInstance attribute;
                Level entity;
                Optional newMobType;
                this.mobControl$mobExRule.hasLoaded = true;
                Constants.LOG.debug("setMob: Finalizing {}, rule {}", (Object)mob.m_7755_().getString(), (Object)this.mobControl$mobExRule.name);
                if (this.mobControl$mobExRule.spawn.convert != null && (newMobType = EntityType.m_20632_((String)Util.getRandomElement(this.mobControl$mobExRule.spawn.convert))).isPresent() && mob.m_6095_() != newMobType.get() && (entity = ((EntityType)newMobType.get()).m_20615_(mob.m_9236_())) instanceof IMob) {
                    IMob iMob = (IMob)entity;
                    iMob.mobControl$setRule(this.mobControl$mobExRule);
                    iMob.mobControl$setMobSpawn(new MobSpawn(MobSpawnType.CONVERSION.toString()));
                    ((Mob)iMob).m_146884_(mob.m_20182_());
                    if (mob.m_6095_().equals(EntityType.f_20565_)) {
                        iMob.mobControl$setCancelBossFight(true);
                    }
                    mob.m_9236_().m_7967_((Entity)entity);
                    mob.m_146870_();
                    mob.m_21153_(0.0f);
                }
                if (!this.mobControl$mobExRule.commandOverride.isEmpty() && (entity = mob.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)entity;
                    int count = this.mobControl$secondaryMobs.size() + 1;
                    this.mobControl$secondaryMobs.clear();
                    String runCommand = this.mobControl$mobExRule.commandOverride.replace("<x>", Integer.toString(mob.m_20183_().m_123341_())).replace("<y>", Integer.toString(mob.m_20183_().m_123342_())).replace("<z>", Integer.toString(mob.m_20183_().m_123343_()));
                    for (int index = 0; index < count; ++index) {
                        serverLevel.m_7654_().m_129892_().m_230957_(serverLevel.m_7654_().m_129893_(), runCommand);
                    }
                    mob.m_146870_();
                    mob.m_21153_(0.0f);
                }
                mob.m_183634_();
                if (!this.mobControl$secondaryMobs.isEmpty()) {
                    for (Mob newMob : this.mobControl$secondaryMobs) {
                        if (mob.m_21224_()) {
                            newMob.m_146870_();
                            newMob.m_21153_(0.0f);
                            continue;
                        }
                        newMob.m_146884_(mob.m_20182_());
                        mob.m_9236_().m_7967_((Entity)newMob);
                    }
                    this.mobControl$secondaryMobs.clear();
                }
                this.m_213945_(mob.m_9236_().f_46441_, mob.m_9236_().m_6436_(mob.m_20183_()));
                Util.setRandomItem(mob, EquipmentSlot.HEAD, this.mobControl$mobExRule.head);
                Util.setRandomItem(mob, EquipmentSlot.CHEST, this.mobControl$mobExRule.chest);
                Util.setRandomItem(mob, EquipmentSlot.LEGS, this.mobControl$mobExRule.legs);
                Util.setRandomItem(mob, EquipmentSlot.FEET, this.mobControl$mobExRule.feet);
                Util.setRandomItem(mob, EquipmentSlot.MAINHAND, this.mobControl$mobExRule.mainhand);
                Util.setRandomItem(mob, EquipmentSlot.OFFHAND, this.mobControl$mobExRule.offhand);
                if (this.mobControl$mobExRule.set.baby != null) {
                    mob.m_6863_(MobEx.can(this.mobControl$mobExRule.set.baby));
                }
                if (this.mobControl$mobExRule.set.xpFrom != null) {
                    this.f_21364_ = MobEx.randomFromRange(this.mobControl$mobExRule.set.xpFrom, this.mobControl$mobExRule.set.xpTo);
                }
                if (this.mobControl$mobExRule.set.healthFrom != null && (attribute = mob.m_21204_().m_22146_(Attributes.f_22276_)) != null) {
                    if (this.mobControl$mobExRule.maxHealth == 0.0f) {
                        Constants.LOG.debug("Setting MAX_HEALTH mobControl$mobExRule.maxHealth == {}", (Object)Float.valueOf(this.mobControl$mobExRule.maxHealth));
                        this.mobControl$mobExRule.currentHealth = this.mobControl$mobExRule.maxHealth = (float)MobEx.randomFromRange(this.mobControl$mobExRule.set.healthFrom, this.mobControl$mobExRule.set.healthTo);
                    }
                    Constants.LOG.debug("Setting MAX_HEALTH XX cur {}, max b4 {}, ruleTo {}", new Object[]{Float.valueOf(this.mobControl$mobExRule.currentHealth), attribute.m_22135_(), this.mobControl$mobExRule.set.healthTo});
                    attribute.m_22100_((double)this.mobControl$mobExRule.maxHealth);
                    mob.m_21153_(this.mobControl$mobExRule.currentHealth);
                    Constants.LOG.debug("Setting MAX_HEALTH to {} with current of {} for {}", new Object[]{mob.m_21204_().m_22181_(Attributes.f_22276_), Float.valueOf(mob.m_21223_()), this.mobControl$mobExRule.mobExName});
                }
                if (this.mobControl$mobExRule.set.damageFrom != null && (attribute = mob.m_21204_().m_22146_(Attributes.f_22281_)) != null) {
                    attribute.m_22100_((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.damageFrom, this.mobControl$mobExRule.set.damageTo));
                    Constants.LOG.debug("Setting ATTACK_DAMAGE to {} for {}", (Object)mob.m_21204_().m_22181_(Attributes.f_22281_), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.knockbackFrom != null && (attribute = mob.m_21204_().m_22146_(Attributes.f_22282_)) != null) {
                    attribute.m_22100_((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.knockbackFrom, this.mobControl$mobExRule.set.knockbackTo));
                    Constants.LOG.debug("Setting ATTACK_KNOCKBACK to {} for {}", (Object)mob.m_21204_().m_22181_(Attributes.f_22282_), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.movementSpeedFrom != null && (attribute = mob.m_21204_().m_22146_(Attributes.f_22279_)) != null) {
                    attribute.m_22100_(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.movementSpeedFrom, this.mobControl$mobExRule.set.movementSpeedTo));
                    Constants.LOG.debug("Setting MOVEMENT_SPEED to {} for {}", (Object)mob.m_21204_().m_22181_(Attributes.f_22279_), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.flyingSpeedFrom != null && (attribute = mob.m_21204_().m_22146_(Attributes.f_22280_)) != null) {
                    attribute.m_22100_(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.flyingSpeedFrom, this.mobControl$mobExRule.set.flyingSpeedTo));
                    Constants.LOG.debug("Setting FLYING_SPEED to {} for {}", (Object)mob.m_21204_().m_22181_(Attributes.f_22280_), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.followRangeFrom != null && (attribute = mob.m_21204_().m_22146_(Attributes.f_22277_)) != null) {
                    attribute.m_22100_((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.followRangeFrom, this.mobControl$mobExRule.set.followRangeTo));
                    Constants.LOG.debug("Setting.FOLLOW_RANGE to {} for {}", (Object)mob.m_21204_().m_22181_(Attributes.f_22277_), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.name != null && !this.mobControl$mobExRule.set.name.isEmpty()) {
                    mob.m_6593_((Component)Component.m_237113_((String)this.mobControl$mobExRule.set.name));
                }
                if (this.mobControl$mobExRule.set.nameAlwaysShown != null) {
                    mob.m_20340_(this.mobControl$mobExRule.set.nameAlwaysShown.booleanValue());
                }
                if (this.mobControl$mobExRule.effect != null && this.mobControl$mobExRule.effect.any()) {
                    this.mobControl$mobExRule.effect.getWeightedGroupRecords().forEach(addEffect -> {
                        MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(ResourceLocation.m_135820_((String)addEffect.key()));
                        if (effect != null) {
                            Constants.LOG.debug("Adding effect {}", (Object)addEffect.key());
                            mob.m_7292_(new MobEffectInstance(effect, MobEx.randomFromRange(addEffect.durationFrom(), addEffect.durationTo()), MobEx.randomFromRange(addEffect.amplifierFrom(), addEffect.amplifierTo()), addEffect.ambient(), addEffect.particles()));
                        }
                    });
                }
                boolean hasAttackGoals = false;
                for (WrappedGoal wrappedGoal : this.f_21345_.m_148105_()) {
                    Goal goal2 = wrappedGoal.m_26015_();
                    if (!goal2.getClass().toString().toLowerCase().contains("attackgoal")) continue;
                    hasAttackGoals = true;
                    break;
                }
                if (!(this.mobControl$mobExRule.set.onHurt == null && this.mobControl$mobExRule.set.attack == null || hasAttackGoals)) {
                    if (mob instanceof PathfinderMob) {
                        pathfinderMob = (PathfinderMob)mob;
                        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)pathfinderMob, 1.2, true));
                    } else {
                        this.f_21345_.m_25352_(1, (Goal)new GenericAttackGoal(mob));
                    }
                }
                if (this.mobControl$mobExRule.set.onHurt != null && !this.mobControl$mobExRule.set.onHurt.isEmpty()) {
                    this.m_262441_(goal -> goal instanceof HurtByTargetGoal);
                    if (mob instanceof PathfinderMob) {
                        pathfinderMob = (PathfinderMob)mob;
                        this.f_21346_.m_25352_(1, (Goal)(this.mobControl$mobExRule.set.onHurt.equals("all") ? new HurtByTargetGoal((PathfinderMob)pathfinderMob, new Class[0]).m_26044_(new Class[0]) : new HurtByTargetGoal((PathfinderMob)pathfinderMob, new Class[0])));
                    } else {
                        this.f_21346_.m_25352_(1, (Goal)(this.mobControl$mobExRule.set.onHurt.equals("all") ? new GenericHurtByTargetGoal(mob).setAlertOthers() : new GenericHurtByTargetGoal(mob)));
                    }
                }
                if (this.mobControl$mobExRule.set.attack != null) {
                    this.m_262441_(goal -> goal instanceof NearestAttackableTargetGoal || goal instanceof NearestAttackableWitchTargetGoal || goal instanceof NonTameRandomTargetGoal);
                    this.m_6710_(null);
                    for (String mobToAttack : this.mobControl$mobExRule.set.attack) {
                        if (mobToAttack.equals("player")) {
                            if (mob instanceof Witch) {
                                Witch witch = (Witch)mob;
                                this.f_21346_.m_25352_(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, Player.class, 10, true, false, livingEntity -> livingEntity instanceof Player));
                                continue;
                            }
                            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(mob, Player.class, true, livingEntity -> livingEntity instanceof Player));
                            continue;
                        }
                        Optional optional = EntityType.m_20632_((String)mobToAttack);
                        if (!optional.isPresent()) continue;
                        EntityType entityType = (EntityType)optional.get();
                        if (mob.m_6095_().equals(entityType)) continue;
                        if (mob instanceof Witch) {
                            Witch witch = (Witch)mob;
                            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, Mob.class, 10, true, false, livingEntity -> livingEntity.m_6095_() == entityType));
                            continue;
                        }
                        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(mob, Mob.class, true, livingEntity -> livingEntity.m_6095_() == entityType));
                    }
                }
                if (MobEx.can(this.mobControl$mobExRule.set.breakBlock) && (mobMix = this) instanceof Monster) {
                    Monster monster = (Monster)mobMix;
                    this.f_21345_.m_25352_(1, new BreakBlocksGoal<Monster>(monster));
                }
            }
            if (this.mobControl$mobExRule.set.climbFallTicks != null) {
                MobExSet mobExSet = this.mobControl$mobExRule.set;
                mobExSet.climbFallTicks = mobExSet.climbFallTicks - 1;
                if (mobExSet.climbFallTicks > 0) {
                    mob.m_183634_();
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (this.mobControl$mobExRule != null) {
            String json = Util.gson.toJson((Object)this.mobControl$mobExRule);
            compound.m_128359_("mobcontrol:rule", json);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (this.mobControl$mobExRule == null) {
            String json = compound.m_128461_("mobcontrol:rule");
            if (!json.isEmpty()) {
                this.mobControl$setRule((MobExRule)Util.gson.fromJson(json, MobExRule.class));
                this.mobControl$mobExRule.hasLoaded = false;
            }
        } else {
            this.mobControl$mobExRule.hasLoaded = false;
        }
    }

    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSunBurnTick(CallbackInfoReturnable<Boolean> cir) {
        if (this.mobControl$mobExRule != null && this.mobControl$mobExRule.set.sunburn != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean mobControl$blockPosContains(BlockPos pos, BlockPos pos1, BlockPos pos2) {
        return pos.m_123341_() >= Math.min(pos1.m_123341_(), pos2.m_123341_()) && pos.m_123341_() <= Math.max(pos1.m_123341_(), pos2.m_123341_()) && pos.m_123343_() >= Math.min(pos1.m_123343_(), pos2.m_123343_()) && pos.m_123343_() <= Math.max(pos1.m_123343_(), pos2.m_123343_());
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")})
    private void customServerAiStep(CallbackInfo ci) {
        List list;
        Block footBlock;
        ServerLevel serverLevel;
        Mob mob;
        block30: {
            block29: {
                mob = (Mob)this;
                Level level = mob.m_9236_();
                if (!(level instanceof ServerLevel)) break block29;
                serverLevel = (ServerLevel)level;
                if (mob != null) break block30;
            }
            return;
        }
        MobExRule mobExRule = this.mobControl$getRule();
        if (mobExRule == null) {
            if (!Util.setMob(serverLevel, mob, mob.m_20185_(), mob.m_20186_(), mob.m_20189_())) {
                Constants.LOG.debug("*WARN* AI: mobExRule == null, type {}, id {} @ {} {} {}", new Object[]{mob.m_6095_(), mob.m_20148_(), mob.m_20183_().m_123341_(), mob.m_20183_().m_123342_(), mob.m_20183_().m_123343_()});
                mob.m_146870_();
                mob.m_21153_(0.0f);
            }
            return;
        }
        if (mobExRule.converting) {
            Constants.LOG.debug("AI: mobExRule.converting");
            mobExRule.converting = false;
            if (!Util.isValidMob(serverLevel, mob, MobSpawnType.CONVERSION.toString())) {
                mob.m_6074_();
            }
            return;
        }
        Vec3 mobVector = new Vec3(mob.m_20185_(), mob.m_20186_(), mob.m_20189_());
        LivingEntity target = this.m_5448_();
        BlockPos aboveMob = BlockPos.m_274561_((double)mob.m_20185_(), (double)mob.m_20188_(), (double)mob.m_20189_()).m_7494_();
        BlockPos mobFootPos = BlockPos.m_274561_((double)mob.m_20185_(), (double)mob.m_20186_(), (double)mob.m_20189_());
        int lightLevel = serverLevel.m_46803_(aboveMob);
        if (serverLevel.m_46461_() && MobEx.can(mobExRule.set.sunburn) && lightLevel > 7 && !mob.m_20071_() && !mob.f_146808_ && !mob.f_146809_ && serverLevel.m_45527_(aboveMob)) {
            ItemStack itemstack = mob.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41773_() + Util.random.nextInt(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        mob.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
            } else {
                mob.m_20254_(7);
            }
        }
        if (MobEx.can(mobExRule.set.eatPlants)) {
            mob.m_21011_(InteractionHand.MAIN_HAND, true);
            footBlock = serverLevel.m_8055_(mobFootPos).m_60734_();
            if (MobMix.mobControl$isBush(footBlock) || MobMix.mobControl$isCrop(footBlock)) {
                serverLevel.m_46961_(mobFootPos, false);
                if (MobEx.can(mobExRule.set.eatPlantsHeals)) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 75, 0));
                }
            }
        }
        if (MobEx.can(mobExRule.set.plantFlowers) && Feature.m_159759_((BlockState)serverLevel.m_8055_(mobFootPos.m_7495_())) && mobFootPos.m_123342_() > 0 && mobFootPos.m_123342_() < 256 && !MobMix.mobControl$isBlockBadSoil(serverLevel, mobFootPos, true) && !(list = ((Biome)serverLevel.m_204166_(mobFootPos).m_203334_()).m_47536_().m_47815_()).isEmpty()) {
            Holder holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
            ((PlacedFeature)holder.m_203334_()).m_226357_((WorldGenLevel)serverLevel, serverLevel.m_7726_().m_8481_(), serverLevel.f_46441_, mobFootPos);
        }
        if (MobEx.can(mobExRule.set.plantTrees) && serverLevel.m_7062_().m_204214_(mobFootPos).m_203543_().isPresent() && Feature.m_159759_((BlockState)serverLevel.m_8055_(mobFootPos.m_7495_())) && mobFootPos.m_123342_() > 0 && mobFootPos.m_123342_() < 256 && MobMix.mobControl$isAreaGoodSoil(serverLevel, mobFootPos)) {
            ResourceLocation currentBiome = ((ResourceKey)serverLevel.m_7062_().m_204214_(mobFootPos).m_203543_().get()).m_135782_();
            serverLevel.m_7731_(mobFootPos, MobMix.mobControl$getSaplingFromBiome(currentBiome), 11);
        }
        if (MobEx.can(mobExRule.set.cutGrass)) {
            mob.m_21011_(InteractionHand.MAIN_HAND, true);
            footBlock = serverLevel.m_8055_(mobFootPos).m_60734_();
            if (MobMix.mobControl$isGrass(footBlock)) {
                serverLevel.m_46961_(mobFootPos, false);
            }
        }
        if (target != null && (this.f_21344_.m_26571_() || this.f_21344_.m_26577_()) && MobEx.can(mobExRule.set.placeBlock) && this.mobControl$blockPosContains(mob.m_20183_(), new BlockPos(target.m_20183_().m_123341_() - 5, 0, target.m_20183_().m_123343_() - 5), new BlockPos(target.m_20183_().m_123341_() + 5, 0, target.m_20183_().m_123343_() + 5))) {
            BlockPos placePos = new BlockPos((Vec3i)mobFootPos);
            if (target.m_20186_() > (double)mob.m_20183_().m_123342_() && !Util.isInWall(serverLevel, mob, placePos.m_252807_())) {
                if (this.mobControl$lastPlacedTick + 100L < serverLevel.m_46467_()) {
                    this.mobControl$lastPlacedTick = serverLevel.m_46467_();
                    serverLevel.m_7731_(placePos, Blocks.f_152544_.m_49966_(), 11);
                    mob.m_21573_().m_26519_((double)placePos.m_123341_(), (double)placePos.m_123342_(), (double)placePos.m_123343_(), (double)mob.m_6113_());
                }
            } else {
                BlockPos towardsTarget = BlockPos.m_274561_((double)(mob.m_20185_() + (double)Double.compare(target.m_20185_(), mob.m_20185_())), (double)(mob.m_20186_() + (double)Double.compare(target.m_20186_(), mob.m_20186_())), (double)(mob.m_20189_() + (double)Double.compare(target.m_20189_(), mob.m_20189_())));
                boolean way = Util.random.nextDouble() > 0.5;
                placePos = new BlockPos(way ? towardsTarget.m_123341_() : mob.m_20183_().m_123341_(), mob.m_20183_().m_123342_(), way ? mob.m_20183_().m_123343_() : towardsTarget.m_123343_());
                if (!Util.isInWall(serverLevel, mob, placePos.m_252807_()) && this.mobControl$lastPlacedTick + 100L < serverLevel.m_46467_()) {
                    this.mobControl$lastPlacedTick = serverLevel.m_46467_();
                    serverLevel.m_7731_(placePos, Blocks.f_152544_.m_49966_(), 11);
                    mob.m_21573_().m_26519_((double)placePos.m_123341_(), (double)placePos.m_123342_(), (double)placePos.m_123343_(), (double)mob.m_6113_());
                }
            }
        }
        List<Entity> nearEntities = serverLevel.m_6443_(Entity.class, new AABB(mobVector, mobVector).m_82400_(0.225), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20238_(mobVector))).toList();
        for (Entity nearEntity : nearEntities) {
            if (mob.m_19879_() == nearEntity.m_19879_() || !(nearEntity instanceof Mob)) continue;
            Mob nearMob = (Mob)nearEntity;
            if (MobEx.can(mobExRule.set.climb) && mob.m_5448_() != null && mob.m_5448_().m_20186_() > mob.m_20186_()) {
                double rndX = Util.random.nextDouble(0.0, 0.1f) * (double)(mob.m_5448_().m_20185_() > mob.m_20185_() ? 1 : -1);
                double rndY = Util.random.nextDouble(0.0, 0.55f) + (mob.m_6162_() ? 0.25 : 0.0);
                double rndZ = Util.random.nextDouble(0.0, 0.1f) * (double)(mob.m_5448_().m_20189_() > mob.m_20189_() ? 1 : -1);
                mob.m_20256_(new Vec3(rndX + mob.m_20184_().m_7096_(), rndY, rndZ + mob.m_20184_().m_7094_()));
                mob.m_21011_(InteractionHand.MAIN_HAND, true);
                mob.m_183634_();
                mobExRule.set.climbFallTicks = 20;
                if (!mob.m_21023_(MobEffects.f_19591_)) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 3, 0, false, false));
                }
            }
            if (!MobEx.can(mobExRule.set.spreadFire) || !mob.m_6060_()) continue;
            if (!mob.m_21023_(MobEffects.f_19596_)) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, mob.m_20094_(), 2, false, false));
            }
            if (nearMob == null || nearMob.m_6060_()) continue;
            int remainingFireTicks = mob.m_20094_();
            nearMob.m_7311_(remainingFireTicks < 75 ? remainingFireTicks + Util.random.nextInt(0, 10) : remainingFireTicks);
        }
    }

    @Unique
    private static boolean mobControl$isGrass(Block block) {
        return block instanceof DoublePlantBlock || block instanceof TallGrassBlock;
    }

    @Unique
    private static boolean mobControl$isBush(Block block) {
        return block instanceof BushBlock;
    }

    @Unique
    private static boolean mobControl$isCrop(Block block) {
        return block instanceof CropBlock;
    }

    @Unique
    private static boolean mobControl$isBlockBadSoil(ServerLevel serverLevel, BlockPos blockPos, boolean groundCheck) {
        boolean goodGround = !groundCheck || Feature.m_159759_((BlockState)serverLevel.m_8055_(blockPos.m_7495_()));
        boolean canSeedPlant = MobMix.mobControl$isGrass(serverLevel.m_8055_(blockPos).m_60734_()) || serverLevel.m_8055_(blockPos).m_60795_();
        return !goodGround || !canSeedPlant;
    }

    @Unique
    private static boolean mobControl$isAreaGoodSoil(ServerLevel serverLevel, BlockPos blockPos) {
        for (int checkY = 0; checkY < 5; ++checkY) {
            BlockPos checkBlockPos = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_() + checkY, blockPos.m_123343_());
            if (serverLevel.m_8055_(checkBlockPos).m_60795_() || MobMix.mobControl$isGrass(serverLevel.m_8055_(checkBlockPos).m_60734_())) continue;
            return false;
        }
        for (int checkX = -2; checkX < 3; ++checkX) {
            for (int checkZ = -2; checkZ < 3; ++checkZ) {
                BlockPos checkBlockPos = new BlockPos(blockPos.m_123341_() + checkX, blockPos.m_123342_(), blockPos.m_123343_() + checkZ);
                if (!MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos, true) && !MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos.m_7494_(), false) && !MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos.m_7494_().m_7494_(), false)) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    private static BlockState mobControl$getSaplingFromBiome(ResourceLocation currentBiome) {
        Weighted<WeightedItem> weighted = new Weighted<WeightedItem>();
        weighted.add(new WeightedItem("oak", "", 2, 1, 1, 0));
        weighted.add(new WeightedItem("birch", "", 1, 1, 1, 0));
        weighted.add(new WeightedItem("default", "", 97, 1, 1, 0));
        if (((WeightedItem)weighted.getWeighted()).key().equals("oak")) {
            return Blocks.f_50746_.m_49966_();
        }
        if (((WeightedItem)weighted.getWeighted()).key().equals("birch")) {
            return Blocks.f_50748_.m_49966_();
        }
        if (((WeightedItem)weighted.getWeighted()).key().equals("default")) {
            if (currentBiome.m_135815_().contains("taiga")) {
                return Blocks.f_50747_.m_49966_();
            }
            if (currentBiome.m_135815_().contains("jungle")) {
                return Blocks.f_50749_.m_49966_();
            }
            if (currentBiome.m_135815_().contains("savanna")) {
                return Blocks.f_50750_.m_49966_();
            }
            if (currentBiome.m_135815_().contains("dark_forest")) {
                return Blocks.f_50751_.m_49966_();
            }
            if (currentBiome.m_135815_().contains("cherry_grove")) {
                return Blocks.f_271334_.m_49966_();
            }
        }
        return Util.random.nextDouble() > 0.75 ? Blocks.f_50748_.m_49966_() : Blocks.f_50746_.m_49966_();
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData spawnGroupData, CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        Mob mob;
        MobMix mobMix = this;
        if (mobMix instanceof Mob && (mob = (Mob)mobMix).m_21224_()) {
            cir.setReturnValue((Object)new AgeableMob.AgeableMobGroupData(false));
        }
    }
}

