/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.WriterContext;
import com.crackerjackbox.toml.iface.IValueReader;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringValueReaderWriter
implements IValueReader,
IValueWriter {
    static final StringValueReaderWriter STRING_VALUE_READER_WRITER = new StringValueReaderWriter();
    private static final Pattern UNICODE_REGEX = Pattern.compile("\\\\[uU](.{4})");
    private static final String[] specialCharacterEscapes = new String[93];

    private StringValueReaderWriter() {
    }

    @Override
    public boolean canRead(String string) {
        return string.startsWith("\"");
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        return this.read(string, atomicInteger, context, false);
    }

    public Object read(String string, AtomicInteger atomicInteger, Context context, boolean relaxed) {
        int startIndex = atomicInteger.incrementAndGet();
        int endIndex = -1;
        int index = atomicInteger.get();
        while (index < string.length()) {
            char character = string.charAt(index + (relaxed ? 1 : 0));
            if (relaxed && character == '\n' || character == '\"' && string.charAt(index - 1) != '\\') {
                endIndex = index;
                break;
            }
            index = atomicInteger.incrementAndGet();
        }
        if (endIndex == -1) {
            Results.Errors errors = new Results.Errors();
            errors.unterminated(context.identifier.getName(), string.substring(startIndex - 1), context.line.get());
            return errors;
        }
        if (relaxed) {
            --startIndex;
            ++endIndex;
        }
        String raw = string.substring(startIndex, endIndex);
        string = this.replaceUnicodeCharacters(raw);
        if ((string = this.replaceSpecialCharacters(string)) == null) {
            Results.Errors errors = new Results.Errors();
            errors.invalidValue(context.identifier.getName(), raw, context.line.get());
            return errors;
        }
        return string;
    }

    String replaceUnicodeCharacters(String value) {
        Matcher unicodeMatcher = UNICODE_REGEX.matcher(value);
        while (unicodeMatcher.find()) {
            value = value.replace(unicodeMatcher.group(), new String(Character.toChars(Integer.parseInt(unicodeMatcher.group(1), 16))));
        }
        return value;
    }

    String replaceSpecialCharacters(String string) {
        for (int index = 0; index < string.length() - 1; ++index) {
            char character = string.charAt(index);
            char next = string.charAt(index + 1);
            if (character == '\\' && next == '\\') {
                ++index;
                continue;
            }
            if (character != '\\' || next == 'b' || next == 'f' || next == 'n' || next == 't' || next == 'r' || next == '\"') continue;
            return null;
        }
        return string.replace("\\n", "\n").replace("\\\"", "\"").replace("\\t", "\t").replace("\\r", "\r").replace("\\\\", "\\").replace("\\/", "/").replace("\\b", "\b").replace("\\f", "\f");
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof String || value instanceof Character || value instanceof URL || value instanceof URI || value instanceof Enum;
    }

    @Override
    public void write(Object value, WriterContext context) {
        context.write('\"');
        this.escapeUnicode(value.toString(), context);
        context.write('\"');
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    private void escapeUnicode(String string, WriterContext context) {
        for (int index = 0; index < string.length(); ++index) {
            int codePoint = string.codePointAt(index);
            if (codePoint < specialCharacterEscapes.length && specialCharacterEscapes[codePoint] != null) {
                context.write(specialCharacterEscapes[codePoint]);
                continue;
            }
            context.write(string.charAt(index));
        }
    }

    public String toString() {
        return "string";
    }

    static {
        StringValueReaderWriter.specialCharacterEscapes[8] = "\\b";
        StringValueReaderWriter.specialCharacterEscapes[9] = "\\t";
        StringValueReaderWriter.specialCharacterEscapes[10] = "\\n";
        StringValueReaderWriter.specialCharacterEscapes[12] = "\\f";
        StringValueReaderWriter.specialCharacterEscapes[13] = "\\r";
        StringValueReaderWriter.specialCharacterEscapes[34] = "\\\"";
        StringValueReaderWriter.specialCharacterEscapes[92] = "\\\\";
    }
}

