/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrialSpawner.class})
public abstract class TrialSpawnerMix {
    @Unique
    private BlockPos mobControl$trialSpawnerPos = null;
    @Unique
    private ServerLevel mobControl$serverLevel;

    @Shadow
    public abstract TrialSpawnerConfig getConfig();

    @Inject(method={"spawnMob"}, at={@At(value="HEAD")})
    private void spawnMob(ServerLevel level, BlockPos pos, CallbackInfoReturnable<Optional<UUID>> cir) {
        this.mobControl$trialSpawnerPos = pos;
        this.mobControl$serverLevel = level;
    }

    @Redirect(method={"spawnMob"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;loadEntityRecursive(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/level/Level;Ljava/util/function/Function;)Lnet/minecraft/world/entity/Entity;"))
    private Entity loadEntityRecursive(CompoundTag tag, Level level, Function<Entity, Entity> entityFunction) {
        return EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, entity -> {
            if (entity instanceof IMob) {
                IMob iMob = (IMob)entity;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    iMob.mobControl$setMobSpawn(new MobSpawn(MobSpawnType.TRIAL_SPAWNER.toString()));
                    RandomSource randomSource = level.getRandom();
                    int count = 0;
                    while (++count < 99) {
                        double x = (double)this.mobControl$trialSpawnerPos.getX() + (randomSource.nextDouble() - randomSource.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
                        double y = this.mobControl$trialSpawnerPos.getY() + randomSource.nextInt(3) - 1;
                        double z = (double)this.mobControl$trialSpawnerPos.getZ() + (randomSource.nextDouble() - randomSource.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
                        entity.moveTo(x, y, z, randomSource.nextFloat() * 360.0f, 0.0f);
                        if (!Util.validSpawnPlacement(this.mobControl$serverLevel, SpawnPlacements.getPlacementType((EntityType)mob.getType()), mob, iMob.mobControl$getRule(), MobSpawnType.TRIAL_SPAWNER.toString())) continue;
                        break;
                    }
                }
            }
            return entity;
        });
    }
}

